/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent.OcAgentTraceExporterConfiguration;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent.OcAgentTraceExporterHandler;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracing;
import com.google.bigtable.repackaged.io.opencensus.trace.export.SpanExporter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OcAgentTraceExporter {
    private static final Object monitor = new Object();
    private static final String REGISTER_NAME = OcAgentTraceExporter.class.getName();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    private OcAgentTraceExporter() {
    }

    public static void createAndRegister() {
        OcAgentTraceExporter.createAndRegister(OcAgentTraceExporterConfiguration.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(OcAgentTraceExporterConfiguration configuration) {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState(handler == null, "OC-Agent exporter is already registered.");
            OcAgentTraceExporterHandler newHandler = new OcAgentTraceExporterHandler(configuration.getEndPoint(), configuration.getServiceName(), configuration.getUseInsecure(), configuration.getSslContext(), configuration.getRetryInterval(), configuration.getEnableConfig(), configuration.getDeadline());
            OcAgentTraceExporter.registerInternal(newHandler);
        }
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerInternal(SpanExporter.Handler newHandler) {
        Object object = monitor;
        synchronized (object) {
            handler = newHandler;
            OcAgentTraceExporter.register(Tracing.getExportComponent().getSpanExporter(), newHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            OcAgentTraceExporter.unregister(Tracing.getExportComponent().getSpanExporter());
            handler = null;
        }
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }
}

