/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.base.AbstractDuration;

@Immutable
@ThreadSafe
public final class RpcQosOptions
implements Serializable,
HasDisplayData {
    private final int maxAttempts;
    private final Duration initialBackoff;
    private final Duration samplePeriod;
    private final Duration samplePeriodBucketSize;
    private final double overloadRatio;
    private final Duration throttleDuration;
    private final int batchInitialCount;
    private final int batchMaxCount;
    private final long batchMaxBytes;
    private final Duration batchTargetLatency;
    private final int hintMaxNumWorkers;
    private final boolean shouldReportDiagnosticMetrics;

    private RpcQosOptions(int maxAttempts, Duration initialBackoff, Duration samplePeriod, Duration samplePeriodBucketSize, double overloadRatio, Duration throttleDuration, int batchInitialCount, int batchMaxCount, long batchMaxBytes, Duration batchTargetLatency, int hintMaxNumWorkers, boolean shouldReportDiagnosticMetrics) {
        this.maxAttempts = maxAttempts;
        this.initialBackoff = initialBackoff;
        this.samplePeriod = samplePeriod;
        this.samplePeriodBucketSize = samplePeriodBucketSize;
        this.overloadRatio = overloadRatio;
        this.throttleDuration = throttleDuration;
        this.batchInitialCount = batchInitialCount;
        this.batchMaxCount = batchMaxCount;
        this.batchMaxBytes = batchMaxBytes;
        this.batchTargetLatency = batchTargetLatency;
        this.hintMaxNumWorkers = hintMaxNumWorkers;
        this.shouldReportDiagnosticMetrics = shouldReportDiagnosticMetrics;
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        builder.add(DisplayData.item((String)"maxAttempts", (Integer)this.maxAttempts).withLabel("maxAttempts")).add(DisplayData.item((String)"initialBackoff", (Duration)this.initialBackoff).withLabel("initialBackoff")).add(DisplayData.item((String)"samplePeriod", (Duration)this.samplePeriod).withLabel("samplePeriod")).add(DisplayData.item((String)"samplePeriodBucketSize", (Duration)this.samplePeriodBucketSize).withLabel("samplePeriodBucketSize")).add(DisplayData.item((String)"overloadRatio", (Double)this.overloadRatio).withLabel("overloadRatio")).add(DisplayData.item((String)"throttleDuration", (Duration)this.throttleDuration).withLabel("throttleDuration")).add(DisplayData.item((String)"batchInitialCount", (Integer)this.batchInitialCount).withLabel("batchInitialCount")).add(DisplayData.item((String)"batchMaxCount", (Integer)this.batchMaxCount).withLabel("batchMaxCount")).add(DisplayData.item((String)"batchMaxBytes", (Long)this.batchMaxBytes).withLabel("batchMaxBytes")).add(DisplayData.item((String)"batchTargetLatency", (Duration)this.batchTargetLatency).withLabel("batchTargetLatency")).add(DisplayData.item((String)"hintMaxNumWorkers", (Integer)this.hintMaxNumWorkers).withLabel("hintMaxNumWorkers")).add(DisplayData.item((String)"shouldReportDiagnosticMetrics", (Boolean)this.shouldReportDiagnosticMetrics).withLabel("shouldReportDiagnosticMetrics"));
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getInitialBackoff() {
        return this.initialBackoff;
    }

    public Duration getSamplePeriod() {
        return this.samplePeriod;
    }

    public Duration getSamplePeriodBucketSize() {
        return this.samplePeriodBucketSize;
    }

    public double getOverloadRatio() {
        return this.overloadRatio;
    }

    public Duration getThrottleDuration() {
        return this.throttleDuration;
    }

    public int getBatchInitialCount() {
        return this.batchInitialCount;
    }

    public int getBatchMaxCount() {
        return this.batchMaxCount;
    }

    public long getBatchMaxBytes() {
        return this.batchMaxBytes;
    }

    public Duration getBatchTargetLatency() {
        return this.batchTargetLatency;
    }

    public int getHintMaxNumWorkers() {
        return this.hintMaxNumWorkers;
    }

    public boolean isShouldReportDiagnosticMetrics() {
        return this.shouldReportDiagnosticMetrics;
    }

    public Builder toBuilder() {
        Builder builder = new Builder().withMaxAttempts(this.maxAttempts).withInitialBackoff(this.initialBackoff).withSamplePeriod(this.samplePeriod).withSamplePeriodBucketSize(this.samplePeriodBucketSize).withOverloadRatio(this.overloadRatio).withThrottleDuration(this.throttleDuration).withBatchInitialCount(this.batchInitialCount).withBatchMaxCount(this.batchMaxCount).withBatchMaxBytes(this.batchMaxBytes).withBatchTargetLatency(this.batchTargetLatency).withHintMaxNumWorkers(this.hintMaxNumWorkers);
        if (this.shouldReportDiagnosticMetrics) {
            return builder.withReportDiagnosticMetrics();
        }
        return builder;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RpcQosOptions)) {
            return false;
        }
        RpcQosOptions that = (RpcQosOptions)o;
        return this.maxAttempts == that.maxAttempts && Double.compare(that.overloadRatio, this.overloadRatio) == 0 && this.batchInitialCount == that.batchInitialCount && this.batchMaxCount == that.batchMaxCount && this.batchMaxBytes == that.batchMaxBytes && this.hintMaxNumWorkers == that.hintMaxNumWorkers && this.shouldReportDiagnosticMetrics == that.shouldReportDiagnosticMetrics && this.initialBackoff.equals((Object)that.initialBackoff) && this.samplePeriod.equals((Object)that.samplePeriod) && this.samplePeriodBucketSize.equals((Object)that.samplePeriodBucketSize) && this.throttleDuration.equals((Object)that.throttleDuration) && this.batchTargetLatency.equals((Object)that.batchTargetLatency);
    }

    public int hashCode() {
        return Objects.hash(this.maxAttempts, this.initialBackoff, this.samplePeriod, this.samplePeriodBucketSize, this.overloadRatio, this.throttleDuration, this.batchInitialCount, this.batchMaxCount, this.batchMaxBytes, this.batchTargetLatency, this.hintMaxNumWorkers, this.shouldReportDiagnosticMetrics);
    }

    public String toString() {
        return "RpcQosOptions{maxAttempts=" + this.maxAttempts + ", initialBackoff=" + this.initialBackoff + ", samplePeriod=" + this.samplePeriod + ", samplePeriodBucketSize=" + this.samplePeriodBucketSize + ", overloadRatio=" + this.overloadRatio + ", throttleDuration=" + this.throttleDuration + ", batchInitialCount=" + this.batchInitialCount + ", batchMaxCount=" + this.batchMaxCount + ", batchMaxBytes=" + this.batchMaxBytes + ", batchTargetLatency=" + this.batchTargetLatency + ", hintMaxNumWorkers=" + this.hintMaxNumWorkers + ", shouldReportDiagnosticMetrics=" + this.shouldReportDiagnosticMetrics + '}';
    }

    public static RpcQosOptions defaultOptions() {
        return RpcQosOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long FIRESTORE_RPC_BYTES_MAX = 0x980000L;
        private static final int FIRESTORE_SINGLE_REQUEST_UPDATE_DOCUMENTS_MAX = 500;
        private int maxAttempts = 5;
        private Duration initialBackoff = Duration.standardSeconds((long)5L);
        private Duration samplePeriod = Duration.standardMinutes((long)2L);
        private Duration samplePeriodBucketSize = Duration.standardSeconds((long)10L);
        private double overloadRatio = 1.05;
        private Duration throttleDuration = Duration.standardSeconds((long)5L);
        private int batchInitialCount = 20;
        private int batchMaxCount = 500;
        private long batchMaxBytes = 0x980000L;
        private Duration batchTargetLatency = Duration.standardSeconds((long)5L);
        private int hintMaxNumWorkers = 500;
        private boolean shouldReportDiagnosticMetrics = false;

        private Builder() {
        }

        public Builder withMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder withInitialBackoff(Duration initialBackoff) {
            this.initialBackoff = initialBackoff;
            return this;
        }

        public Builder withSamplePeriod(Duration samplePeriod) {
            this.samplePeriod = samplePeriod;
            return this;
        }

        public Builder withSamplePeriodBucketSize(Duration samplePeriodBucketSize) {
            this.samplePeriodBucketSize = samplePeriodBucketSize;
            return this;
        }

        public Builder withOverloadRatio(double overloadRatio) {
            this.overloadRatio = overloadRatio;
            return this;
        }

        public Builder withThrottleDuration(Duration throttleDuration) {
            this.throttleDuration = throttleDuration;
            return this;
        }

        public Builder withBatchInitialCount(int batchInitialCount) {
            this.batchInitialCount = batchInitialCount;
            return this;
        }

        public Builder withBatchMaxCount(int batchMaxCount) {
            this.batchMaxCount = batchMaxCount;
            return this;
        }

        public Builder withBatchMaxBytes(long batchMaxBytes) {
            this.batchMaxBytes = batchMaxBytes;
            return this;
        }

        public Builder withBatchTargetLatency(Duration batchTargetLatency) {
            this.batchTargetLatency = batchTargetLatency;
            return this;
        }

        public Builder withHintMaxNumWorkers(int hintMaxNumWorkers) {
            this.hintMaxNumWorkers = hintMaxNumWorkers;
            return this;
        }

        public Builder withReportDiagnosticMetrics() {
            this.shouldReportDiagnosticMetrics = true;
            return this;
        }

        public RpcQosOptions build() {
            this.validateIndividualFields();
            this.validateRelatedFields();
            return this.unsafeBuild();
        }

        @VisibleForTesting
        RpcQosOptions unsafeBuild() {
            return new RpcQosOptions(this.maxAttempts, this.initialBackoff, this.samplePeriod, this.samplePeriodBucketSize, this.overloadRatio, this.throttleDuration, this.batchInitialCount, this.batchMaxCount, this.batchMaxBytes, this.batchTargetLatency, this.hintMaxNumWorkers, this.shouldReportDiagnosticMetrics);
        }

        @VisibleForTesting
        void validateIndividualFields() {
            Builder.checkInRange("maxAttempts", 1, 5, this.maxAttempts, Integer::compare);
            Objects.requireNonNull(this.initialBackoff, "initialBackoff must be non null");
            Builder.checkInRange("initialBackoff", Duration.standardSeconds((long)5L), Duration.standardMinutes((long)2L), this.initialBackoff, AbstractDuration::compareTo);
            Objects.requireNonNull(this.samplePeriod, "samplePeriod must be non null");
            Builder.checkInRange("samplePeriod", Duration.standardMinutes((long)2L), Duration.standardMinutes((long)20L), this.samplePeriod, AbstractDuration::compareTo);
            Objects.requireNonNull(this.samplePeriodBucketSize, "samplePeriodBucketSize must be non null");
            Builder.checkInRange("samplePeriodBucketSize", Duration.standardSeconds((long)10L), Duration.standardMinutes((long)20L), this.samplePeriodBucketSize, AbstractDuration::compareTo);
            Builder.checkInRange("overloadRatio", 1.0, 1.5, this.overloadRatio, Double::compare);
            Objects.requireNonNull(this.throttleDuration, "throttleDuration must be non null");
            Builder.checkInRange("throttleDuration", Duration.standardSeconds((long)5L), Duration.standardMinutes((long)1L), this.throttleDuration, AbstractDuration::compareTo);
            Builder.checkInRange("batchInitialCount", 1, 500, this.batchInitialCount, Integer::compare);
            Builder.checkInRange("batchMaxCount", 1, 500, this.batchMaxCount, Integer::compare);
            Builder.checkInRange("batchMaxBytes", 1L, 0x980000L, this.batchMaxBytes, Long::compare);
            Objects.requireNonNull(this.batchTargetLatency, "batchTargetLatency must be non null");
            Builder.checkInRange("batchTargetLatency", Duration.standardSeconds((long)5L), Duration.standardMinutes((long)2L), this.batchTargetLatency, AbstractDuration::compareTo);
            Builder.checkInRange("hintWorkerCount", 1, Integer.MAX_VALUE, this.hintMaxNumWorkers, Integer::compare);
        }

        @VisibleForTesting
        void validateRelatedFields() {
            Preconditions.checkArgument((this.samplePeriodBucketSize.compareTo((ReadableDuration)this.samplePeriod) <= 0 ? 1 : 0) != 0, (Object)String.format("expected samplePeriodBucketSize <= samplePeriod, but was %s <= %s", this.samplePeriodBucketSize, this.samplePeriod));
        }

        private static <T> void checkInRange(String fieldName, T min, T max, T actual, Comparator<T> comp) {
            Preconditions.checkArgument((0 <= comp.compare(actual, min) && comp.compare(actual, max) <= 0 ? 1 : 0) != 0, (Object)String.format("%s must be in the range %s to %s, but was %s", fieldName, min, max, actual));
        }
    }
}

