/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;

@DefaultCoder(value=AvroCoder.class)
public class HeartbeatRecord
implements ChangeStreamRecord {
    private static final long serialVersionUID = 5331450064150969956L;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp timestamp;
    @org.apache.avro.reflect.Nullable
    private ChangeStreamRecordMetadata metadata;

    private HeartbeatRecord() {
    }

    public HeartbeatRecord(Timestamp timestamp, ChangeStreamRecordMetadata metadata) {
        this.timestamp = timestamp;
        this.metadata = metadata;
    }

    @Override
    public Timestamp getRecordTimestamp() {
        return this.getTimestamp();
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeartbeatRecord)) {
            return false;
        }
        HeartbeatRecord that = (HeartbeatRecord)o;
        return Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp);
    }

    public String toString() {
        return "HeartbeatRecord{timestamp=" + this.timestamp + ", metadata=" + this.metadata + '}';
    }
}

