/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.OperatorValidationUtils;
import org.apache.flink.api.common.typeinfo.NothingTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.configuration.Configuration;

@Public
public class DataSink<T> {
    private final OutputFormat<T> format;
    private final TypeInformation<T> type;
    private final DataSet<T> data;
    private String name;
    private int parallelism = -1;
    private ResourceSpec minResources = ResourceSpec.DEFAULT;
    private ResourceSpec preferredResources = ResourceSpec.DEFAULT;
    private Configuration parameters;
    private int[] sortKeyPositions;
    private Order[] sortOrders;

    public DataSink(DataSet<T> data, OutputFormat<T> format, TypeInformation<T> type) {
        if (format == null) {
            throw new IllegalArgumentException("The output format must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The input type information must not be null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("The data set must not be null.");
        }
        this.format = format;
        this.data = data;
        this.type = type;
    }

    @Internal
    public OutputFormat<T> getFormat() {
        return this.format;
    }

    @Internal
    public TypeInformation<T> getType() {
        return this.type;
    }

    @Internal
    public DataSet<T> getDataSet() {
        return this.data;
    }

    public DataSink<T> withParameters(Configuration parameters) {
        this.parameters = parameters;
        return this;
    }

    @Deprecated
    @PublicEvolving
    public DataSink<T> sortLocalOutput(int field, Order order) {
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(field, this.type);
        int[] flatKeys = ek.computeLogicalKeyPositions();
        if (!Keys.ExpressionKeys.isSortKey((int)field, this.type)) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
        if (this.sortKeyPositions == null) {
            this.sortKeyPositions = flatKeys;
            this.sortOrders = new Order[flatKeys.length];
            Arrays.fill(this.sortOrders, order);
        } else {
            int oldLength = this.sortKeyPositions.length;
            int newLength = oldLength + flatKeys.length;
            this.sortKeyPositions = Arrays.copyOf(this.sortKeyPositions, newLength);
            this.sortOrders = Arrays.copyOf(this.sortOrders, newLength);
            for (int i = 0; i < flatKeys.length; ++i) {
                this.sortKeyPositions[oldLength + i] = flatKeys[i];
                this.sortOrders[oldLength + i] = order;
            }
        }
        return this;
    }

    @Deprecated
    @PublicEvolving
    public DataSink<T> sortLocalOutput(String fieldExpression, Order order) {
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(fieldExpression, this.type);
        int[] fields = ek.computeLogicalKeyPositions();
        if (!Keys.ExpressionKeys.isSortKey((String)fieldExpression, this.type)) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
        int numFields = fields.length;
        Object[] orders = new Order[numFields];
        Arrays.fill(orders, order);
        if (this.sortKeyPositions == null) {
            this.sortKeyPositions = fields;
            this.sortOrders = orders;
        } else {
            int oldLength = this.sortKeyPositions.length;
            int newLength = oldLength + numFields;
            this.sortKeyPositions = Arrays.copyOf(this.sortKeyPositions, newLength);
            this.sortOrders = Arrays.copyOf(this.sortOrders, newLength);
            for (int i = 0; i < numFields; ++i) {
                this.sortKeyPositions[oldLength + i] = fields[i];
                this.sortOrders[oldLength + i] = orders[i];
            }
        }
        return this;
    }

    public Configuration getParameters() {
        return this.parameters;
    }

    public DataSink<T> name(String name) {
        this.name = name;
        return this;
    }

    protected GenericDataSinkBase<T> translateToDataFlow(Operator<T> input) {
        String name = this.name != null ? this.name : this.format.toString();
        GenericDataSinkBase sink = new GenericDataSinkBase(this.format, new UnaryOperatorInformation(this.type, (TypeInformation)new NothingTypeInfo()), name);
        sink.setInput(input);
        if (this.parameters != null) {
            sink.getParameters().addAll(this.parameters);
        }
        if (this.parallelism > 0) {
            sink.setParallelism(this.parallelism);
        } else {
            sink.setParallelism(input.getParallelism());
        }
        if (this.sortKeyPositions != null) {
            Ordering ordering = new Ordering();
            for (int i = 0; i < this.sortKeyPositions.length; ++i) {
                ordering.appendOrdering(Integer.valueOf(this.sortKeyPositions[i]), null, this.sortOrders[i]);
            }
            sink.setLocalOrder(ordering);
        }
        return sink;
    }

    public String toString() {
        return "DataSink '" + (this.name == null ? "<unnamed>" : this.name) + "' (" + this.format.toString() + ")";
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public DataSink<T> setParallelism(int parallelism) {
        OperatorValidationUtils.validateParallelism((int)parallelism);
        this.parallelism = parallelism;
        return this;
    }

    @PublicEvolving
    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    @PublicEvolving
    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    private DataSink<T> setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        OperatorValidationUtils.validateMinAndPreferredResources((ResourceSpec)minResources, (ResourceSpec)preferredResources);
        this.minResources = minResources;
        this.preferredResources = preferredResources;
        return this;
    }

    private DataSink<T> setResources(ResourceSpec resources) {
        OperatorValidationUtils.validateResources((ResourceSpec)resources);
        this.minResources = resources;
        this.preferredResources = resources;
        return this;
    }
}

