/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvariable;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.setvariable.SetVariable;
import org.apache.hop.pipeline.transforms.setvariable.SetVariableData;
import org.w3c.dom.Node;

@Transform(id="SetVariable", image="setvariable.svg", name="i18n::SetVariable.Name", description="i18n::SetVariable.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Workflow", keywords={"i18n::SetVariableMeta.keyword"}, documentationUrl="/pipeline/transforms/setvariable.html")
public class SetVariableMeta
extends BaseTransformMeta<SetVariable, SetVariableData> {
    private static final Class<?> PKG = SetVariableMeta.class;
    public static final int VARIABLE_TYPE_JVM = 0;
    public static final int VARIABLE_TYPE_PARENT_WORKFLOW = 1;
    public static final int VARIABLE_TYPE_GRAND_PARENT_WORKFLOW = 2;
    public static final int VARIABLE_TYPE_ROOT_WORKFLOW = 3;
    private static final String[] variableTypeCode = new String[]{"JVM", "PARENT_WORKFLOW", "GP_WORKFLOW", "ROOT_WORKFLOW"};
    private static final String[] variableTypeDesc = new String[]{"Valid in the Java Virtual Machine", "Valid in the parent workflow", "Valid in the grand-parent workflow", "Valid in the root workflow"};
    private String[] fieldName;
    private String[] variableName;
    private int[] variableType;
    private String[] defaultValue;
    private boolean usingFormatting;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public void setVariableName(String[] fieldValue) {
        this.variableName = fieldValue;
    }

    public String[] getVariableName() {
        return this.variableName;
    }

    public int[] getVariableType() {
        return this.variableType;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static final String getVariableTypeCode(int variableType) {
        return variableTypeCode[variableType];
    }

    public static final String getVariableTypeDescription(int variableType) {
        return variableTypeDesc[variableType];
    }

    public static final int getVariableType(String variableType) {
        int i;
        for (i = 0; i < variableTypeCode.length; ++i) {
            if (!variableTypeCode[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        for (i = 0; i < variableTypeDesc.length; ++i) {
            if (!variableTypeDesc[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        return 0;
    }

    public void setVariableType(int[] localVariable) {
        this.variableType = localVariable;
    }

    public static final String[] getVariableTypeDescriptions() {
        return variableTypeDesc;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.variableName = new String[count];
        this.variableType = new int[count];
        this.defaultValue = new String[count];
    }

    public Object clone() {
        SetVariableMeta retval = (SetVariableMeta)((Object)super.clone());
        int count = this.fieldName.length;
        retval.allocate(count);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, count);
        System.arraycopy(this.variableName, 0, retval.variableName, 0, count);
        System.arraycopy(this.variableType, 0, retval.variableType, 0, count);
        System.arraycopy(this.defaultValue, 0, retval.defaultValue, 0, count);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int count = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"field_name");
                this.variableName[i] = XmlHandler.getTagValue((Node)fnode, (String)"variable_name");
                this.variableType[i] = SetVariableMeta.getVariableType(XmlHandler.getTagValue((Node)fnode, (String)"variable_type"));
                this.defaultValue[i] = XmlHandler.getTagValue((Node)fnode, (String)"default_value");
            }
            this.usingFormatting = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"use_formatting"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"SetVariableMeta.RuntimeError.UnableToReadXML.SETVARIABLE0004", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.variableName[i] = "";
            this.variableType[i] = 0;
            this.defaultValue[i] = "";
        }
        this.usingFormatting = true;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(150);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"field_name", (String)this.fieldName[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"variable_name", (String)this.variableName[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"variable_type", (String)SetVariableMeta.getVariableTypeCode(this.variableType[i])));
            retval.append("        ").append(XmlHandler.addTagValue((String)"default_value", (String)this.defaultValue[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </fields>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"use_formatting", (boolean)this.usingFormatting));
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SetVariableMeta.CheckResult.NotReceivingFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SetVariableMeta.CheckResult.ReceivingFieldsFromPreviousTransforms", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SetVariableMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SetVariableMeta.CheckResult.NotReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean isUsingFormatting() {
        return this.usingFormatting;
    }

    public void setUsingFormatting(boolean usingFormatting) {
        this.usingFormatting = usingFormatting;
    }
}

