/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IGuiSize;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class NotePadMeta
implements Cloneable,
IGuiPosition,
IGuiSize {
    public static final String XML_TAG = "notepad";
    public static final int COLOR_RGB_BLACK_RED = 14;
    public static final int COLOR_RGB_BLACK_GREEN = 58;
    public static final int COLOR_RGB_BLACK_BLUE = 90;
    public static final int COLOR_RGB_DEFAULT_BG_RED = 201;
    public static final int COLOR_RGB_DEFAULT_BG_GREEN = 232;
    public static final int COLOR_RGB_DEFAULT_BG_BLUE = 251;
    public static final int COLOR_RGB_DEFAULT_BORDER_RED = 14;
    public static final int COLOR_RGB_DEFAULT_BORDER_GREEN = 58;
    public static final int COLOR_RGB_DEFAULT_BORDER_BLUE = 90;
    private String note;
    private String fontName;
    private int fontSize;
    private boolean fontBold;
    private boolean fontItalic;
    private int fontColorRed;
    private int fontColorGreen;
    private int fontColorBlue;
    private int backgroundColorRed;
    private int backgroundColorGreen;
    private int backgroundColorBlue;
    private int borderColorRed;
    private int borderColorGreen;
    private int borderColorBlue;
    private Point location;
    public int width;
    public int height;
    private boolean selected;
    private boolean changed;

    public NotePadMeta() {
        this.note = null;
        this.location = new Point(-1, -1);
        this.width = -1;
        this.height = -1;
        this.selected = false;
        this.backgroundColorRed = 201;
        this.backgroundColorGreen = 232;
        this.backgroundColorBlue = 251;
        this.setDefaultFont();
    }

    public NotePadMeta(String note, int locationX, int locationY, int width, int height) {
        this();
        this.note = note;
        this.location = new Point(locationX, locationY);
        this.width = width;
        this.height = height;
    }

    public NotePadMeta(String n, int xl, int yl, int w, int h, String fontName, int fontSize, boolean fontBold, boolean fontItalic, int fontColorRed, int fontColorGreen, int fontColorBlue, int backGrounColorRed, int backGrounColorGreen, int backGrounColorBlue, int borderColorRed, int borderColorGreen, int borderColorBlue) {
        this.note = n;
        this.location = new Point(xl, yl);
        this.width = w;
        this.height = h;
        this.selected = false;
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontBold = fontBold;
        this.fontItalic = fontItalic;
        this.fontColorRed = fontColorRed;
        this.fontColorGreen = fontColorGreen;
        this.fontColorBlue = fontColorBlue;
        this.backgroundColorRed = backGrounColorRed;
        this.backgroundColorGreen = backGrounColorGreen;
        this.backgroundColorBlue = backGrounColorBlue;
        this.borderColorRed = borderColorRed;
        this.borderColorGreen = borderColorGreen;
        this.borderColorBlue = borderColorBlue;
    }

    public NotePadMeta(NotePadMeta n) {
        this(n.note, n.location.x, n.location.y, n.width, n.height, n.fontName, n.fontSize, n.fontBold, n.fontItalic, n.fontColorRed, n.fontColorGreen, n.fontColorBlue, n.backgroundColorRed, n.backgroundColorGreen, n.backgroundColorBlue, n.borderColorRed, n.borderColorGreen, n.borderColorBlue);
    }

    public NotePadMeta(Node notepadnode) throws HopXmlException {
        try {
            this.note = XmlHandler.getTagValue((Node)notepadnode, (String)"note");
            String sxloc = XmlHandler.getTagValue((Node)notepadnode, (String)"xloc");
            String syloc = XmlHandler.getTagValue((Node)notepadnode, (String)"yloc");
            String swidth = XmlHandler.getTagValue((Node)notepadnode, (String)"width");
            String sheight = XmlHandler.getTagValue((Node)notepadnode, (String)"heigth");
            int x = Const.toInt((String)sxloc, (int)0);
            int y = Const.toInt((String)syloc, (int)0);
            this.location = new Point(x, y);
            this.width = Const.toInt((String)swidth, (int)0);
            this.height = Const.toInt((String)sheight, (int)0);
            this.selected = false;
            this.fontName = XmlHandler.getTagValue((Node)notepadnode, (String)"fontname");
            this.fontSize = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"fontsize"), (int)-1);
            this.fontBold = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)notepadnode, (String)"fontbold"));
            this.fontItalic = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)notepadnode, (String)"fontitalic"));
            this.fontColorRed = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"fontcolorred"), (int)14);
            this.fontColorGreen = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"fontcolorgreen"), (int)58);
            this.fontColorBlue = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"fontcolorblue"), (int)90);
            this.backgroundColorRed = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"backgroundcolorred"), (int)201);
            this.backgroundColorGreen = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"backgroundcolorgreen"), (int)232);
            this.backgroundColorBlue = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"backgroundcolorblue"), (int)251);
            this.borderColorRed = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"bordercolorred"), (int)14);
            this.borderColorGreen = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"bordercolorgreen"), (int)58);
            this.borderColorBlue = Const.toInt((String)XmlHandler.getTagValue((Node)notepadnode, (String)"bordercolorblue"), (int)90);
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to read Notepad info from XML", (Throwable)e);
        }
    }

    public void setLocation(int x, int y) {
        if (x != this.location.x || y != this.location.y) {
            this.setChanged();
        }
        this.location.x = x;
        this.location.y = y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Point getLocation() {
        return this.location;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setBorderColorRed(int red) {
        this.borderColorRed = red;
    }

    public void setBorderColorGreen(int green) {
        this.borderColorGreen = green;
    }

    public void setBorderColorBlue(int blue) {
        this.borderColorBlue = blue;
    }

    public void setBackGroundColorRed(int red) {
        this.backgroundColorRed = red;
    }

    public void setBackGroundColorGreen(int green) {
        this.backgroundColorGreen = green;
    }

    public void setBackGroundColorBlue(int blue) {
        this.backgroundColorBlue = blue;
    }

    public void setFontColorRed(int red) {
        this.fontColorRed = red;
    }

    public void setFontColorGreen(int green) {
        this.fontColorGreen = green;
    }

    public void setFontColorBlue(int blue) {
        this.fontColorBlue = blue;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public NotePadMeta clone() {
        return new NotePadMeta(this);
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public String toString() {
        return this.note;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(100);
        xml.append("    <notepad>").append(Const.CR);
        xml.append("      ").append(XmlHandler.addTagValue((String)"note", (String)this.note));
        xml.append("      ").append(XmlHandler.addTagValue((String)"xloc", (int)this.location.x));
        xml.append("      ").append(XmlHandler.addTagValue((String)"yloc", (int)this.location.y));
        xml.append("      ").append(XmlHandler.addTagValue((String)"width", (int)this.width));
        xml.append("      ").append(XmlHandler.addTagValue((String)"heigth", (int)this.height));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fontname", (String)this.fontName));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fontsize", (int)this.fontSize));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fontbold", (boolean)this.fontBold));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fontitalic", (boolean)this.fontItalic));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fontcolorred", (int)this.fontColorRed));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fontcolorgreen", (int)this.fontColorGreen));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fontcolorblue", (int)this.fontColorBlue));
        xml.append("      ").append(XmlHandler.addTagValue((String)"backgroundcolorred", (int)this.backgroundColorRed));
        xml.append("      ").append(XmlHandler.addTagValue((String)"backgroundcolorgreen", (int)this.backgroundColorGreen));
        xml.append("      ").append(XmlHandler.addTagValue((String)"backgroundcolorblue", (int)this.backgroundColorBlue));
        xml.append("      ").append(XmlHandler.addTagValue((String)"bordercolorred", (int)this.borderColorRed));
        xml.append("      ").append(XmlHandler.addTagValue((String)"bordercolorgreen", (int)this.borderColorGreen));
        xml.append("      ").append(XmlHandler.addTagValue((String)"bordercolorblue", (int)this.borderColorBlue));
        xml.append("    </notepad>").append(Const.CR);
        return xml.toString();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontname) {
        this.fontName = fontname;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontBold(boolean fontbold) {
        this.fontBold = fontbold;
    }

    public boolean isFontBold() {
        return this.fontBold;
    }

    public void setFontItalic(boolean fontitalic) {
        this.fontItalic = fontitalic;
    }

    public boolean isFontItalic() {
        return this.fontItalic;
    }

    public int getBorderColorRed() {
        return this.borderColorRed;
    }

    public int getBorderColorGreen() {
        return this.borderColorGreen;
    }

    public int getBorderColorBlue() {
        return this.borderColorBlue;
    }

    public int getBackGroundColorRed() {
        return this.backgroundColorRed;
    }

    public int getBackGroundColorGreen() {
        return this.backgroundColorGreen;
    }

    public int getBackGroundColorBlue() {
        return this.backgroundColorBlue;
    }

    public int getFontColorRed() {
        return this.fontColorRed;
    }

    public int getFontColorGreen() {
        return this.fontColorGreen;
    }

    public int getFontColorBlue() {
        return this.fontColorBlue;
    }

    public void setFontSize(int fontsize) {
        this.fontSize = fontsize;
    }

    private void setDefaultFont() {
        this.fontName = null;
        this.fontSize = -1;
        this.fontBold = false;
        this.fontItalic = false;
        this.fontColorRed = 14;
        this.fontColorGreen = 58;
        this.fontColorBlue = 90;
        this.backgroundColorRed = 201;
        this.backgroundColorGreen = 232;
        this.backgroundColorBlue = 251;
        this.borderColorRed = 14;
        this.borderColorGreen = 58;
        this.borderColorBlue = 90;
    }
}

