/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.dataorch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableCallback;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.TabFolderReorder;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiKeyHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyFileType;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

@HopPerspectivePlugin(id="100-HopDataOrchestrationPerspective", name="i18n::DataOrchestrationPerspective.Name", image="ui/images/data_orch.svg", description="i18n::DataOrchestrationPerspective.Description")
@GuiPlugin(description="i18n::DataOrchestrationPerspective.GuiPlugin.Description")
public class HopDataOrchestrationPerspective
implements IHopPerspective {
    private static final Class<?> PKG = HopDataOrchestrationPerspective.class;
    public static final String ID_PERSPECTIVE_TOOLBAR_ITEM = "20010-perspective-data-orchestration";
    private final HopPipelineFileType<PipelineMeta> pipelineFileType;
    private final HopWorkflowFileType<WorkflowMeta> workflowFileType;
    private HopGui hopGui;
    private Composite parent;
    private Composite composite;
    private CTabFolder tabFolder;
    private List<TabItemHandler> items = new CopyOnWriteArrayList<TabItemHandler>();
    private TabItemHandler activeItem = null;
    private Stack<Integer> tabSelectionHistory = new Stack();
    private int tabSelectionIndex = 0;

    public HopDataOrchestrationPerspective() {
        this.pipelineFileType = new HopPipelineFileType();
        this.workflowFileType = new HopWorkflowFileType();
    }

    @Override
    public String getId() {
        return "data-orch";
    }

    @Override
    @GuiKeyboardShortcut(control=true, shift=true, key=100)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=100)
    public void activate() {
        this.hopGui.setActivePerspective(this);
        if (this.activeItem != null) {
            this.tabFolder.setSelection(this.activeItem.getTabItem());
        }
    }

    @Override
    public void perspectiveActivated() {
        IHopFileTypeHandler handler = this.getActiveFileTypeHandler();
        HopGui.getInstance().handleFileCapabilities(handler.getFileType(), handler.hasChanged(), false, false);
        this.setActiveFileTypeHandler(handler);
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.parent = parent;
        PropsUi props = PropsUi.getInstance();
        this.composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginRight = props.getMargin();
        layout.marginBottom = props.getMargin();
        this.composite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)formData);
        this.tabFolder = new CTabFolder(this.composite, 2050);
        props.setLook((Control)this.tabFolder, 5);
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(100, 0);
        fdLabel.top = new FormAttachment(0, 0);
        fdLabel.bottom = new FormAttachment(100, 0);
        this.tabFolder.setLayoutData((Object)fdLabel);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                HopDataOrchestrationPerspective.this.handleTabCloseEvent(event);
            }
        });
        this.tabFolder.addListener(13, event -> this.handleTabSelectionEvent(event));
        Menu menu = new Menu((Control)this.tabFolder);
        this.tabFolder.setMenu(menu);
        this.tabFolder.addListener(35, event -> this.handleTabMenuDetectEvent(event));
        MenuItem miClose = new MenuItem(menu, 0);
        miClose.setText(BaseMessages.getString(PKG, (String)"DataOrchestrationPerspective.Close.Button.Text", (String[])new String[0]));
        miClose.addListener(13, event -> {
            if (this.activeItem != null) {
                this.activeItem.getTypeHandler().close();
            }
        });
        MenuItem miCloseOthers = new MenuItem(menu, 0);
        miCloseOthers.setText(BaseMessages.getString(PKG, (String)"DataOrchestrationPerspective.CloseOther.Button.Text", (String[])new String[0]));
        miCloseOthers.addListener(13, event -> {
            TabItemHandler currentItem = this.activeItem;
            this.items.forEach(item -> {
                if (!item.equals(currentItem)) {
                    this.activeItem = item;
                    item.getTypeHandler().close();
                }
            });
        });
        MenuItem miCloseAll = new MenuItem(menu, 0);
        miCloseAll.setText(BaseMessages.getString(PKG, (String)"DataOrchestrationPerspective.CloseAll.Button.Text", (String[])new String[0]));
        miCloseAll.addListener(13, event -> this.items.forEach(item -> {
            this.activeItem = item;
            item.getTypeHandler().close();
        }));
        new TabFolderReorder(this.tabFolder);
        HopGuiKeyHandler.getInstance().addParentObjectToHandle(this);
    }

    private void handleTabMenuDetectEvent(Event event) {
        CTabItem tabItem = this.tabFolder.getSelection();
        if (tabItem == null) {
            event.doit = false;
            return;
        }
    }

    private void handleTabSelectionEvent(Event event) {
        Integer lastIndex;
        CTabItem tabItem = (CTabItem)event.item;
        this.activeItem = this.findTabItemHandler(tabItem);
        if (this.activeItem != null) {
            this.activeItem.getTypeHandler().redraw();
            this.activeItem.getTypeHandler().updateGui();
        }
        int tabIndex = this.tabFolder.indexOf(tabItem);
        Integer n = lastIndex = this.tabSelectionHistory.isEmpty() ? null : this.tabSelectionHistory.peek();
        if (lastIndex == null || lastIndex != tabIndex) {
            this.tabSelectionHistory.push(tabIndex);
            this.tabSelectionIndex = this.tabSelectionHistory.size() - 1;
        }
    }

    private void handleTabCloseEvent(CTabFolderEvent event) {
        CTabItem tabItem = (CTabItem)event.item;
        int tabIndex = this.tabFolder.indexOf(tabItem);
        TabItemHandler tabItemHandler = this.findTabItemHandler(tabItem);
        if (tabItemHandler == null) {
            this.hopGui.getLog().logError("Tab item handler not found for tab item " + tabItem.toString());
            return;
        }
        IHopFileTypeHandler typeHandler = tabItemHandler.getTypeHandler();
        boolean isRemoved = this.remove(typeHandler);
        try {
            if (isRemoved && typeHandler.getFilename() != null) {
                this.hopGui.fileRefreshDelegate.remove(HopVfs.getFileObject((String)typeHandler.getFilename()).getPublicURIString());
            }
        }
        catch (HopFileException e) {
            this.hopGui.getLog().logError("Error getting VFS fileObject", (Throwable)e);
        }
        if (!isRemoved) {
            event.doit = false;
            return;
        }
        if (tabIndex >= 0) {
            Integer activeIndex;
            int i;
            int historyIndex = this.tabSelectionHistory.indexOf(tabIndex);
            while (historyIndex >= 0) {
                if (historyIndex <= this.tabSelectionIndex) {
                    --this.tabSelectionIndex;
                }
                this.tabSelectionHistory.remove(historyIndex);
                historyIndex = this.tabSelectionHistory.indexOf(tabIndex);
            }
            Stack<Integer> newHistory = new Stack<Integer>();
            Integer previous = null;
            for (i = 0; i < this.tabSelectionHistory.size(); ++i) {
                Integer index = (Integer)this.tabSelectionHistory.get(i);
                if (previous == null || previous != index) {
                    newHistory.add(index);
                } else if (this.tabSelectionIndex >= i) {
                    --this.tabSelectionIndex;
                }
                previous = index;
            }
            this.tabSelectionHistory = newHistory;
            for (i = 0; i < this.tabSelectionHistory.size(); ++i) {
                int index = (Integer)this.tabSelectionHistory.get(i);
                if (index <= tabIndex) continue;
                this.tabSelectionHistory.set(i, index--);
            }
            if (this.tabSelectionIndex < 0) {
                this.tabSelectionIndex = 0;
            } else if (this.tabSelectionIndex >= this.tabSelectionHistory.size()) {
                this.tabSelectionIndex = this.tabSelectionHistory.size() - 1;
            }
            if (!this.tabSelectionHistory.isEmpty() && (activeIndex = (Integer)this.tabSelectionHistory.get(this.tabSelectionIndex)) < this.items.size()) {
                this.activeItem = this.items.get(activeIndex);
                this.tabFolder.setSelection(activeIndex.intValue());
                this.activeItem.getTypeHandler().updateGui();
            }
            if (this.tabFolder.getItemCount() == 0) {
                HopGui.getInstance().handleFileCapabilities(new EmptyFileType(), false, false, false);
            }
        }
    }

    public TabItemHandler findTabItemHandler(CTabItem tabItem) {
        int index = this.tabFolder.indexOf(tabItem);
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return this.items.get(index);
    }

    public TabItemHandler findTabItemHandler(IHopFileTypeHandler handler) {
        for (TabItemHandler item : this.items) {
            if (!item.getTypeHandler().equals(handler)) continue;
            return item;
        }
        return null;
    }

    public IHopFileTypeHandler addPipeline(HopGui hopGui, PipelineMeta pipelineMeta, HopPipelineFileType pipelineFile) throws HopException {
        CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setImage(GuiResource.getInstance().getImagePipeline());
        HopGuiPipelineGraph pipelineGraph = new HopGuiPipelineGraph((Composite)this.tabFolder, hopGui, tabItem, this, pipelineMeta, pipelineFile);
        tabItem.setControl((Control)pipelineGraph);
        if (pipelineMeta.getFilename() != null) {
            hopGui.fileRefreshDelegate.register(HopVfs.getFileObject((String)pipelineMeta.getFilename()).getPublicURIString(), pipelineGraph);
        }
        this.updateTabLabel(tabItem, pipelineMeta.getFilename(), pipelineMeta.getName());
        pipelineMeta.setInternalHopVariables(pipelineGraph.getVariables());
        hopGui.setParametersAsVariablesInUI((INamedParameterDefinitions)pipelineMeta, pipelineGraph.getVariables());
        this.tabFolder.setSelection(tabItem);
        this.activeItem = new TabItemHandler(tabItem, pipelineGraph);
        this.items.add(this.activeItem);
        while (this.tabSelectionHistory.size() - 1 > this.tabSelectionIndex) {
            this.tabSelectionHistory.pop();
        }
        int tabIndex = this.tabFolder.indexOf(tabItem);
        this.tabSelectionHistory.add(tabIndex);
        this.tabSelectionIndex = this.tabSelectionHistory.size() - 1;
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)pipelineGraph.getVariables(), (String)HopExtensionPoint.HopGuiNewPipelineTab.id, (Object)pipelineGraph);
        }
        catch (Exception e) {
            throw new HopException("Error calling extension point plugin for plugin id " + HopExtensionPoint.HopGuiNewPipelineTab.id + " trying to handle a new pipeline tab", (Throwable)e);
        }
        pipelineGraph.adjustScrolling();
        pipelineGraph.setFocus();
        return pipelineGraph;
    }

    public void updateTabLabel(CTabItem tabItem, String filename, String name) {
        if (!tabItem.isDisposed()) {
            tabItem.setText(Const.NVL((String)name, (String)"<>"));
            tabItem.setToolTipText(filename);
        }
    }

    public IHopFileTypeHandler addWorkflow(HopGui hopGui, WorkflowMeta workflowMeta, HopWorkflowFileType workflowFile) throws HopException {
        CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setImage(GuiResource.getInstance().getImageWorkflow());
        HopGuiWorkflowGraph workflowGraph = new HopGuiWorkflowGraph((Composite)this.tabFolder, hopGui, tabItem, this, workflowMeta, workflowFile);
        tabItem.setControl((Control)workflowGraph);
        if (workflowMeta.getFilename() != null) {
            hopGui.fileRefreshDelegate.register(HopVfs.getFileObject((String)workflowMeta.getFilename()).getPublicURIString(), workflowGraph);
        }
        workflowMeta.setInternalHopVariables(workflowGraph.getVariables());
        hopGui.setParametersAsVariablesInUI((INamedParameterDefinitions)workflowMeta, workflowGraph.getVariables());
        this.updateTabLabel(tabItem, workflowMeta.getFilename(), workflowMeta.getName());
        this.tabFolder.setSelection(tabItem);
        this.activeItem = new TabItemHandler(tabItem, workflowGraph);
        this.items.add(this.activeItem);
        while (this.tabSelectionHistory.size() - 1 > this.tabSelectionIndex) {
            this.tabSelectionHistory.pop();
        }
        int tabIndex = this.tabFolder.indexOf(tabItem);
        this.tabSelectionHistory.add(tabIndex);
        this.tabSelectionIndex = this.tabSelectionHistory.size() - 1;
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)workflowGraph.getVariables(), (String)HopExtensionPoint.HopGuiNewWorkflowTab.id, (Object)workflowGraph);
        }
        catch (Exception e) {
            throw new HopException("Error calling extension point plugin for plugin id " + HopExtensionPoint.HopGuiNewWorkflowTab.id + " trying to handle a new workflow tab", (Throwable)e);
        }
        workflowGraph.setFocus();
        return workflowGraph;
    }

    @Override
    public boolean remove(IHopFileTypeHandler typeHandler) {
        TabItemHandler tabItemHandler = this.findTabItemHandler(typeHandler);
        if (tabItemHandler == null) {
            return false;
        }
        if (typeHandler.isCloseable()) {
            this.items.remove(tabItemHandler);
            CTabItem tabItem = tabItemHandler.getTabItem();
            tabItem.dispose();
            HopGuiKeyHandler.getInstance().removeParentObjectToHandle(typeHandler);
            this.hopGui.getMainHopGuiComposite().setFocus();
            if (typeHandler.getSubject() != null) {
                if (typeHandler.getSubject() instanceof PipelineMeta) {
                    try {
                        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)this.hopGui.getVariables(), (String)HopExtensionPoint.HopGuiPipelineAfterClose.id, (Object)typeHandler.getSubject());
                    }
                    catch (Exception e) {
                        this.hopGui.getLog().logError("Error calling extension point 'HopGuiPipelineAfterClose'", (Throwable)e);
                    }
                } else if (typeHandler.getSubject() instanceof WorkflowMeta) {
                    try {
                        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)this.hopGui.getVariables(), (String)HopExtensionPoint.HopGuiWorkflowAfterClose.id, (Object)typeHandler.getSubject());
                    }
                    catch (Exception e) {
                        this.hopGui.getLog().logError("Error calling extension point 'HopGuiWorkflowAfterClose'", (Throwable)e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        if (this.activeItem == null) {
            return new EmptyHopFileTypeHandler();
        }
        return this.activeItem.getTypeHandler();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler activeFileTypeHandler) {
        TabItemHandler tabItemHandler = this.findTabItemHandler(activeFileTypeHandler);
        if (tabItemHandler == null) {
            return;
        }
        this.switchToTab(tabItemHandler);
    }

    public void switchToTab(TabItemHandler tabItemHandler) {
        this.tabFolder.setSelection(tabItemHandler.getTabItem());
        this.tabFolder.showItem(tabItemHandler.getTabItem());
        this.tabFolder.setFocus();
        this.activeItem = tabItemHandler;
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return Arrays.asList(this.pipelineFileType, this.workflowFileType);
    }

    @Override
    public void navigateToPreviousFile() {
        if (this.hasNavigationPreviousFile()) {
            --this.tabSelectionIndex;
            Integer tabIndex = (Integer)this.tabSelectionHistory.get(this.tabSelectionIndex);
            this.activeItem = this.items.get(tabIndex);
            this.tabFolder.setSelection(tabIndex.intValue());
            this.activeItem.getTypeHandler().updateGui();
        }
    }

    @Override
    public void navigateToNextFile() {
        if (this.hasNavigationNextFile()) {
            ++this.tabSelectionIndex;
            Integer tabIndex = (Integer)this.tabSelectionHistory.get(this.tabSelectionIndex);
            this.activeItem = this.items.get(tabIndex);
            this.tabFolder.setSelection(tabIndex.intValue());
            this.activeItem.getTypeHandler().updateGui();
        }
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        return this.tabSelectionIndex > 0 && this.tabSelectionIndex < this.tabSelectionHistory.size();
    }

    @Override
    public boolean hasNavigationNextFile() {
        return this.tabSelectionIndex + 1 < this.tabSelectionHistory.size();
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        ArrayList<IGuiContextHandler> handlers = new ArrayList<IGuiContextHandler>();
        for (IHopFileType fileType : this.getSupportedHopFileTypes()) {
            handlers.addAll(fileType.getContextHandlers());
        }
        return handlers;
    }

    public void updateTabs() {
        for (TabItemHandler item : this.items) {
            IHopFileTypeHandler typeHandler = item.getTypeHandler();
            this.updateTabLabel(item.getTabItem(), typeHandler.getFilename(), typeHandler.getName());
        }
    }

    public TabItemHandler findTabItemHandlerWithFilename(String filename) {
        if (filename == null) {
            return null;
        }
        for (TabItemHandler item : this.items) {
            if (!filename.equals(item.getTypeHandler().getFilename())) continue;
            return item;
        }
        return null;
    }

    @Override
    public List<ISearchable> getSearchables() {
        ArrayList<ISearchable> searchables = new ArrayList<ISearchable>();
        for (final TabItemHandler item : this.items) {
            final IHopFileTypeHandler typeHandler = item.getTypeHandler();
            searchables.add(new ISearchable(){

                public String getLocation() {
                    return "Data orchestration perspective in tab : " + item.getTabItem().getText();
                }

                public String getName() {
                    return typeHandler.getName();
                }

                public String getType() {
                    return typeHandler.getFileType().getName();
                }

                public String getFilename() {
                    return typeHandler.getFilename();
                }

                public Object getSearchableObject() {
                    return typeHandler.getSubject();
                }

                public ISearchableCallback getSearchCallback() {
                    return (searchable, searchResult) -> {
                        HopDataOrchestrationPerspective.this.activate();
                        HopDataOrchestrationPerspective.this.switchToTab(item);
                    };
                }
            });
        }
        return searchables;
    }

    public TabItemHandler findPipeline(String logChannelId) {
        for (TabItemHandler item : this.items) {
            HopGuiPipelineGraph graph;
            IPipelineEngine<PipelineMeta> pipeline;
            if (!(item.getTypeHandler() instanceof HopGuiPipelineGraph) || (pipeline = (graph = (HopGuiPipelineGraph)item.getTypeHandler()).getPipeline()) == null || !logChannelId.equals(pipeline.getLogChannelId())) continue;
            return item;
        }
        return null;
    }

    public TabItemHandler findWorkflow(String logChannelId) {
        for (TabItemHandler item : this.items) {
            HopGuiWorkflowGraph graph;
            IWorkflowEngine<WorkflowMeta> workflow;
            if (!(item.getTypeHandler() instanceof HopGuiWorkflowGraph) || (workflow = (graph = (HopGuiWorkflowGraph)item.getTypeHandler()).getWorkflow()) == null || !logChannelId.equals(workflow.getLogChannelId())) continue;
            return item;
        }
        return null;
    }

    @Override
    public List<TabItemHandler> getItems() {
        return this.items;
    }

    public void setItems(List<TabItemHandler> items) {
        this.items = items;
    }

    public TabItemHandler getActiveItem() {
        return this.activeItem;
    }

    public void setActiveItem(TabItemHandler activeItem) {
        this.activeItem = activeItem;
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabFolder(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public HopPipelineFileType<PipelineMeta> getPipelineFileType() {
        return this.pipelineFileType;
    }

    public HopWorkflowFileType<WorkflowMeta> getWorkflowFileType() {
        return this.workflowFileType;
    }
}

