/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.execution;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.Point;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;

public abstract class BaseExecutionViewer
extends Composite
implements KeyListener,
MouseListener {
    public static final String STRING_STATE_STALE = "Stale";
    protected final HopGui hopGui;
    protected final PropsUi props;
    protected final int iconSize;
    protected final List<AreaOwner> areaOwners;
    protected ToolBar toolBar;
    protected GuiToolbarWidgets toolBarWidgets;
    protected SashForm sash;
    protected Canvas canvas;
    protected float magnification = 1.0f;
    protected CTabFolder tabFolder;
    protected Point offset;

    public BaseExecutionViewer(Composite parent, HopGui hopGui) {
        super(parent, 262144);
        this.hopGui = hopGui;
        this.props = PropsUi.getInstance();
        this.iconSize = hopGui.getProps().getIconSize();
        this.areaOwners = new ArrayList<AreaOwner>();
        this.offset = new Point(0, 0);
    }

    protected Display hopDisplay() {
        return this.hopGui.getDisplay();
    }

    public boolean setFocus() {
        return this.canvas.setFocus();
    }

    protected float calculateCorrectedMagnification() {
        return (float)((double)this.magnification * PropsUi.getInstance().getZoomFactor());
    }

    public Point screen2real(int x, int y) {
        float correctedMagnification = this.calculateCorrectedMagnification();
        Point real = new Point(Math.round((float)x / correctedMagnification - (float)this.offset.x), Math.round((float)y / correctedMagnification - (float)this.offset.y));
        return real;
    }

    public synchronized AreaOwner getVisibleAreaOwner(int x, int y) {
        for (int i = this.areaOwners.size() - 1; i >= 0; --i) {
            AreaOwner areaOwner = this.areaOwners.get(i);
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    protected String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date);
    }

    public abstract void drillDownOnLocation(Point var1);

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        this.drillDownOnLocation(this.screen2real(mouseEvent.x, mouseEvent.y));
    }
}

