/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.file.types.base;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.HopFileTypeBase;
import org.apache.hop.ui.hopgui.file.HopFileTypePlugin;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfigSingleton;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.eclipse.swt.widgets.MessageBox;

public abstract class BaseExplorerFileType<T extends IExplorerFileTypeHandler>
extends HopFileTypeBase
implements IExplorerFileType<T> {
    private String name;
    private String defaultFileExtension;
    private String[] filterExtensions;
    private String[] filterNames;
    private Properties capabilities;

    public BaseExplorerFileType() {
    }

    public BaseExplorerFileType(String name, String defaultFileExtension, String[] filterExtensions, String[] filterNames, Properties capabilities) {
        this.name = name;
        this.defaultFileExtension = defaultFileExtension;
        this.filterExtensions = filterExtensions;
        this.filterNames = filterNames;
        this.capabilities = capabilities;
    }

    @Override
    public boolean supportsFile(IHasFilename metaObject) {
        return false;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    public void setDefaultFileExtension(String defaultFileExtension) {
        this.defaultFileExtension = defaultFileExtension;
    }

    @Override
    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    @Override
    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }

    @Override
    public Properties getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Properties capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public String getFileTypeImage() {
        return this.getClass().getAnnotation(HopFileTypePlugin.class).image();
    }

    public T openFile(HopGui hopGui, String filename, IVariables parentVariables) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)parentVariables.resolve(filename));
            String name = fileObject.getName().getBaseName();
            long fileSize = fileObject.getContent().getSize();
            long sizeMb = fileSize / 0x100000L;
            String maxSizeOption = ExplorerPerspectiveConfigSingleton.getConfig().getFileLoadingMaxSize();
            long maxSizeMb = Const.toLong((String)hopGui.getVariables().resolve(maxSizeOption), (long)16L);
            if (sizeMb > maxSizeMb) {
                MessageBox box = new MessageBox(hopGui.getShell(), 196);
                box.setText("Open large file?");
                box.setMessage(name + Const.CR + Const.CR + "The file to open is " + sizeMb + "MB in size. This is larger than the configured maximum of " + maxSizeMb + "MB.  There might be a danger of running out of memory. " + Const.CR + Const.CR + "Are you sure you still want to open this file?");
                int answer = box.open();
                if ((answer & 0x40) == 0) {
                    return null;
                }
            }
            ExplorerPerspective perspective = ExplorerPerspective.getInstance();
            ExplorerFile explorerFile = new ExplorerFile();
            explorerFile.setName(Const.NVL((String)name, (String)""));
            explorerFile.setFilename(filename);
            explorerFile.setFileType(this);
            explorerFile.setTabImage(perspective.getFileTypeImage(this));
            T fileTypeHandler = this.createFileTypeHandler(hopGui, perspective, explorerFile);
            explorerFile.setFileTypeHandler((IExplorerFileTypeHandler)fileTypeHandler);
            perspective.addFile(explorerFile);
            return fileTypeHandler;
        }
        catch (Exception e) {
            throw new HopException("Error opening file '" + filename + "' in a new tab in the Explorer perspective", (Throwable)e);
        }
    }

    @Override
    public abstract T createFileTypeHandler(HopGui var1, ExplorerPerspective var2, ExplorerFile var3);
}

