/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapoutput;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapConnection;
import org.apache.hop.pipeline.transforms.ldapinput.LdapProtocol;
import org.apache.hop.pipeline.transforms.ldapinput.LdapProtocolFactory;
import org.apache.hop.pipeline.transforms.ldapoutput.LdapOutputMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LdapOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = LdapOutputMeta.class;
    private Button wUsingAuthentication;
    private final LdapOutputMeta input;
    private TextVar wHost;
    private Label wlUserName;
    private TextVar wUserName;
    private Label wlPassword;
    private TextVar wPassword;
    private TextVar wPort;
    private ComboVar wDnField;
    private Label wlDnField;
    private ComboVar wOldDnField;
    private Label wlOldDnField;
    private ComboVar wNewDnField;
    private Label wlNewDnField;
    private Label wlFailIfNotExist;
    private Button wFailIfNotExist;
    private Label wlDeleteRDN;
    private Button wDeleteRDN;
    private final Map<String, Integer> inputFields;
    private ColumnInfo[] ciReturn;
    private Button wDoMapping;
    private Label wlReturn;
    private TableView wReturn;
    private Button wGetLU;
    private CCombo wOperation;
    private CCombo wReferral;
    private CCombo wDerefAliases;
    private Label wlMultiValuedSeparator;
    private TextVar wMultiValuedSeparator;
    private Label wlBaseDN;
    private TextVar wBaseDN;
    private ComboVar wProtocol;
    private Label wlTrustStorePath;
    private TextVar wTrustStorePath;
    private Label wlTrustStorePassword;
    private TextVar wTrustStorePassword;
    private Label wlSetTrustStore;
    private Button wSetTrustStore;
    private Label wlTrustAll;
    private Button wTrustAll;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private boolean gotPrevious = false;
    private Button wbbFilename;
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};

    public LdapOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (LdapOutputMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.General.Tab", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)fileLayout);
        Group wConnectionGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wConnectionGroup);
        wConnectionGroup.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Group.ConnectionGroup.Label", (String[])new String[0]));
        FormLayout connectiongroupLayout = new FormLayout();
        connectiongroupLayout.marginWidth = 10;
        connectiongroupLayout.marginHeight = 10;
        wConnectionGroup.setLayout((Layout)connectiongroupLayout);
        Label wlHost = new Label((Composite)wConnectionGroup, 131072);
        wlHost.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Host.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHost);
        FormData fdlHost = new FormData();
        fdlHost.left = new FormAttachment(0, 0);
        fdlHost.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlHost.right = new FormAttachment(middle, -margin);
        wlHost.setLayoutData((Object)fdlHost);
        this.wHost = new TextVar(this.variables, (Composite)wConnectionGroup, 18436);
        this.wHost.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Host.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHost);
        this.wHost.addModifyListener(lsMod);
        FormData fdHost = new FormData();
        fdHost.left = new FormAttachment(middle, 0);
        fdHost.top = new FormAttachment((Control)this.wTransformName, margin);
        fdHost.right = new FormAttachment(100, 0);
        this.wHost.setLayoutData((Object)fdHost);
        Label wlPort = new Label((Composite)wConnectionGroup, 131072);
        wlPort.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPort);
        FormData fdlPort = new FormData();
        fdlPort.left = new FormAttachment(0, 0);
        fdlPort.top = new FormAttachment((Control)this.wHost, margin);
        fdlPort.right = new FormAttachment(middle, -margin);
        wlPort.setLayoutData((Object)fdlPort);
        this.wPort = new TextVar(this.variables, (Composite)wConnectionGroup, 18436);
        this.props.setLook((Control)this.wPort);
        this.wPort.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Port.Tooltip", (String[])new String[0]));
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(middle, 0);
        fdPort.top = new FormAttachment((Control)this.wHost, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        Label wlReferral = new Label((Composite)wConnectionGroup, 131072);
        wlReferral.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Referral.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReferral);
        FormData fdlReferral = new FormData();
        fdlReferral.left = new FormAttachment(0, 0);
        fdlReferral.right = new FormAttachment(middle, -margin);
        fdlReferral.top = new FormAttachment((Control)this.wPort, margin);
        wlReferral.setLayoutData((Object)fdlReferral);
        this.wReferral = new CCombo((Composite)wConnectionGroup, 2056);
        this.props.setLook((Control)this.wReferral);
        this.wReferral.addModifyListener(lsMod);
        FormData fdReferral = new FormData();
        fdReferral.left = new FormAttachment(middle, 0);
        fdReferral.top = new FormAttachment((Control)this.wPort, margin);
        fdReferral.right = new FormAttachment(100, -margin);
        this.wReferral.setLayoutData((Object)fdReferral);
        this.wReferral.setItems(LdapOutputMeta.referralTypeDesc);
        this.wReferral.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapOutputDialog.this.input.setChanged();
            }
        });
        Label wlDerefAliases = new Label((Composite)wConnectionGroup, 131072);
        wlDerefAliases.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.DerefAliases.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDerefAliases);
        FormData fdlDerefAliases = new FormData();
        fdlDerefAliases.left = new FormAttachment(0, 0);
        fdlDerefAliases.right = new FormAttachment(middle, -margin);
        fdlDerefAliases.top = new FormAttachment((Control)this.wReferral, margin);
        wlDerefAliases.setLayoutData((Object)fdlDerefAliases);
        this.wDerefAliases = new CCombo((Composite)wConnectionGroup, 2056);
        this.props.setLook((Control)this.wDerefAliases);
        this.wDerefAliases.addModifyListener(lsMod);
        FormData fdDerefAliases = new FormData();
        fdDerefAliases.left = new FormAttachment(middle, 0);
        fdDerefAliases.top = new FormAttachment((Control)this.wReferral, margin);
        fdDerefAliases.right = new FormAttachment(100, -margin);
        this.wDerefAliases.setLayoutData((Object)fdDerefAliases);
        this.wDerefAliases.setItems(LdapOutputMeta.derefAliasesTypeDesc);
        this.wDerefAliases.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapOutputDialog.this.input.setChanged();
            }
        });
        Label wlProtocol = new Label((Composite)wConnectionGroup, 131072);
        wlProtocol.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Protocol.Label", (String[])new String[0]));
        this.props.setLook((Control)wlProtocol);
        FormData fdlProtocol = new FormData();
        fdlProtocol.left = new FormAttachment(0, 0);
        fdlProtocol.right = new FormAttachment(middle, -margin);
        fdlProtocol.top = new FormAttachment((Control)this.wDerefAliases, margin);
        wlProtocol.setLayoutData((Object)fdlProtocol);
        this.wProtocol = new ComboVar(this.variables, (Composite)wConnectionGroup, 2056);
        this.wProtocol.setEditable(true);
        this.props.setLook((Control)this.wProtocol);
        this.wProtocol.addModifyListener(lsMod);
        FormData fdProtocol = new FormData();
        fdProtocol.left = new FormAttachment(middle, 0);
        fdProtocol.top = new FormAttachment((Control)this.wDerefAliases, margin);
        fdProtocol.right = new FormAttachment(100, -margin);
        this.wProtocol.setLayoutData((Object)fdProtocol);
        this.wProtocol.setItems(LdapProtocolFactory.getConnectionTypes((ILogChannel)this.log).toArray(new String[0]));
        this.wProtocol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapOutputDialog.this.setProtocol();
            }
        });
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, margin);
        fdConnectionGroup.top = new FormAttachment(0, margin);
        fdConnectionGroup.right = new FormAttachment(100, -margin);
        wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        Group wAuthenticationGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wAuthenticationGroup);
        wAuthenticationGroup.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Group.AuthenticationGroup.Label", (String[])new String[0]));
        FormLayout authenticationGroupLayout = new FormLayout();
        authenticationGroupLayout.marginWidth = 10;
        authenticationGroupLayout.marginHeight = 10;
        wAuthenticationGroup.setLayout((Layout)authenticationGroupLayout);
        Label wlUsingAuthentication = new Label((Composite)wAuthenticationGroup, 131072);
        wlUsingAuthentication.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.usingAuthentication.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUsingAuthentication);
        FormData fdlUsingAuthentication = new FormData();
        fdlUsingAuthentication.left = new FormAttachment(0, 0);
        fdlUsingAuthentication.top = new FormAttachment((Control)wConnectionGroup, margin);
        fdlUsingAuthentication.right = new FormAttachment(middle, -margin);
        wlUsingAuthentication.setLayoutData((Object)fdlUsingAuthentication);
        this.wUsingAuthentication = new Button((Composite)wAuthenticationGroup, 32);
        this.props.setLook((Control)this.wUsingAuthentication);
        this.wUsingAuthentication.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.usingAuthentication.Tooltip", (String[])new String[0]));
        FormData fdUsingAuthentication = new FormData();
        fdUsingAuthentication.left = new FormAttachment(middle, 0);
        fdUsingAuthentication.top = new FormAttachment((Control)wlUsingAuthentication, 0, 0x1000000);
        this.wUsingAuthentication.setLayoutData((Object)fdUsingAuthentication);
        this.wUsingAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapOutputDialog.this.useAuthentication();
                LdapOutputDialog.this.input.setChanged();
            }
        });
        this.wlUserName = new Label((Composite)wAuthenticationGroup, 131072);
        this.wlUserName.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Username.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUserName);
        FormData fdlUserName = new FormData();
        fdlUserName.left = new FormAttachment(0, 0);
        fdlUserName.top = new FormAttachment((Control)this.wUsingAuthentication, margin);
        fdlUserName.right = new FormAttachment(middle, -margin);
        this.wlUserName.setLayoutData((Object)fdlUserName);
        this.wUserName = new TextVar(this.variables, (Composite)wAuthenticationGroup, 18436);
        this.props.setLook((Control)this.wUserName);
        this.wUserName.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Username.Tooltip", (String[])new String[0]));
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(middle, 0);
        fdUserName.top = new FormAttachment((Control)this.wUsingAuthentication, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        this.wlPassword = new Label((Composite)wAuthenticationGroup, 131072);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Password.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdlPassword.right = new FormAttachment(middle, -margin);
        this.wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.variables, (Composite)wAuthenticationGroup, 18436);
        this.wPassword.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Password.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        FormData fdAuthenticationGroup = new FormData();
        fdAuthenticationGroup.left = new FormAttachment(0, margin);
        fdAuthenticationGroup.top = new FormAttachment((Control)wConnectionGroup, margin);
        fdAuthenticationGroup.right = new FormAttachment(100, -margin);
        wAuthenticationGroup.setLayoutData((Object)fdAuthenticationGroup);
        Group wCertificateGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wCertificateGroup);
        wCertificateGroup.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Group.CertificateGroup.Label", (String[])new String[0]));
        FormLayout certificateGroupLayout = new FormLayout();
        certificateGroupLayout.marginWidth = 10;
        certificateGroupLayout.marginHeight = 10;
        wCertificateGroup.setLayout((Layout)certificateGroupLayout);
        this.wlSetTrustStore = new Label((Composite)wCertificateGroup, 131072);
        this.wlSetTrustStore.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.setTrustStore.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSetTrustStore);
        FormData fdlsetTrustStore = new FormData();
        fdlsetTrustStore.left = new FormAttachment(0, 0);
        fdlsetTrustStore.top = new FormAttachment((Control)wAuthenticationGroup, margin);
        fdlsetTrustStore.right = new FormAttachment(middle, -margin);
        this.wlSetTrustStore.setLayoutData((Object)fdlsetTrustStore);
        this.wSetTrustStore = new Button((Composite)wCertificateGroup, 32);
        this.props.setLook((Control)this.wSetTrustStore);
        this.wSetTrustStore.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.setTrustStore.Tooltip", (String[])new String[0]));
        FormData fdsetTrustStore = new FormData();
        fdsetTrustStore.left = new FormAttachment(middle, 0);
        fdsetTrustStore.top = new FormAttachment((Control)this.wlSetTrustStore, 0, 0x1000000);
        this.wSetTrustStore.setLayoutData((Object)fdsetTrustStore);
        this.wSetTrustStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapOutputDialog.this.input.setChanged();
                LdapOutputDialog.this.setTrustStore();
            }
        });
        this.wlTrustStorePath = new Label((Composite)wCertificateGroup, 131072);
        this.wlTrustStorePath.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.TrustStorePath.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTrustStorePath);
        FormData fdlTrustStorePath = new FormData();
        fdlTrustStorePath.left = new FormAttachment(0, -margin);
        fdlTrustStorePath.top = new FormAttachment((Control)this.wSetTrustStore, margin);
        fdlTrustStorePath.right = new FormAttachment(middle, -margin);
        this.wlTrustStorePath.setLayoutData((Object)fdlTrustStorePath);
        this.wbbFilename = new Button((Composite)wCertificateGroup, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wSetTrustStore, margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbbFilename.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wTrustStorePath, (IVariables)this.variables));
        this.wTrustStorePath = new TextVar(this.variables, (Composite)wCertificateGroup, 18436);
        this.props.setLook((Control)this.wTrustStorePath);
        this.wTrustStorePath.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.TrustStorePath.Tooltip", (String[])new String[0]));
        this.wTrustStorePath.addModifyListener(lsMod);
        FormData fdTrustStorePath = new FormData();
        fdTrustStorePath.left = new FormAttachment(middle, 0);
        fdTrustStorePath.top = new FormAttachment((Control)this.wSetTrustStore, margin);
        fdTrustStorePath.right = new FormAttachment((Control)this.wbbFilename, -margin);
        this.wTrustStorePath.setLayoutData((Object)fdTrustStorePath);
        this.wlTrustStorePassword = new Label((Composite)wCertificateGroup, 131072);
        this.wlTrustStorePassword.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.TrustStorePassword.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTrustStorePassword);
        FormData fdlTrustStorePassword = new FormData();
        fdlTrustStorePassword.left = new FormAttachment(0, -margin);
        fdlTrustStorePassword.top = new FormAttachment((Control)this.wTrustStorePath, margin);
        fdlTrustStorePassword.right = new FormAttachment(middle, -margin);
        this.wlTrustStorePassword.setLayoutData((Object)fdlTrustStorePassword);
        this.wTrustStorePassword = new PasswordTextVar(this.variables, (Composite)wCertificateGroup, 18436);
        this.props.setLook((Control)this.wTrustStorePassword);
        this.wTrustStorePassword.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.TrustStorePassword.Tooltip", (String[])new String[0]));
        this.wTrustStorePassword.addModifyListener(lsMod);
        FormData fdTrustStorePassword = new FormData();
        fdTrustStorePassword.left = new FormAttachment(middle, 0);
        fdTrustStorePassword.top = new FormAttachment((Control)this.wTrustStorePath, margin);
        fdTrustStorePassword.right = new FormAttachment(100, -margin);
        this.wTrustStorePassword.setLayoutData((Object)fdTrustStorePassword);
        this.wlTrustAll = new Label((Composite)wCertificateGroup, 131072);
        this.wlTrustAll.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.TrustAll.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTrustAll);
        FormData fdlTrustAll = new FormData();
        fdlTrustAll.left = new FormAttachment(0, 0);
        fdlTrustAll.top = new FormAttachment((Control)this.wTrustStorePassword, margin);
        fdlTrustAll.right = new FormAttachment(middle, -margin);
        this.wlTrustAll.setLayoutData((Object)fdlTrustAll);
        this.wTrustAll = new Button((Composite)wCertificateGroup, 32);
        this.props.setLook((Control)this.wTrustAll);
        this.wTrustAll.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.TrustAll.Tooltip", (String[])new String[0]));
        FormData fdTrustAll = new FormData();
        fdTrustAll.left = new FormAttachment(middle, 0);
        fdTrustAll.top = new FormAttachment((Control)this.wlTrustAll, 0, 0x1000000);
        this.wTrustAll.setLayoutData((Object)fdTrustAll);
        this.wTrustAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapOutputDialog.this.input.setChanged();
                LdapOutputDialog.this.trustAll();
            }
        });
        FormData fdCertificateGroup = new FormData();
        fdCertificateGroup.left = new FormAttachment(0, margin);
        fdCertificateGroup.top = new FormAttachment((Control)wAuthenticationGroup, margin);
        fdCertificateGroup.right = new FormAttachment(100, -margin);
        wCertificateGroup.setLayoutData((Object)fdCertificateGroup);
        Button wTest = new Button(wGeneralComp, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)wCertificateGroup, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wSettingsTab = new CTabItem(wTabFolder, 0);
        wSettingsTab.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Settings.Tab", (String[])new String[0]));
        Composite wSettingsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wSettingsComp);
        FormLayout settLayout = new FormLayout();
        settLayout.marginWidth = 3;
        settLayout.marginHeight = 3;
        wSettingsComp.setLayout((Layout)settLayout);
        Group wSettings = new Group(wSettingsComp, 32);
        this.props.setLook((Control)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Group.Settings.Label", (String[])new String[0]));
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 10;
        settingsLayout.marginHeight = 10;
        wSettings.setLayout((Layout)settingsLayout);
        Label wlOperation = new Label((Composite)wSettings, 131072);
        wlOperation.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Operation.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOperation);
        FormData fdlOperation = new FormData();
        fdlOperation.left = new FormAttachment(0, 0);
        fdlOperation.right = new FormAttachment(middle, -margin);
        fdlOperation.top = new FormAttachment((Control)this.wTransformName, margin);
        wlOperation.setLayoutData((Object)fdlOperation);
        this.wOperation = new CCombo((Composite)wSettings, 2056);
        this.props.setLook((Control)this.wOperation);
        this.wOperation.addModifyListener(lsMod);
        FormData fdOperation = new FormData();
        fdOperation.left = new FormAttachment(middle, 0);
        fdOperation.top = new FormAttachment((Control)this.wTransformName, margin);
        fdOperation.right = new FormAttachment(100, -margin);
        this.wOperation.setLayoutData((Object)fdOperation);
        this.wOperation.setItems(LdapOutputMeta.operationTypeDesc);
        this.wOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapOutputDialog.this.updateOperation();
                LdapOutputDialog.this.input.setChanged();
            }
        });
        this.wlMultiValuedSeparator = new Label((Composite)wSettings, 131072);
        this.wlMultiValuedSeparator.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.MultiValuedSeparator.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMultiValuedSeparator);
        FormData fdlMultiValuedSeparator = new FormData();
        fdlMultiValuedSeparator.left = new FormAttachment(0, 0);
        fdlMultiValuedSeparator.top = new FormAttachment((Control)this.wOperation, margin);
        fdlMultiValuedSeparator.right = new FormAttachment(middle, -margin);
        this.wlMultiValuedSeparator.setLayoutData((Object)fdlMultiValuedSeparator);
        this.wMultiValuedSeparator = new TextVar(this.variables, (Composite)wSettings, 18436);
        this.props.setLook((Control)this.wMultiValuedSeparator);
        this.wMultiValuedSeparator.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.MultiValuedSeparator.Tooltip", (String[])new String[0]));
        this.wMultiValuedSeparator.addModifyListener(lsMod);
        FormData fdMultiValuedSeparator = new FormData();
        fdMultiValuedSeparator.left = new FormAttachment(middle, 0);
        fdMultiValuedSeparator.top = new FormAttachment((Control)this.wOperation, margin);
        fdMultiValuedSeparator.right = new FormAttachment(100, 0);
        this.wMultiValuedSeparator.setLayoutData((Object)fdMultiValuedSeparator);
        this.wlFailIfNotExist = new Label((Composite)wSettings, 131072);
        this.wlFailIfNotExist.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.FailIfNotExist.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFailIfNotExist);
        FormData fdlFailIfNotExist = new FormData();
        fdlFailIfNotExist.left = new FormAttachment(0, 0);
        fdlFailIfNotExist.top = new FormAttachment((Control)this.wMultiValuedSeparator, margin);
        fdlFailIfNotExist.right = new FormAttachment(middle, -margin);
        this.wlFailIfNotExist.setLayoutData((Object)fdlFailIfNotExist);
        this.wFailIfNotExist = new Button((Composite)wSettings, 32);
        this.wFailIfNotExist.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.FailIfNotExist.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wFailIfNotExist);
        FormData fdFailIfNotExist = new FormData();
        fdFailIfNotExist.left = new FormAttachment(middle, 0);
        fdFailIfNotExist.top = new FormAttachment((Control)this.wlFailIfNotExist, 0, 0x1000000);
        fdFailIfNotExist.right = new FormAttachment(100, 0);
        this.wFailIfNotExist.setLayoutData((Object)fdFailIfNotExist);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LdapOutputDialog.this.input.setChanged();
            }
        };
        this.wFailIfNotExist.addSelectionListener((SelectionListener)lsSelR);
        this.wlDnField = new Label((Composite)wSettings, 131072);
        this.wlDnField.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.DnField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDnField);
        FormData fdlDnField = new FormData();
        fdlDnField.left = new FormAttachment(0, 0);
        fdlDnField.top = new FormAttachment((Control)this.wFailIfNotExist, margin);
        fdlDnField.right = new FormAttachment(middle, -margin);
        this.wlDnField.setLayoutData((Object)fdlDnField);
        this.wDnField = new ComboVar(this.variables, (Composite)wSettings, 2060);
        this.wDnField.setEditable(true);
        this.props.setLook((Control)this.wDnField);
        this.wDnField.addModifyListener(lsMod);
        FormData fdDnField = new FormData();
        fdDnField.left = new FormAttachment(middle, 0);
        fdDnField.top = new FormAttachment((Control)this.wFailIfNotExist, margin);
        fdDnField.right = new FormAttachment(100, -margin);
        this.wDnField.setLayoutData((Object)fdDnField);
        this.wDnField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LdapOutputDialog.this.getPreviousFields();
            }
        });
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)wConnectionGroup, margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        Group wRenameGroup = new Group(wSettingsComp, 32);
        this.props.setLook((Control)wRenameGroup);
        wRenameGroup.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Group.RenameGroup.Label", (String[])new String[0]));
        FormLayout renameGroupLayout = new FormLayout();
        renameGroupLayout.marginWidth = 10;
        renameGroupLayout.marginHeight = 10;
        wRenameGroup.setLayout((Layout)renameGroupLayout);
        this.wlOldDnField = new Label((Composite)wRenameGroup, 131072);
        this.wlOldDnField.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.OldDnField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOldDnField);
        FormData fdlOldDnField = new FormData();
        fdlOldDnField.left = new FormAttachment(0, 0);
        fdlOldDnField.top = new FormAttachment((Control)wSettings, margin);
        fdlOldDnField.right = new FormAttachment(middle, -margin);
        this.wlOldDnField.setLayoutData((Object)fdlOldDnField);
        this.wOldDnField = new ComboVar(this.variables, (Composite)wRenameGroup, 2060);
        this.wOldDnField.setEditable(true);
        this.props.setLook((Control)this.wOldDnField);
        this.wOldDnField.addModifyListener(lsMod);
        FormData fdOldDnField = new FormData();
        fdOldDnField.left = new FormAttachment(middle, 0);
        fdOldDnField.top = new FormAttachment((Control)wSettings, margin);
        fdOldDnField.right = new FormAttachment(100, -margin);
        this.wOldDnField.setLayoutData((Object)fdOldDnField);
        this.wOldDnField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LdapOutputDialog.this.getPreviousFields();
            }
        });
        this.wlNewDnField = new Label((Composite)wRenameGroup, 131072);
        this.wlNewDnField.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.NewDnField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNewDnField);
        FormData fdlNewDnField = new FormData();
        fdlNewDnField.left = new FormAttachment(0, 0);
        fdlNewDnField.top = new FormAttachment((Control)this.wOldDnField, margin);
        fdlNewDnField.right = new FormAttachment(middle, -margin);
        this.wlNewDnField.setLayoutData((Object)fdlNewDnField);
        this.wNewDnField = new ComboVar(this.variables, (Composite)wRenameGroup, 2060);
        this.wNewDnField.setEditable(true);
        this.props.setLook((Control)this.wNewDnField);
        this.wNewDnField.addModifyListener(lsMod);
        FormData fdNewDnField = new FormData();
        fdNewDnField.left = new FormAttachment(middle, 0);
        fdNewDnField.top = new FormAttachment((Control)this.wOldDnField, margin);
        fdNewDnField.right = new FormAttachment(100, -margin);
        this.wNewDnField.setLayoutData((Object)fdNewDnField);
        this.wNewDnField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LdapOutputDialog.this.getPreviousFields();
            }
        });
        this.wlDeleteRDN = new Label((Composite)wRenameGroup, 131072);
        this.wlDeleteRDN.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.DeleteRDN.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDeleteRDN);
        FormData fdlDeleteRDN = new FormData();
        fdlDeleteRDN.left = new FormAttachment(0, 0);
        fdlDeleteRDN.top = new FormAttachment((Control)this.wNewDnField, margin);
        fdlDeleteRDN.right = new FormAttachment(middle, -margin);
        this.wlDeleteRDN.setLayoutData((Object)fdlDeleteRDN);
        this.wDeleteRDN = new Button((Composite)wRenameGroup, 32);
        this.wDeleteRDN.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.DeleteRDN.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDeleteRDN);
        FormData fdDeleteRDN = new FormData();
        fdDeleteRDN.left = new FormAttachment(middle, 0);
        fdDeleteRDN.top = new FormAttachment((Control)this.wlDeleteRDN, 0, 0x1000000);
        fdDeleteRDN.right = new FormAttachment(100, 0);
        this.wDeleteRDN.setLayoutData((Object)fdDeleteRDN);
        SelectionAdapter lsSeld = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LdapOutputDialog.this.input.setChanged();
            }
        };
        this.wDeleteRDN.addSelectionListener((SelectionListener)lsSeld);
        FormData fdRenameGroup = new FormData();
        fdRenameGroup.left = new FormAttachment(0, margin);
        fdRenameGroup.top = new FormAttachment((Control)wSettings, margin);
        fdRenameGroup.right = new FormAttachment(100, -margin);
        wRenameGroup.setLayoutData((Object)fdRenameGroup);
        FormData fdSettingsComp = new FormData();
        fdSettingsComp.left = new FormAttachment(0, 0);
        fdSettingsComp.top = new FormAttachment(0, 0);
        fdSettingsComp.right = new FormAttachment(100, 0);
        fdSettingsComp.bottom = new FormAttachment(100, 0);
        wSettingsComp.setLayoutData((Object)fdSettingsComp);
        wSettingsComp.layout();
        wSettingsTab.setControl((Control)wSettingsComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Fields.Tab", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        Group wFields = new Group(wFieldsComp, 32);
        this.props.setLook((Control)wFields);
        wFields.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Group.Fields.Label", (String[])new String[0]));
        FormLayout fieldsLayout2 = new FormLayout();
        fieldsLayout2.marginWidth = 10;
        fieldsLayout2.marginHeight = 10;
        wFields.setLayout((Layout)fieldsLayout2);
        this.wlBaseDN = new Label((Composite)wFields, 131072);
        this.wlBaseDN.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.BaseDN.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBaseDN);
        FormData fdlBaseDN = new FormData();
        fdlBaseDN.left = new FormAttachment(0, 0);
        fdlBaseDN.top = new FormAttachment((Control)wSettings, margin);
        fdlBaseDN.right = new FormAttachment(middle, -margin);
        this.wlBaseDN.setLayoutData((Object)fdlBaseDN);
        this.wBaseDN = new TextVar(this.variables, (Composite)wFields, 18436);
        this.wBaseDN.setToolTipText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.BaseDN.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wBaseDN);
        this.wBaseDN.addModifyListener(lsMod);
        FormData fdBaseDN = new FormData();
        fdBaseDN.left = new FormAttachment(middle, 0);
        fdBaseDN.top = new FormAttachment((Control)wSettings, margin);
        fdBaseDN.right = new FormAttachment(100, 0);
        this.wBaseDN.setLayoutData((Object)fdBaseDN);
        this.wBaseDN.addModifyListener(e -> {
            this.input.setChanged();
            if (Utils.isEmpty((CharSequence)this.wBaseDN.getText())) {
                this.wDoMapping.setEnabled(false);
            } else {
                this.setFieldsCombo();
                this.wDoMapping.setEnabled(true);
            }
        });
        this.wlReturn = new Label((Composite)wFields, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"LdapOutputUpdateDialog.UpdateFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)this.wBaseDN, margin);
        this.wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 3;
        int upInsRows = this.input.getUpdateLookup() != null ? this.input.getUpdateLookup().length : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapOutputUpdateDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapOutputUpdateDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapOutputUpdateDialog.ColumnInfo.Update", (String[])new String[0]), 2, new String[]{"Y", "N"});
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, (Composite)wFields, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        this.wGetLU = new Button((Composite)wFields, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"LdapOutputUpdateDialog.GetAndUpdateFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)this.wlReturn, margin);
        fdGetLU.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)fdGetLU);
        this.wDoMapping = new Button((Composite)wFields, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"LdapOutputUpdateDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)this.wGetLU, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)fdDoMapping);
        this.wDoMapping.addListener(13, arg0 -> this.generateMappings());
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)this.wGetLU, -5 * margin);
        fdReturn.bottom = new FormAttachment(100, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, margin);
        fdFields.top = new FormAttachment((Control)wSettings, margin);
        fdFields.right = new FormAttachment(100, -margin);
        fdFields.bottom = new FormAttachment(100, -margin);
        wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTest.addListener(13, e -> this.test());
        this.wGetLU.addListener(13, e -> this.getUpdate());
        wTabFolder.setSelection(0);
        this.getData(this.input);
        this.useAuthentication();
        this.setProtocol();
        this.setTrustStore();
        this.updateOperation();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() {
        LdapConnection connection = null;
        try {
            LdapOutputMeta meta = new LdapOutputMeta();
            this.getInfo(meta);
            connection = new LdapConnection((ILogChannel)this.log, this.variables, meta, null);
            if (this.wUsingAuthentication.getSelection()) {
                connection.connect(this.variables.resolve(meta.getUserName()), Encr.decryptPasswordOptionallyEncrypted((String)this.variables.resolve(meta.getPassword())));
            } else {
                connection.connect();
            }
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Connected.OK", (String[])new String[0]) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Connected.NOK", (String[])new String[]{e.getMessage()}));
            mb.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.Connected.Title.Error", (String[])new String[0]));
            mb.open();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void getData(LdapOutputMeta in) {
        this.wProtocol.setText(Const.NVL((String)in.getProtocol(), (String)LdapProtocolFactory.getConnectionTypes((ILogChannel)this.log).get(0)));
        this.wSetTrustStore.setSelection(in.isUseCertificate());
        if (in.getTrustStorePath() != null) {
            this.wTrustStorePath.setText(in.getTrustStorePath());
        }
        if (in.getTrustStorePassword() != null) {
            this.wTrustStorePassword.setText(in.getTrustStorePassword());
        }
        this.wTrustAll.setSelection(in.isTrustAllCertificates());
        this.wUsingAuthentication.setSelection(in.isUseAuthentication());
        if (in.getHost() != null) {
            this.wHost.setText(in.getHost());
        }
        if (in.getUserName() != null) {
            this.wUserName.setText(in.getUserName());
        }
        if (in.getPassword() != null) {
            this.wPassword.setText(in.getPassword());
        }
        if (in.getPort() != null) {
            this.wPort.setText(in.getPort());
        }
        if (in.getDnField() != null) {
            this.wDnField.setText(in.getDnField());
        }
        this.wFailIfNotExist.setSelection(in.isFailIfNotExist());
        this.wOperation.setText(LdapOutputMeta.getOperationTypeDesc(this.input.getOperationType()));
        if (in.getMultiValuedSeparator() != null) {
            this.wMultiValuedSeparator.setText(in.getMultiValuedSeparator());
        }
        if (in.getSearchBaseDN() != null) {
            this.wBaseDN.setText(in.getSearchBaseDN());
        }
        this.wReferral.setText(LdapOutputMeta.getReferralTypeDesc(this.input.getReferralType()));
        this.wDerefAliases.setText(LdapOutputMeta.getDerefAliasesTypeDesc(this.input.getDerefAliasesType()));
        if (in.getOldDnFieldName() != null) {
            this.wOldDnField.setText(in.getOldDnFieldName());
        }
        if (in.getNewDnFieldName() != null) {
            this.wNewDnField.setText(in.getNewDnFieldName());
        }
        this.wDeleteRDN.setSelection(in.isDeleteRDN());
        if (this.input.getUpdateLookup() != null) {
            for (int i = 0; i < this.input.getUpdateLookup().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getUpdateLookup()[i] != null) {
                    item.setText(1, this.input.getUpdateLookup()[i]);
                }
                if (this.input.getUpdateStream()[i] != null) {
                    item.setText(2, this.input.getUpdateStream()[i]);
                }
                if (this.input.getUpdate()[i] == null || this.input.getUpdate()[i].booleanValue()) {
                    item.setText(3, "Y");
                    continue;
                }
                item.setText(3, "N");
            }
        }
        this.wReturn.removeEmptyRows();
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapOutputDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(LdapOutputMeta in) throws HopException {
        this.transformName = this.wTransformName.getText();
        in.setProtocol(this.wProtocol.getText());
        in.setUseCertificate(this.wSetTrustStore.getSelection());
        in.setTrustStorePath(this.wTrustStorePath.getText());
        in.setTrustStorePassword(this.wTrustStorePassword.getText());
        in.setTrustAllCertificates(this.wTrustAll.getSelection());
        in.setUseAuthentication(this.wUsingAuthentication.getSelection());
        in.setHost(this.wHost.getText());
        in.setUserName(this.wUserName.getText());
        in.setPassword(this.wPassword.getText());
        in.setPort(this.wPort.getText());
        in.setDnField(this.wDnField.getText());
        in.setFailIfNotExist(this.wFailIfNotExist.getSelection());
        in.setOperationType(LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()));
        in.setMultiValuedSeparator(this.wMultiValuedSeparator.getText());
        in.setSearchBaseDN(this.wBaseDN.getText());
        in.setReferralType(LdapOutputMeta.getReferralTypeByDesc(this.wReferral.getText()));
        in.setDerefAliasesType(LdapOutputMeta.getDerefAliasesTypeByDesc(this.wDerefAliases.getText()));
        in.setOldDnFieldName(this.wOldDnField.getText());
        in.setNewDnFieldName(this.wNewDnField.getText());
        in.setDeleteRDN(this.wDeleteRDN.getSelection());
        int nrFields = this.wReturn.nrNonEmpty();
        in.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            in.getUpdateLookup()[i] = item.getText(1);
            in.getUpdateStream()[i] = item.getText(2);
            in.getUpdate()[i] = "Y".equals(item.getText(3));
        }
    }

    private void useAuthentication() {
        this.wUserName.setEnabled(this.wUsingAuthentication.getSelection());
        this.wlUserName.setEnabled(this.wUsingAuthentication.getSelection());
        this.wPassword.setEnabled(this.wUsingAuthentication.getSelection());
        this.wlPassword.setEnabled(this.wUsingAuthentication.getSelection());
    }

    private void getPreviousFields() {
        if (!this.gotPrevious) {
            try {
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    String dn = this.wDnField.getText();
                    String olddn = this.wOldDnField.getText();
                    String newdn = this.wNewDnField.getText();
                    this.wDnField.removeAll();
                    this.wOldDnField.removeAll();
                    this.wNewDnField.removeAll();
                    this.wDnField.setItems(r.getFieldNames());
                    this.wOldDnField.setItems(r.getFieldNames());
                    this.wNewDnField.setItems(r.getFieldNames());
                    if (dn != null) {
                        this.wDnField.setText(dn);
                    }
                    if (olddn != null) {
                        this.wOldDnField.setText(olddn);
                    }
                    if (newdn != null) {
                        this.wNewDnField.setText(newdn);
                    }
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapOutputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPrevious = true;
        }
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(3, "Y");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapOutputUpdateDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputUpdateDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void updateOperation() {
        boolean activateFields = LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 4 && LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 5;
        this.wlReturn.setEnabled(activateFields);
        this.wReturn.setEnabled(activateFields);
        this.wGetLU.setEnabled(activateFields);
        this.wBaseDN.setEnabled(activateFields);
        this.wlBaseDN.setEnabled(activateFields);
        this.wDoMapping.setEnabled(activateFields && !Utils.isEmpty((CharSequence)this.wBaseDN.getText()));
        boolean activateMulTiValueSeparator = LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 4 && LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2 && LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 5;
        this.wlMultiValuedSeparator.setEnabled(activateMulTiValueSeparator);
        this.wMultiValuedSeparator.setEnabled(activateMulTiValueSeparator);
        boolean activateFailIfNotExist = LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 1 && LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 0 && LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 5;
        this.wlFailIfNotExist.setEnabled(activateFailIfNotExist);
        this.wFailIfNotExist.setEnabled(activateFailIfNotExist);
        boolean activateRename = LdapOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) == 5;
        this.wlOldDnField.setEnabled(activateRename);
        this.wOldDnField.setEnabled(activateRename);
        this.wlNewDnField.setEnabled(activateRename);
        this.wNewDnField.setEnabled(activateRename);
        this.wlDeleteRDN.setEnabled(activateRename);
        this.wDeleteRDN.setEnabled(activateRename);
        this.wlDnField.setEnabled(!activateRename);
        this.wDnField.setEnabled(!activateRename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowMeta getLDAPFields() throws HopException {
        LdapConnection connection = null;
        try {
            LdapOutputMeta meta = new LdapOutputMeta();
            this.getInfo(meta);
            connection = new LdapConnection((ILogChannel)this.log, this.variables, meta, null);
            if (this.wUsingAuthentication.getSelection()) {
                String username = this.variables.resolve(this.wUserName.getText());
                String password = Encr.decryptPasswordOptionallyEncrypted((String)this.variables.resolve(this.wPassword.getText()));
                connection.connect(username, password);
            } else {
                connection.connect();
            }
            RowMeta rowMeta = connection.getFields(this.variables.resolve(this.wBaseDN.getText()));
            return rowMeta;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapOutputDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        LdapConnection connection = null;
        try {
            targetFields = this.getLDAPFields();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapOutputDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), e);
            return;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"LdapOutputDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"LdapOutputDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"LdapOutputDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageBox box = new MessageBox(this.shell, 192);
            box.setText(BaseMessages.getString(PKG, (String)"LdapOutputDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]));
            box.setMessage((String)message);
            boolean bl = goOn = (box.open() & 0x40) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    public void setFieldsCombo() {
        Display display = this.shell.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(() -> {
                block8: {
                    for (ColumnInfo colInfo : this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (this.wBaseDN.isDisposed()) {
                        return;
                    }
                    String baseDn = this.variables.resolve(this.wBaseDN.getText());
                    if (!Utils.isEmpty((CharSequence)baseDn)) {
                        try {
                            IRowMeta fields = this.getLDAPFields();
                            String[] fieldsName = new String[fields.size()];
                            for (int i = 0; i < fields.size(); ++i) {
                                fieldsName[i] = fields.getValueMeta(i).getName();
                            }
                            if (fieldsName == null) break block8;
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldsName);
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            });
        }
    }

    private void setProtocol() {
        boolean enable = !LdapProtocol.getName().equals(this.wProtocol.getText());
        this.wlSetTrustStore.setEnabled(enable);
        this.wSetTrustStore.setEnabled(enable);
        this.setTrustStore();
    }

    private void setTrustStore() {
        boolean enable = this.wSetTrustStore.getSelection() && !LdapProtocol.getName().equals(this.wProtocol.getText());
        this.wlTrustAll.setEnabled(enable);
        this.wTrustAll.setEnabled(enable);
        this.trustAll();
    }

    private void trustAll() {
        boolean enable = this.wSetTrustStore.getSelection() && !LdapProtocol.getName().equals(this.wProtocol.getText()) && !this.wTrustAll.getSelection();
        this.wlTrustStorePath.setEnabled(enable);
        this.wTrustStorePath.setEnabled(enable);
        this.wlTrustStorePassword.setEnabled(enable);
        this.wTrustStorePassword.setEnabled(enable);
        this.wbbFilename.setEnabled(enable);
    }
}

