/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public abstract class PipelineRunner<ResultT extends PipelineResult> {
    public static PipelineRunner<? extends PipelineResult> fromOptions(PipelineOptions options) {
        Preconditions.checkNotNull((Object)options);
        PipelineOptionsValidator.validate(PipelineOptions.class, options);
        FileSystems.setDefaultPipelineOptions(options);
        PipelineRunner result = InstanceBuilder.ofType(PipelineRunner.class).fromClass(options.getRunner()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, options).build();
        return result;
    }

    public static PipelineRunner<? extends PipelineResult> create() {
        return PipelineRunner.fromOptions(PipelineOptionsFactory.create());
    }

    public abstract ResultT run(Pipeline var1);

    public ResultT run(PTransform<PBegin, ?> pTransform, PipelineOptions options) {
        Pipeline p = Pipeline.create(options);
        p.apply(pTransform);
        return this.run(p);
    }

    public ResultT run(PTransform<PBegin, ?> pTransform) {
        return this.run(pTransform, PipelineOptionsFactory.create());
    }
}

