/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteCoder;

public class BooleanCoder
extends AtomicCoder<Boolean> {
    private static final ByteCoder BYTE_CODER = ByteCoder.of();
    private static final BooleanCoder INSTANCE = new BooleanCoder();

    public static BooleanCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode(Boolean value, OutputStream os) throws IOException {
        BYTE_CODER.encode(value != false ? (byte)1 : 0, os);
    }

    @Override
    public Boolean decode(InputStream is) throws IOException {
        Byte value = BYTE_CODER.decode(is);
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new IOException(String.format("Expected 0 or 1, got %d", value));
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Boolean value) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(Boolean value) throws Exception {
        return 1L;
    }
}

