/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.joda.time.Instant;

public abstract class PartitioningWindowFn<T, W extends BoundedWindow>
extends NonMergingWindowFn<T, W> {
    public abstract W assignWindow(Instant var1);

    @Override
    public final Collection<W> assignWindows(WindowFn.AssignContext c) {
        return Arrays.asList(this.assignWindow(c.timestamp()));
    }

    @Override
    public WindowMappingFn<W> getDefaultWindowMappingFn() {
        return new WindowMappingFn<W>(){

            @Override
            public W getSideInputWindow(BoundedWindow mainWindow) {
                if (mainWindow instanceof GlobalWindow) {
                    throw new IllegalArgumentException("Attempted to get side input window for GlobalWindow from non-global WindowFn");
                }
                return PartitioningWindowFn.this.assignWindow(mainWindow.maxTimestamp());
            }
        };
    }

    @Override
    public final boolean assignsToOneWindow() {
        return true;
    }
}

