/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatements;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

@InternalApi
public class SpannerStatementParser
extends AbstractStatementParser {
    public SpannerStatementParser() throws ClientSideStatementImpl.CompileException {
        super(Dialect.GOOGLE_STANDARD_SQL, Collections.unmodifiableSet(ClientSideStatements.getInstance(Dialect.GOOGLE_STANDARD_SQL).getCompiledStatements()));
    }

    @Override
    protected boolean supportsExplain() {
        return true;
    }

    @Override
    @InternalApi
    String removeCommentsAndTrimInternal(String sql) {
        Preconditions.checkNotNull((Object)sql);
        boolean isInQuoted = false;
        boolean isInSingleLineComment = false;
        boolean isInMultiLineComment = false;
        char startQuote = '\u0000';
        boolean lastCharWasEscapeChar = false;
        boolean isTripleQuoted = false;
        StringBuilder res = new StringBuilder(sql.length());
        for (int index = 0; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            if (isInQuoted) {
                if (!(c != '\n' && c != '\r' || isTripleQuoted)) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
                }
                if (c == startQuote) {
                    if (lastCharWasEscapeChar) {
                        lastCharWasEscapeChar = false;
                    } else if (isTripleQuoted) {
                        if (sql.length() > index + 2 && sql.charAt(index + 1) == startQuote && sql.charAt(index + 2) == startQuote) {
                            isInQuoted = false;
                            startQuote = '\u0000';
                            isTripleQuoted = false;
                            res.append(c).append(c);
                            index += 2;
                        }
                    } else {
                        isInQuoted = false;
                        startQuote = '\u0000';
                    }
                } else {
                    lastCharWasEscapeChar = c == '\\';
                }
                res.append(c);
                continue;
            }
            if (isInSingleLineComment) {
                if (c != '\n') continue;
                isInSingleLineComment = false;
                res.append(c);
                continue;
            }
            if (isInMultiLineComment) {
                if (sql.length() <= index + 1 || c != '*' || sql.charAt(index + 1) != '/') continue;
                isInMultiLineComment = false;
                ++index;
                continue;
            }
            if (c == '#' || sql.length() > index + 1 && c == '-' && sql.charAt(index + 1) == '-') {
                isInSingleLineComment = true;
                continue;
            }
            if (sql.length() > index + 1 && c == '/' && sql.charAt(index + 1) == '*') {
                isInMultiLineComment = true;
                ++index;
                continue;
            }
            if (c == '\'' || c == '\"' || c == '`') {
                isInQuoted = true;
                startQuote = c;
                if (sql.length() > index + 2 && sql.charAt(index + 1) == startQuote && sql.charAt(index + 2) == startQuote) {
                    isTripleQuoted = true;
                    res.append(c).append(c);
                    index += 2;
                }
            }
            res.append(c);
        }
        if (isInQuoted) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
        }
        if (res.length() > 0 && res.charAt(res.length() - 1) == ';') {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString().trim();
    }

    @Override
    String removeStatementHint(String sql) {
        String keyword;
        int startStatementHintIndex = sql.indexOf(123);
        int startQueryIndex = -1;
        String upperCaseSql = sql.toUpperCase();
        ImmutableSet selectAndDmlStatements = Sets.union((Set)selectStatements, (Set)dmlStatements).immutableCopy();
        Iterator iterator = selectAndDmlStatements.iterator();
        while (iterator.hasNext() && (startQueryIndex = upperCaseSql.indexOf(keyword = (String)iterator.next())) <= -1) {
        }
        if (startQueryIndex > -1) {
            int endStatementHintIndex = sql.substring(0, startQueryIndex).lastIndexOf(125);
            if (startStatementHintIndex == -1 || startStatementHintIndex > endStatementHintIndex) {
                return sql;
            }
            return this.removeCommentsAndTrim(sql.substring(endStatementHintIndex + 1));
        }
        return sql;
    }

    @Override
    @InternalApi
    AbstractStatementParser.ParametersInfo convertPositionalParametersToNamedParametersInternal(char paramChar, String sql) {
        int SINGLE_QUOTE = 39;
        int DOUBLE_QUOTE = 34;
        int BACKTICK_QUOTE = 96;
        boolean isInQuoted = false;
        char startQuote = '\u0000';
        boolean lastCharWasEscapeChar = false;
        boolean isTripleQuoted = false;
        int paramIndex = 1;
        StringBuilder named = new StringBuilder(sql.length() + SpannerStatementParser.countOccurrencesOf(paramChar, sql));
        for (int index = 0; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            if (isInQuoted) {
                if (!(c != '\n' && c != '\r' || isTripleQuoted)) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
                }
                if (c == startQuote) {
                    if (lastCharWasEscapeChar) {
                        lastCharWasEscapeChar = false;
                    } else if (isTripleQuoted) {
                        if (sql.length() > index + 2 && sql.charAt(index + 1) == startQuote && sql.charAt(index + 2) == startQuote) {
                            isInQuoted = false;
                            startQuote = '\u0000';
                            isTripleQuoted = false;
                        }
                    } else {
                        isInQuoted = false;
                        startQuote = '\u0000';
                    }
                } else {
                    lastCharWasEscapeChar = c == '\\';
                }
                named.append(c);
                continue;
            }
            if (c == paramChar) {
                named.append("@p" + paramIndex);
                ++paramIndex;
                continue;
            }
            if (c == '\'' || c == '\"' || c == '`') {
                isInQuoted = true;
                startQuote = c;
                if (sql.length() > index + 2 && sql.charAt(index + 1) == startQuote && sql.charAt(index + 2) == startQuote) {
                    isTripleQuoted = true;
                }
            }
            named.append(c);
        }
        if (isInQuoted) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
        }
        return new AbstractStatementParser.ParametersInfo(paramIndex - 1, named.toString());
    }
}

