/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.google.auto.value.AutoValue;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.AutoValue_ModelCoders_KvCoderComponents;
import org.apache.beam.runners.core.construction.AutoValue_ModelCoders_WindowedValueCoderComponents;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

public class ModelCoders {
    public static final String BYTES_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BYTES);
    public static final String BOOL_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.BOOL);
    public static final String INT64_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.VARINT);
    public static final String STRING_UTF8_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STRING_UTF8);
    public static final String DOUBLE_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.DOUBLE);
    public static final String ITERABLE_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.ITERABLE);
    public static final String TIMER_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.TIMER);
    public static final String KV_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.KV);
    public static final String LENGTH_PREFIX_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.LENGTH_PREFIX);
    public static final String GLOBAL_WINDOW_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.GLOBAL_WINDOW);
    public static final String INTERVAL_WINDOW_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.INTERVAL_WINDOW);
    public static final String CUSTOM_WINDOW_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.CUSTOM_WINDOW);
    public static final String WINDOWED_VALUE_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.WINDOWED_VALUE);
    public static final String PARAM_WINDOWED_VALUE_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.PARAM_WINDOWED_VALUE);
    public static final String ROW_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.ROW);
    public static final String STATE_BACKED_ITERABLE_CODER_URN = "beam:coder:state_backed_iterable:v1";
    public static final String SHARDED_KEY_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.SHARDED_KEY);
    public static final String NULLABLE_CODER_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.NULLABLE);
    private static final Set<String> MODEL_CODER_URNS;

    private ModelCoders() {
    }

    public static Set<String> urns() {
        return MODEL_CODER_URNS;
    }

    public static WindowedValueCoderComponents getWindowedValueCoderComponents(RunnerApi.Coder coder) {
        Preconditions.checkArgument((boolean)WINDOWED_VALUE_CODER_URN.equals(coder.getSpec().getUrn()));
        return new AutoValue_ModelCoders_WindowedValueCoderComponents(coder.getComponentCoderIds(0), coder.getComponentCoderIds(1));
    }

    public static RunnerApi.Coder windowedValueCoder(String elementCoderId, String windowCoderId) {
        return RunnerApi.Coder.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(WINDOWED_VALUE_CODER_URN)).addComponentCoderIds(elementCoderId).addComponentCoderIds(windowCoderId).build();
    }

    public static RunnerApi.Coder paramWindowedValueCoder(String elementCoderId, String windowCoderId, byte[] payload) {
        return RunnerApi.Coder.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(PARAM_WINDOWED_VALUE_CODER_URN).setPayload(ByteString.copyFrom((byte[])payload))).addComponentCoderIds(elementCoderId).addComponentCoderIds(windowCoderId).build();
    }

    public static KvCoderComponents getKvCoderComponents(RunnerApi.Coder coder) {
        Preconditions.checkArgument((boolean)KV_CODER_URN.equals(coder.getSpec().getUrn()), (String)"Provided coder %s is not of type %s", (Object)coder.getSpec().getUrn(), (Object)KV_CODER_URN);
        return new AutoValue_ModelCoders_KvCoderComponents(coder.getComponentCoderIds(0), coder.getComponentCoderIds(1));
    }

    public static RunnerApi.Coder kvCoder(String keyCoderId, String valueCoderId) {
        return RunnerApi.Coder.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(KV_CODER_URN)).addComponentCoderIds(keyCoderId).addComponentCoderIds(valueCoderId).build();
    }

    static {
        Preconditions.checkState((boolean)STATE_BACKED_ITERABLE_CODER_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.STATE_BACKED_ITERABLE)));
        MODEL_CODER_URNS = ImmutableSet.of((Object)BYTES_CODER_URN, (Object)BOOL_CODER_URN, (Object)INT64_CODER_URN, (Object)STRING_UTF8_CODER_URN, (Object)ITERABLE_CODER_URN, (Object)TIMER_CODER_URN, (Object[])new String[]{KV_CODER_URN, LENGTH_PREFIX_CODER_URN, GLOBAL_WINDOW_CODER_URN, INTERVAL_WINDOW_CODER_URN, CUSTOM_WINDOW_CODER_URN, WINDOWED_VALUE_CODER_URN, DOUBLE_CODER_URN, ROW_CODER_URN, PARAM_WINDOWED_VALUE_CODER_URN, STATE_BACKED_ITERABLE_CODER_URN, SHARDED_KEY_CODER_URN, NULLABLE_CODER_URN});
    }

    @AutoValue
    public static abstract class KvCoderComponents {
        public abstract String keyCoderId();

        public abstract String valueCoderId();
    }

    @AutoValue
    public static abstract class WindowedValueCoderComponents {
        public abstract String elementCoderId();

        public abstract String windowCoderId();
    }
}

