/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.util.Collections;
import org.apache.cassandra.utils.NativeLibraryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryDarwin
implements NativeLibraryWrapper {
    private static final Logger logger = LoggerFactory.getLogger(NativeLibraryDarwin.class);
    private static boolean available;

    private static native int mlockall(int var0) throws LastErrorException;

    private static native int munlockall() throws LastErrorException;

    private static native int fcntl(int var0, int var1, long var2) throws LastErrorException;

    private static native int open(String var0, int var1) throws LastErrorException;

    private static native int fsync(int var0) throws LastErrorException;

    private static native int close(int var0) throws LastErrorException;

    private static native Pointer strerror(int var0) throws LastErrorException;

    private static native long getpid() throws LastErrorException;

    @Override
    public int callMlockall(int flags) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryDarwin.mlockall(flags);
    }

    @Override
    public int callMunlockall() throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryDarwin.munlockall();
    }

    @Override
    public int callFcntl(int fd, int command, long flags) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryDarwin.fcntl(fd, command, flags);
    }

    @Override
    public int callPosixFadvise(int fd, long offset, int len, int flag) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public int callOpen(String path, int flags) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryDarwin.open(path, flags);
    }

    @Override
    public int callFsync(int fd) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryDarwin.fsync(fd);
    }

    @Override
    public int callClose(int fd) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryDarwin.close(fd);
    }

    @Override
    public Pointer callStrerror(int errnum) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryDarwin.strerror(errnum);
    }

    @Override
    public long callGetpid() throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryDarwin.getpid();
    }

    @Override
    public boolean isAvailable() {
        return available;
    }

    static {
        try {
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"c", Collections.emptyMap()));
            available = true;
        }
        catch (NoClassDefFoundError e) {
            logger.warn("JNA not found. Native methods will be disabled.");
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Failed to link the C library against JNA. Native methods will be unavailable.", (Throwable)e);
        }
        catch (NoSuchMethodError e) {
            logger.warn("Obsolete version of JNA present; unable to register C library. Upgrade to JNA 3.2.7 or later");
        }
    }
}

