/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphStoreWatcher;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.flink.shaded.curator5.org.apache.curator.utils.ZKPaths;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperJobGraphStoreWatcher
implements JobGraphStoreWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperJobGraphStoreWatcher.class);
    private final PathChildrenCache pathCache;
    private JobGraphStore.JobGraphListener jobGraphListener;
    private volatile boolean running;

    public ZooKeeperJobGraphStoreWatcher(PathChildrenCache pathCache) {
        this.pathCache = (PathChildrenCache)Preconditions.checkNotNull((Object)pathCache);
        this.pathCache.getListenable().addListener((Object)new JobGraphsPathCacheListener());
        this.running = false;
    }

    @Override
    public void start(JobGraphStore.JobGraphListener jobGraphListener) throws Exception {
        this.jobGraphListener = (JobGraphStore.JobGraphListener)Preconditions.checkNotNull((Object)jobGraphListener);
        this.running = true;
        this.pathCache.start();
    }

    @Override
    public void stop() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Stopping ZooKeeperJobGraphStoreWatcher ");
        this.pathCache.close();
    }

    private final class JobGraphsPathCacheListener
    implements PathChildrenCacheListener {
        private JobGraphsPathCacheListener() {
        }

        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
            if (LOG.isDebugEnabled()) {
                if (event.getData() != null) {
                    LOG.debug("Received {} event (path: {})", (Object)event.getType(), (Object)event.getData().getPath());
                } else {
                    LOG.debug("Received {} event", (Object)event.getType());
                }
            }
            switch (event.getType()) {
                case CHILD_ADDED: {
                    JobID jobId = this.fromEvent(event);
                    LOG.debug("Received CHILD_ADDED event notification for job {}", (Object)jobId);
                    ZooKeeperJobGraphStoreWatcher.this.jobGraphListener.onAddedJobGraph(jobId);
                    break;
                }
                case CHILD_UPDATED: {
                    break;
                }
                case CHILD_REMOVED: {
                    JobID jobId = this.fromEvent(event);
                    LOG.debug("Received CHILD_REMOVED event notification for job {}", (Object)jobId);
                    ZooKeeperJobGraphStoreWatcher.this.jobGraphListener.onRemovedJobGraph(jobId);
                    break;
                }
                case CONNECTION_SUSPENDED: {
                    LOG.warn("ZooKeeper connection SUSPENDING. Changes to the submitted job graphs are not monitored (temporarily).");
                    break;
                }
                case CONNECTION_LOST: {
                    LOG.warn("ZooKeeper connection LOST. Changes to the submitted job graphs are not monitored (permanently).");
                    break;
                }
                case CONNECTION_RECONNECTED: {
                    LOG.info("ZooKeeper connection RECONNECTED. Changes to the submitted job graphs are monitored again.");
                    break;
                }
                case INITIALIZED: {
                    LOG.info("JobGraphsPathCacheListener initialized");
                }
            }
        }

        private JobID fromEvent(PathChildrenCacheEvent event) {
            return JobID.fromHexString((String)ZKPaths.getNodeFromPath((String)event.getData().getPath()));
        }
    }
}

