/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.values.PCollection;

public class PCollectionTranslation {
    private PCollectionTranslation() {
    }

    public static RunnerApi.PCollection toProto(PCollection<?> pCollection, SdkComponents components) throws IOException {
        String coderId = components.registerCoder(pCollection.getCoder());
        String windowingStrategyId = components.registerWindowingStrategy(pCollection.getWindowingStrategy());
        return RunnerApi.PCollection.newBuilder().setUniqueName(pCollection.getName()).setCoderId(coderId).setIsBounded(PCollectionTranslation.toProto(pCollection.isBounded())).setWindowingStrategyId(windowingStrategyId).build();
    }

    public static PCollection<?> fromProto(RunnerApi.PCollection pCollection, Pipeline pipeline, RehydratedComponents components) throws IOException {
        Coder<?> coder = components.getCoder(pCollection.getCoderId());
        return PCollection.createPrimitiveOutputInternal(pipeline, components.getWindowingStrategy(pCollection.getWindowingStrategyId()), PCollectionTranslation.fromProto(pCollection.getIsBounded()), coder);
    }

    public static PCollection.IsBounded isBounded(RunnerApi.PCollection pCollection) {
        return PCollectionTranslation.fromProto(pCollection.getIsBounded());
    }

    static RunnerApi.IsBounded.Enum toProto(PCollection.IsBounded bounded) {
        switch (bounded) {
            case BOUNDED: {
                return RunnerApi.IsBounded.Enum.BOUNDED;
            }
            case UNBOUNDED: {
                return RunnerApi.IsBounded.Enum.UNBOUNDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s %s", new Object[]{PCollection.IsBounded.class.getSimpleName(), bounded}));
    }

    static PCollection.IsBounded fromProto(RunnerApi.IsBounded.Enum isBounded) {
        switch (isBounded) {
            case BOUNDED: {
                return PCollection.IsBounded.BOUNDED;
            }
            case UNBOUNDED: {
                return PCollection.IsBounded.UNBOUNDED;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.IsBounded.class.getCanonicalName(), PCollection.IsBounded.class.getCanonicalName(), isBounded));
    }
}

