/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class PTransformReplacements {
    public static <T> PCollection<T> getSingletonMainInput(AppliedPTransform<? extends PCollection<? extends T>, ?, ?> application) {
        return PTransformReplacements.getSingletonMainInput(application.getInputs(), ((PTransform)application.getTransform()).getAdditionalInputs().keySet());
    }

    private static <T> PCollection<T> getSingletonMainInput(Map<TupleTag<?>, PCollection<?>> inputs, Set<TupleTag<?>> ignoredTags) {
        PCollection<?> mainInput = null;
        for (Map.Entry<TupleTag<?>, PCollection<?>> input : inputs.entrySet()) {
            if (ignoredTags.contains(input.getKey())) continue;
            Preconditions.checkArgument((mainInput == null ? 1 : 0) != 0, (String)"Got multiple inputs that are not additional inputs for a singleton main input: %s and %s", mainInput, input.getValue());
            Preconditions.checkArgument((boolean)(input.getValue() instanceof PCollection), (String)"Unexpected input type %s", input.getValue().getClass());
            mainInput = input.getValue();
        }
        Preconditions.checkArgument((mainInput != null ? 1 : 0) != 0, (String)"No main input found in inputs: Inputs %s, Side Input tags %s", inputs, ignoredTags);
        return mainInput;
    }

    public static <T> PCollection<T> getSingletonMainOutput(AppliedPTransform<?, PCollection<T>, ? extends PTransform<?, PCollection<T>>> transform) {
        return (PCollection)Iterables.getOnlyElement(transform.getOutputs().values());
    }
}

