/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.Operation;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.RequestResponseChannel;
import com.microsoft.azure.eventhubs.impl.SessionProvider;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResponseOpener
implements Operation<RequestResponseChannel> {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(RequestResponseOpener.class);
    private final SessionProvider sessionProvider;
    private final String clientId;
    private final String sessionName;
    private final String linkName;
    private final String endpointAddress;
    private final AmqpConnection eventDispatcher;
    private final ScheduledExecutorService executor;
    private boolean isOpened;

    public RequestResponseOpener(SessionProvider sessionProvider, String clientId, String sessionName, String linkName, String endpointAddress, AmqpConnection eventDispatcher, ScheduledExecutorService executor) {
        this.sessionProvider = sessionProvider;
        this.clientId = clientId;
        this.sessionName = sessionName;
        this.linkName = linkName;
        this.endpointAddress = endpointAddress;
        this.eventDispatcher = eventDispatcher;
        this.executor = executor;
    }

    @Override
    public synchronized void run(final OperationResult<RequestResponseChannel, Exception> operationCallback) {
        if (this.isOpened) {
            return;
        }
        Session session = this.sessionProvider.getSession(this.sessionName, null, (error, exception) -> {
            if (error != null) {
                operationCallback.onError(ExceptionUtil.toException(error));
            } else if (exception != null) {
                operationCallback.onError((Exception)exception);
            }
        });
        if (session == null) {
            return;
        }
        final RequestResponseChannel requestResponseChannel = new RequestResponseChannel(this.linkName, this.endpointAddress, session, this.executor);
        requestResponseChannel.open(new OperationResult<Void, Exception>(){

            @Override
            public void onComplete(Void result) {
                RequestResponseOpener.this.eventDispatcher.registerForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.registerForConnectionError((Link)requestResponseChannel.getReceiveLink());
                operationCallback.onComplete(requestResponseChannel);
                RequestResponseOpener.this.isOpened = true;
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info(String.format(Locale.US, "requestResponseChannel.onOpen complete clientId[%s], session[%s], link[%s], endpoint[%s]", RequestResponseOpener.this.clientId, RequestResponseOpener.this.sessionName, RequestResponseOpener.this.linkName, RequestResponseOpener.this.endpointAddress));
                }
            }

            @Override
            public void onError(Exception error) {
                operationCallback.onError(error);
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "requestResponseChannel.onOpen error clientId[%s], session[%s], link[%s], endpoint[%s], error %s", RequestResponseOpener.this.clientId, RequestResponseOpener.this.sessionName, RequestResponseOpener.this.linkName, RequestResponseOpener.this.endpointAddress, error));
                }
            }
        }, new OperationResult<Void, Exception>(){

            @Override
            public void onComplete(Void result) {
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getReceiveLink());
                RequestResponseOpener.this.isOpened = false;
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info(String.format(Locale.US, "requestResponseChannel.onClose complete clientId[%s], session[%s], link[%s], endpoint[%s]", RequestResponseOpener.this.clientId, RequestResponseOpener.this.sessionName, RequestResponseOpener.this.linkName, RequestResponseOpener.this.endpointAddress));
                }
            }

            @Override
            public void onError(Exception error) {
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getReceiveLink());
                RequestResponseOpener.this.isOpened = false;
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "requestResponseChannel.onClose error clientId[%s], session[%s], link[%s], endpoint[%s], error %s", RequestResponseOpener.this.clientId, RequestResponseOpener.this.sessionName, RequestResponseOpener.this.linkName, RequestResponseOpener.this.endpointAddress, error));
                }
            }
        });
    }
}

