/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.PubsubMessageToHopRowFn;
import org.apache.hop.beam.core.fn.StringToHopRowFn;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamSubscribeTransform
extends PTransform<PBegin, PCollection<HopRow>> {
    private String transformName;
    private String subscription;
    private String topic;
    private String messageType;
    private String rowMetaJson;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(BeamSubscribeTransform.class);
    private transient IRowMeta rowMeta;
    private transient Counter initCounter;
    private transient Counter inputCounter;
    private transient Counter writtenCounter;
    private transient Counter errorCounter;

    public BeamSubscribeTransform() {
    }

    public BeamSubscribeTransform(@Nullable String name, String transformName, String subscription, String topic, String messageType, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        super(name);
        this.transformName = transformName;
        this.subscription = subscription;
        this.topic = topic;
        this.messageType = messageType;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    public PCollection<HopRow> expand(PBegin input) {
        try {
            PCollection output;
            if (this.rowMeta == null) {
                BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
                this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
                this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                Metrics.counter((String)"init", (String)this.transformName).inc();
            }
            if ("String".equalsIgnoreCase(this.messageType)) {
                PubsubIO.Read stringRead = PubsubIO.readStrings();
                stringRead = StringUtils.isNotEmpty((String)this.subscription) ? stringRead.fromSubscription(this.subscription) : stringRead.fromTopic(this.topic);
                PCollection stringPCollection = stringRead.expand(input);
                output = (PCollection)stringPCollection.apply(this.transformName, (PTransform)ParDo.of((DoFn)new StringToHopRowFn(this.transformName, this.rowMetaJson, this.transformPluginClasses, this.xpPluginClasses)));
            } else if ("PubsubMessage".equalsIgnoreCase(this.messageType)) {
                PubsubIO.Read messageRead = PubsubIO.readMessages();
                messageRead = StringUtils.isNotEmpty((String)this.subscription) ? messageRead.fromSubscription(this.subscription) : messageRead.fromTopic(this.topic);
                PCollection messagesPCollection = messageRead.expand(input);
                output = (PCollection)messagesPCollection.apply(this.transformName, (PTransform)ParDo.of((DoFn)new PubsubMessageToHopRowFn(this.transformName, this.rowMetaJson, this.transformPluginClasses, this.xpPluginClasses)));
            } else {
                throw new RuntimeException("Unsupported message type: " + this.messageType);
            }
            return output;
        }
        catch (Exception e) {
            Metrics.counter((String)"error", (String)this.transformName).inc();
            LOG.error("Error in beam subscribe transform", (Throwable)e);
            throw new RuntimeException("Error in beam subscribe transform", e);
        }
    }

    public String getTransformName() {
        return this.transformName;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }
}

