/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bigtable;

import com.google.bigtable.v2.Mutation;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.transforms.bigtable.BigtableColumn;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopToBigtableFn
extends DoFn<HopRow, KV<ByteString, Iterable<Mutation>>> {
    private final int keyIndex;
    private final String counterName;
    private final String rowMetaJson;
    private final String columnsJson;
    private final List<String> transformPluginClasses;
    private final List<String> xpPluginClasses;
    private transient List<BigtableColumn> columns;
    private transient IRowMeta rowMeta;
    private transient Counter readCounter;
    private transient Counter outputCounter;
    private transient Counter errorCounter;
    private transient List<Integer> sourceFieldIndexes;
    private static final Logger LOG = LoggerFactory.getLogger(HopToBigtableFn.class);

    public HopToBigtableFn(int keyIndex, String columnsJson, String counterName, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.keyIndex = keyIndex;
        this.columnsJson = columnsJson;
        this.counterName = counterName;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            Counter initCounter = Metrics.counter((String)"init", (String)this.counterName);
            this.readCounter = Metrics.counter((String)"read", (String)this.counterName);
            this.outputCounter = Metrics.counter((String)"output", (String)this.counterName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.counterName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            JSONParser parser = new JSONParser();
            JSONArray array = (JSONArray)parser.parse(this.columnsJson);
            this.columns = new ArrayList<BigtableColumn>();
            this.sourceFieldIndexes = new ArrayList<Integer>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jc = (JSONObject)array.get(i);
                String qualifier = (String)jc.get((Object)"qualifier");
                String family = (String)jc.get((Object)"family");
                String sourceField = (String)jc.get((Object)"field");
                this.columns.add(new BigtableColumn(qualifier, family, sourceField));
                this.sourceFieldIndexes.add(this.rowMeta.indexOfValue(sourceField));
            }
            initCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.info("Parse error on setup of Hop data to Bigtable KV : " + e.getMessage());
            throw new RuntimeException("Error on setup of converting Hop data to Bigtable KV", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        HopRow inputRow = (HopRow)processContext.element();
        this.readCounter.inc();
        try {
            String key = this.rowMeta.getString(inputRow.getRow(), this.keyIndex);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            for (int i = 0; i < this.columns.size(); ++i) {
                BigtableColumn column = this.columns.get(i);
                int sourceIndex = this.sourceFieldIndexes.get(i);
                IValueMeta valueMeta = this.rowMeta.getValueMeta(sourceIndex);
                Object valueData = valueMeta.getNativeDataType(inputRow.getRow()[sourceIndex]);
                if (valueData == null) continue;
                Mutation.SetCell setCell = Mutation.SetCell.newBuilder().setFamilyName(column.getFamily()).setColumnQualifier(HopToBigtableFn.toByteString(column.getName())).setTimestampMicros(System.currentTimeMillis() * 1000L).setValue(HopToBigtableFn.toByteString(valueMeta, valueData)).build();
                Mutation mutation = Mutation.newBuilder().setSetCell(setCell).build();
                mutations.add(mutation);
            }
            KV kv = KV.of((Object)ByteString.copyFromUtf8((String)key), mutations);
            processContext.output((Object)kv);
            this.outputCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.info("Conversion error HopRow to Bigtable KV : " + e.getMessage());
            throw new RuntimeException("Error converting HopRow to Bigtable KV", e);
        }
    }

    static ByteString toByteString(String string) {
        return ByteString.copyFrom((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    static ByteString toByteString(IValueMeta valueMeta, Object value) {
        byte[] bytes = new byte[]{};
        switch (valueMeta.getType()) {
            case 5: {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putLong((Long)value);
                bytes = buffer.array();
                break;
            }
            case 3: {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putLong(((Date)value).getTime());
                bytes = buffer.array();
                break;
            }
            case 4: {
                boolean b = (Boolean)value;
                if (b) {
                    bytes = new byte[]{1};
                    break;
                }
                bytes = new byte[]{0};
                break;
            }
            case 1: {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putDouble((Double)value);
                bytes = buffer.array();
                break;
            }
            default: {
                bytes = value.toString().getBytes(Charset.forName("UTF-8"));
            }
        }
        return ByteString.copyFrom((byte[])bytes);
    }
}

