/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public abstract class CellPath
implements IMeasurableMemory {
    public static final CellPath BOTTOM = new EmptyCellPath();
    public static final CellPath TOP = new EmptyCellPath();

    public abstract int size();

    public abstract ByteBuffer get(int var1);

    public static CellPath create(ByteBuffer value) {
        assert (value != null);
        return new SingleItemCellPath(value);
    }

    public int dataSize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            size += this.get(i).remaining();
        }
        return size;
    }

    public void digest(Digest digest) {
        for (int i = 0; i < this.size(); ++i) {
            digest.update(this.get(i));
        }
    }

    public abstract CellPath clone(ByteBufferCloner var1);

    public abstract long unsharedHeapSizeExcludingData();

    @Override
    public abstract long unsharedHeapSize();

    public final int hashCode() {
        int result = 31;
        for (int i = 0; i < this.size(); ++i) {
            result += 31 * Objects.hash(this.get(i));
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof CellPath)) {
            return false;
        }
        CellPath that = (CellPath)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Objects.equals(this.get(i), that.get(i))) continue;
            return false;
        }
        return true;
    }

    private static class EmptyCellPath
    extends CellPath {
        private EmptyCellPath() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ByteBuffer get(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CellPath clone(ByteBufferCloner cloner) {
            return this;
        }

        @Override
        public long unsharedHeapSize() {
            return 0L;
        }

        @Override
        public long unsharedHeapSizeExcludingData() {
            return 0L;
        }
    }

    private static class SingleItemCellPath
    extends CellPath {
        private static final long EMPTY_SIZE = ObjectSizes.measure(new SingleItemCellPath(ByteBufferUtil.EMPTY_BYTE_BUFFER));
        protected final ByteBuffer value;

        private SingleItemCellPath(ByteBuffer value) {
            this.value = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ByteBuffer get(int i) {
            assert (i == 0);
            return this.value;
        }

        @Override
        public CellPath clone(ByteBufferCloner cloner) {
            return new SingleItemCellPath(cloner.clone(this.value));
        }

        @Override
        public long unsharedHeapSize() {
            return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.value);
        }

        @Override
        public long unsharedHeapSizeExcludingData() {
            return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.value);
        }
    }

    public static interface Serializer {
        public void serialize(CellPath var1, DataOutputPlus var2) throws IOException;

        public CellPath deserialize(DataInputPlus var1) throws IOException;

        public long serializedSize(CellPath var1);

        public void skip(DataInputPlus var1) throws IOException;
    }
}

