/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.diag;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.diag.LastEventIdBroadcasterMBean;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.progress.jmx.JMXBroadcastExecutor;

final class LastEventIdBroadcaster
extends NotificationBroadcasterSupport
implements LastEventIdBroadcasterMBean {
    private static final LastEventIdBroadcaster instance = new LastEventIdBroadcaster();
    private static final int PERIODIC_BROADCAST_INTERVAL_MILLIS = 30000;
    private static final int SHORT_TERM_BROADCAST_DELAY_MILLIS = 1000;
    private final AtomicLong notificationSerialNumber = new AtomicLong();
    private final AtomicReference<ScheduledFuture<?>> scheduledPeriodicalBroadcast = new AtomicReference();
    private final AtomicReference<ScheduledFuture<?>> scheduledShortTermBroadcast = new AtomicReference();
    private final Map<String, Comparable> summary = new ConcurrentHashMap<String, Comparable>();

    private LastEventIdBroadcaster() {
        super(JMXBroadcastExecutor.executor);
        this.summary.put("last_updated_at", Long.valueOf(0L));
        MBeanWrapper.instance.registerMBean((Object)this, "org.apache.cassandra.diag:type=LastEventIdBroadcaster");
    }

    public static LastEventIdBroadcaster instance() {
        return instance;
    }

    @Override
    public Map<String, Comparable> getLastEventIds() {
        return this.summary;
    }

    @Override
    public Map<String, Comparable> getLastEventIdsIfModified(long lastUpdate) {
        if (lastUpdate >= (Long)this.summary.get("last_updated_at")) {
            return this.summary;
        }
        return this.getLastEventIds();
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        ScheduledFuture<?> scheduledFuture;
        super.addNotificationListener(listener, filter, handback);
        if (this.scheduledPeriodicalBroadcast.get() == null && !this.scheduledPeriodicalBroadcast.compareAndSet(null, scheduledFuture = ScheduledExecutors.scheduledTasks.scheduleAtFixedRate(this::broadcastEventIds, 30000L, 30000L, TimeUnit.MILLISECONDS))) {
            scheduledFuture.cancel(false);
        }
    }

    public void setLastEventId(String key, Comparable id) {
        if (this.summary.compute(key, (k, v) -> v == null ? id : (id.compareTo(v) > 0 ? id : v)) == id) {
            this.summary.put("last_updated_at", Long.valueOf(Clock.Global.currentTimeMillis()));
            this.scheduleBroadcast();
        }
    }

    private void scheduleBroadcast() {
        ScheduledFuture<?> scheduledFuture;
        ScheduledFuture<?> running = this.scheduledShortTermBroadcast.get();
        if ((running == null || running.isDone()) && !this.scheduledShortTermBroadcast.compareAndSet(running, scheduledFuture = ScheduledExecutors.scheduledTasks.schedule(this::broadcastEventIds, 1000L, TimeUnit.MILLISECONDS))) {
            scheduledFuture.cancel(false);
        }
    }

    private void broadcastEventIds() {
        if (!this.summary.isEmpty()) {
            this.broadcastEventIds(this.summary);
        }
    }

    private void broadcastEventIds(Map<String, Comparable> summary) {
        Notification notification = new Notification("event_last_id_summary", "LastEventIdBroadcaster", this.notificationSerialNumber.incrementAndGet(), Clock.Global.currentTimeMillis(), "Event last IDs summary");
        notification.setUserData(summary);
        this.sendNotification(notification);
    }
}

