/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.RewriteResponse;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.AutoValue_GcsUtil_CreateOptions;
import org.apache.beam.sdk.extensions.gcp.util.AutoValue_GcsUtil_GcsCountersOptions;
import org.apache.beam.sdk.extensions.gcp.util.AutoValue_GcsUtil_StorageObjectOrIOException;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.extensions.gcp.util.channels.CountingSeekableByteChannel;
import org.apache.beam.sdk.extensions.gcp.util.channels.CountingWritableByteChannel;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.FileSystemUtils;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.MoreFutures;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsUtil {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GcsUtil.class);
    private static final @UnknownKeyFor @NonNull @Initialized long MAX_LIST_ITEMS_PER_CALL = 1024L;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern GLOB_PREFIX = Pattern.compile("(?<PREFIX>[^\\[*?]*)[\\[*?].*");
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_REQUESTS_PER_BATCH = 100;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_REQUESTS_PER_COPY_BATCH = 10;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_CONCURRENT_BATCHES = 256;
    private static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(10).withInitialBackoff(Duration.standardSeconds((long)1L));
    private @UnknownKeyFor @NonNull @Initialized Storage storageClient;
    private @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized BatchInterface> batchRequestSupplier;
    private final @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer httpRequestInitializer;
    private final @Nullable @UnknownKeyFor @Initialized Integer uploadBufferSizeBytes;
    private final @UnknownKeyFor @NonNull @Initialized ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
    final @UnknownKeyFor @NonNull @Initialized ExecutorService executorService;
    private final @UnknownKeyFor @NonNull @Initialized Credentials credentials;
    private @UnknownKeyFor @NonNull @Initialized GoogleCloudStorage googleCloudStorage;
    private @UnknownKeyFor @NonNull @Initialized GoogleCloudStorageOptions googleCloudStorageOptions;
    private final @UnknownKeyFor @NonNull @Initialized int rewriteDataOpBatchLimit;
    private final @UnknownKeyFor @NonNull @Initialized GcsCountersOptions gcsCountersOptions;
    @VisibleForTesting
    @Nullable @UnknownKeyFor @Initialized Long maxBytesRewrittenPerCall;
    @VisibleForTesting
    @Nullable @UnknownKeyFor @Initialized AtomicInteger numRewriteTokensUsed;

    public static @UnknownKeyFor @NonNull @Initialized String getNonWildcardPrefix(@UnknownKeyFor @NonNull @Initialized String globExp) {
        Matcher m = GLOB_PREFIX.matcher(globExp);
        Preconditions.checkArgument((boolean)m.matches(), (Object)String.format("Glob expression: [%s] is not expandable.", globExp));
        return m.group("PREFIX");
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isWildcard(@UnknownKeyFor @NonNull @Initialized GcsPath spec) {
        return GLOB_PREFIX.matcher(spec.getObject()).matches();
    }

    @VisibleForTesting
    GcsUtil(@UnknownKeyFor @NonNull @Initialized Storage storageClient, @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer httpRequestInitializer, @UnknownKeyFor @NonNull @Initialized ExecutorService executorService, @UnknownKeyFor @NonNull @Initialized Boolean shouldUseGrpc, @UnknownKeyFor @NonNull @Initialized Credentials credentials, @Nullable @UnknownKeyFor @Initialized Integer uploadBufferSizeBytes, @Nullable @UnknownKeyFor @Initialized Integer rewriteDataOpBatchLimit, @UnknownKeyFor @NonNull @Initialized GcsCountersOptions gcsCountersOptions) {
        this.storageClient = storageClient;
        this.httpRequestInitializer = httpRequestInitializer;
        this.uploadBufferSizeBytes = uploadBufferSizeBytes;
        this.executorService = executorService;
        this.credentials = credentials;
        this.maxBytesRewrittenPerCall = null;
        this.numRewriteTokensUsed = null;
        this.googleCloudStorageOptions = GoogleCloudStorageOptions.builder().setAppName("Beam").setGrpcEnabled(shouldUseGrpc.booleanValue()).build();
        this.googleCloudStorage = this.createGoogleCloudStorage(this.googleCloudStorageOptions, storageClient, credentials);
        this.batchRequestSupplier = () -> {
            final GcsUtil util = this;
            return new BatchInterface(){
                final @UnknownKeyFor @NonNull @Initialized BatchRequest batch;
                {
                    this.batch = util.storageClient.batch(util.httpRequestInitializer);
                }

                @Override
                public <T> void queue(@UnknownKeyFor @NonNull @Initialized AbstractGoogleJsonClientRequest<T> request, @UnknownKeyFor @NonNull @Initialized JsonBatchCallback<T> cb) throws @UnknownKeyFor @NonNull @Initialized IOException {
                    request.queue(this.batch, cb);
                }

                @Override
                public void execute() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    this.batch.execute();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized int size() {
                    return this.batch.size();
                }
            };
        };
        this.rewriteDataOpBatchLimit = rewriteDataOpBatchLimit == null ? 10 : rewriteDataOpBatchLimit;
        this.gcsCountersOptions = gcsCountersOptions;
    }

    protected void setStorageClient(@UnknownKeyFor @NonNull @Initialized Storage storageClient) {
        this.storageClient = storageClient;
    }

    protected void setBatchRequestSupplier(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized BatchInterface> supplier) {
        this.batchRequestSupplier = supplier;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsPath> expand(@UnknownKeyFor @NonNull @Initialized GcsPath gcsPattern) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects objects;
        Pattern p = null;
        String prefix = null;
        if (!GcsUtil.isWildcard(gcsPattern)) {
            try {
                this.getObject(gcsPattern);
                return ImmutableList.of((Object)gcsPattern);
            }
            catch (FileNotFoundException e) {
                return ImmutableList.of();
            }
        }
        prefix = GcsUtil.getNonWildcardPrefix(gcsPattern.getObject());
        p = Pattern.compile(FileSystemUtils.wildcardToRegexp((String)gcsPattern.getObject()));
        LOG.debug("matching files in bucket {}, prefix {} against pattern {}", new Object[]{gcsPattern.getBucket(), prefix, p.toString()});
        String pageToken = null;
        ArrayList<GcsPath> results = new ArrayList<GcsPath>();
        while ((objects = this.listObjects(gcsPattern.getBucket(), prefix, pageToken)).getItems() != null) {
            for (StorageObject o : objects.getItems()) {
                String name = o.getName();
                if (!p.matcher(name).matches() || name.endsWith("/")) continue;
                LOG.debug("Matched object: {}", (Object)name);
                results.add(GcsPath.fromObject(o));
            }
            pageToken = objects.getNextPageToken();
            if (pageToken != null) continue;
        }
        return results;
    }

    @VisibleForTesting
    @Nullable @UnknownKeyFor @Initialized Integer getUploadBufferSizeBytes() {
        return this.uploadBufferSizeBytes;
    }

    private static @UnknownKeyFor @NonNull @Initialized BackOff createBackOff() {
        return BackOffAdapter.toGcpBackOff(BACKOFF_FACTORY.backoff());
    }

    public @UnknownKeyFor @NonNull @Initialized long fileSize(@UnknownKeyFor @NonNull @Initialized GcsPath path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.getObject(path).getSize().longValue();
    }

    public @UnknownKeyFor @NonNull @Initialized StorageObject getObject(@UnknownKeyFor @NonNull @Initialized GcsPath gcsPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.getObject(gcsPath, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized StorageObject getObject(@UnknownKeyFor @NonNull @Initialized GcsPath gcsPath, @UnknownKeyFor @NonNull @Initialized BackOff backoff, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Storage.Objects.Get getObject = this.storageClient.objects().get(gcsPath.getBucket(), gcsPath.getObject());
        try {
            return (StorageObject)ResilientOperation.retry(() -> ((Storage.Objects.Get)getObject).execute(), (BackOff)backoff, (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class, (Sleeper)sleeper);
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (e instanceof IOException && this.errorExtractor.itemNotFound((IOException)e)) {
                throw new FileNotFoundException(gcsPath.toString());
            }
            throw new IOException(String.format("Unable to get the file object for path %s.", gcsPath), e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized StorageObjectOrIOException> getObjects(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsPath> gcsPaths) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (gcsPaths.isEmpty()) {
            return ImmutableList.of();
        }
        if (gcsPaths.size() == 1) {
            GcsPath path = gcsPaths.get(0);
            try {
                StorageObject object = this.getObject(path);
                return ImmutableList.of((Object)StorageObjectOrIOException.create(object));
            }
            catch (IOException e) {
                return ImmutableList.of((Object)StorageObjectOrIOException.create(e));
            }
            catch (Exception e) {
                IOException ioException = new IOException(String.format("Error trying to get %s: %s", path, e));
                return ImmutableList.of((Object)StorageObjectOrIOException.create(ioException));
            }
        }
        ArrayList<StorageObjectOrIOException[]> results = new ArrayList<StorageObjectOrIOException[]>();
        GcsUtil.executeBatches(this.makeGetBatches(gcsPaths, results));
        ImmutableList.Builder ret = ImmutableList.builder();
        for (StorageObjectOrIOException[] result : results) {
            ret.add((Object)result[0]);
        }
        return ret.build();
    }

    public @UnknownKeyFor @NonNull @Initialized Objects listObjects(@UnknownKeyFor @NonNull @Initialized String bucket, @UnknownKeyFor @NonNull @Initialized String prefix, @Nullable @UnknownKeyFor @Initialized String pageToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.listObjects(bucket, prefix, pageToken, null);
    }

    public @UnknownKeyFor @NonNull @Initialized Objects listObjects(@UnknownKeyFor @NonNull @Initialized String bucket, @UnknownKeyFor @NonNull @Initialized String prefix, @Nullable @UnknownKeyFor @Initialized String pageToken, @Nullable @UnknownKeyFor @Initialized String delimiter) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Storage.Objects.List listObject = this.storageClient.objects().list(bucket);
        listObject.setMaxResults(Long.valueOf(1024L));
        listObject.setPrefix(prefix);
        listObject.setDelimiter(delimiter);
        if (pageToken != null) {
            listObject.setPageToken(pageToken);
        }
        try {
            return (Objects)ResilientOperation.retry(() -> ((Storage.Objects.List)listObject).execute(), (BackOff)GcsUtil.createBackOff(), (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class);
        }
        catch (Exception e) {
            throw new IOException(String.format("Unable to match files in bucket %s, prefix %s.", bucket, prefix), e);
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Long> fileSizes(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsPath> paths) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<StorageObjectOrIOException> results = this.getObjects(paths);
        ImmutableList.Builder ret = ImmutableList.builder();
        for (StorageObjectOrIOException result : results) {
            ret.add((Object)this.toFileSize(result));
        }
        return ret.build();
    }

    private @UnknownKeyFor @NonNull @Initialized Long toFileSize(@UnknownKeyFor @NonNull @Initialized StorageObjectOrIOException storageObjectOrIOException) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (storageObjectOrIOException.ioException() != null) {
            throw storageObjectOrIOException.ioException();
        }
        return storageObjectOrIOException.storageObject().getSize().longValue();
    }

    @VisibleForTesting
    void setCloudStorageImpl(@UnknownKeyFor @NonNull @Initialized GoogleCloudStorage g) {
        this.googleCloudStorage = g;
    }

    @VisibleForTesting
    void setCloudStorageImpl(@UnknownKeyFor @NonNull @Initialized GoogleCloudStorageOptions g) {
        this.googleCloudStorageOptions = g;
    }

    private static @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> createCounterConsumer(@UnknownKeyFor @NonNull @Initialized String counterNamePrefix, @UnknownKeyFor @NonNull @Initialized String bucket) {
        return arg_0 -> ((Counter)Metrics.counter(GcsUtil.class, (String)String.format("%s_%s", counterNamePrefix, bucket))).inc(arg_0);
    }

    private @UnknownKeyFor @NonNull @Initialized WritableByteChannel wrapInCounting(@UnknownKeyFor @NonNull @Initialized WritableByteChannel writableByteChannel, @UnknownKeyFor @NonNull @Initialized String bucket) {
        if (writableByteChannel instanceof CountingWritableByteChannel) {
            return writableByteChannel;
        }
        return Optional.ofNullable(this.gcsCountersOptions.getWriteCounterPrefix()).map(prefix -> {
            LOG.debug("wrapping writable byte channel using counter name prefix {} and bucket {}", prefix, (Object)bucket);
            return new CountingWritableByteChannel(writableByteChannel, GcsUtil.createCounterConsumer(prefix, bucket));
        }).orElse(writableByteChannel);
    }

    private @UnknownKeyFor @NonNull @Initialized SeekableByteChannel wrapInCounting(@UnknownKeyFor @NonNull @Initialized SeekableByteChannel seekableByteChannel, @UnknownKeyFor @NonNull @Initialized String bucket) {
        if (seekableByteChannel instanceof CountingSeekableByteChannel || !this.gcsCountersOptions.hasAnyPrefix()) {
            return seekableByteChannel;
        }
        return new CountingSeekableByteChannel(seekableByteChannel, Optional.ofNullable(this.gcsCountersOptions.getReadCounterPrefix()).map(prefix -> {
            LOG.debug("wrapping seekable byte channel with \"bytes read\" counter name prefix {} and bucket {}", prefix, (Object)bucket);
            return GcsUtil.createCounterConsumer(prefix, bucket);
        }).orElse(null), Optional.ofNullable(this.gcsCountersOptions.getWriteCounterPrefix()).map(prefix -> {
            LOG.debug("wrapping seekable byte channel with \"bytes written\" counter name prefix {} and bucket {}", prefix, (Object)bucket);
            return GcsUtil.createCounterConsumer(prefix, bucket);
        }).orElse(null));
    }

    public @UnknownKeyFor @NonNull @Initialized SeekableByteChannel open(@UnknownKeyFor @NonNull @Initialized GcsPath path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String bucket = path.getBucket();
        SeekableByteChannel channel = this.googleCloudStorage.open(new StorageResourceId(path.getBucket(), path.getObject()));
        return this.wrapInCounting(channel, bucket);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized SeekableByteChannel open(@UnknownKeyFor @NonNull @Initialized GcsPath path, @UnknownKeyFor @NonNull @Initialized GoogleCloudStorageReadOptions readOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        HashMap<String, String> baseLabels = new HashMap<String, String>();
        baseLabels.put("PTRANSFORM", "");
        baseLabels.put("SERVICE", "Storage");
        baseLabels.put("METHOD", "GcsGet");
        baseLabels.put("RESOURCE", GcpResourceIdentifiers.cloudStorageBucket((String)path.getBucket()));
        baseLabels.put("GCS_PROJECT_ID", String.valueOf(this.googleCloudStorageOptions.getProjectId()));
        baseLabels.put("GCS_BUCKET", path.getBucket());
        ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        try {
            SeekableByteChannel channel = this.googleCloudStorage.open(new StorageResourceId(path.getBucket(), path.getObject()), readOptions);
            serviceCallMetric.call("ok");
            return this.wrapInCounting(channel, path.getBucket());
        }
        catch (IOException e) {
            if (e.getCause() instanceof GoogleJsonResponseException) {
                serviceCallMetric.call(((GoogleJsonResponseException)e.getCause()).getDetails().getCode());
            }
            throw e;
        }
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized GcsPath path, @UnknownKeyFor @NonNull @Initialized String type) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CreateOptions.Builder builder = CreateOptions.builder().setContentType(type);
        return this.create(path, builder.build());
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized GcsPath path, @UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized Integer uploadBufferSizeBytes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CreateOptions.Builder builder = CreateOptions.builder().setContentType(type).setUploadBufferSizeBytes(uploadBufferSizeBytes);
        return this.create(path, builder.build());
    }

    public @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized GcsPath path, @UnknownKeyFor @NonNull @Initialized CreateOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Integer uploadBufferSizeBytes;
        AsyncWriteChannelOptions wcOptions = this.googleCloudStorageOptions.getWriteChannelOptions();
        Integer n = uploadBufferSizeBytes = options.getUploadBufferSizeBytes() != null ? options.getUploadBufferSizeBytes() : this.getUploadBufferSizeBytes();
        if (uploadBufferSizeBytes != null) {
            wcOptions = wcOptions.toBuilder().setUploadChunkSize(uploadBufferSizeBytes.intValue()).build();
        }
        GoogleCloudStorageOptions newGoogleCloudStorageOptions = this.googleCloudStorageOptions.toBuilder().setWriteChannelOptions(wcOptions).build();
        GoogleCloudStorage gcpStorage = this.createGoogleCloudStorage(newGoogleCloudStorageOptions, this.storageClient, this.credentials);
        StorageResourceId resourceId = new StorageResourceId(path.getBucket(), path.getObject(), options.getExpectFileToNotExist() ? 0L : -1L);
        CreateObjectOptions.Builder createBuilder = CreateObjectOptions.builder().setOverwriteExisting(true);
        if (options.getContentType() != null) {
            createBuilder = createBuilder.setContentType(options.getContentType());
        }
        HashMap<String, String> baseLabels = new HashMap<String, String>();
        baseLabels.put("PTRANSFORM", "");
        baseLabels.put("SERVICE", "Storage");
        baseLabels.put("METHOD", "GcsInsert");
        baseLabels.put("RESOURCE", GcpResourceIdentifiers.cloudStorageBucket((String)path.getBucket()));
        baseLabels.put("GCS_PROJECT_ID", String.valueOf(this.googleCloudStorageOptions.getProjectId()));
        baseLabels.put("GCS_BUCKET", path.getBucket());
        ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        try {
            WritableByteChannel channel = gcpStorage.create(resourceId, createBuilder.build());
            serviceCallMetric.call("ok");
            return this.wrapInCounting(channel, path.getBucket());
        }
        catch (IOException e) {
            if (e.getCause() instanceof GoogleJsonResponseException) {
                serviceCallMetric.call(((GoogleJsonResponseException)e.getCause()).getDetails().getCode());
            }
            throw e;
        }
    }

    @UnknownKeyFor @NonNull @Initialized GoogleCloudStorage createGoogleCloudStorage(@UnknownKeyFor @NonNull @Initialized GoogleCloudStorageOptions options, @UnknownKeyFor @NonNull @Initialized Storage storage, @UnknownKeyFor @NonNull @Initialized Credentials credentials) {
        return new GoogleCloudStorageImpl(options, storage, credentials);
    }

    public void verifyBucketAccessible(@UnknownKeyFor @NonNull @Initialized GcsPath path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.verifyBucketAccessible(path, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean bucketAccessible(@UnknownKeyFor @NonNull @Initialized GcsPath path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.bucketAccessible(path, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    public @UnknownKeyFor @NonNull @Initialized long bucketOwner(@UnknownKeyFor @NonNull @Initialized GcsPath path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.getBucket(path, GcsUtil.createBackOff(), Sleeper.DEFAULT).getProjectNumber().longValue();
    }

    public void createBucket(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized Bucket bucket) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.createBucket(projectId, bucket, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    public @Nullable @UnknownKeyFor @Initialized Bucket getBucket(@UnknownKeyFor @NonNull @Initialized GcsPath path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.getBucket(path, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    public void removeBucket(@UnknownKeyFor @NonNull @Initialized Bucket bucket) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.removeBucket(bucket, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized boolean bucketAccessible(@UnknownKeyFor @NonNull @Initialized GcsPath path, @UnknownKeyFor @NonNull @Initialized BackOff backoff, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return this.getBucket(path, backoff, sleeper) != null;
        }
        catch (FileNotFoundException | AccessDeniedException e) {
            return false;
        }
    }

    @VisibleForTesting
    void verifyBucketAccessible(@UnknownKeyFor @NonNull @Initialized GcsPath path, @UnknownKeyFor @NonNull @Initialized BackOff backoff, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.getBucket(path, backoff, sleeper);
    }

    @VisibleForTesting
    @Nullable @UnknownKeyFor @Initialized Bucket getBucket(@UnknownKeyFor @NonNull @Initialized GcsPath path, @UnknownKeyFor @NonNull @Initialized BackOff backoff, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Storage.Buckets.Get getBucket = this.storageClient.buckets().get(path.getBucket());
        try {
            return (Bucket)ResilientOperation.retry(() -> ((Storage.Buckets.Get)getBucket).execute(), (BackOff)backoff, (RetryDeterminer)new RetryDeterminer<IOException>(){

                public @UnknownKeyFor @NonNull @Initialized boolean shouldRetry(@UnknownKeyFor @NonNull @Initialized IOException e) {
                    if (GcsUtil.this.errorExtractor.itemNotFound(e) || GcsUtil.this.errorExtractor.accessDenied(e)) {
                        return false;
                    }
                    return RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)e);
                }
            }, IOException.class, (Sleeper)sleeper);
        }
        catch (GoogleJsonResponseException e) {
            if (this.errorExtractor.accessDenied((IOException)((Object)e))) {
                throw new AccessDeniedException(path.toString(), null, e.getMessage());
            }
            if (this.errorExtractor.itemNotFound((IOException)((Object)e))) {
                throw new FileNotFoundException(e.getMessage());
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(String.format("Error while attempting to verify existence of bucket gs://%s", path.getBucket()), e);
        }
    }

    @VisibleForTesting
    void createBucket(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized Bucket bucket, @UnknownKeyFor @NonNull @Initialized BackOff backoff, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Storage.Buckets.Insert insertBucket = this.storageClient.buckets().insert(projectId, bucket);
        insertBucket.setPredefinedAcl("projectPrivate");
        insertBucket.setPredefinedDefaultObjectAcl("projectPrivate");
        try {
            ResilientOperation.retry(() -> ((Storage.Buckets.Insert)insertBucket).execute(), (BackOff)backoff, (RetryDeterminer)new RetryDeterminer<IOException>(){

                public @UnknownKeyFor @NonNull @Initialized boolean shouldRetry(@UnknownKeyFor @NonNull @Initialized IOException e) {
                    if (GcsUtil.this.errorExtractor.itemAlreadyExists(e) || GcsUtil.this.errorExtractor.accessDenied(e)) {
                        return false;
                    }
                    return RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)e);
                }
            }, IOException.class, (Sleeper)sleeper);
            return;
        }
        catch (GoogleJsonResponseException e) {
            if (this.errorExtractor.accessDenied((IOException)((Object)e))) {
                throw new AccessDeniedException(bucket.getName(), null, e.getMessage());
            }
            if (this.errorExtractor.itemAlreadyExists((IOException)((Object)e))) {
                throw new FileAlreadyExistsException(bucket.getName(), null, e.getMessage());
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(String.format("Error while attempting to create bucket gs://%s for project %s", bucket.getName(), projectId), e);
        }
    }

    @VisibleForTesting
    void removeBucket(@UnknownKeyFor @NonNull @Initialized Bucket bucket, @UnknownKeyFor @NonNull @Initialized BackOff backoff, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Storage.Buckets.Delete getBucket = this.storageClient.buckets().delete(bucket.getName());
        try {
            ResilientOperation.retry(() -> ((Storage.Buckets.Delete)getBucket).execute(), (BackOff)backoff, (RetryDeterminer)new RetryDeterminer<IOException>(){

                public @UnknownKeyFor @NonNull @Initialized boolean shouldRetry(@UnknownKeyFor @NonNull @Initialized IOException e) {
                    if (GcsUtil.this.errorExtractor.itemNotFound(e) || GcsUtil.this.errorExtractor.accessDenied(e)) {
                        return false;
                    }
                    return RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)e);
                }
            }, IOException.class, (Sleeper)sleeper);
        }
        catch (GoogleJsonResponseException e) {
            if (this.errorExtractor.accessDenied((IOException)((Object)e))) {
                throw new AccessDeniedException(bucket.getName(), null, e.getMessage());
            }
            if (this.errorExtractor.itemNotFound((IOException)((Object)e))) {
                throw new FileNotFoundException(e.getMessage());
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(String.format("Error while attempting to remove bucket gs://%s", bucket.getName()), e);
        }
    }

    private static void executeBatches(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BatchInterface> batches) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(256, 256, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (BatchInterface batch : batches) {
            futures.add(MoreFutures.runAsync(batch::execute, (ExecutorService)executor));
        }
        try {
            try {
                MoreFutures.get((CompletionStage)MoreFutures.allAsList(futures));
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    throw (FileNotFoundException)e.getCause();
                }
                throw new IOException("Error executing batch GCS request", e);
            }
            finally {
                executor.shutdown();
                if (!executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    LOG.warn("Taking over 5 minutes to flush gcs op batches after error");
                    executor.shutdownNow();
                    if (!executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                        LOG.warn("Took over 10 minutes to flush gcs op batches after error and interruption.");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while executing batch GCS request", e);
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BatchInterface> makeGetBatches(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized GcsPath> paths, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized StorageObjectOrIOException @UnknownKeyFor @NonNull @Initialized []> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<BatchInterface> batches = new ArrayList<BatchInterface>();
        for (List filesToGet : Lists.partition((List)Lists.newArrayList(paths), (int)100)) {
            BatchInterface batch = this.batchRequestSupplier.get();
            for (GcsPath path : filesToGet) {
                results.add(this.enqueueGetFileSize(path, batch));
            }
            batches.add(batch);
        }
        return batches;
    }

    public void copy(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> srcFilenames, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> destFilenames) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.rewriteHelper(srcFilenames, destFilenames, false, false, false);
    }

    public void rename(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> srcFilenames, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> destFilenames, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        HashSet moveOptionSet = Sets.newHashSet((Object[])moveOptions);
        boolean ignoreMissingSrc = moveOptionSet.contains(MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
        boolean ignoreExistingDest = moveOptionSet.contains(MoveOptions.StandardMoveOptions.SKIP_IF_DESTINATION_EXISTS);
        this.rewriteHelper(srcFilenames, destFilenames, true, ignoreMissingSrc, ignoreExistingDest);
    }

    private void rewriteHelper(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> srcFilenames, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> destFilenames, @UnknownKeyFor @NonNull @Initialized boolean deleteSource, @UnknownKeyFor @NonNull @Initialized boolean ignoreMissingSource, @UnknownKeyFor @NonNull @Initialized boolean ignoreExistingDest) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<BatchInterface> batches;
        LinkedList<RewriteOp> rewrites = this.makeRewriteOps(srcFilenames, destFilenames, deleteSource, ignoreMissingSource, ignoreExistingDest);
        org.apache.beam.sdk.util.BackOff backoff = BACKOFF_FACTORY.backoff();
        while (!(batches = this.makeRewriteBatches(rewrites)).isEmpty()) {
            Preconditions.checkState((!rewrites.isEmpty() ? 1 : 0) != 0);
            RewriteOp sampleErrorOp = rewrites.stream().filter(op -> op.getLastError() != null).findFirst().orElse(null);
            if (sampleErrorOp != null) {
                long backOffMillis = backoff.nextBackOffMillis();
                if (backOffMillis == -1L) {
                    throw new IOException(String.format("Error completing file copies with retries, sample: from %s to %s due to %s", sampleErrorOp.getFrom().toString(), sampleErrorOp.getTo().toString(), sampleErrorOp.getLastError()));
                }
                LOG.warn("Retrying with backoff unsuccessful copy requests, sample request: from {} to {} due to {}", new Object[]{sampleErrorOp.getFrom(), sampleErrorOp.getTo(), sampleErrorOp.getLastError()});
                try {
                    Thread.sleep(backOffMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(String.format("Interrupted backoff of file copies with retries, sample: from %s to %s due to %s", sampleErrorOp.getFrom().toString(), sampleErrorOp.getTo().toString(), sampleErrorOp.getLastError()));
                }
            }
            GcsUtil.executeBatches(batches);
        }
    }

    @UnknownKeyFor @NonNull @Initialized LinkedList<@UnknownKeyFor @NonNull @Initialized GcsUtil. @UnknownKeyFor @NonNull @Initialized RewriteOp> makeRewriteOps(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> srcFilenames, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> destFilenames, @UnknownKeyFor @NonNull @Initialized boolean deleteSource, @UnknownKeyFor @NonNull @Initialized boolean ignoreMissingSource, @UnknownKeyFor @NonNull @Initialized boolean ignoreExistingDest) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList srcList = Lists.newArrayList(srcFilenames);
        ArrayList destList = Lists.newArrayList(destFilenames);
        Preconditions.checkArgument((srcList.size() == destList.size() ? 1 : 0) != 0, (String)"Number of source files %s must equal number of destination files %s", (int)srcList.size(), (int)destList.size());
        LinkedList rewrites = Lists.newLinkedList();
        for (int i = 0; i < srcList.size(); ++i) {
            GcsPath sourcePath = GcsPath.fromUri((String)srcList.get(i));
            GcsPath destPath = GcsPath.fromUri((String)destList.get(i));
            if (ignoreExistingDest && !sourcePath.getBucket().equals(destPath.getBucket())) {
                throw new UnsupportedOperationException("Skipping dest existence is only supported within a bucket.");
            }
            rewrites.addLast(new RewriteOp(sourcePath, destPath, deleteSource, ignoreMissingSource));
        }
        return rewrites;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BatchInterface> makeRewriteBatches(@UnknownKeyFor @NonNull @Initialized LinkedList<@UnknownKeyFor @NonNull @Initialized GcsUtil. @UnknownKeyFor @NonNull @Initialized RewriteOp> rewrites) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<BatchInterface> batches = new ArrayList<BatchInterface>();
        @Nullable BatchInterface opBatch = null;
        boolean useSeparateRewriteDataBatch = this.rewriteDataOpBatchLimit != 100;
        Iterator it = rewrites.iterator();
        ArrayList<RewriteOp> deferredRewriteDataOps = new ArrayList<RewriteOp>();
        while (it.hasNext()) {
            RewriteOp rewrite = (RewriteOp)((Object)it.next());
            if (!rewrite.getReadyToEnqueue()) {
                it.remove();
                continue;
            }
            if (useSeparateRewriteDataBatch && !rewrite.isMetadataOperation()) {
                deferredRewriteDataOps.add(rewrite);
                continue;
            }
            if (opBatch != null && opBatch.size() >= 100) {
                opBatch = null;
            }
            if (opBatch == null) {
                opBatch = this.batchRequestSupplier.get();
                batches.add(opBatch);
            }
            rewrite.enqueue(opBatch);
        }
        for (RewriteOp rewrite : deferredRewriteDataOps) {
            if (opBatch != null && opBatch.size() >= this.rewriteDataOpBatchLimit) {
                opBatch = null;
            }
            if (opBatch == null) {
                opBatch = this.batchRequestSupplier.get();
                batches.add(opBatch);
            }
            rewrite.enqueue(opBatch);
        }
        return batches;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BatchInterface> makeRemoveBatches(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> filenames) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<BatchInterface> batches = new ArrayList<BatchInterface>();
        for (List filesToDelete : Lists.partition((List)Lists.newArrayList(filenames), (int)100)) {
            BatchInterface batch = this.batchRequestSupplier.get();
            for (String file : filesToDelete) {
                this.enqueueDelete(GcsPath.fromUri(file), batch);
            }
            batches.add(batch);
        }
        return batches;
    }

    public void remove(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> filenames) throws @UnknownKeyFor @NonNull @Initialized IOException {
        GcsUtil.executeBatches(this.makeRemoveBatches(filenames));
    }

    private @UnknownKeyFor @NonNull @Initialized StorageObjectOrIOException @UnknownKeyFor @NonNull @Initialized [] enqueueGetFileSize(final @UnknownKeyFor @NonNull @Initialized GcsPath path, @UnknownKeyFor @NonNull @Initialized BatchInterface batch) throws @UnknownKeyFor @NonNull @Initialized IOException {
        final StorageObjectOrIOException[] ret = new StorageObjectOrIOException[1];
        Storage.Objects.Get getRequest = this.storageClient.objects().get(path.getBucket(), path.getObject());
        batch.queue(getRequest, new JsonBatchCallback<StorageObject>(){

            public void onSuccess(@UnknownKeyFor @NonNull @Initialized StorageObject response, @UnknownKeyFor @NonNull @Initialized HttpHeaders httpHeaders) throws @UnknownKeyFor @NonNull @Initialized IOException {
                ret[0] = StorageObjectOrIOException.create(response);
            }

            public void onFailure(@UnknownKeyFor @NonNull @Initialized GoogleJsonError e, @UnknownKeyFor @NonNull @Initialized HttpHeaders httpHeaders) throws @UnknownKeyFor @NonNull @Initialized IOException {
                IOException ioException = e.getCode() == 404 ? new FileNotFoundException(path.toString()) : new IOException(String.format("Error trying to get %s: %s", path, e));
                ret[0] = StorageObjectOrIOException.create(ioException);
            }
        });
        return ret;
    }

    private void enqueueDelete(final @UnknownKeyFor @NonNull @Initialized GcsPath file, @UnknownKeyFor @NonNull @Initialized BatchInterface batch) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Storage.Objects.Delete deleteRequest = this.storageClient.objects().delete(file.getBucket(), file.getObject());
        batch.queue(deleteRequest, new JsonBatchCallback<Void>(){

            public void onSuccess(@UnknownKeyFor @Nullable @Initialized Void obj, @UnknownKeyFor @NonNull @Initialized HttpHeaders responseHeaders) {
                LOG.debug("Successfully deleted {}", (Object)file);
            }

            public void onFailure(@UnknownKeyFor @NonNull @Initialized GoogleJsonError e, @UnknownKeyFor @NonNull @Initialized HttpHeaders responseHeaders) throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (e.getCode() != 404) {
                    throw new IOException(String.format("Error trying to delete %s: %s", file, e));
                }
                LOG.info("Ignoring failed deletion of file {} which already does not exist: {}", (Object)file, (Object)e);
            }
        });
    }

    @VisibleForTesting
    static interface BatchInterface {
        public <T> void queue(@UnknownKeyFor @NonNull @Initialized AbstractGoogleJsonClientRequest<T> var1, @UnknownKeyFor @NonNull @Initialized JsonBatchCallback<T> var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

        public void execute() throws @UnknownKeyFor @NonNull @Initialized IOException;

        public @UnknownKeyFor @NonNull @Initialized int size();
    }

    @SuppressFBWarnings(value={"NM_CLASS_NOT_EXCEPTION"})
    @AutoValue
    public static abstract class StorageObjectOrIOException {
        public abstract @Nullable @UnknownKeyFor @Initialized StorageObject storageObject();

        public abstract @Nullable @UnknownKeyFor @Initialized IOException ioException();

        @VisibleForTesting
        public static @UnknownKeyFor @NonNull @Initialized StorageObjectOrIOException create(@UnknownKeyFor @NonNull @Initialized StorageObject storageObject) {
            return new AutoValue_GcsUtil_StorageObjectOrIOException((StorageObject)Preconditions.checkNotNull((Object)storageObject, (Object)"storageObject"), null);
        }

        @VisibleForTesting
        public static @UnknownKeyFor @NonNull @Initialized StorageObjectOrIOException create(@UnknownKeyFor @NonNull @Initialized IOException ioException) {
            return new AutoValue_GcsUtil_StorageObjectOrIOException(null, (IOException)Preconditions.checkNotNull((Object)ioException, (Object)"ioException"));
        }
    }

    class RewriteOp
    extends JsonBatchCallback<RewriteResponse> {
        private final @UnknownKeyFor @NonNull @Initialized GcsPath from;
        private final @UnknownKeyFor @NonNull @Initialized GcsPath to;
        private final @UnknownKeyFor @NonNull @Initialized boolean deleteSource;
        private final @UnknownKeyFor @NonNull @Initialized boolean ignoreMissingSource;
        private @UnknownKeyFor @NonNull @Initialized boolean readyToEnqueue;
        private @UnknownKeyFor @NonNull @Initialized boolean performDelete;
        private @Nullable @UnknownKeyFor @Initialized GoogleJsonError lastError;
        @VisibleForTesting
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Storage. @UnknownKeyFor @NonNull @Initialized Objects. @UnknownKeyFor @NonNull @Initialized Rewrite rewriteRequest;

        public @UnknownKeyFor @NonNull @Initialized boolean getReadyToEnqueue() {
            return this.readyToEnqueue;
        }

        public @Nullable @UnknownKeyFor @Initialized GoogleJsonError getLastError() {
            return this.lastError;
        }

        public @UnknownKeyFor @NonNull @Initialized GcsPath getFrom() {
            return this.from;
        }

        public @UnknownKeyFor @NonNull @Initialized GcsPath getTo() {
            return this.to;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isMetadataOperation() {
            return this.performDelete || this.from.getBucket().equals(this.to.getBucket());
        }

        public void enqueue(@UnknownKeyFor @NonNull @Initialized BatchInterface batch) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (!this.readyToEnqueue) {
                throw new IOException(String.format("Invalid state for Rewrite, from=%s, to=%s, readyToEnqueue=%s", this.from, this.to, this.readyToEnqueue));
            }
            if (!this.performDelete) {
                batch.queue(this.rewriteRequest, this);
                return;
            }
            Storage.Objects.Delete deleteRequest = GcsUtil.this.storageClient.objects().delete(this.from.getBucket(), this.from.getObject());
            batch.queue(deleteRequest, new JsonBatchCallback<Void>(){

                public void onSuccess(@UnknownKeyFor @Nullable @Initialized Void obj, @UnknownKeyFor @NonNull @Initialized HttpHeaders responseHeaders) {
                    LOG.debug("Successfully deleted {} after moving to {}", (Object)RewriteOp.this.from, (Object)RewriteOp.this.to);
                    RewriteOp.this.readyToEnqueue = false;
                    RewriteOp.this.lastError = null;
                }

                public void onFailure(@UnknownKeyFor @NonNull @Initialized GoogleJsonError e, @UnknownKeyFor @NonNull @Initialized HttpHeaders responseHeaders) throws @UnknownKeyFor @NonNull @Initialized IOException {
                    if (e.getCode() == 404) {
                        LOG.info("Ignoring failed deletion of moved file {} which already does not exist: {}", (Object)RewriteOp.this.from, (Object)e);
                        RewriteOp.this.readyToEnqueue = false;
                        RewriteOp.this.lastError = null;
                    } else {
                        RewriteOp.this.readyToEnqueue = true;
                        RewriteOp.this.lastError = e;
                    }
                }
            });
        }

        public RewriteOp(@UnknownKeyFor @NonNull @Initialized GcsPath from, @UnknownKeyFor @NonNull @Initialized GcsPath to, @UnknownKeyFor @NonNull @Initialized boolean deleteSource, boolean ignoreMissingSource) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.from = from;
            this.to = to;
            this.deleteSource = deleteSource;
            this.ignoreMissingSource = ignoreMissingSource;
            this.rewriteRequest = GcsUtil.this.storageClient.objects().rewrite(from.getBucket(), from.getObject(), to.getBucket(), to.getObject(), null);
            if (GcsUtil.this.maxBytesRewrittenPerCall != null) {
                this.rewriteRequest.setMaxBytesRewrittenPerCall(GcsUtil.this.maxBytesRewrittenPerCall);
            }
            this.readyToEnqueue = true;
        }

        public void onSuccess(@UnknownKeyFor @NonNull @Initialized RewriteResponse rewriteResponse, @UnknownKeyFor @NonNull @Initialized HttpHeaders responseHeaders) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.lastError = null;
            if (rewriteResponse.getDone().booleanValue()) {
                if (this.deleteSource) {
                    this.readyToEnqueue = true;
                    this.performDelete = true;
                } else {
                    this.readyToEnqueue = false;
                }
            } else {
                LOG.debug("Rewrite progress: {} of {} bytes, {} to {}", new Object[]{rewriteResponse.getTotalBytesRewritten(), rewriteResponse.getObjectSize(), this.from, this.to});
                this.rewriteRequest.setRewriteToken(rewriteResponse.getRewriteToken());
                this.readyToEnqueue = true;
                if (GcsUtil.this.numRewriteTokensUsed != null) {
                    GcsUtil.this.numRewriteTokensUsed.incrementAndGet();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onFailure(@UnknownKeyFor @NonNull @Initialized GoogleJsonError e, @UnknownKeyFor @NonNull @Initialized HttpHeaders responseHeaders) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (e.getCode() == 404) {
                if (!this.ignoreMissingSource) throw new FileNotFoundException(String.format("Rewrite from %s to %s has failed. Either source or sink not found. Failed with error: %s", this.from.toString(), this.to.toString(), e.getMessage()));
                this.readyToEnqueue = false;
                this.lastError = null;
                return;
            } else if (e.getCode() == 403 && e.getErrors().size() == 1 && ((GoogleJsonError.ErrorInfo)e.getErrors().get(0)).getReason().equals("retentionPolicyNotMet")) {
                List<StorageObjectOrIOException> srcAndDestObjects = GcsUtil.this.getObjects(Arrays.asList(this.from, this.to));
                String srcHash = srcAndDestObjects.get(0).storageObject().getMd5Hash();
                String destHash = srcAndDestObjects.get(1).storageObject().getMd5Hash();
                if (srcHash == null || !srcHash.equals(destHash)) throw new IOException(e.getMessage());
                LOG.warn("Caught retentionPolicyNotMet error while rewriting to a bucket with retention policy. Skipping because destination {} and source {} are considered identical because their MD5 Hashes are equal.", (Object)this.getFrom(), (Object)this.getTo());
                if (this.deleteSource) {
                    this.readyToEnqueue = true;
                    this.performDelete = true;
                } else {
                    this.readyToEnqueue = false;
                }
                this.lastError = null;
                return;
            } else {
                this.lastError = e;
                this.readyToEnqueue = true;
            }
        }
    }

    @AutoValue
    public static abstract class CreateOptions {
        public abstract @UnknownKeyFor @NonNull @Initialized boolean getExpectFileToNotExist();

        public abstract @Nullable @UnknownKeyFor @Initialized Integer getUploadBufferSizeBytes();

        public abstract @Nullable @UnknownKeyFor @Initialized String getContentType();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_GcsUtil_CreateOptions.Builder().setExpectFileToNotExist(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setContentType(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUploadBufferSizeBytes(@UnknownKeyFor @NonNull @Initialized int var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setExpectFileToNotExist(@UnknownKeyFor @NonNull @Initialized boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized CreateOptions build();
        }
    }

    public static class GcsUtilFactory
    implements DefaultValueFactory<GcsUtil> {
        public @UnknownKeyFor @NonNull @Initialized GcsUtil create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            LOG.debug("Creating new GcsUtil");
            GcsOptions gcsOptions = (GcsOptions)options.as(GcsOptions.class);
            Storage.Builder storageBuilder = Transport.newStorageClient(gcsOptions);
            return new GcsUtil(storageBuilder.build(), storageBuilder.getHttpRequestInitializer(), gcsOptions.getExecutorService(), ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)"use_grpc_for_gcs"), gcsOptions.getGcpCredential(), gcsOptions.getGcsUploadBufferSizeBytes(), gcsOptions.getGcsRewriteDataOpBatchLimit(), GcsCountersOptions.create(gcsOptions.getEnableBucketReadMetricCounter() != false ? gcsOptions.getGcsReadCounterPrefix() : null, gcsOptions.getEnableBucketWriteMetricCounter() != false ? gcsOptions.getGcsWriteCounterPrefix() : null));
        }

        public static @UnknownKeyFor @NonNull @Initialized GcsUtil create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Storage storageClient, @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer httpRequestInitializer, @UnknownKeyFor @NonNull @Initialized ExecutorService executorService, @UnknownKeyFor @NonNull @Initialized Credentials credentials, @Nullable @UnknownKeyFor @Initialized Integer uploadBufferSizeBytes, @UnknownKeyFor @NonNull @Initialized GcsCountersOptions gcsCountersOptions) {
            return new GcsUtil(storageClient, httpRequestInitializer, executorService, ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)"use_grpc_for_gcs"), credentials, uploadBufferSizeBytes, null, gcsCountersOptions);
        }
    }

    @AutoValue
    public static abstract class GcsCountersOptions {
        public abstract @Nullable @UnknownKeyFor @Initialized String getReadCounterPrefix();

        public abstract @Nullable @UnknownKeyFor @Initialized String getWriteCounterPrefix();

        public @UnknownKeyFor @NonNull @Initialized boolean hasAnyPrefix() {
            return this.getWriteCounterPrefix() != null || this.getReadCounterPrefix() != null;
        }

        public static @UnknownKeyFor @NonNull @Initialized GcsCountersOptions create(@Nullable @UnknownKeyFor @Initialized String readCounterPrefix, @Nullable @UnknownKeyFor @Initialized String writeCounterPrefix) {
            return new AutoValue_GcsUtil_GcsCountersOptions(readCounterPrefix, writeCounterPrefix);
        }
    }
}

