/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.numbersystrem;

import org.psjava.ds.numbersystrem.OverflowException;

public class GuavasLongMath {
    public static long checkedAdd(long a, long b) {
        long result = a + b;
        GuavasLongMath.assertOverflowCondition((a ^ b) < 0L | (a ^ result) >= 0L);
        return result;
    }

    public static long checkedSubtract(long a, long b) {
        long result = a - b;
        GuavasLongMath.assertOverflowCondition((a ^ b) >= 0L | (a ^ result) >= 0L);
        return result;
    }

    public static long checkedMultiply(long a, long b) {
        int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a * b;
        }
        GuavasLongMath.assertOverflowCondition(leadingZeros >= 64);
        GuavasLongMath.assertOverflowCondition(a >= 0L | b != Long.MIN_VALUE);
        long result = a * b;
        GuavasLongMath.assertOverflowCondition(a == 0L || result / a == b);
        return result;
    }

    private static void assertOverflowCondition(boolean c) {
        if (!c) {
            throw OverflowException.create();
        }
    }
}

