/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.staticschema.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.staticschema.metadata.SchemaFieldDefinition;

@HopMetadata(key="schema-definition", name="i18n::SchemaDefinition.Name", description="i18n::SchemaDefinition.Description", image="ui/images/folder.svg", documentationUrl="/metadata-types/static-schema-definition.html")
public class SchemaDefinition
extends HopMetadataBase
implements Serializable,
IHopMetadata {
    private static final Class<?> PKG = SchemaDefinition.class;
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty
    private List<SchemaFieldDefinition> fieldDefinitions;
    @HopMetadataProperty
    private String separator;
    @HopMetadataProperty
    private String enclosure;

    public SchemaDefinition() {
        this.fieldDefinitions = new ArrayList<SchemaFieldDefinition>();
    }

    public SchemaDefinition(String name, String description, List<SchemaFieldDefinition> fieldDefinitions, String separator, String enclosure) {
        this.name = name;
        this.description = description;
        this.fieldDefinitions = fieldDefinitions;
        this.separator = separator;
        this.enclosure = enclosure;
    }

    public IRowMeta getRowMeta() throws HopPluginException {
        RowMeta rowMeta = new RowMeta();
        for (SchemaFieldDefinition fieldDefinition : this.fieldDefinitions) {
            rowMeta.addValueMeta(fieldDefinition.getValueMeta());
        }
        return rowMeta;
    }

    public void validate() throws HopException {
        for (IValueMeta valueMeta : this.getRowMeta().getValueMetaList()) {
            if (StringUtils.isEmpty((String)valueMeta.getName())) {
                throw new HopException("Schema definition " + this.name + " should not contain fields without a name");
            }
            if (valueMeta.getType() != 0) continue;
            throw new HopException("Schema definition " + this.name + " should not contain fields without a type");
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<SchemaFieldDefinition> getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFieldDefinitions(List<SchemaFieldDefinition> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }
}

