/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.DefaultMetricResults;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MetricUpdates;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.runners.core.metrics.StringSetData;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class MetricsContainerStepMap
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl> metricsContainers;
    private @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl unboundContainer = new MetricsContainerImpl(null);

    public MetricsContainerStepMap() {
        this.metricsContainers = new ConcurrentHashMap<String, MetricsContainerImpl>();
    }

    public @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl getUnboundContainer() {
        return this.unboundContainer;
    }

    public @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl getContainer(@UnknownKeyFor @NonNull @Initialized String stepName) {
        if (stepName == null) {
            return this.getUnboundContainer();
        }
        return this.metricsContainers.computeIfAbsent(stepName, name -> new MetricsContainerImpl((String)name));
    }

    public void updateAll(@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap other) {
        for (Map.Entry<String, MetricsContainerImpl> container : other.metricsContainers.entrySet()) {
            this.getContainer(container.getKey()).update(container.getValue());
        }
        this.getUnboundContainer().update(other.getUnboundContainer());
    }

    public void update(@UnknownKeyFor @NonNull @Initialized String step, @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl container) {
        this.getContainer(step).update(container);
    }

    public void reset() {
        this.metricsContainers.forEach((key, value) -> value.reset());
        this.unboundContainer.reset();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof MetricsContainerStepMap) {
            MetricsContainerStepMap metricsContainerStepMap = (MetricsContainerStepMap)object;
            return Objects.equals(this.metricsContainers, metricsContainerStepMap.metricsContainers) && Objects.equals(this.unboundContainer, metricsContainerStepMap.unboundContainer);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.metricsContainers, this.unboundContainer);
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricResults asAttemptedOnlyMetricResults(@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap attemptedMetricsContainers) {
        return MetricsContainerStepMap.asMetricResults(attemptedMetricsContainers, new MetricsContainerStepMap());
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricResults asMetricResults(@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap attemptedMetricsContainers, @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap committedMetricsContainers) {
        HashMap counters = new HashMap();
        HashMap distributions = new HashMap();
        HashMap gauges = new HashMap();
        HashMap sets = new HashMap();
        attemptedMetricsContainers.forEachMetricContainer(container -> {
            MetricUpdates cumulative = container.getCumulative();
            MetricsContainerStepMap.mergeAttemptedResults(counters, cumulative.counterUpdates(), (l, r) -> l + r);
            MetricsContainerStepMap.mergeAttemptedResults(distributions, cumulative.distributionUpdates(), DistributionData::combine);
            MetricsContainerStepMap.mergeAttemptedResults(gauges, cumulative.gaugeUpdates(), GaugeData::combine);
            MetricsContainerStepMap.mergeAttemptedResults(sets, cumulative.stringSetUpdates(), StringSetData::combine);
        });
        committedMetricsContainers.forEachMetricContainer(container -> {
            MetricUpdates cumulative = container.getCumulative();
            MetricsContainerStepMap.mergeCommittedResults(counters, cumulative.counterUpdates(), (l, r) -> l + r);
            MetricsContainerStepMap.mergeCommittedResults(distributions, cumulative.distributionUpdates(), DistributionData::combine);
            MetricsContainerStepMap.mergeCommittedResults(gauges, cumulative.gaugeUpdates(), GaugeData::combine);
            MetricsContainerStepMap.mergeCommittedResults(sets, cumulative.stringSetUpdates(), StringSetData::combine);
        });
        return new DefaultMetricResults(counters.values(), distributions.values().stream().map(result -> result.transform(DistributionData::extractResult)).collect(Collectors.toList()), gauges.values().stream().map(result -> result.transform(GaugeData::extractResult)).collect(Collectors.toList()), sets.values().stream().map(result -> result.transform(StringSetData::extractResult)).collect(Collectors.toList()));
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> getMonitoringInfos() {
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfos = new ArrayList<MetricsApi.MonitoringInfo>();
        this.forEachMetricContainer(container -> {
            for (MetricsApi.MonitoringInfo mi : container.getMonitoringInfos()) {
                monitoringInfos.add(mi);
            }
        });
        return monitoringInfos;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> getMonitoringData(@UnknownKeyFor @NonNull @Initialized ShortIdMap shortIds) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.forEachMetricContainer(container -> builder.putAll(container.getMonitoringData(shortIds)));
        return builder.build();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        JobApi.MetricResults results = JobApi.MetricResults.newBuilder().addAllAttempted(this.getMonitoringInfos()).build();
        JobApi.GetJobMetricsResponse response = JobApi.GetJobMetricsResponse.newBuilder().setMetrics(results).build();
        try {
            JsonFormat.Printer printer = JsonFormat.printer();
            return printer.print((MessageOrBuilder)response);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private void forEachMetricContainer(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized MetricsContainerImpl> c) {
        this.metricsContainers.forEach((key, value) -> c.accept((MetricsContainerImpl)value));
        c.accept(this.unboundContainer);
    }

    private static <T> void mergeAttemptedResults(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized MetricResult<T>> metricResultMap, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricUpdates.MetricUpdate<T>> updates, @UnknownKeyFor @NonNull @Initialized BiFunction<T, T, T> combine) {
        for (MetricUpdates.MetricUpdate metricUpdate : updates) {
            MetricKey key = metricUpdate.getKey();
            metricResultMap.compute(key, (k, current) -> {
                if (current == null) {
                    return MetricResult.attempted(key, metricUpdate.getUpdate());
                }
                return current.addAttempted(metricUpdate.getUpdate(), combine);
            });
        }
    }

    private static <T> void mergeCommittedResults(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized MetricResult<T>> metricResultMap, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricUpdates.MetricUpdate<T>> updates, @UnknownKeyFor @NonNull @Initialized BiFunction<T, T, T> combine) {
        for (MetricUpdates.MetricUpdate metricUpdate : updates) {
            MetricKey key = metricUpdate.getKey();
            if (metricResultMap.computeIfPresent(key, (k, current) -> current.addCommitted(metricUpdate.getUpdate(), combine)) != null) continue;
            throw new IllegalStateException(String.format("%s: existing 'attempted' result not found for 'committed' value %s", key, metricUpdate.getUpdate()));
        }
    }
}

