/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.Collections;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public enum TimestampCombiner {
    EARLIEST{

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant combine(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Instant> timestamps) {
            return Ordering.natural().min(timestamps);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant merge(@UnknownKeyFor @NonNull @Initialized BoundedWindow intoWindow, @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Instant> mergingTimestamps) {
            return this.combine(mergingTimestamps);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean dependsOnlyOnEarliestTimestamp() {
            return true;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean dependsOnlyOnWindow() {
            return false;
        }
    }
    ,
    LATEST{

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant combine(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Instant> timestamps) {
            return Ordering.natural().max(timestamps);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant merge(@UnknownKeyFor @NonNull @Initialized BoundedWindow intoWindow, @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Instant> mergingTimestamps) {
            return this.combine(mergingTimestamps);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean dependsOnlyOnEarliestTimestamp() {
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean dependsOnlyOnWindow() {
            return false;
        }
    }
    ,
    END_OF_WINDOW{

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant combine(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Instant> timestamps) {
            Preconditions.checkArgument(Iterables.size(timestamps) > 0);
            return Iterables.get(timestamps, 0);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant merge(@UnknownKeyFor @NonNull @Initialized BoundedWindow intoWindow, @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Instant> mergingTimestamps) {
            return intoWindow.maxTimestamp();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean dependsOnlyOnEarliestTimestamp() {
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean dependsOnlyOnWindow() {
            return true;
        }
    };


    public abstract @UnknownKeyFor @NonNull @Initialized Instant combine(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Instant> var1);

    public abstract @UnknownKeyFor @NonNull @Initialized Instant merge(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1, @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Instant> var2);

    public final @UnknownKeyFor @NonNull @Initialized Instant assign(@UnknownKeyFor @NonNull @Initialized BoundedWindow intoWindow, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        return this.merge(intoWindow, Collections.singleton(timestamp));
    }

    public final @UnknownKeyFor @NonNull @Initialized Instant combine(Instant ... timestamps) {
        return this.combine(Arrays.asList(timestamps));
    }

    public final @UnknownKeyFor @NonNull @Initialized Instant merge(@UnknownKeyFor @NonNull @Initialized BoundedWindow intoWindow, Instant ... timestamps) {
        return this.merge(intoWindow, Arrays.asList(timestamps));
    }

    public abstract @UnknownKeyFor @NonNull @Initialized boolean dependsOnlyOnEarliestTimestamp();

    public abstract @UnknownKeyFor @NonNull @Initialized boolean dependsOnlyOnWindow();
}

