/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TimestampPrefixingWindowCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.CoderTranslator;
import org.apache.beam.sdk.util.construction.CoderTranslatorRegistrar;
import org.apache.beam.sdk.util.construction.CoderTranslators;
import org.apache.beam.sdk.util.construction.ModelCoders;
import org.apache.beam.sdk.util.construction.Timer;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={CoderTranslatorRegistrar.class})
public class ModelCoderRegistrar
implements CoderTranslatorRegistrar {
    private static final @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized String> BEAM_MODEL_CODER_URNS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(ByteArrayCoder.class, ModelCoders.BYTES_CODER_URN)).put(BooleanCoder.class, ModelCoders.BOOL_CODER_URN)).put(StringUtf8Coder.class, ModelCoders.STRING_UTF8_CODER_URN)).put(KvCoder.class, ModelCoders.KV_CODER_URN)).put(VarLongCoder.class, ModelCoders.INT64_CODER_URN)).put(IntervalWindow.IntervalWindowCoder.class, ModelCoders.INTERVAL_WINDOW_CODER_URN)).put(IterableCoder.class, ModelCoders.ITERABLE_CODER_URN)).put(Timer.Coder.class, ModelCoders.TIMER_CODER_URN)).put(LengthPrefixCoder.class, ModelCoders.LENGTH_PREFIX_CODER_URN)).put(GlobalWindow.Coder.class, ModelCoders.GLOBAL_WINDOW_CODER_URN)).put(WindowedValue.FullWindowedValueCoder.class, ModelCoders.WINDOWED_VALUE_CODER_URN)).put(WindowedValue.ParamWindowedValueCoder.class, ModelCoders.PARAM_WINDOWED_VALUE_CODER_URN)).put(DoubleCoder.class, ModelCoders.DOUBLE_CODER_URN)).put(RowCoder.class, ModelCoders.ROW_CODER_URN)).put(ShardedKey.Coder.class, ModelCoders.SHARDED_KEY_CODER_URN)).put(TimestampPrefixingWindowCoder.class, ModelCoders.CUSTOM_WINDOW_CODER_URN)).put(NullableCoder.class, ModelCoders.NULLABLE_CODER_URN)).build();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized CoderTranslator<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> BEAM_MODEL_CODERS = ImmutableMap.builder().put(ByteArrayCoder.class, CoderTranslators.atomic(ByteArrayCoder.class)).put(BooleanCoder.class, CoderTranslators.atomic(BooleanCoder.class)).put(StringUtf8Coder.class, CoderTranslators.atomic(StringUtf8Coder.class)).put(VarLongCoder.class, CoderTranslators.atomic(VarLongCoder.class)).put(IntervalWindow.IntervalWindowCoder.class, CoderTranslators.atomic(IntervalWindow.IntervalWindowCoder.class)).put(GlobalWindow.Coder.class, CoderTranslators.atomic(GlobalWindow.Coder.class)).put(KvCoder.class, CoderTranslators.kv()).put(IterableCoder.class, CoderTranslators.iterable()).put(Timer.Coder.class, CoderTranslators.timer()).put(LengthPrefixCoder.class, CoderTranslators.lengthPrefix()).put(WindowedValue.FullWindowedValueCoder.class, CoderTranslators.fullWindowedValue()).put(WindowedValue.ParamWindowedValueCoder.class, CoderTranslators.paramWindowedValue()).put(DoubleCoder.class, CoderTranslators.atomic(DoubleCoder.class)).put(RowCoder.class, CoderTranslators.row()).put(ShardedKey.Coder.class, CoderTranslators.shardedKey()).put(TimestampPrefixingWindowCoder.class, CoderTranslators.timestampPrefixingWindow()).put(NullableCoder.class, CoderTranslators.nullable()).build();

    public static @UnknownKeyFor @NonNull @Initialized boolean isKnownCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        return BEAM_MODEL_CODER_URNS.containsKey(coder.getClass());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized String> getCoderURNs() {
        return BEAM_MODEL_CODER_URNS;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized CoderTranslator<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> getCoderTranslators() {
        return BEAM_MODEL_CODERS;
    }

    static {
        Preconditions.checkState(BEAM_MODEL_CODERS.keySet().containsAll(BEAM_MODEL_CODER_URNS.keySet()), "Every Model %s must have an associated %s. Missing: %s", (Object)Coder.class.getSimpleName(), (Object)CoderTranslator.class.getSimpleName(), Sets.difference(BEAM_MODEL_CODER_URNS.keySet(), BEAM_MODEL_CODERS.keySet()));
        Preconditions.checkState(Sets.symmetricDifference(ModelCoders.urns(), Collections.singleton("beam:coder:state_backed_iterable:v1")).equals(BEAM_MODEL_CODER_URNS.values()), "All Model %ss should have an associated java %s", (Object)Coder.class.getSimpleName(), (Object)Coder.class.getSimpleName());
    }
}

