/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.snmptrap;

import java.net.InetAddress;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.LabelText;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.snmptrap.ActionSNMPTrap;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.snmp4j.UserTarget;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.UdpAddress;

public class ActionSNMPTrapDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionSNMPTrap.class;
    private LabelText wName;
    private LabelTextVar wServerName;
    private LabelTextVar wTimeout;
    private LabelTextVar wComString;
    private LabelTextVar wUser;
    private LabelTextVar wPassphrase;
    private LabelTextVar wEngineID;
    private LabelTextVar wRetry;
    private ActionSNMPTrap action;
    private boolean changed;
    private LabelTextVar wPort;
    private LabelTextVar wOID;
    private StyledTextComp wMessage;
    private CCombo wTargetType;

    public ActionSNMPTrapDialog(Shell parent, ActionSNMPTrap action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        this.wName = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Name.Tooltip", (String[])new String[0]));
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wServerSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wServerSettings);
        wServerSettings.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout serverSettingsgroupLayout = new FormLayout();
        serverSettingsgroupLayout.marginWidth = 10;
        serverSettingsgroupLayout.marginHeight = 10;
        wServerSettings.setLayout((Layout)serverSettingsgroupLayout);
        this.wServerName = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Server.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        FormData fdServerName = new FormData();
        fdServerName.left = new FormAttachment(0, 0);
        fdServerName.top = new FormAttachment((Control)this.wName, margin);
        fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData((Object)fdServerName);
        this.wPort = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Port.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wPort);
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(0, 0);
        fdPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        this.wOID = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.OID.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.OID.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOID);
        this.wOID.addModifyListener(lsMod);
        FormData fdOID = new FormData();
        fdOID.left = new FormAttachment(0, 0);
        fdOID.top = new FormAttachment((Control)this.wPort, margin);
        fdOID.right = new FormAttachment(100, 0);
        this.wOID.setLayoutData((Object)fdOID);
        Button wTest = new Button((Composite)wServerSettings, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.TestConnection.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wOID, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        wTest.addListener(13, e -> this.test());
        FormData fdServerSettings = new FormData();
        fdServerSettings.left = new FormAttachment(0, margin);
        fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        fdServerSettings.right = new FormAttachment(100, -margin);
        wServerSettings.setLayoutData((Object)fdServerSettings);
        Group wAdvancedSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wAdvancedSettings);
        wAdvancedSettings.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.AdvancedSettings.Group.Label", (String[])new String[0]));
        FormLayout advancedSettingsgroupLayout = new FormLayout();
        advancedSettingsgroupLayout.marginWidth = 10;
        advancedSettingsgroupLayout.marginHeight = 10;
        wAdvancedSettings.setLayout((Layout)advancedSettingsgroupLayout);
        Label wlTargetType = new Label((Composite)wAdvancedSettings, 131072);
        wlTargetType.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.TargetType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetType);
        FormData fdlTargetType = new FormData();
        fdlTargetType.left = new FormAttachment(0, margin);
        fdlTargetType.right = new FormAttachment(middle, -margin);
        fdlTargetType.top = new FormAttachment((Control)wServerSettings, margin);
        wlTargetType.setLayoutData((Object)fdlTargetType);
        this.wTargetType = new CCombo((Composite)wAdvancedSettings, 2060);
        this.wTargetType.setItems(ActionSNMPTrap.targetTypeDesc);
        PropsUi.setLook((Widget)this.wTargetType);
        FormData fdTargetType = new FormData();
        fdTargetType.left = new FormAttachment(middle, margin);
        fdTargetType.top = new FormAttachment((Control)wServerSettings, margin);
        fdTargetType.right = new FormAttachment(100, 0);
        this.wTargetType.setLayoutData((Object)fdTargetType);
        this.wTargetType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSNMPTrapDialog.this.checkUseUserTarget();
            }
        });
        this.wComString = new LabelTextVar(this.variables, (Composite)wAdvancedSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.ComString.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.ComString.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wComString);
        this.wComString.addModifyListener(lsMod);
        FormData fdComString = new FormData();
        fdComString.left = new FormAttachment(0, 0);
        fdComString.top = new FormAttachment((Control)this.wTargetType, margin);
        fdComString.right = new FormAttachment(100, 0);
        this.wComString.setLayoutData((Object)fdComString);
        this.wUser = new LabelTextVar(this.variables, (Composite)wAdvancedSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.User.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.User.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUser);
        this.wUser.addModifyListener(lsMod);
        FormData fdUser = new FormData();
        fdUser.left = new FormAttachment(0, 0);
        fdUser.top = new FormAttachment((Control)this.wComString, margin);
        fdUser.right = new FormAttachment(100, 0);
        this.wUser.setLayoutData((Object)fdUser);
        this.wPassphrase = new LabelTextVar(this.variables, (Composite)wAdvancedSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Passphrase.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Passphrase.Tooltip", (String[])new String[0]), true);
        PropsUi.setLook((Widget)this.wPassphrase);
        this.wPassphrase.addModifyListener(lsMod);
        FormData fdPassphrase = new FormData();
        fdPassphrase.left = new FormAttachment(0, 0);
        fdPassphrase.top = new FormAttachment((Control)this.wUser, margin);
        fdPassphrase.right = new FormAttachment(100, 0);
        this.wPassphrase.setLayoutData((Object)fdPassphrase);
        this.wEngineID = new LabelTextVar(this.variables, (Composite)wAdvancedSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.EngineID.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.EngineID.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wEngineID);
        this.wEngineID.addModifyListener(lsMod);
        FormData fdEngineID = new FormData();
        fdEngineID.left = new FormAttachment(0, 0);
        fdEngineID.top = new FormAttachment((Control)this.wPassphrase, margin);
        fdEngineID.right = new FormAttachment(100, 0);
        this.wEngineID.setLayoutData((Object)fdEngineID);
        this.wRetry = new LabelTextVar(this.variables, (Composite)wAdvancedSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Retry.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Retry.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wRetry);
        this.wRetry.addModifyListener(lsMod);
        FormData fdRetry = new FormData();
        fdRetry.left = new FormAttachment(0, 0);
        fdRetry.top = new FormAttachment((Control)this.wEngineID, margin);
        fdRetry.right = new FormAttachment(100, 0);
        this.wRetry.setLayoutData((Object)fdRetry);
        this.wTimeout = new LabelTextVar(this.variables, (Composite)wAdvancedSettings, BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Timeout.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Timeout.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTimeout);
        this.wTimeout.addModifyListener(lsMod);
        FormData fdTimeout = new FormData();
        fdTimeout.left = new FormAttachment(0, 0);
        fdTimeout.top = new FormAttachment((Control)this.wRetry, margin);
        fdTimeout.right = new FormAttachment(100, 0);
        this.wTimeout.setLayoutData((Object)fdTimeout);
        FormData fdAdvancedSettings = new FormData();
        fdAdvancedSettings.left = new FormAttachment(0, margin);
        fdAdvancedSettings.top = new FormAttachment((Control)wServerSettings, margin);
        fdAdvancedSettings.right = new FormAttachment(100, -margin);
        wAdvancedSettings.setLayoutData((Object)fdAdvancedSettings);
        Group wMessageGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wMessageGroup);
        wMessageGroup.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.MessageGroup.Group.Label", (String[])new String[0]));
        FormLayout messageGroupgroupLayout = new FormLayout();
        messageGroupgroupLayout.marginWidth = 10;
        messageGroupgroupLayout.marginHeight = 10;
        wMessageGroup.setLayout((Layout)messageGroupgroupLayout);
        Label wlMessage = new Label((Composite)wMessageGroup, 131072);
        wlMessage.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Message.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMessage);
        FormData fdlMessage = new FormData();
        fdlMessage.left = new FormAttachment(0, 0);
        fdlMessage.top = new FormAttachment((Control)this.wComString, margin);
        fdlMessage.right = new FormAttachment(middle, -margin);
        wlMessage.setLayoutData((Object)fdlMessage);
        this.wMessage = new StyledTextComp((IVariables)this.action, (Composite)wMessageGroup, 19202);
        PropsUi.setLook((Widget)this.wMessage);
        this.wMessage.addModifyListener(lsMod);
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment(middle, 0);
        fdMessage.top = new FormAttachment((Control)this.wComString, margin);
        fdMessage.right = new FormAttachment(100, -2 * margin);
        fdMessage.bottom = new FormAttachment(100, -margin);
        this.wMessage.setLayoutData((Object)fdMessage);
        FormData fdMessageGroup = new FormData();
        fdMessageGroup.left = new FormAttachment(0, margin);
        fdMessageGroup.top = new FormAttachment((Control)wAdvancedSettings, margin);
        fdMessageGroup.right = new FormAttachment(100, -margin);
        fdMessageGroup.bottom = new FormAttachment(100, -margin);
        wMessageGroup.setLayoutData((Object)fdMessageGroup);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.checkUseUserTarget();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void checkUseUserTarget() {
        this.wComString.setEnabled(this.wTargetType.getSelectionIndex() == 0);
        this.wUser.setEnabled(this.wTargetType.getSelectionIndex() == 1);
        this.wPassphrase.setEnabled(this.wTargetType.getSelectionIndex() == 1);
        this.wEngineID.setEnabled(this.wTargetType.getSelectionIndex() == 1);
    }

    private void test() {
        boolean testOK = false;
        String errMsg = null;
        String hostname = this.variables.resolve(this.wServerName.getText());
        int nrPort = Const.toInt((String)this.variables.resolve(this.wPort.getText()), (int)162);
        try {
            UdpAddress udpAddress = new UdpAddress(InetAddress.getByName(hostname), nrPort);
            UserTarget usertarget = new UserTarget();
            usertarget.setAddress((Address)udpAddress);
            testOK = usertarget.getAddress().isValid();
            if (!testOK) {
                errMsg = BaseMessages.getString(PKG, (String)"ActionSNMPTrap.CanNotGetAddress", (String[])new String[]{hostname});
            }
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (testOK) {
            mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Connected.OK", (String[])new String[]{hostname}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Connected.NOK.ConnectionBad", (String[])new String[]{hostname}) + Const.CR + errMsg + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.Connected.Title.Bad", (String[])new String[0]));
            mb.open();
        }
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wServerName.setText(Const.NVL((String)this.action.getServerName(), (String)""));
        this.wPort.setText(this.action.getPort());
        this.wOID.setText(Const.NVL((String)this.action.getOid(), (String)""));
        this.wTimeout.setText(this.action.getTimeout());
        this.wRetry.setText(this.action.getNrretry());
        this.wComString.setText(Const.NVL((String)this.action.getComString(), (String)""));
        this.wMessage.setText(Const.NVL((String)this.action.getMessage(), (String)""));
        this.wTargetType.setText(this.action.getTargetTypeDesc(this.action.getTargettype()));
        this.wUser.setText(Const.NVL((String)this.action.getUser(), (String)""));
        this.wPassphrase.setText(Const.NVL((String)this.action.getPassphrase(), (String)""));
        this.wEngineID.setText(Const.NVL((String)this.action.getEngineid(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setPort(this.wPort.getText());
        this.action.setServerName(this.wServerName.getText());
        this.action.setOid(this.wOID.getText());
        this.action.setTimeout(this.wTimeout.getText());
        this.action.setNrretry(this.wTimeout.getText());
        this.action.setComString(this.wComString.getText());
        this.action.setMessage(this.wMessage.getText());
        this.action.setTargettype(this.wTargetType.getText());
        this.action.setUser(this.wUser.getText());
        this.action.setPassphrase(this.wPassphrase.getText());
        this.action.setEngineid(this.wEngineID.getText());
        this.dispose();
    }
}

