/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.history.AuditManager;
import org.apache.hop.history.AuditState;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ActionDetails;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="This dialog presents you all the actions you can take in a given context")
public class ContextDialog
extends Dialog {
    public static final Class<?> PKG = ContextDialog.class;
    public static final String CATEGORY_OTHER = "Other";
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "ContextDialog-Toolbar";
    public static final String TOOLBAR_ITEM_COLLAPSE_ALL = "ContextDialog-Toolbar-10010-CollapseAll";
    public static final String TOOLBAR_ITEM_EXPAND_ALL = "ContextDialog-Toolbar-10020-ExpandAll";
    public static final String TOOLBAR_ITEM_ENABLE_CATEGORIES = "ContextDialog-Toolbar-10030-EnableCategories";
    public static final String TOOLBAR_ITEM_FIXED_WIDTH = "ContextDialog-Toolbar-10040-FixedWidth";
    public static final String TOOLBAR_ITEM_CLEAR_SEARCH = "ContextDialog-Toolbar-10040-ClearSearch";
    public static final String AUDIT_TYPE_TOOLBAR_SHOW_CATEGORIES = "ContextDialogShowCategories";
    public static final String AUDIT_TYPE_TOOLBAR_FIXED_WIDTH = "ContextDialogFixedWidth";
    public static final String AUDIT_TYPE_CONTEXT_DIALOG = "ContextDialog";
    public static final String AUDIT_NAME_CATEGORY_STATES = "CategoryStates";
    private final Point location;
    private final List<GuiAction> actions;
    private final PropsUi props;
    private Shell shell;
    private Text wSearch;
    private Label wlTooltip;
    private Canvas wCanvas;
    private ScrolledComposite wScrolledComposite;
    private final int iconSize;
    private final int margin;
    private int xMargin;
    private int yMargin;
    private boolean shiftClicked;
    private boolean ctrlClicked;
    private boolean focusLost;
    private final List<Item> items = new ArrayList<Item>();
    private final List<Item> filteredItems = new ArrayList<Item>();
    private Item selectedItem;
    private GuiAction selectedAction;
    private List<AreaOwner> areaOwners = new ArrayList<AreaOwner>();
    private final Color highlightColor;
    private int totalContentHeight = 0;
    private int previousTotalContentHeight = 0;
    private Font headerFont;
    private Font itemsFont;
    private Item firstShownItem;
    private Item lastShownItem;
    private GuiToolbarWidgets toolBarWidgets;
    private static ContextDialog activeInstance;
    private List<CategoryAndOrder> categories;

    public ContextDialog(Shell parent, String title, Point location, List<GuiAction> actions, String contextId) {
        super(parent);
        this.setText(title);
        this.location = location;
        this.actions = actions;
        this.props = PropsUi.getInstance();
        this.shiftClicked = false;
        this.ctrlClicked = false;
        this.iconSize = (int)Math.round(this.props.getZoomFactor() * (double)this.props.getIconSize() * 0.75);
        this.margin = PropsUi.getMargin();
        this.highlightColor = new Color((Device)parent.getDisplay(), this.props.contrastColor(201, 232, 251));
    }

    public GuiAction open() {
        this.shell = new Shell(this.getParent(), 2160);
        this.shell.setText(this.getText());
        this.shell.setMinimumSize(200, 180);
        this.shell.setImage(GuiResource.getInstance().getImageHop());
        this.shell.setLayout((Layout)new FormLayout());
        Display display = this.shell.getDisplay();
        this.xMargin = 3 * this.margin;
        this.yMargin = 2 * this.margin;
        this.categories = new ArrayList<CategoryAndOrder>();
        for (GuiAction guiAction : this.actions) {
            CategoryAndOrder categoryAndOrder = StringUtils.isNotEmpty((String)guiAction.getCategory()) ? new CategoryAndOrder(guiAction.getCategory(), Const.NVL((String)guiAction.getCategoryOrder(), (String)"0"), false) : new CategoryAndOrder(CATEGORY_OTHER, "9999", false);
            if (this.categories.contains(categoryAndOrder)) continue;
            this.categories.add(categoryAndOrder);
        }
        this.categories.sort(Comparator.comparing(o -> o.order));
        int correctedIconSize = (int)((double)this.iconSize / this.props.getZoomFactor());
        this.items.clear();
        for (GuiAction action : this.actions) {
            ClassLoader classLoader = action.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Image image = GuiResource.getInstance().getImage(action.getImage(), classLoader, correctedIconSize, correctedIconSize);
            this.items.add(new Item(action, image));
        }
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        PropsUi.setLook((Widget)composite, 5);
        FormData fdlSearchComposite = new FormData();
        fdlSearchComposite.top = new FormAttachment(0, 0);
        fdlSearchComposite.left = new FormAttachment(0, 0);
        fdlSearchComposite.right = new FormAttachment(100, 0);
        composite.setLayoutData((Object)fdlSearchComposite);
        Label wlSearch = new Label(composite, 16384);
        wlSearch.setText(BaseMessages.getString(PKG, (String)"ContextDialog.Search.Label.Text", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSearch, 5);
        this.wSearch = new Text(composite, 19332);
        this.wSearch.setLayoutData((Object)new GridData(1808));
        PropsUi.setLook((Widget)this.wSearch, 5);
        ToolBar toolBar = new ToolBar(composite, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject((Object)this);
        this.toolBarWidgets.createToolbarWidgets((Composite)toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        toolBar.pack();
        PropsUi.setLook((Widget)toolBar, 5);
        this.recallToolbarSettings();
        Composite wTooltipComposite = new Composite((Composite)this.shell, 0);
        GridLayout gdlTooltipComposite = new GridLayout(1, false);
        gdlTooltipComposite.marginLeft = PropsUi.getFormMargin();
        gdlTooltipComposite.marginRight = PropsUi.getFormMargin();
        gdlTooltipComposite.marginTop = PropsUi.getFormMargin();
        gdlTooltipComposite.marginBottom = PropsUi.getFormMargin();
        wTooltipComposite.setLayout((Layout)new GridLayout(1, false));
        PropsUi.setLook((Widget)wTooltipComposite, 5);
        FormData fdlTooltip = new FormData();
        fdlTooltip.left = new FormAttachment(0, 0);
        fdlTooltip.right = new FormAttachment(100, 0);
        fdlTooltip.top = new FormAttachment(100, -((int)(this.props.getZoomFactor() * 50.0)));
        fdlTooltip.bottom = new FormAttachment(100, 0);
        wTooltipComposite.setLayoutData((Object)fdlTooltip);
        this.wlTooltip = new Label(wTooltipComposite, 16384);
        this.wlTooltip.setLayoutData((Object)new GridData(4, 4, true, true));
        PropsUi.setLook((Widget)this.wlTooltip, 5);
        this.wScrolledComposite = new ScrolledComposite((Composite)this.shell, 512);
        this.wCanvas = new Canvas((Composite)this.wScrolledComposite, 0x20040000);
        this.wScrolledComposite.setContent((Control)this.wCanvas);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.top = new FormAttachment((Control)composite, 0);
        fdCanvas.bottom = new FormAttachment((Control)wTooltipComposite, 0);
        this.wScrolledComposite.setLayoutData((Object)fdCanvas);
        this.wScrolledComposite.setExpandHorizontal(true);
        this.itemsFont = GuiResource.getInstance().getFontDefault();
        int fontHeight = this.itemsFont.getFontData()[0].getHeight() + 1;
        this.headerFont = new Font((Device)this.getParent().getDisplay(), this.props.getDefaultFont().getName(), fontHeight, this.props.getGraphFont().getStyle() | 1 | 2);
        int width = (int)Math.round(800.0 * this.props.getZoomFactor());
        int height = (int)Math.round(600.0 * this.props.getZoomFactor());
        if (this.location != null) {
            Monitor monitor = this.shell.getMonitor();
            boolean fitOtherMonitors = false;
            for (Monitor monitorCheck : this.shell.getDisplay().getMonitors()) {
                org.eclipse.swt.graphics.Rectangle displayPositionCheck = monitorCheck.getBounds();
                if (this.location.x - displayPositionCheck.x <= monitorCheck.getClientArea().width - width && this.location.y - displayPositionCheck.y <= monitorCheck.getClientArea().height - height) {
                    fitOtherMonitors = true;
                    break;
                }
                if (!monitorCheck.getClientArea().contains(this.location.x, this.location.y)) continue;
                monitor = monitorCheck;
            }
            org.eclipse.swt.graphics.Rectangle displayPosition = monitor.getBounds();
            if (width > displayPosition.width) {
                width = displayPosition.width;
            }
            if (height > displayPosition.height) {
                height = displayPosition.height;
            }
            if (!fitOtherMonitors) {
                if (this.location.x - displayPosition.x > monitor.getClientArea().width - width) {
                    this.location.x = monitor.getClientArea().width + displayPosition.x - width;
                }
                if (this.location.y - displayPosition.y > monitor.getClientArea().height - height) {
                    this.location.y = monitor.getClientArea().height + displayPosition.y - height;
                }
            }
            this.shell.setSize(width, height);
            this.shell.setLocation(this.location.x, this.location.y);
        } else {
            BaseTransformDialog.setSize(this.shell, width, height, false);
        }
        this.shell.addListener(11, this::onResize);
        this.shell.addListener(27, event -> this.onFocusLost());
        this.shell.addListener(21, event -> this.storeDialogSettings());
        this.wSearch.addListener(1, this::onKeyPressed);
        this.wSearch.addListener(24, event -> this.onModifySearch());
        this.wSearch.addListener(14, event -> {
            if (event.detail == 512 || event.detail == 256) {
                return;
            }
            if (this.selectedItem != null) {
                this.selectedAction = this.selectedItem.getAction();
            }
            this.dispose();
        });
        this.wCanvas.addListener(1, this::onKeyPressed);
        this.wCanvas.addListener(9, this::onPaint);
        this.wCanvas.addListener(4, this::onMouseUp);
        if (!EnvironmentUtils.getInstance().isWeb()) {
            this.wCanvas.addListener(5, this::onMouseMove);
        }
        if (OsHelper.isMac()) {
            this.wCanvas.addListener(37, event -> {
                org.eclipse.swt.graphics.Point origin = this.wScrolledComposite.getOrigin();
                origin.y -= event.count;
                this.wScrolledComposite.setOrigin(origin);
            });
        }
        this.shell.layout();
        activeInstance = this;
        this.wCanvas.setSize(10, 10);
        this.shell.open();
        this.filter(null);
        this.wSearch.setFocus();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        activeInstance = null;
        return this.selectedAction;
    }

    public static ContextDialog getInstance() {
        return activeInstance;
    }

    private void recallToolbarSettings() {
        AuditState auditState;
        Button fixedWidthCheckBox;
        Button categoriesCheckBox = this.getCategoriesCheckBox();
        if (categoriesCheckBox != null) {
            String strUseCategories = HopConfig.getGuiProperty((String)AUDIT_TYPE_TOOLBAR_SHOW_CATEGORIES);
            categoriesCheckBox.setSelection("Y".equalsIgnoreCase(Const.NVL((String)strUseCategories, (String)"Y")));
        }
        if ((fixedWidthCheckBox = this.getFixedWidthCheckBox()) != null) {
            String strUseFixedWidth = HopConfig.getGuiProperty((String)AUDIT_TYPE_TOOLBAR_FIXED_WIDTH);
            fixedWidthCheckBox.setSelection("Y".equalsIgnoreCase(Const.NVL((String)strUseFixedWidth, (String)"Y")));
        }
        if ((auditState = AuditManager.retrieveState((ILogChannel)LogChannel.UI, (String)HopNamespace.getNamespace(), (String)AUDIT_TYPE_CONTEXT_DIALOG, (String)AUDIT_NAME_CATEGORY_STATES)) != null) {
            Map states = auditState.getStateMap();
            for (CategoryAndOrder category : this.categories) {
                Object expanded = states.get(category.getCategory());
                if (expanded == null) {
                    category.setCollapsed(false);
                    continue;
                }
                category.setCollapsed("N".equalsIgnoreCase(expanded.toString()));
            }
        }
    }

    private void storeDialogSettings() {
        Button fixedWidthCheckBox;
        Button categoriesCheckBox;
        if (this.location == null) {
            this.props.setScreen(new WindowProperty(this.shell));
        }
        if ((categoriesCheckBox = this.getCategoriesCheckBox()) != null) {
            HopConfig.setGuiProperty((String)AUDIT_TYPE_TOOLBAR_SHOW_CATEGORIES, (String)(categoriesCheckBox.getSelection() ? "Y" : "N"));
        }
        if ((fixedWidthCheckBox = this.getFixedWidthCheckBox()) != null) {
            HopConfig.setGuiProperty((String)AUDIT_TYPE_TOOLBAR_FIXED_WIDTH, (String)(fixedWidthCheckBox.getSelection() ? "Y" : "N"));
        }
        try {
            HopConfig.getInstance().saveToFile();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ContextDialog.SaveConfig.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ContextDialog.SaveConfig.Error.Dialog.Message", (String[])new String[0]), e);
        }
        HashMap<String, String> states = new HashMap<String, String>();
        for (CategoryAndOrder category : this.categories) {
            states.put(category.getCategory(), category.isCollapsed() ? "N" : "Y");
        }
        AuditManager.storeState((ILogChannel)LogChannel.UI, (String)HopNamespace.getNamespace(), (String)AUDIT_TYPE_CONTEXT_DIALOG, (String)AUDIT_NAME_CATEGORY_STATES, states);
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public void dispose() {
        this.storeDialogSettings();
        this.shell.close();
        this.highlightColor.dispose();
        this.headerFont.dispose();
    }

    @GuiToolbarElement(root="ContextDialog-Toolbar", id="ContextDialog-Toolbar-10010-CollapseAll", toolTip="i18n::ContextDialog.GuiAction.CollapseCategories.Tooltip", image="ui/images/collapse-all.svg")
    public void collapseAll() {
        for (CategoryAndOrder category : this.categories) {
            category.setCollapsed(true);
        }
        this.wCanvas.redraw();
    }

    @GuiToolbarElement(root="ContextDialog-Toolbar", id="ContextDialog-Toolbar-10020-ExpandAll", toolTip="i18n::ContextDialog.GuiAction.ExpandCategories.Tooltip", image="ui/images/expand-all.svg")
    public void expandAll() {
        for (CategoryAndOrder category : this.categories) {
            category.setCollapsed(false);
        }
        this.wCanvas.redraw();
    }

    @GuiToolbarElement(root="ContextDialog-Toolbar", id="ContextDialog-Toolbar-10030-EnableCategories", label="i18n::ContextDialog.GuiAction.ShowCategories.Label", toolTip="i18n::ContextDialog.GuiAction.ShowCategories.Tooltip", type=GuiToolbarElementType.CHECKBOX)
    public void enableDisableCategories() {
        this.wCanvas.redraw();
        this.wSearch.setFocus();
    }

    @GuiToolbarElement(root="ContextDialog-Toolbar", id="ContextDialog-Toolbar-10040-FixedWidth", label="i18n::ContextDialog.GuiAction.FixedWidth.Label", toolTip="i18n::ContextDialog.GuiAction.FixedWidth.Tooltip", type=GuiToolbarElementType.CHECKBOX)
    public void enableDisableFixedWidth() {
        this.wCanvas.redraw();
        this.wSearch.setFocus();
    }

    private Button getCategoriesCheckBox() {
        ToolItem checkboxItem = this.toolBarWidgets.findToolItem(TOOLBAR_ITEM_ENABLE_CATEGORIES);
        if (checkboxItem == null) {
            return null;
        }
        return (Button)checkboxItem.getControl();
    }

    private Button getFixedWidthCheckBox() {
        ToolItem checkboxItem = this.toolBarWidgets.findToolItem(TOOLBAR_ITEM_FIXED_WIDTH);
        if (checkboxItem == null) {
            return null;
        }
        return (Button)checkboxItem.getControl();
    }

    private void onMouseMove(Event event) {
        Item item = this.findItem(event.x, event.y);
        if (item != null) {
            this.selectItem(item, false);
        }
    }

    private void onMouseUp(Event event) {
        AreaOwner areaOwner = AreaOwner.getVisibleAreaOwner(this.areaOwners, (int)event.x, (int)event.y);
        if (areaOwner == null) {
            return;
        }
        OwnerType ownerType = (OwnerType)((Object)areaOwner.getParent());
        switch (ownerType) {
            case CATEGORY: {
                CategoryAndOrder categoryAndOrder = (CategoryAndOrder)areaOwner.getOwner();
                categoryAndOrder.flipCollapsed();
                this.wCanvas.redraw();
                break;
            }
            case ITEM: {
                Item item = (Item)areaOwner.getOwner();
                if (item == null) break;
                this.selectedAction = item.getAction();
                this.shiftClicked = (event.stateMask & 0x20000) != 0;
                this.ctrlClicked = (event.stateMask & 0x40000) != 0 || Const.isOSX() && (event.stateMask & 0x400000) != 0;
                this.dispose();
            }
        }
    }

    private void onResize(Event event) {
        this.updateVerticalBar();
    }

    private void onPaint(Event event) {
        GC gc = event.gc;
        org.eclipse.swt.graphics.Rectangle area = this.wScrolledComposite.getClientArea();
        org.eclipse.swt.graphics.Rectangle canvas = this.wCanvas.getBounds();
        Button categoriesCheckBox = this.getCategoriesCheckBox();
        boolean useCategories = categoriesCheckBox == null ? true : categoriesCheckBox.getSelection();
        useCategories &= !this.categories.isEmpty();
        Button fixedWidthCheckBox = this.getFixedWidthCheckBox();
        boolean useFixedWidth = fixedWidthCheckBox == null ? false : fixedWidthCheckBox.getSelection();
        this.updateToolbar();
        gc.setForeground(GuiResource.getInstance().getColorBlack());
        gc.setBackground(GuiResource.getInstance().getColorBackground());
        gc.fillRectangle(0, 0, canvas.width, canvas.height);
        gc.setForeground(GuiResource.getInstance().getColorBlack());
        gc.setLineWidth(1);
        this.areaOwners = new ArrayList<AreaOwner>();
        int height = 0;
        int categoryNr = 0;
        int x = this.margin;
        int y = this.margin;
        this.firstShownItem = null;
        while (useCategories && categoryNr < this.categories.size() || (!useCategories || this.categories.isEmpty()) && categoryNr == 0) {
            CategoryAndOrder categoryAndOrder = !useCategories || this.categories.isEmpty() ? null : this.categories.get(categoryNr);
            List<Item> itemsToPaint = this.findItemsForCategory(categoryAndOrder);
            if (!itemsToPaint.isEmpty()) {
                if (categoryAndOrder != null) {
                    gc.setFont(this.headerFont);
                    if (categoryAndOrder.isCollapsed()) {
                        gc.setForeground(GuiResource.getInstance().getColorDarkGray());
                    } else {
                        gc.setForeground(GuiResource.getInstance().getColorBlack());
                    }
                    org.eclipse.swt.graphics.Point categoryExtent = gc.textExtent(categoryAndOrder.category);
                    gc.drawText(categoryAndOrder.category, x, y);
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.CUSTOM, x, y, categoryExtent.x, categoryExtent.y, new DPoint(0.0, 0.0), (Object)OwnerType.CATEGORY, (Object)categoryAndOrder));
                    gc.setLineWidth(1);
                    gc.drawLine(this.margin, (y += categoryExtent.y + this.yMargin) - this.yMargin, area.width - this.xMargin, y - this.yMargin);
                }
                gc.setForeground(GuiResource.getInstance().getColorBlack());
                gc.setFont(this.itemsFont);
                if (categoryAndOrder == null || !categoryAndOrder.isCollapsed()) {
                    HashMap<GuiAction, ActionDetails> detailsMap = new HashMap<GuiAction, ActionDetails>();
                    for (Item item : itemsToPaint) {
                        ActionDetails details2 = new ActionDetails();
                        details2.name = Const.NVL((String)item.action.getName(), (String)item.action.getId());
                        details2.imageBounds = item.image.getBounds();
                        details2.nameExtent = gc.textExtent(details2.name);
                        details2.width = Math.max(details2.nameExtent.x, details2.imageBounds.width);
                        details2.height = details2.nameExtent.y + this.margin + details2.imageBounds.height;
                        detailsMap.put(item.action, details2);
                    }
                    if (useFixedWidth) {
                        int maxWidth = 0;
                        for (ActionDetails details : detailsMap.values()) {
                            maxWidth = Math.max(maxWidth, details.width);
                        }
                        for (ActionDetails details : detailsMap.values()) {
                            details.width = maxWidth;
                        }
                    }
                    for (Item item : itemsToPaint) {
                        ActionDetails details;
                        details = (ActionDetails)detailsMap.get(item.action);
                        this.lastShownItem = item;
                        if (this.firstShownItem == null) {
                            this.firstShownItem = item;
                        }
                        int width = details.width;
                        height = details.height;
                        if (x + width + this.xMargin > area.width) {
                            x = this.margin;
                            y += height + this.yMargin;
                        }
                        if (item.isSelected()) {
                            gc.setLineWidth(2);
                            gc.setBackground(this.highlightColor);
                            gc.fillRoundRectangle(x - this.xMargin / 2, y - this.yMargin / 2, width + this.xMargin, height + this.yMargin, this.margin, this.margin);
                        }
                        int imageMargin = (width - details.imageBounds.width) / 2;
                        gc.drawImage(item.getImage(), x + imageMargin, y);
                        int textMargin = (width - details.nameExtent.x) / 2;
                        gc.drawText(details.name, x + textMargin, y + details.imageBounds.height + this.margin);
                        gc.setLineWidth(1);
                        gc.setBackground(GuiResource.getInstance().getColorBackground());
                        AreaOwner areaOwner = new AreaOwner(AreaOwner.AreaType.CUSTOM, x, y, width, height, new DPoint(0.0, 0.0), (Object)OwnerType.ITEM, (Object)item);
                        this.areaOwners.add(areaOwner);
                        item.setAreaOwner(areaOwner);
                        if ((x += width + this.xMargin) <= area.width) continue;
                        x = this.margin;
                        y += height + this.yMargin;
                    }
                    x = this.margin;
                    y += height + this.yMargin;
                } else {
                    y -= this.yMargin;
                }
            }
            ++categoryNr;
            if (itemsToPaint.isEmpty()) continue;
            y += this.yMargin;
        }
        this.totalContentHeight = Math.max(area.height, y);
        if (this.previousTotalContentHeight != this.totalContentHeight) {
            this.previousTotalContentHeight = this.totalContentHeight;
            this.wCanvas.setSize(area.width, this.totalContentHeight);
        }
    }

    private void updateToolbar() {
        Button categoriesCheckBox = this.getCategoriesCheckBox();
        boolean categoriesEnabled = categoriesCheckBox != null && categoriesCheckBox.getSelection();
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_COLLAPSE_ALL, categoriesEnabled);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_EXPAND_ALL, categoriesEnabled);
    }

    private List<Item> findItemsForCategory(CategoryAndOrder categoryAndOrder) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (Item filteredItem : this.filteredItems) {
            if (categoryAndOrder == null || categoryAndOrder.category.equalsIgnoreCase(filteredItem.action.getCategory())) {
                list.add(filteredItem);
                continue;
            }
            if (!CATEGORY_OTHER.equals(categoryAndOrder.category) || !StringUtils.isEmpty((String)filteredItem.action.getCategory())) continue;
            list.add(filteredItem);
        }
        return list;
    }

    private void selectItem(Item selectedItem, boolean scroll) {
        for (Item item : this.items) {
            item.setSelected(false);
        }
        if (selectedItem == null) {
            this.wlTooltip.setText("");
        } else {
            this.selectedItem = selectedItem;
            this.wlTooltip.setText(Const.NVL((String)selectedItem.getAction().getTooltip(), (String)""));
            selectedItem.setSelected(true);
            if (!EnvironmentUtils.getInstance().isWeb() && scroll && this.totalContentHeight > 0) {
                Rectangle itemArea = selectedItem.getAreaOwner().getArea();
                org.eclipse.swt.graphics.Rectangle clientArea = this.wScrolledComposite.getClientArea();
                ScrollBar verticalBar = this.wScrolledComposite.getVerticalBar();
                while (itemArea.y + itemArea.height + 2 * this.yMargin > verticalBar.getSelection() + clientArea.height) {
                    this.wScrolledComposite.setOrigin(0, Math.min(verticalBar.getSelection() + verticalBar.getPageIncrement(), verticalBar.getMaximum() - verticalBar.getThumb()));
                }
                while (itemArea.y < verticalBar.getSelection()) {
                    this.wScrolledComposite.setOrigin(0, Math.max(verticalBar.getSelection() - verticalBar.getPageIncrement(), 0));
                }
            }
        }
        this.wCanvas.redraw();
    }

    public Text getSearchTextWidget() {
        return this.wSearch;
    }

    public void filter(String text) {
        if (text == null) {
            text = "";
        }
        String[] filters = text.split(",");
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = Const.trim((String)filters[i]);
        }
        this.filteredItems.clear();
        for (Item item : this.items) {
            GuiAction action = item.getAction();
            if (!StringUtils.isEmpty((String)text) && !action.containsFilterStrings(filters)) continue;
            this.filteredItems.add(item);
        }
        if (this.filteredItems.isEmpty()) {
            this.selectItem(null, false);
        } else if (!this.filteredItems.contains(this.selectedItem)) {
            this.selectItem(this.filteredItems.get(0), false);
        }
        this.updateVerticalBar();
        this.wCanvas.redraw();
    }

    private void onFocusLost() {
        this.focusLost = true;
        this.dispose();
    }

    private void onModifySearch() {
        String text = this.wSearch.getText();
        this.filter(text);
    }

    private synchronized void onKeyPressed(Event event) {
        if (this.filteredItems.isEmpty()) {
            return;
        }
        if (this.shell.isDisposed() || !this.shell.isVisible()) {
            return;
        }
        Rectangle area = null;
        if (this.selectedItem == null) {
            if (this.firstShownItem != null) {
                area = this.firstShownItem.getAreaOwner().getArea();
            }
        } else if (this.selectedItem.getAreaOwner() != null) {
            area = this.selectedItem.getAreaOwner().getArea();
        }
        switch (event.keyCode) {
            case 0x1000002: {
                this.selectItemDown(area);
                break;
            }
            case 0x1000001: {
                this.selectItemUp(area);
                break;
            }
            case 0x1000005: {
                this.selectItemPageUp(area);
                break;
            }
            case 0x1000006: {
                this.selectItemPageDown(area);
                break;
            }
            case 0x1000003: {
                this.selectItemLeft(area);
                break;
            }
            case 0x1000004: {
                this.selectItemRight(area);
                break;
            }
            case 0x1000007: {
                this.selectItem(this.firstShownItem, true);
                break;
            }
            case 0x1000008: {
                this.selectItem(this.lastShownItem, true);
            }
        }
    }

    private void selectClosest(Rectangle area, List<AreaOwner> areas) {
        areas.sort((o1, o2) -> (int)(o1.getArea().distance(area) - o2.getArea().distance(area)));
        if (!areas.isEmpty()) {
            Item item = (Item)areas.get(0).getOwner();
            this.selectItem(item, true);
        }
    }

    private void selectItemRight(Rectangle area) {
        ArrayList<AreaOwner> rightAreas = new ArrayList<AreaOwner>();
        for (AreaOwner areaOwner : this.areaOwners) {
            if (!(areaOwner.getOwner() instanceof Item)) continue;
            Rectangle r = areaOwner.getArea();
            if (r.x <= area.x + area.width || r.y - 2 * this.yMargin >= area.y || r.y + 2 * this.yMargin <= area.y) continue;
            rightAreas.add(areaOwner);
        }
        this.selectClosest(area, rightAreas);
    }

    private void selectItemLeft(Rectangle area) {
        ArrayList<AreaOwner> leftAreas = new ArrayList<AreaOwner>();
        for (AreaOwner areaOwner : this.areaOwners) {
            if (!(areaOwner.getOwner() instanceof Item)) continue;
            Rectangle r = areaOwner.getArea();
            if (r.x >= area.x || r.y - 2 * this.yMargin >= area.y || r.y + 2 * this.yMargin <= area.y) continue;
            leftAreas.add(areaOwner);
        }
        this.selectClosest(area, leftAreas);
    }

    private void selectItemUp(Rectangle area) {
        ArrayList<AreaOwner> topAreas = new ArrayList<AreaOwner>();
        for (AreaOwner areaOwner : this.areaOwners) {
            if (!(areaOwner.getOwner() instanceof Item) || areaOwner.getArea().y >= area.y) continue;
            topAreas.add(areaOwner);
        }
        this.selectClosest(area, topAreas);
    }

    private void selectItemDown(Rectangle area) {
        ArrayList<AreaOwner> bottomAreas = new ArrayList<AreaOwner>();
        for (AreaOwner areaOwner : this.areaOwners) {
            if (!(areaOwner.getOwner() instanceof Item) || areaOwner.getArea().y <= area.y + area.height) continue;
            bottomAreas.add(areaOwner);
        }
        this.selectClosest(area, bottomAreas);
    }

    private void selectItemPageUp(Rectangle area) {
        ScrollBar verticalBar = this.wScrolledComposite.getVerticalBar();
        ArrayList<AreaOwner> topAreas = new ArrayList<AreaOwner>();
        for (AreaOwner areaOwner : this.areaOwners) {
            if (!(areaOwner.getOwner() instanceof Item) || areaOwner.getArea().y >= area.y - verticalBar.getPageIncrement()) continue;
            topAreas.add(areaOwner);
        }
        if (topAreas.isEmpty()) {
            topAreas.add(this.firstShownItem.getAreaOwner());
        }
        this.selectClosest(area, topAreas);
    }

    private void selectItemPageDown(Rectangle area) {
        ScrollBar verticalBar = this.wScrolledComposite.getVerticalBar();
        ArrayList<AreaOwner> bottomAreas = new ArrayList<AreaOwner>();
        for (AreaOwner areaOwner : this.areaOwners) {
            if (!(areaOwner.getOwner() instanceof Item)) continue;
            Rectangle r = areaOwner.getArea();
            if (r.y <= area.y + area.height + verticalBar.getPageIncrement()) continue;
            bottomAreas.add(areaOwner);
        }
        if (bottomAreas.isEmpty()) {
            bottomAreas.add(this.lastShownItem.getAreaOwner());
        }
        this.selectClosest(area, bottomAreas);
    }

    private void updateVerticalBar() {
        ScrollBar verticalBar = this.wScrolledComposite.getVerticalBar();
        org.eclipse.swt.graphics.Rectangle clientArea = this.wScrolledComposite.getClientArea();
        if (this.totalContentHeight < clientArea.height) {
            verticalBar.setEnabled(false);
            verticalBar.setVisible(false);
        } else {
            verticalBar.setEnabled(true);
            verticalBar.setVisible(true);
            org.eclipse.swt.graphics.Rectangle bounds = this.wCanvas.getBounds();
            verticalBar.setMinimum(0);
            verticalBar.setMaximum(bounds.height);
            verticalBar.setThumb(Math.min(clientArea.height, bounds.height));
        }
    }

    private Item findItem(int x, int y) {
        for (AreaOwner areaOwner : this.areaOwners) {
            if (!areaOwner.contains(x, y) || !(areaOwner.getOwner() instanceof Item)) continue;
            return (Item)areaOwner.getOwner();
        }
        return null;
    }

    public boolean isShiftClicked() {
        return this.shiftClicked;
    }

    public void setShiftClicked(boolean shiftClicked) {
        this.shiftClicked = shiftClicked;
    }

    public boolean isCtrlClicked() {
        return this.ctrlClicked;
    }

    public void setCtrlClicked(boolean ctrlClicked) {
        this.ctrlClicked = ctrlClicked;
    }

    public boolean isFocusLost() {
        return this.focusLost;
    }

    public void setFocusLost(boolean focusLost) {
        this.focusLost = focusLost;
    }

    private class CategoryAndOrder {
        String category;
        String order;
        boolean collapsed;

        public CategoryAndOrder(String category, String order, boolean collapsed) {
            this.category = category;
            this.order = order;
            this.collapsed = collapsed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CategoryAndOrder that = (CategoryAndOrder)o;
            return this.category.equals(that.category);
        }

        public int hashCode() {
            return Objects.hash(this.category);
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        public void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
        }

        public void flipCollapsed() {
            this.collapsed = !this.collapsed;
        }
    }

    private static class Item {
        private final GuiAction action;
        private final Image image;
        private boolean selected;
        private AreaOwner areaOwner;

        public Item(GuiAction action, Image image) {
            this.action = action;
            this.image = image;
            this.selected = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return Objects.equals(this.action, item.action);
        }

        public int hashCode() {
            return Objects.hash(this.action);
        }

        public GuiAction getAction() {
            return this.action;
        }

        public String getText() {
            return this.action.getShortName();
        }

        public Image getImage() {
            return this.image;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public AreaOwner getAreaOwner() {
            return this.areaOwner;
        }

        public void setAreaOwner(AreaOwner areaOwner) {
            this.areaOwner = areaOwner;
        }
    }

    private static enum OwnerType {
        CATEGORY,
        ITEM;

    }
}

