/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.client.CachedExchange;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.StringUtil;

public class ContentExchange
extends CachedExchange {
    protected int _responseStatus;
    protected int _contentLength = -1;
    protected String _encoding = "utf-8";
    protected ByteArrayOutputStream2 _responseContent;
    protected File _fileForUpload;

    public ContentExchange() {
        super(false);
    }

    public ContentExchange(boolean keepHeaders) {
        super(keepHeaders);
    }

    public int getResponseStatus() {
        if (this.getStatus() < 5) {
            throw new IllegalStateException("Response not received");
        }
        return this._responseStatus;
    }

    public String getResponseContent() throws UnsupportedEncodingException {
        if (this._responseContent != null) {
            return this._responseContent.toString(this._encoding);
        }
        return null;
    }

    public byte[] getResponseBytes() {
        if (this._responseContent != null) {
            if (this._contentLength >= 0 && this._responseContent.getBuf().length == this._contentLength) {
                return this._responseContent.getBuf();
            }
            return this._responseContent.toByteArray();
        }
        return null;
    }

    public void writeResponseBytesTo(OutputStream out) throws IOException {
        if (this._responseContent != null) {
            out.write(this._responseContent.getBuf(), 0, this._responseContent.getCount());
        }
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (this._responseContent != null) {
            this._responseContent.reset();
        }
        this._responseStatus = status;
        super.onResponseStatus(version, status, reason);
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        super.onResponseHeader(name, value);
        int header = HttpHeaders.CACHE.getOrdinal(name);
        switch (header) {
            case 12: {
                this._contentLength = BufferUtil.toInt((Buffer)value);
                break;
            }
            case 16: {
                String mime = StringUtil.asciiToLowerCase((String)value.toString());
                int i = mime.indexOf("charset=");
                if (i <= 0) break;
                this._encoding = mime.substring(i + 8);
            }
        }
    }

    protected void onResponseContent(Buffer content) throws IOException {
        super.onResponseContent(content);
        if (this._responseContent == null) {
            this._responseContent = this._contentLength >= 0 ? new ByteArrayOutputStream2(this._contentLength) : new ByteArrayOutputStream2();
        }
        content.writeTo((OutputStream)this._responseContent);
    }

    protected void onRetry() throws IOException {
        if (this._fileForUpload != null) {
            this.setRequestContent(null);
            this.setRequestContentSource(this.getInputStream());
        } else {
            super.onRetry();
        }
    }

    private InputStream getInputStream() throws IOException {
        return new FileInputStream(this._fileForUpload);
    }

    public File getFileForUpload() {
        return this._fileForUpload;
    }

    public void setFileForUpload(File fileForUpload) throws IOException {
        this._fileForUpload = fileForUpload;
        this._requestContentSource = this.getInputStream();
    }
}

