/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.plugins.IClassLoadingPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.Plugin;

public class SupplementalPlugin
extends Plugin
implements IClassLoadingPlugin {
    Map<Class, Callable> factoryMap = new HashMap<Class, Callable>();
    private Class<? extends IPluginType> pluginClass;
    private String id;

    public SupplementalPlugin(Class<? extends IPluginType> pluginClass, String id) {
        super(new String[]{id}, pluginClass, null, "", id, id, "", false, false, Collections.emptyMap(), Collections.emptyList(), "", new String[0], null, false);
        this.pluginClass = pluginClass;
        this.id = id;
    }

    @Override
    public <T> T loadClass(Class<T> pluginClass) {
        if (!this.factoryMap.containsKey(pluginClass)) {
            return null;
        }
        try {
            return (T)this.factoryMap.get(pluginClass).call();
        }
        catch (Exception e) {
            throw new RuntimeException(new HopPluginException("Error creating plugin class", e));
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public <T> void addFactory(Class<T> tClass, Callable<T> callable) {
        this.factoryMap.put(tClass, callable);
    }
}

