/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.javascript;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.JavaScriptUtils;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesAddedFunctions;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesData;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesMeta;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesScript;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptValues
extends BaseTransform<ScriptValuesMeta, ScriptValuesData> {
    private static final Class<?> PKG = ScriptValuesMeta.class;
    public static final int SKIP_PIPELINE = 1;
    public static final int ABORT_PIPELINE = -1;
    public static final int ERROR_PIPELINE = -2;
    public static final int CONTINUE_PIPELINE = 0;
    private boolean bWithPipelineStat = false;
    private boolean bRC = false;
    private int iPipelineStat = 0;
    private boolean bFirstRun = false;
    private ScriptValuesScript[] jsScripts;
    private String strTransformScript = "";
    private String strStartScript = "";
    private String strEndScript = "";
    public Script script;

    public ScriptValues(TransformMeta transformMeta, ScriptValuesMeta meta, ScriptValuesData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void determineUsedFields(IRowMeta row) {
        String valname;
        int i;
        int nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valname = row.getValueMeta(i).getName().toUpperCase();
            if (this.strTransformScript.toUpperCase().indexOf(valname) < 0) continue;
            ++nr;
        }
        ((ScriptValuesData)this.data).fieldsUsed = new int[nr];
        nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valname = row.getValueMeta(i).getName();
            if (this.strTransformScript.indexOf(valname) < 0) continue;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.UsedValueName", (String[])new String[]{String.valueOf(i), valname}));
            }
            ((ScriptValuesData)this.data).fieldsUsed[nr] = i;
            ++nr;
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.UsingValuesFromInputStream", (String[])new String[]{String.valueOf(((ScriptValuesData)this.data).fieldsUsed.length)}));
        }
    }

    private boolean addValues(IRowMeta rowMeta, Object[] row) throws HopException {
        Object valueData;
        if (this.first) {
            this.first = false;
            ((ScriptValuesData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((ScriptValuesMeta)this.meta).getFields(((ScriptValuesData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            this.determineUsedFields(rowMeta);
            ((ScriptValuesData)this.data).replaceIndex = new int[((ScriptValuesMeta)this.meta).getFieldname().length];
            for (int i = 0; i < ((ScriptValuesMeta)this.meta).getFieldname().length; ++i) {
                if (((ScriptValuesMeta)this.meta).getReplace()[i]) {
                    ((ScriptValuesData)this.data).replaceIndex[i] = rowMeta.indexOfValue(((ScriptValuesMeta)this.meta).getFieldname()[i]);
                    if (((ScriptValuesData)this.data).replaceIndex[i] >= 0) continue;
                    if (Utils.isEmpty((CharSequence)((ScriptValuesMeta)this.meta).getFieldname()[i])) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{((ScriptValuesMeta)this.meta).getFieldname()[i]}));
                    }
                    ((ScriptValuesData)this.data).replaceIndex[i] = rowMeta.indexOfValue(((ScriptValuesMeta)this.meta).getRename()[i]);
                    if (((ScriptValuesData)this.data).replaceIndex[i] >= 0) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{((ScriptValuesMeta)this.meta).getRename()[i]}));
                }
                ((ScriptValuesData)this.data).replaceIndex[i] = -1;
            }
            ((ScriptValuesData)this.data).cx = ContextFactory.getGlobal().enterContext();
            try {
                String optimizationLevelAsString = this.resolve(((ScriptValuesMeta)this.meta).getOptimizationLevel());
                if (!Utils.isEmpty((CharSequence)Const.trim((String)optimizationLevelAsString))) {
                    ((ScriptValuesData)this.data).cx.setOptimizationLevel(Integer.parseInt(optimizationLevelAsString.trim()));
                    this.logBasic(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Optimization.Level", (String[])new String[]{this.resolve(((ScriptValuesMeta)this.meta).getOptimizationLevel())}));
                } else {
                    ((ScriptValuesData)this.data).cx.setOptimizationLevel(Integer.parseInt("9"));
                    this.logBasic(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Optimization.UsingDefault", (String[])new String[]{"9"}));
                }
            }
            catch (NumberFormatException nfe) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.NumberFormatException", (String[])new String[]{this.resolve(((ScriptValuesMeta)this.meta).getOptimizationLevel())}));
            }
            catch (IllegalArgumentException iae) {
                throw new HopException(iae.getMessage());
            }
            ((ScriptValuesData)this.data).scope = ((ScriptValuesData)this.data).cx.initStandardObjects(null, false);
            this.bFirstRun = true;
            Scriptable jsvalue = Context.toObject((Object)((Object)this), (Scriptable)((ScriptValuesData)this.data).scope);
            ((ScriptValuesData)this.data).scope.put("_transform_", ((ScriptValuesData)this.data).scope, (Object)jsvalue);
            for (int i = 0; i < ((ScriptValuesMeta)this.meta).getNumberOfJSScripts(); ++i) {
                Scriptable jsR = Context.toObject((Object)this.jsScripts[i].getScript(), (Scriptable)((ScriptValuesData)this.data).scope);
                ((ScriptValuesData)this.data).scope.put(this.jsScripts[i].getScriptName(), ((ScriptValuesData)this.data).scope, (Object)jsR);
            }
            ((ScriptValuesData)this.data).scope.put("_PipelineName_", ((ScriptValuesData)this.data).scope, (Object)this.getPipelineMeta().getName());
            try {
                Scriptable jsrow = Context.toObject((Object)row, (Scriptable)((ScriptValuesData)this.data).scope);
                ((ScriptValuesData)this.data).scope.put("row", ((ScriptValuesData)this.data).scope, (Object)jsrow);
                for (int i = 0; i < ((ScriptValuesData)this.data).fieldsUsed.length; ++i) {
                    IValueMeta valueMeta = rowMeta.getValueMeta(((ScriptValuesData)this.data).fieldsUsed[i]);
                    Object normalStorageValueData = valueMeta.convertToNormalStorageType(valueData = row[((ScriptValuesData)this.data).fieldsUsed[i]]);
                    Scriptable jsarg = normalStorageValueData != null ? Context.toObject((Object)normalStorageValueData, (Scriptable)((ScriptValuesData)this.data).scope) : null;
                    ((ScriptValuesData)this.data).scope.put(valueMeta.getName(), ((ScriptValuesData)this.data).scope, (Object)jsarg);
                }
                Scriptable jsrowMeta = Context.toObject((Object)rowMeta, (Scriptable)((ScriptValuesData)this.data).scope);
                ((ScriptValuesData)this.data).scope.put("rowMeta", ((ScriptValuesData)this.data).scope, (Object)jsrowMeta);
                try {
                    if (((ScriptValuesMeta)this.meta).getAddClasses() != null) {
                        for (int i = 0; i < ((ScriptValuesMeta)this.meta).getAddClasses().length; ++i) {
                            Object jsOut = Context.javaToJS((Object)((ScriptValuesMeta)this.meta).getAddClasses()[i].getAddObject(), (Scriptable)((ScriptValuesData)this.data).scope);
                            ScriptableObject.putProperty((Scriptable)((ScriptValuesData)this.data).scope, (String)((ScriptValuesMeta)this.meta).getAddClasses()[i].getJSName(), (Object)jsOut);
                        }
                    }
                }
                catch (Exception e) {
                    throw new HopValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.CouldNotAttachAdditionalScripts", (String[])new String[0]), (Throwable)e);
                }
                try {
                    Context.javaToJS(ScriptValuesAddedFunctions.class, (Scriptable)((ScriptValuesData)this.data).scope);
                    ((ScriptableObject)((ScriptValuesData)this.data).scope).defineFunctionProperties(ScriptValuesAddedFunctions.jsFunctionList, ScriptValuesAddedFunctions.class, 2);
                }
                catch (Exception ex) {
                    throw new HopValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.CouldNotAddDefaultFunctions", (String[])new String[0]), (Throwable)ex);
                }
                try {
                    ((ScriptValuesData)this.data).scope.put("SKIP_PIPELINE", ((ScriptValuesData)this.data).scope, (Object)1);
                    ((ScriptValuesData)this.data).scope.put("ABORT_PIPELINE", ((ScriptValuesData)this.data).scope, (Object)-1);
                    ((ScriptValuesData)this.data).scope.put("ERROR_PIPELINE", ((ScriptValuesData)this.data).scope, (Object)-2);
                    ((ScriptValuesData)this.data).scope.put("CONTINUE_PIPELINE", ((ScriptValuesData)this.data).scope, (Object)0);
                }
                catch (Exception ex) {
                    throw new HopValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.CouldNotAddDefaultConstants", (String[])new String[0]), (Throwable)ex);
                }
                try {
                    if (this.strStartScript != null && this.strStartScript.length() > 0) {
                        Script startScript = ((ScriptValuesData)this.data).cx.compileString(this.strStartScript, "pipeline_Start", 1, null);
                        startScript.exec(((ScriptValuesData)this.data).cx, ((ScriptValuesData)this.data).scope);
                        if (this.log.isDetailed()) {
                            this.logDetailed("Start Script found!");
                        }
                    } else if (this.log.isDetailed()) {
                        this.logDetailed("No starting Script found!");
                    }
                }
                catch (Exception es) {
                    throw new HopValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.ErrorProcessingStartScript", (String[])new String[0]), (Throwable)es);
                }
                ((ScriptValuesData)this.data).script = ((ScriptValuesData)this.data).cx.compileString(this.strTransformScript, "script", 1, null);
            }
            catch (Exception e) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.CouldNotCompileJavascript", (String[])new String[0]), (Throwable)e);
            }
        }
        Object[] outputRow = RowDataUtil.resizeArray((Object[])row, (int)((ScriptValuesData)this.data).outputRowMeta.size());
        int outputIndex = rowMeta.size();
        try {
            try {
                Scriptable jsrow = Context.toObject((Object)row, (Scriptable)((ScriptValuesData)this.data).scope);
                ((ScriptValuesData)this.data).scope.put("row", ((ScriptValuesData)this.data).scope, (Object)jsrow);
                for (int i = 0; i < ((ScriptValuesData)this.data).fieldsUsed.length; ++i) {
                    Object valueData2;
                    IValueMeta valueMeta = rowMeta.getValueMeta(((ScriptValuesData)this.data).fieldsUsed[i]);
                    Object normalStorageValueData = valueMeta.convertToNormalStorageType(valueData2 = row[((ScriptValuesData)this.data).fieldsUsed[i]]);
                    Scriptable jsarg = normalStorageValueData != null ? Context.toObject((Object)normalStorageValueData, (Scriptable)((ScriptValuesData)this.data).scope) : null;
                    ((ScriptValuesData)this.data).scope.put(valueMeta.getName(), ((ScriptValuesData)this.data).scope, (Object)jsarg);
                }
                Scriptable jsrowMeta = Context.toObject((Object)rowMeta, (Scriptable)((ScriptValuesData)this.data).scope);
                ((ScriptValuesData)this.data).scope.put("rowMeta", ((ScriptValuesData)this.data).scope, (Object)jsrowMeta);
            }
            catch (Exception e) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.UnexpectedeError", (String[])new String[0]), (Throwable)e);
            }
            ((ScriptValuesData)this.data).script.exec(((ScriptValuesData)this.data).cx, ((ScriptValuesData)this.data).scope);
            if (this.bFirstRun) {
                this.bFirstRun = false;
                Object pipelineStatus = ((ScriptValuesData)this.data).scope.get("pipeline_Status", ((ScriptValuesData)this.data).scope);
                if (pipelineStatus != Scriptable.NOT_FOUND) {
                    this.bWithPipelineStat = true;
                    if (this.log.isDetailed()) {
                        this.logDetailed("pipeline_Status found. Checking pipeline status while script execution.");
                    }
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed("No pipeline_Status found. Pipeline status checking not available.");
                    }
                    this.bWithPipelineStat = false;
                }
            }
            this.iPipelineStat = this.bWithPipelineStat ? (int)Context.toNumber((Object)((ScriptValuesData)this.data).scope.get("pipeline_Status", ((ScriptValuesData)this.data).scope)) : 0;
            if (this.iPipelineStat == 0) {
                this.bRC = true;
                for (int i = 0; i < ((ScriptValuesMeta)this.meta).getFieldname().length; ++i) {
                    Object result = ((ScriptValuesData)this.data).scope.get(((ScriptValuesMeta)this.meta).getFieldname()[i], ((ScriptValuesData)this.data).scope);
                    valueData = this.getValueFromJScript(result, i);
                    if (((ScriptValuesData)this.data).replaceIndex[i] < 0) {
                        outputRow[outputIndex++] = valueData;
                        continue;
                    }
                    outputRow[((ScriptValuesData)this.data).replaceIndex[i]] = valueData;
                }
                this.putRow(((ScriptValuesData)this.data).outputRowMeta, outputRow);
            } else {
                switch (this.iPipelineStat) {
                    case 1: {
                        this.bRC = true;
                        break;
                    }
                    case -1: {
                        if (((ScriptValuesData)this.data).cx != null) {
                            Context.exit();
                        }
                        this.stopAll();
                        this.setOutputDone();
                        this.bRC = false;
                        break;
                    }
                    case -2: {
                        if (((ScriptValuesData)this.data).cx != null) {
                            Context.exit();
                        }
                        this.setErrors(1L);
                        this.stopAll();
                        this.bRC = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HopValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.JavascriptError", (String[])new String[0]), (Throwable)e);
        }
        return this.bRC;
    }

    public Object getValueFromJScript(Object result, int i) throws HopValueException {
        String fieldName = ((ScriptValuesMeta)this.meta).getFieldname()[i];
        if (!Utils.isEmpty((CharSequence)fieldName)) {
            try {
                return result == null ? null : JavaScriptUtils.convertFromJs((Object)result, (int)((ScriptValuesMeta)this.meta).getType()[i], (String)fieldName);
            }
            catch (Exception e) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.JavascriptError", (String[])new String[0]), (Throwable)e);
            }
        }
        throw new HopValueException("No name was specified for result value #" + (i + 1));
    }

    public IRowMeta getOutputRowMeta() {
        return ((ScriptValuesData)this.data).outputRowMeta;
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            try {
                if (((ScriptValuesData)this.data).cx != null) {
                    if (this.strEndScript != null && this.strEndScript.length() > 0) {
                        Script endScript = ((ScriptValuesData)this.data).cx.compileString(this.strEndScript, "pipeline_End", 1, null);
                        endScript.exec(((ScriptValuesData)this.data).cx, ((ScriptValuesData)this.data).scope);
                        if (this.log.isDetailed()) {
                            this.logDetailed("End Script found!");
                        }
                    } else if (this.log.isDetailed()) {
                        this.logDetailed("No end Script found!");
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.UnexpectedeError", (String[])new String[0]) + " : " + e.toString());
                this.logError(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.ErrorStackTrace", (String[])new String[0]) + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
            }
            try {
                if (((ScriptValuesData)this.data).cx != null) {
                    Context.exit();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setOutputDone();
            return false;
        }
        try {
            this.addValues(this.getInputRowMeta(), r);
        }
        catch (HopValueException e) {
            String location = null;
            if (e.getCause() instanceof EvaluatorException) {
                EvaluatorException ee = (EvaluatorException)e.getCause();
                location = "--> " + ee.lineNumber() + ":" + ee.columnNumber();
            }
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.getMessage() + Const.CR + location, null, "SCR-001");
                this.bRC = true;
            }
            throw e;
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return this.bRC;
    }

    public boolean init() {
        if (super.init()) {
            this.jsScripts = ((ScriptValuesMeta)this.meta).getJSScripts();
            block5: for (int j = 0; j < this.jsScripts.length; ++j) {
                switch (this.jsScripts[j].getScriptType()) {
                    case 0: {
                        this.strTransformScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                    case 1: {
                        this.strStartScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                    case 2: {
                        this.strEndScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        try {
            if (((ScriptValuesData)this.data).cx != null) {
                Context.exit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose();
    }
}

