/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.writetolog;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.writetolog.LogField;
import org.apache.hop.pipeline.transforms.writetolog.WriteToLogMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WriteToLogDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = WriteToLogDialog.class;
    private final WriteToLogMeta input;
    private CCombo wLoglevel;
    private Button wPrintHeader;
    private StyledTextComp wLogMessage;
    private TableView wFields;
    private Button wLimitRows;
    private Label wlLimitRowsNumber;
    private Text wLimitRowsNumber;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] colinf;

    public WriteToLogDialog(Shell parent, IVariables variables, WriteToLogMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        Listener lsModify = event -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addListener(24, lsModify);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlLoglevel = new Label((Composite)this.shell, 131072);
        wlLoglevel.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Loglevel.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLoglevel);
        FormData fdlLoglevel = new FormData();
        fdlLoglevel.left = new FormAttachment(0, 0);
        fdlLoglevel.right = new FormAttachment(middle, -margin);
        fdlLoglevel.top = new FormAttachment((Control)this.wTransformName, margin);
        wlLoglevel.setLayoutData((Object)fdlLoglevel);
        this.wLoglevel = new CCombo((Composite)this.shell, 2060);
        this.wLoglevel.setItems(LogLevel.getLogLevelDescriptions());
        PropsUi.setLook((Widget)this.wLoglevel);
        FormData fdLoglevel = new FormData();
        fdLoglevel.left = new FormAttachment(middle, 0);
        fdLoglevel.top = new FormAttachment((Control)this.wTransformName, margin);
        fdLoglevel.right = new FormAttachment(100, 0);
        this.wLoglevel.setLayoutData((Object)fdLoglevel);
        this.wLoglevel.addListener(13, lsModify);
        Label wlPrintHeader = new Label((Composite)this.shell, 131072);
        wlPrintHeader.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.PrintHeader.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPrintHeader);
        FormData fdlPrintHeader = new FormData();
        fdlPrintHeader.left = new FormAttachment(0, 0);
        fdlPrintHeader.top = new FormAttachment((Control)this.wLoglevel, margin);
        fdlPrintHeader.right = new FormAttachment(middle, -margin);
        wlPrintHeader.setLayoutData((Object)fdlPrintHeader);
        this.wPrintHeader = new Button((Composite)this.shell, 32);
        this.wPrintHeader.setToolTipText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.PrintHeader.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wPrintHeader);
        FormData fdPrintHeader = new FormData();
        fdPrintHeader.left = new FormAttachment(middle, 0);
        fdPrintHeader.top = new FormAttachment((Control)wlPrintHeader, 0, 0x1000000);
        fdPrintHeader.right = new FormAttachment(100, 0);
        this.wPrintHeader.setLayoutData((Object)fdPrintHeader);
        this.wPrintHeader.addListener(13, lsModify);
        Label wlLimitRows = new Label((Composite)this.shell, 131072);
        wlLimitRows.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.LimitRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimitRows);
        FormData fdlLimitRows = new FormData();
        fdlLimitRows.left = new FormAttachment(0, 0);
        fdlLimitRows.right = new FormAttachment(middle, -margin);
        fdlLimitRows.top = new FormAttachment((Control)this.wPrintHeader, margin);
        wlLimitRows.setLayoutData((Object)fdlLimitRows);
        this.wLimitRows = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wLimitRows);
        FormData fdLimitRows = new FormData();
        fdLimitRows.left = new FormAttachment(middle, 0);
        fdLimitRows.top = new FormAttachment((Control)wlLimitRows, 0, 0x1000000);
        this.wLimitRows.setLayoutData((Object)fdLimitRows);
        this.wLimitRows.addListener(13, lsModify);
        this.wLimitRows.addListener(13, e -> this.enableFields());
        this.wlLimitRowsNumber = new Label((Composite)this.shell, 131072);
        this.wlLimitRowsNumber.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.LimitRowsNumber.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLimitRowsNumber);
        this.wlLimitRowsNumber.setEnabled(this.input.isLimitRows());
        FormData fdlLimitRowsNumber = new FormData();
        fdlLimitRowsNumber.left = new FormAttachment(0, 0);
        fdlLimitRowsNumber.right = new FormAttachment(middle, -margin);
        fdlLimitRowsNumber.top = new FormAttachment((Control)this.wLimitRows, margin);
        this.wlLimitRowsNumber.setLayoutData((Object)fdlLimitRowsNumber);
        this.wLimitRowsNumber = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLimitRowsNumber);
        this.wLimitRowsNumber.setEnabled(this.input.isLimitRows());
        this.wLimitRowsNumber.addListener(24, lsModify);
        FormData fdLimitRowsNumber = new FormData();
        fdLimitRowsNumber.left = new FormAttachment(middle, 0);
        fdLimitRowsNumber.right = new FormAttachment(100, 0);
        fdLimitRowsNumber.top = new FormAttachment((Control)this.wLimitRows, margin);
        this.wLimitRowsNumber.setLayoutData((Object)fdLimitRowsNumber);
        Label wlLogMessage = new Label((Composite)this.shell, 131072);
        wlLogMessage.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Shell.Title", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLogMessage);
        FormData fdlLogMessage = new FormData();
        fdlLogMessage.left = new FormAttachment(0, 0);
        fdlLogMessage.top = new FormAttachment((Control)this.wLimitRowsNumber, margin);
        fdlLogMessage.right = new FormAttachment(middle, -margin);
        wlLogMessage.setLayoutData((Object)fdlLogMessage);
        this.wLogMessage = new StyledTextComp(this.variables, (Composite)this.shell, 19202);
        PropsUi.setLook((Widget)this.wLogMessage, (int)1);
        FormData fdLogMessage = new FormData();
        fdLogMessage.left = new FormAttachment(middle, 0);
        fdLogMessage.top = new FormAttachment((Control)this.wLimitRowsNumber, margin);
        fdLogMessage.right = new FormAttachment(100, -2 * margin);
        fdLogMessage.height = (int)(125.0 * this.props.getZoomFactor());
        this.wLogMessage.setLayoutData((Object)fdLogMessage);
        this.wLogMessage.addListener(24, lsModify);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wLogMessage, margin);
        wlFields.setLayoutData((Object)fdlFields);
        boolean fieldsCols = true;
        int fieldsRows = this.input.getLogFields().size();
        this.colinf = new ColumnInfo[1];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, fieldsRows, event -> this.input.setChanged(), this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wGet.addListener(13, event -> this.get());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener insertListener = (tableItem, v) -> true;
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)insertListener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        this.wPrintHeader.setSelection(this.input.isDisplayHeader());
        this.wLimitRows.setSelection(this.input.isLimitRows());
        this.wLimitRowsNumber.setText("" + this.input.getLimitRowsNumber());
        LogLevel logLevel = this.input.getLogLevel();
        if (logLevel == null) {
            logLevel = LogLevel.BASIC;
        }
        this.wLoglevel.select(logLevel.getLevel());
        if (this.input.getLogMessage() != null) {
            this.wLogMessage.setText(this.input.getLogMessage());
        }
        Table table = this.wFields.table;
        table.removeAll();
        for (int i = 0; i < this.input.getLogFields().size(); ++i) {
            LogField field = this.input.getLogFields().get(i);
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, field.getName());
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setDisplayHeader(this.wPrintHeader.getSelection());
        this.input.setLimitRows(this.wLimitRows.getSelection());
        this.input.setLimitRowsNumber(Const.toInt((String)this.wLimitRowsNumber.getText(), (int)0));
        if (this.wLoglevel.getSelectionIndex() < 0) {
            this.input.setLogLevel(LogLevel.BASIC);
        } else {
            this.input.setLogLevel(LogLevel.lookupCode((String)this.wLoglevel.getText()));
        }
        if (this.wLogMessage.getText() != null && this.wLogMessage.getText().length() > 0) {
            this.input.setLogMessage(this.wLogMessage.getText());
        } else {
            this.input.setLogMessage("");
        }
        int nrFields = this.wFields.nrNonEmpty();
        ArrayList<LogField> fields = new ArrayList<LogField>(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            LogField field = new LogField();
            field.setName(item.getText(1));
            fields.add(field);
        }
        this.input.setLogFields(fields);
        this.dispose();
    }

    private void enableFields() {
        this.wLimitRowsNumber.setEnabled(this.wLimitRows.getSelection());
        this.wlLimitRowsNumber.setEnabled(this.wLimitRows.getSelection());
    }
}

