/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.plugins;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.apache.hop.core.plugins.BasePluginType;
import org.apache.hop.core.plugins.HopURLClassLoader;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.IPluginTypeListener;
import org.apache.hop.core.plugins.PluginRegistry;

public abstract class BaseFragmentType<T extends Annotation>
extends BasePluginType<T> {
    BaseFragmentType(Class<T> pluginType, String id, String name, Class<? extends IPluginType> typeToTrack) {
        super(pluginType, id, name);
        this.initListeners(this.getClass(), typeToTrack);
    }

    protected void initListeners(Class<? extends IPluginType> aClass, Class<? extends IPluginType> typeToTrack) {
        this.registry.addPluginListener(aClass, new FragmentTypeListener(this.registry, (Class)typeToTrack){

            @Override
            void mergePlugin(IPlugin fragment, IPlugin plugin) {
                if (plugin != null) {
                    plugin.merge(fragment);
                }
            }
        });
        this.registry.addPluginListener(typeToTrack, new FragmentTypeListener(this.registry, (Class)aClass){

            @Override
            void mergePlugin(IPlugin plugin, IPlugin fragment) {
                if (plugin != null) {
                    plugin.merge(fragment);
                }
            }
        });
    }

    @Override
    public boolean isFragment() {
        return true;
    }

    @Override
    protected URLClassLoader createUrlClassLoader(URL jarFileUrl, ClassLoader classLoader) {
        return new HopURLClassLoader(new URL[]{jarFileUrl}, classLoader);
    }

    @Override
    protected String extractName(T annotation) {
        return null;
    }

    @Override
    protected String extractDesc(T annotation) {
        return null;
    }

    @Override
    protected String extractCategory(T annotation) {
        return null;
    }

    @Override
    protected boolean extractSeparateClassLoader(T annotation) {
        return false;
    }

    @Override
    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, T annotation) {
    }

    protected abstract class FragmentTypeListener
    implements IPluginTypeListener {
        private final PluginRegistry registry;
        private final Class<? extends IPluginType> typeToTrack;

        FragmentTypeListener(PluginRegistry registry, Class<? extends IPluginType> typeToTrack) {
            this.registry = registry;
            this.typeToTrack = typeToTrack;
        }

        abstract void mergePlugin(IPlugin var1, IPlugin var2);

        @Override
        public void pluginAdded(Object serviceObject) {
            IPlugin left = (IPlugin)serviceObject;
            IPlugin right = this.registry.findPluginWithId(this.typeToTrack, left.getIds()[0]);
            this.mergePlugin(left, right);
        }

        @Override
        public void pluginRemoved(Object serviceObject) {
        }

        @Override
        public void pluginChanged(Object serviceObject) {
            this.pluginAdded(serviceObject);
        }
    }
}

