/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.ai4j.openai4j.Json;
import dev.ai4j.openai4j.chat.AssistantMessage;
import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.ToolCall;
import java.io.IOException;
import java.util.List;

class AssistantMessageTypeAdapter
extends TypeAdapter<AssistantMessage> {
    static final TypeAdapterFactory ASSISTANT_MESSAGE_TYPE_ADAPTER_FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() != AssistantMessage.class) {
                return null;
            }
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new AssistantMessageTypeAdapter(delegate);
        }
    };
    private final TypeAdapter<AssistantMessage> delegate;

    private AssistantMessageTypeAdapter(TypeAdapter<AssistantMessage> delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, AssistantMessage assistantMessage) throws IOException {
        List<ToolCall> toolCalls;
        out.beginObject();
        out.name("role");
        out.value(assistantMessage.role().toString().toLowerCase());
        out.name("content");
        if (assistantMessage.content() == null) {
            boolean serializeNulls = out.getSerializeNulls();
            out.setSerializeNulls(true);
            out.nullValue();
            out.setSerializeNulls(serializeNulls);
        } else {
            out.value(assistantMessage.content());
        }
        if (assistantMessage.name() != null) {
            out.name("name");
            out.value(assistantMessage.name());
        }
        if ((toolCalls = assistantMessage.toolCalls()) != null && !toolCalls.isEmpty()) {
            out.name("tool_calls");
            out.beginArray();
            TypeAdapter toolCallTypeAdapter = Json.GSON.getAdapter(ToolCall.class);
            for (ToolCall toolCall : toolCalls) {
                toolCallTypeAdapter.write(out, (Object)toolCall);
            }
            out.endArray();
        }
        if (assistantMessage.functionCall() != null) {
            out.name("function_call");
            TypeAdapter functionCallTypeAdapter = Json.GSON.getAdapter(FunctionCall.class);
            functionCallTypeAdapter.write(out, (Object)assistantMessage.functionCall());
        }
        out.endObject();
    }

    public AssistantMessage read(JsonReader in) throws IOException {
        return (AssistantMessage)this.delegate.read(in);
    }
}

