/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.datastax;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTable;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableStart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.databases.cassandra.datastax.DriverConnection;
import org.apache.hop.databases.cassandra.datastax.DriverCqlRowHandler;
import org.apache.hop.databases.cassandra.datastax.TableMetaData;
import org.apache.hop.databases.cassandra.spi.CqlRowHandler;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.CassandraUtils;

public class DriverKeyspace
implements Keyspace {
    protected DriverConnection conn;
    private KeyspaceMetadata meta;
    private String name;

    public DriverKeyspace(DriverConnection conn, KeyspaceMetadata keyspace) {
        this.meta = keyspace;
        this.conn = conn;
        this.name = keyspace.getName().asCql(false);
    }

    @Override
    public void setConnection(DriverConnection conn) throws Exception {
        this.conn = conn;
    }

    @Override
    public DriverConnection getConnection() {
        return this.conn;
    }

    @Override
    public void setKeyspace(String keyspaceName) throws Exception {
        this.name = keyspaceName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.conn.setAdditionalOptions(options);
    }

    @Override
    public void executeCQL(String cql, String compression, String consistencyLevel, ILogChannel log) throws Exception {
        this.conn.getSession(this.name).execute(cql);
    }

    @Override
    public void createKeyspace(String keyspaceName, Map<String, Object> options, ILogChannel log) throws Exception {
        SchemaBuilder.createKeyspace((String)keyspaceName);
    }

    @Override
    public List<String> getTableNamesCQL3() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        this.meta.getTables().keySet().forEach(ti -> names.add(ti.asCql(false)));
        return names;
    }

    @Override
    public boolean tableExists(String tableName) throws Exception {
        return this.meta.getTable(tableName).isPresent();
    }

    @Override
    public ITableMetaData getTableMetaData(String familyName) throws Exception {
        Optional optionalTable = this.meta.getTable(familyName);
        if (optionalTable.isEmpty()) {
            return null;
        }
        TableMetadata tableMeta = (TableMetadata)optionalTable.get();
        return new TableMetaData(this, tableMeta);
    }

    @Override
    public boolean createTable(String tableName, IRowMeta rowMeta, List<Integer> keyIndexes, String createTableWithClause, ILogChannel log) throws Exception {
        int i;
        CreateTableStart createTableStart = SchemaBuilder.createTable((String)tableName).ifNotExists();
        CreateTable createTable = null;
        for (i = 0; i < rowMeta.size(); ++i) {
            if (!keyIndexes.contains(i)) continue;
            IValueMeta key = rowMeta.getValueMeta(i);
            createTable = createTableStart.withPartitionKey(key.getName(), CassandraUtils.getCassandraDataTypeFromValueMeta(key));
        }
        if (createTable == null) {
            throw new HopException("Please specify one or more keys fields");
        }
        for (i = 0; i < rowMeta.size(); ++i) {
            if (keyIndexes.contains(i)) continue;
            IValueMeta valueMeta = rowMeta.getValueMeta(i);
            createTable = createTable.withColumn(valueMeta.getName(), CassandraUtils.getCassandraDataTypeFromValueMeta(valueMeta));
        }
        CqlSession session = this.getSession();
        if (!Utils.isEmpty((CharSequence)createTableWithClause)) {
            StringBuilder cql = new StringBuilder(createTable.asCql());
            if (!createTableWithClause.toLowerCase().trim().startsWith("with")) {
                cql.append(" WITH ");
            }
            cql.append(createTableWithClause);
            session.execute(cql.toString());
        } else {
            session.execute(createTable.asCql());
        }
        return true;
    }

    @Override
    public void updateTableCQL3(String tableName, IRowMeta rowMeta, List<Integer> keyIndexes, ILogChannel log) throws Exception {
        CqlSession session = this.getSession();
        ITableMetaData table = this.getTableMetaData(tableName);
        for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
            if (table.columnExistsInSchema(valueMeta.getName())) continue;
            DataType dataType = CassandraUtils.getCassandraDataTypeFromValueMeta(valueMeta);
            String cql = SchemaBuilder.alterTable((String)tableName).addColumn(valueMeta.getName(), dataType).asCql();
            session.execute(cql);
        }
    }

    @Override
    public void truncateTable(String tableName, ILogChannel log) throws Exception {
        this.getSession().execute(QueryBuilder.truncate((String)tableName).asCql());
    }

    protected CqlSession getSession() {
        return this.conn.getSession(this.name);
    }

    @Override
    public CqlRowHandler getCQLRowHandler() {
        return new DriverCqlRowHandler(this, this.getSession(), this.getConnection().isExpandCollection());
    }
}

