/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.history.AuditManager;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataInstance;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.HopGui;

public class ProjectsUtil {
    public static final String VARIABLE_PROJECT_HOME = "PROJECT_HOME";
    public static final String VARIABLE_HOP_DATASETS_FOLDER = "HOP_DATASETS_FOLDER";
    public static final String VARIABLE_HOP_UNIT_TESTS_FOLDER = "HOP_UNIT_TESTS_FOLDER";
    public static final String STRING_PROJECTS_AUDIT_GROUP = "projects";
    public static final String STRING_PROJECT_AUDIT_TYPE = "project";
    public static final String STRING_ENVIRONMENT_AUDIT_TYPE = "environment";

    public static void enableProject(ILogChannel log, String projectName, Project project, IVariables variables, List<String> configurationFiles, String environmentName, IHasHopMetadataProvider hasHopMetadataProvider) throws HopException {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        if (projectConfig == null) {
            throw new HopException("Error enabling project " + projectName + ": it is not configured.");
        }
        project.modifyVariables(variables, projectConfig, configurationFiles, environmentName);
        if (hasHopMetadataProvider != null) {
            MultiMetadataProvider metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)variables);
            hasHopMetadataProvider.setMetadataProvider(metadataProvider);
            HopMetadataInstance.setMetadataProvider((MultiMetadataProvider)metadataProvider);
            project.setMetadataProvider(metadataProvider);
        }
        HopNamespace.setNamespace((String)projectName);
        AuditManager.registerEvent((String)"hop-gui", (String)STRING_PROJECT_AUDIT_TYPE, (String)projectName, (String)"open");
        ExtensionPointHandler.callExtensionPoint((ILogChannel)log, (IVariables)variables, (String)"ProjectActivated", (Object)projectName);
    }

    public static void validateFileInProject(ILogChannel log, String filename, ProjectConfig projectConfig, IVariables variables) throws HopException, FileSystemException {
        String projectHome = projectConfig.getProjectHome();
        if (StringUtils.isNotEmpty((String)filename)) {
            log.logBasic("Validation against environment '" + projectConfig.getProjectName() + "' in home folder : " + projectHome);
            FileObject envHome = HopVfs.getFileObject((String)projectHome);
            FileObject transFile = HopVfs.getFileObject((String)filename);
            if (!ProjectsUtil.isInSubDirectory(transFile, envHome)) {
                throw new HopException("File '" + filename + "' does not live in the configured environment home folder : '" + projectHome + "'");
            }
        }
    }

    private static boolean isInSubDirectory(FileObject file, FileObject directory) throws FileSystemException {
        String directoryPath;
        String filePath = file.getName().getURI();
        if (filePath.equals(directoryPath = directory.getName().getURI())) {
            System.out.println("Found " + filePath + " in directory " + directoryPath);
            return true;
        }
        if (filePath.startsWith(directoryPath)) {
            return true;
        }
        FileObject parent = file.getParent();
        return parent != null && ProjectsUtil.isInSubDirectory(parent, directory);
    }

    public static void validateFileInProject(ILogChannel log, String executableFilename, IVariables variables) throws FileSystemException, HopException {
        if (StringUtils.isEmpty((String)executableFilename)) {
            return;
        }
        String activeProjectName = System.getProperty("HOP_PROJECT_NAME");
        if (StringUtils.isEmpty((String)activeProjectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        log.logBasic("Validating active project '" + activeProjectName + "'");
        ProjectConfig projectConfig = config.findProjectConfig(activeProjectName);
        if (projectConfig == null) {
            throw new HopException("Project '" + activeProjectName + "' is not defined");
        }
        Project project = projectConfig.loadProject(variables);
        if (project.isEnforcingExecutionInHome()) {
            ProjectsUtil.validateFileInProject(log, executableFilename, projectConfig, variables);
        }
    }

    public static boolean projectExists(String projectName) {
        boolean prjFound = false;
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        List<String> prjs = config.listProjectConfigNames();
        Iterator<String> iPrj = prjs.iterator();
        while (!prjFound && iPrj.hasNext()) {
            String p = iPrj.next();
            prjFound = p.equals(projectName);
        }
        return prjFound;
    }

    public static List<String> getParentProjectReferences(String projectName) throws HopException {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        List<String> prjs = config.listProjectConfigNames();
        HopGui hopGui = HopGui.getInstance();
        ArrayList<String> parentProjectReferences = new ArrayList();
        ProjectConfig currentProjectConfig = config.findProjectConfig(projectName);
        if (currentProjectConfig == null) {
            parentProjectReferences = Collections.EMPTY_LIST;
        } else {
            for (String prj : prjs) {
                if (prj.equals(projectName)) continue;
                ProjectConfig prjCfg = config.findProjectConfig(prj);
                Project thePrj = prjCfg.loadProject(hopGui.getVariables());
                if (thePrj != null) {
                    if (thePrj.getParentProjectName() == null || !thePrj.getParentProjectName().equals(projectName)) continue;
                    parentProjectReferences.add(prj);
                    continue;
                }
                hopGui.getLog().logError("Unable to load project '" + prj + "' from its configuration");
            }
        }
        return parentProjectReferences;
    }

    public static List<String> changeParentProjectReferences(String currentName, String newName) throws HopException {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        List<String> prjs = config.listProjectConfigNames();
        HopGui hopGui = HopGui.getInstance();
        ArrayList<String> parentProjectReferences = new ArrayList();
        ProjectConfig currentProjectConfig = config.findProjectConfig(currentName);
        if (currentProjectConfig == null) {
            parentProjectReferences = Collections.EMPTY_LIST;
        } else {
            for (String prj : prjs) {
                if (prj.equals(currentName)) continue;
                ProjectConfig prjCfg = config.findProjectConfig(prj);
                Project thePrj = prjCfg.loadProject(hopGui.getVariables());
                if (thePrj != null) {
                    if (thePrj.getParentProjectName() == null || !thePrj.getParentProjectName().equals(currentName)) continue;
                    thePrj.setParentProjectName(newName);
                    continue;
                }
                hopGui.getLog().logError("Unable to load project '" + prj + "' from its configuration");
            }
        }
        return parentProjectReferences;
    }
}

