/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCResultSetMetaData;
import com.ibm.as400.access.AS400JDBCSQLXMLLocator;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDCursor;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDRowCache;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLLocator;
import com.ibm.as400.access.ToolboxWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AS400JDBCResultSet
extends ToolboxWrapper
implements ResultSet {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    static final int HOLDABILITY_NOT_SPECIFIED = -9999;
    static final int HOLD_CURSORS_OVER_COMMIT = 1;
    static final int CLOSE_CURSORS_AT_COMMIT = 2;
    private String catalog_;
    private boolean closed_;
    private int columnCount_;
    private int concurrency_;
    private AS400JDBCConnection connection_;
    private String correlationName_;
    private String cursorName_;
    private boolean dataTruncation_;
    private PreparedStatement deleteStatement_;
    private int fetchDirection_;
    private int fetchSize_;
    private Lock internalLock;
    private int maxRows_;
    private InputStream openInputStream_;
    private Reader openReader_;
    private JDRow row_;
    private JDRowCache rowCache_;
    private String selectTable_;
    private SQLWarning sqlWarning_;
    private AS400JDBCStatement statement_;
    private int type_;
    private boolean[] updateNulls_;
    private boolean[] updateDefaults_;
    private boolean[] updateUnassigned_;
    private JDRow updateRow_;
    private boolean[] updateSet_;
    private boolean wasNull_;
    private boolean wasDataMappingError_;
    boolean isMetadataResultSet = false;
    private DBReplyRequestedDS reply_ = null;
    private Class byteArrayClass_ = null;
    private SQLException savedException_;
    DBExtendedColumnDescriptors extendedDescriptors_;
    SQLConversionSettings settings_;
    private static final int NOT_KNOWN = -9999;
    private int positionFromFirst_ = 0;
    private int positionFromLast_ = -1;
    private boolean positionInsert_ = false;
    private boolean positionValid_ = false;
    private int totalRows_ = -9999;
    private int highestKnownRow_ = -9999;

    AS400JDBCResultSet(AS400JDBCStatement statement, JDSQLStatement sqlStatement, JDRowCache rowCache, String catalog, String cursorName, int maxRows, int type, int concurrency, int fetchDirection, int fetchSize, DBExtendedColumnDescriptors extendedDescriptors) throws SQLException {
        this.catalog_ = catalog;
        this.closed_ = false;
        this.concurrency_ = concurrency;
        this.connection_ = (AS400JDBCConnection)(statement != null ? statement.getConnection() : null);
        this.settings_ = this.connection_ != null ? SQLConversionSettings.getConversionSettings(this.connection_) : null;
        this.cursorName_ = cursorName;
        this.deleteStatement_ = null;
        this.fetchDirection_ = fetchDirection;
        this.fetchSize_ = fetchSize;
        this.internalLock = statement != null ? statement.getInternalLock() : new ReentrantLock();
        this.maxRows_ = maxRows;
        this.openInputStream_ = null;
        this.openReader_ = null;
        this.row_ = rowCache.getRow();
        this.rowCache_ = rowCache;
        this.sqlWarning_ = null;
        this.statement_ = statement;
        this.type_ = type;
        this.wasNull_ = false;
        this.wasDataMappingError_ = false;
        this.columnCount_ = this.row_.getFieldCount();
        this.rowCache_.setResultSet(this);
        this.rowCache_.open();
        this.extendedDescriptors_ = extendedDescriptors;
        if (this.connection_ == null || sqlStatement == null || this.connection_.getMustSpecifyForUpdate() && !sqlStatement.isForUpdate()) {
            this.selectTable_ = null;
            this.correlationName_ = null;
            this.concurrency_ = 1007;
        } else {
            this.selectTable_ = sqlStatement.getSelectTable();
            this.correlationName_ = sqlStatement.getCorrelationName();
        }
        if (this.concurrency_ == 1008) {
            this.updateRow_ = new JDSimpleRow(this.row_, true);
            this.updateSet_ = new boolean[this.columnCount_];
            this.updateNulls_ = new boolean[this.columnCount_];
            this.updateDefaults_ = new boolean[this.columnCount_];
            this.updateUnassigned_ = new boolean[this.columnCount_];
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateSet_[i] = false;
                this.updateNulls_[i] = true;
            }
        }
        this.dataTruncation_ = this.connection_ != null ? this.connection_.getProperties().getBoolean(33) : false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, this.statement_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Conncurrency", this.concurrency_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Fetch direction", this.fetchDirection_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Fetch size", this.fetchSize_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Max rows", this.maxRows_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Type", this.type_);
        }
    }

    AS400JDBCResultSet(JDRowCache rowCache, String catalog, String cursorName, AS400JDBCConnection con, DBReplyRequestedDS reply) throws SQLException {
        this(null, null, rowCache, catalog, cursorName, 0, 1004, 1007, 1000, 0, reply == null ? null : reply.getExtendedColumnDescriptors());
        this.reply_ = reply;
        if (con != null) {
            this.connection_ = con;
        }
    }

    void checkOpen() throws SQLException {
        if (this.closed_) {
            JDError.throwSQLException("24000");
        }
    }

    private void clearCurrentRow() throws SQLException {
        this.clearCurrentValue();
        this.clearWarnings();
        if (this.concurrency_ == 1008) {
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateNulls_[i] = true;
                this.updateDefaults_[i] = false;
                this.updateUnassigned_[i] = false;
                this.updateSet_[i] = false;
            }
        }
    }

    private void clearCurrentValue() {
        if (this.openInputStream_ != null) {
            try {
                this.openInputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openInputStream_ = null;
        }
        if (this.openReader_ != null) {
            try {
                this.openReader_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openReader_ = null;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.internalLock.lock();
            if (this.isClosed()) {
                return;
            }
            this.rowCache_.close();
            if (this.reply_ != null) {
                this.reply_.returnToPool();
                this.reply_ = null;
            }
            this.closed_ = true;
            if (this.statement_ != null) {
                this.statement_.notifyClose();
            }
            if (this.deleteStatement_ != null) {
                this.deleteStatement_.close();
            }
            if (this.isMetadataResultSet) {
                this.statement_.close();
            }
            if (JDTrace.isTraceOn()) {
                SQLException sqlex = new SQLException("Cursor was closed here");
                JDTrace.logException(this, "Closing info", sqlex);
                JDTrace.logClose(this);
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed_) {
                JDTrace.logInformation(this, "WARNING: Finalizer thread closing result set object.");
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            int n = this.row_.findField(columnName != null ? columnName : "");
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.statement_ != null) {
                JDCursor cursor = this.statement_.getCursor();
                if (cursor.getCursorAttributeUpdatable() == 0) {
                    int n = 1007;
                    return n;
                }
                if (cursor.getCursorAttributeUpdatable() == 1) {
                    int n = 1008;
                    return n;
                }
                int n = this.concurrency_;
                return n;
            }
            int n = this.concurrency_;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            String string = this.cursorName_;
            return string;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            int n = this.fetchDirection_;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            int n = this.fetchSize_;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    JDRowCache getRowCache() {
        return this.rowCache_;
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isMetadataResultSet) {
            return null;
        }
        return this.statement_;
    }

    void setStatement(AS400JDBCStatement statement) {
        this.statement_ = statement;
    }

    @Override
    public int getType() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.type_ == 1003) {
                int n = 1003;
                return n;
            }
            if (this.statement_ != null) {
                JDCursor cursor = this.statement_.getCursor();
                if (cursor.getCursorAttributeScrollable() == 0) {
                    int n = 1003;
                    return n;
                }
                if (cursor.getCursorAttributeSensitive() == 0) {
                    int n = 1004;
                    return n;
                }
                if (cursor.getCursorAttributeSensitive() == 1) {
                    int n = 1005;
                    return n;
                }
                int n = this.type_;
                return n;
            }
            int n = this.type_;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            String string;
            block7: {
                this.internalLock.lock();
                this.checkOpen();
                try {
                    string = this.getString(columnIndex);
                    if (string != null) break block7;
                    URL uRL = null;
                    return uRL;
                }
                catch (MalformedURLException e) {
                    JDError.throwSQLException("07006", e);
                    URL uRL = null;
                    return uRL;
                }
            }
            URL uRL = new URL(string);
            return uRL;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed_;
    }

    void postWarning(AS400JDBCConnection connection, int id, int errorClass, int returnCode) throws SQLException {
        try {
            String sqlState = JDError.getSQLState(connection, id);
            if (this.statement_ != null && this.statement_.getConnection() != null && ((AS400JDBCConnection)this.statement_.getConnection()).ignoreWarning(sqlState)) {
                return;
            }
        }
        catch (SQLException sqlState) {
            // empty catch block
        }
        SQLWarning sqlWarning = JDError.getSQLWarning(connection, id, errorClass, returnCode);
        this.postCheckedWarning(sqlWarning);
    }

    void postCheckedWarning(SQLWarning sqlWarning) {
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sqlWarning;
        } else {
            this.sqlWarning_.setNextWarning(sqlWarning);
        }
    }

    void postDataTruncationWarning(int index, boolean parameter, boolean read, int dataSize, int transferSize) throws SQLException {
        try {
            String sqlState = read ? "01004" : "22001";
            if (this.statement_ != null && this.statement_.getConnection() != null && ((AS400JDBCConnection)this.statement_.getConnection()).ignoreWarning(sqlState)) {
                return;
            }
        }
        catch (SQLException sqlState) {
            // empty catch block
        }
        DataTruncation sqlWarning = new DataTruncation(index, parameter, read, dataSize, transferSize);
        this.postCheckedWarning(sqlWarning);
    }

    void postWarningSQLState(String sqlState) {
        try {
            if (this.statement_ != null && this.statement_.getConnection() != null && ((AS400JDBCConnection)this.statement_.getConnection()).ignoreWarning(sqlState)) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SQLWarning sqlWarning = JDError.getSQLWarning(sqlState);
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sqlWarning;
        } else {
            this.sqlWarning_.setNextWarning(sqlWarning);
        }
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        try {
            this.internalLock.lock();
            if (fetchDirection != 1000 && fetchDirection != 1001 && fetchDirection != 1002 || this.getType() == 1003 && fetchDirection != 1000) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchDirection_ = fetchDirection;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "setFetchDirection", "Fetch direction", this.fetchDirection_);
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        try {
            this.internalLock.lock();
            if (fetchSize < 0 || fetchSize > this.maxRows_ && this.maxRows_ > 0) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchSize_ = fetchSize;
            if (this.rowCache_ instanceof JDServerRowCache) {
                ((JDServerRowCache)this.rowCache_).setFetchSize(this.fetchSize_);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "setFetchSize", "Fetch size", this.fetchSize_);
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    public String toString() {
        return this.cursorName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int rowNumber) throws SQLException {
        try {
            this.internalLock.lock();
            if (rowNumber == 0) {
                this.beforeFirst();
                boolean bl = false;
                return bl;
            }
            this.beforePositioning(true);
            if (this.maxRows_ > 0) {
                if (rowNumber > 0) {
                    if (rowNumber > this.maxRows_) {
                        this.afterLast();
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    int distanceFromFirst;
                    if (this.totalRows_ == -9999) {
                        this.findLastRow();
                    }
                    if ((distanceFromFirst = this.totalRows_ + rowNumber) < 0) {
                        this.beforeFirst();
                        boolean bl = false;
                        return bl;
                    }
                    rowNumber = distanceFromFirst + 1;
                }
            }
            this.rowCache_.absolute(rowNumber);
            this.positionValid_ = this.rowCache_.isValid();
            if (rowNumber > 0) {
                this.positionFromFirst_ = this.positionValid_ ? rowNumber : -1;
                int n = this.positionFromLast_ = this.positionValid_ ? -1 : 0;
                if (this.positionValid_) {
                    if (this.highestKnownRow_ < rowNumber) {
                        this.highestKnownRow_ = rowNumber;
                    }
                    if (this.totalRows_ != -9999) {
                        this.positionFromLast_ = this.totalRows_ - rowNumber + 1;
                    }
                }
            } else {
                this.positionFromFirst_ = this.positionValid_ ? -1 : 0;
                int n = this.positionFromLast_ = this.positionValid_ ? -rowNumber : -1;
                if (this.positionValid_ && this.totalRows_ != -9999) {
                    int currentRow = this.totalRows_ + rowNumber;
                    if (this.highestKnownRow_ < currentRow) {
                        this.highestKnownRow_ = currentRow;
                    }
                    this.positionFromFirst_ = currentRow + 1;
                }
            }
            boolean bl = this.positionValid_;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.internalLock.lock();
            this.last();
            this.next();
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.internalLock.lock();
            this.first();
            this.previous();
            this.positionFromLast_ = -1;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private void beforePositioning(boolean scrollable) throws SQLException {
        if (this.savedException_ != null) {
            SQLException nextException = this.savedException_;
            this.savedException_ = null;
            JDError.throwSQLException((Object)this, nextException);
        }
        this.checkOpen();
        if (scrollable && this.getType() == 1003) {
            JDError.throwSQLException("24000");
        }
        this.clearCurrentRow();
        this.positionInsert_ = false;
    }

    private void findLastRow() throws SQLException {
        this.checkOpen();
        if (this.totalRows_ != -9999) {
            return;
        }
        if (this.highestKnownRow_ > 0) {
            if (this.highestKnownRow_ >= this.maxRows_) {
                this.highestKnownRow_ = this.maxRows_;
            } else {
                this.rowCache_.absolute(this.highestKnownRow_);
                this.rowCache_.next();
                while (this.rowCache_.isValid()) {
                    ++this.highestKnownRow_;
                    if (this.maxRows_ <= 0 || this.highestKnownRow_ != this.maxRows_) {
                        this.rowCache_.next();
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.rowCache_.first();
            if (!this.rowCache_.isValid()) {
                return;
            }
            this.highestKnownRow_ = 0;
            while (this.rowCache_.isValid()) {
                ++this.highestKnownRow_;
                if (this.maxRows_ <= 0 || this.highestKnownRow_ != this.maxRows_) {
                    this.rowCache_.next();
                    continue;
                }
                break;
            }
        }
        this.totalRows_ = this.highestKnownRow_;
    }

    @Override
    public boolean first() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforePositioning(true);
            this.rowCache_.first();
            if (this.rowCache_.isValid()) {
                this.positionFromFirst_ = 1;
                this.positionFromLast_ = this.totalRows_ == -9999 ? -1 : this.totalRows_;
                this.positionValid_ = true;
                if (this.highestKnownRow_ < 1) {
                    this.highestKnownRow_ = 1;
                }
            } else {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = -1;
                this.positionValid_ = false;
                this.totalRows_ = 0;
                this.highestKnownRow_ = -9999;
            }
            boolean bl = this.positionValid_;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.positionInsert_ || !this.positionValid_ || this.isBeforeFirst() || this.isAfterLast()) {
                int n = 0;
                return n;
            }
            if (this.positionFromFirst_ > 0) {
                int n = this.positionFromFirst_;
                return n;
            }
            if (this.isLast()) {
                if (this.totalRows_ != -9999) {
                    int n = this.positionFromFirst_ = this.totalRows_;
                    return n;
                }
                if (this.highestKnownRow_ == -9999) {
                    this.first();
                } else {
                    this.absolute(this.highestKnownRow_);
                }
                while (this.next()) {
                }
                this.previous();
                int n = this.positionFromFirst_;
                return n;
            }
            if (this.positionFromLast_ > 0) {
                if (this.totalRows_ != -9999) {
                    int n = this.positionFromFirst_ = this.totalRows_ - this.positionFromLast_ + 1;
                    return n;
                }
                int currentPositionFromLast = this.positionFromLast_;
                if (this.highestKnownRow_ == -9999) {
                    this.first();
                } else {
                    this.absolute(this.highestKnownRow_);
                }
                while (this.next()) {
                }
                this.absolute(this.totalRows_ - currentPositionFromLast + 1);
                int n = this.positionFromFirst_;
                return n;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Could not determine row number in getRow().");
            }
            int n = 0;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            boolean bl = this.positionFromLast_ == 0 && this.positionFromFirst_ != 0 && !this.positionInsert_ && !this.rowCache_.isEmpty();
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            boolean bl = this.positionFromFirst_ == 0 && this.positionFromLast_ != 0 && !this.positionInsert_ && !this.rowCache_.isEmpty();
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            boolean bl = this.positionFromFirst_ == 1 && !this.positionInsert_;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.positionInsert_ || this.positionFromLast_ > 1 || !this.positionValid_) {
                boolean bl = false;
                return bl;
            }
            if (this.positionFromLast_ == 1 || this.positionFromFirst_ == this.maxRows_ && this.maxRows_ > 0) {
                boolean bl = true;
                return bl;
            }
            boolean returnValue = !this.next();
            this.previous();
            boolean bl = returnValue;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforePositioning(true);
            if (this.maxRows_ > 0) {
                this.findLastRow();
                if (this.totalRows_ >= this.maxRows_) {
                    this.rowCache_.absolute(this.maxRows_);
                } else {
                    this.rowCache_.last();
                }
            } else {
                this.rowCache_.last();
            }
            if (this.rowCache_.isValid()) {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = 1;
                this.positionValid_ = true;
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_;
                }
            } else {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = -1;
                this.positionValid_ = false;
                this.totalRows_ = 0;
                this.highestKnownRow_ = -9999;
            }
            boolean bl = this.positionValid_;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforePositioning(true);
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforePositioning(true);
            this.beforeUpdate();
            this.positionInsert_ = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforePositioning(false);
            if (this.maxRows_ > 0 && this.positionFromFirst_ >= this.maxRows_) {
                block16: {
                    try {
                        this.rowCache_.absolute(this.maxRows_ + 1);
                    }
                    catch (Exception e) {
                        if (!JDTrace.isTraceOn()) break block16;
                        JDTrace.logException(this, "Warning: Exception encountered on going to last  ", e);
                    }
                }
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = 0;
                this.positionValid_ = false;
                this.totalRows_ = this.maxRows_;
                this.highestKnownRow_ = this.maxRows_;
                boolean bl = false;
                return bl;
            }
            this.rowCache_.next();
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ >= 0) {
                    ++this.positionFromFirst_;
                }
                if (this.positionFromLast_ > 0) {
                    --this.positionFromLast_;
                }
                if (this.positionFromFirst_ >= 0 && this.highestKnownRow_ < this.positionFromFirst_) {
                    this.highestKnownRow_ = this.positionFromFirst_;
                }
                this.positionValid_ = true;
            } else {
                if (!this.rowCache_.isEmpty()) {
                    if (this.positionFromLast_ != 0 && this.positionFromFirst_ >= 0) {
                        this.totalRows_ = this.positionFromFirst_++;
                    }
                    this.positionFromLast_ = 0;
                } else if (this.highestKnownRow_ > 0) {
                    this.positionFromFirst_ = this.totalRows_ = this.highestKnownRow_;
                    this.positionFromLast_ = 0;
                }
                this.positionValid_ = false;
            }
            boolean bl = this.positionValid_;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforePositioning(true);
            this.rowCache_.previous();
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ > 0) {
                    --this.positionFromFirst_;
                }
                if (this.positionFromLast_ >= 0) {
                    ++this.positionFromLast_;
                }
                this.positionValid_ = true;
            } else {
                if (this.positionFromFirst_ != 0 && this.positionFromLast_ >= 0) {
                    ++this.positionFromLast_;
                }
                this.positionFromFirst_ = 0;
                this.positionValid_ = false;
            }
            boolean bl = this.positionValid_;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.internalLock.lock();
            if (this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            this.beforePositioning(true);
            if (!this.positionValid_) {
                JDError.throwSQLException("HY109");
            }
            if (this.concurrency_ == 1008) {
                for (int i = 0; i < this.columnCount_; ++i) {
                    this.updateSet_[i] = false;
                }
            }
            this.rowCache_.refreshRow();
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean relative(int rowNumber) throws SQLException {
        try {
            this.internalLock.lock();
            this.beforePositioning(true);
            if (rowNumber < 0 && this.isBeforeFirst()) {
                boolean bl = false;
                return bl;
            }
            if (this.maxRows_ > 0 && this.positionFromFirst_ == -1) {
                this.getRow();
            }
            if (this.positionFromFirst_ >= 0 && this.positionFromFirst_ + rowNumber > this.maxRows_ && this.maxRows_ > 0) {
                this.afterLast();
                boolean bl = false;
                return bl;
            }
            this.rowCache_.relative(rowNumber);
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ >= 0) {
                    this.positionFromFirst_ += rowNumber;
                }
                if (this.positionFromLast_ >= 0) {
                    this.positionFromLast_ -= rowNumber;
                }
                this.positionValid_ = true;
                if (this.positionFromFirst_ >= 0 && this.highestKnownRow_ < this.positionFromFirst_) {
                    this.highestKnownRow_ = this.positionFromFirst_;
                }
            } else {
                if (rowNumber >= 0) {
                    this.positionFromFirst_ = -1;
                    this.positionFromLast_ = 0;
                } else {
                    this.positionFromFirst_ = 0;
                    this.positionFromLast_ = -1;
                }
                this.positionValid_ = false;
            }
            boolean bl = this.positionValid_;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + columnIndex);
        return null;
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        return this.getArray(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            InputStream value;
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            this.openInputStream_ = value = data == null ? null : data.getAsciiStream();
            this.testDataTruncation(columnIndex, data, false);
            InputStream inputStream = value;
            return inputStream;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            BigDecimal value = data == null ? null : data.getBigDecimal(-1);
            this.testDataTruncation(columnIndex, data, false);
            BigDecimal bigDecimal = value;
            return bigDecimal;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (scale < 0) {
            JDError.throwSQLException("HY094", "" + scale);
        }
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            BigDecimal value = data == null ? null : data.getBigDecimal(scale);
            this.testDataTruncation(columnIndex, data, false);
            BigDecimal bigDecimal = value;
            return bigDecimal;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            InputStream value;
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            this.openInputStream_ = value = data == null ? null : data.getBinaryStream();
            this.testDataTruncation(columnIndex, data, false);
            InputStream inputStream = value;
            return inputStream;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            Blob value = data == null ? null : data.getBlob();
            this.testDataTruncation(columnIndex, data, false);
            Blob blob = value;
            return blob;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            boolean value = data == null ? false : data.getBoolean();
            this.testDataTruncation(columnIndex, data, false);
            boolean bl = value;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            byte value = data == null ? (byte)0 : data.getByte();
            this.testDataTruncation(columnIndex, data, true);
            byte by = value;
            return by;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            byte[] value;
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            int sqlType = 0;
            if (data != null) {
                sqlType = data.getSQLType();
            }
            if (data != null && sqlType != 2 && sqlType != 29 && sqlType != 3 && sqlType != 4 && sqlType != 6 && sqlType != 20 && sqlType != 31 && sqlType != 25 && sqlType != 40 && this.row_ instanceof JDServerRow) {
                value = ((JDServerRow)this.row_).getRawBytes(columnIndex);
                if (sqlType == 30 || sqlType == 32 || sqlType == 36 || sqlType == 9) {
                    if (value != null && value.length >= 2) {
                        int newLength = 256 * (value[0] & 0xFF) + (value[1] & 0xFF);
                        if (sqlType == 32 || sqlType == 36) {
                            newLength *= 2;
                        }
                        byte[] newValue = new byte[newLength];
                        for (int i = 0; i < newLength; ++i) {
                            newValue[i] = value[i + 2];
                        }
                        value = newValue;
                    }
                } else if (sqlType == 8) {
                    String x = data.getString();
                    try {
                        value = x.getBytes("ISO8859_1");
                    }
                    catch (Exception exception) {}
                } else if (sqlType == 12 || sqlType == 34) {
                    String x = data.getString();
                    try {
                        value = x.getBytes("UTF-16BE");
                    }
                    catch (Exception exception) {}
                }
            } else {
                value = data == null ? null : data.getBytes();
                this.testDataTruncation(columnIndex, data, false);
            }
            byte[] byArray = value;
            return byArray;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            Reader value;
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            this.openReader_ = value = data == null ? null : data.getCharacterStream();
            this.testDataTruncation(columnIndex, data, false);
            Reader reader = value;
            return reader;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            Clob value = data == null ? null : data.getClob();
            this.testDataTruncation(columnIndex, data, false);
            Clob clob = value;
            return clob;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.internalGetDate(columnIndex, null);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.internalGetDate(this.findColumn(columnName), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date internalGetDate(int columnIndex, Calendar calendar) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            Date value = data == null ? null : data.getDate(calendar);
            this.testDataTruncation(columnIndex, data, false);
            Date date = value;
            return date;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetDate(columnIndex, calendar);
    }

    @Override
    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(columnName), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            double value = data == null ? 0.0 : data.getDouble();
            this.testDataTruncation(columnIndex, data, true);
            double d = value;
            return d;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            float value = data == null ? 0.0f : data.getFloat();
            this.testDataTruncation(columnIndex, data, true);
            float f = value;
            return f;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            int value = data == null ? 0 : data.getInt();
            this.testDataTruncation(columnIndex, data, true);
            int n = value;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            long value = data == null ? 0L : data.getLong();
            this.testDataTruncation(columnIndex, data, true);
            long l = value;
            return l;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.internalLock.lock();
            ConvTable convTable = null;
            if (this.extendedDescriptors_ != null) {
                convTable = this.connection_.getConverter();
            }
            AS400JDBCResultSetMetaData aS400JDBCResultSetMetaData = new AS400JDBCResultSetMetaData(this.catalog_, this.concurrency_, this.cursorName_, this.row_, this.extendedDescriptors_, convTable, this.connection_);
            return aS400JDBCResultSetMetaData;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            Object value = data == null ? null : data.getObject();
            this.testDataTruncation(columnIndex, data, false);
            Object object = value;
            return object;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(int columnIndex, Map typeMap) throws SQLException {
        if (typeMap == null) {
            JDError.throwSQLException("HY024");
        }
        return this.getObject(columnIndex);
    }

    public Object getObject(String columnName, Map typeMap) throws SQLException {
        if (typeMap == null) {
            JDError.throwSQLException("HY024");
        }
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + columnIndex);
        return null;
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            short value = data == null ? (short)0 : data.getShort();
            this.testDataTruncation(columnIndex, data, true);
            short s = value;
            return s;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            String value = data == null ? null : data.getString();
            this.testDataTruncation(columnIndex, data, false);
            String string = value;
            return string;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.internalGetTime(columnIndex, null);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.internalGetTime(this.findColumn(columnName), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time internalGetTime(int columnIndex, Calendar calendar) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            Time value = data == null ? null : data.getTime(calendar);
            this.testDataTruncation(columnIndex, data, false);
            Time time = value;
            return time;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetTime(columnIndex, calendar);
    }

    @Override
    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(columnName), calendar);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.internalGetTimestamp(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.internalGetTimestamp(this.findColumn(columnName), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp internalGetTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            Timestamp value = data == null ? null : data.getTimestamp(calendar);
            this.testDataTruncation(columnIndex, data, false);
            Timestamp timestamp = value;
            return timestamp;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetTimestamp(columnIndex, calendar);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try {
            InputStream value;
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            this.openInputStream_ = value = data == null ? null : data.getUnicodeStream();
            this.testDataTruncation(columnIndex, data, false);
            InputStream inputStream = value;
            return inputStream;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    private SQLData getValue(int columnIndex) throws SQLException {
        this.checkOpen();
        this.clearCurrentValue();
        if (!this.positionValid_ && !this.positionInsert_) {
            JDError.throwSQLException("HY109");
        }
        if (columnIndex < 1) {
            JDError.throwSQLException("07009", columnIndex + "<1");
        }
        if (columnIndex > this.columnCount_) {
            JDError.throwSQLException("07009", columnIndex + ">" + this.columnCount_);
        }
        if (this.concurrency_ == 1008 && (this.updateSet_[columnIndex - 1] || this.positionInsert_)) {
            this.wasNull_ = this.updateNulls_[columnIndex - 1];
            this.wasDataMappingError_ = false;
            if (this.wasNull_) {
                return null;
            }
            return this.updateRow_.getSQLData(columnIndex);
        }
        this.wasNull_ = this.row_.isNull(columnIndex);
        this.wasDataMappingError_ = this.row_.isDataMappingError(columnIndex);
        SQLData sqlData = this.row_.getSQLType(columnIndex);
        int sqlType = sqlData.getSQLType();
        if ((sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40) && this.statement_ != null) {
            this.statement_.setAssociatedWithLocators(true);
        }
        if (this.wasNull_ || this.wasDataMappingError_) {
            return null;
        }
        return this.row_.getSQLData(columnIndex);
    }

    private void testDataTruncation(int columnIndex, SQLData data, boolean exceptionOnTrunc) throws SQLException {
        int truncated;
        if (this.wasDataMappingError_) {
            this.postDataTruncationWarning(columnIndex, false, true, -1, -1);
        }
        if (data != null && (truncated = data.getTruncated()) > 0) {
            if (this.connection_.getVRM() >= JDUtilities.vrm610 && exceptionOnTrunc) {
                JDError.throwSQLException((Object)this, "07006", "C#=" + columnIndex);
            }
            int actualSize = data.getActualSize();
            this.postDataTruncationWarning(columnIndex, false, true, actualSize, actualSize - truncated);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            boolean bl = this.wasNull_;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private void beforeUpdate() throws SQLException {
        this.checkOpen();
        if (this.concurrency_ != 1008) {
            JDError.throwSQLException("24000");
        }
    }

    private void beforeUpdateValue(int columnIndex) throws SQLException {
        this.beforeUpdate();
        if (!this.positionValid_ && !this.positionInsert_) {
            JDError.throwSQLException("HY109");
        }
        if (columnIndex < 1) {
            JDError.throwSQLException("07009", columnIndex + "<1");
        }
        if (columnIndex > this.columnCount_) {
            JDError.throwSQLException("07009", columnIndex + ">" + this.columnCount_);
        }
    }

    private void checkForValidConversion(int columnIndex) throws SQLException {
        SQLData sqlData = this.updateRow_.getSQLType(columnIndex);
        int sqlType = sqlData.getSQLType();
        if (sqlType == 41) {
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforeUpdate();
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateSet_[i] = false;
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforeUpdate();
            if (!this.positionValid_) {
                JDError.throwSQLException("HY109");
            }
            if (this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Deleting a row.");
            }
            if (this.deleteStatement_ == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("DELETE FROM ");
                buffer.append(this.selectTable_);
                buffer.append(" WHERE CURRENT OF \"");
                buffer.append(this.cursorName_);
                buffer.append("\"");
                this.deleteStatement_ = this.connection_.prepareStatement(buffer.toString());
            }
            this.deleteStatement_.execute();
            this.positionValid_ = false;
            this.rowCache_.flush();
        }
        finally {
            this.internalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        try {
            this.internalLock.lock();
            this.beforeUpdate();
            if (!this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO ");
            buffer.append(this.selectTable_);
            buffer.append(" (");
            StringBuffer values = new StringBuffer();
            int columnsSet = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                if (!this.updateSet_[i]) continue;
                if (columnsSet++ > 0) {
                    buffer.append(",");
                    values.append(",");
                }
                buffer.append("\"");
                buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                buffer.append("\"");
                values.append("?");
            }
            if (columnsSet == 0) {
                buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(1)));
            }
            buffer.append(") VALUES (");
            if (columnsSet == 0) {
                buffer.append("NULL");
            } else {
                buffer.append(values.toString());
            }
            buffer.append(")");
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Inserting a row: " + buffer);
            }
            PreparedStatement insertStatement = this.connection_.prepareStatement(buffer.toString());
            int columnsSet2 = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                if (!this.updateSet_[i]) continue;
                Object columnValue = this.updateRow_.getSQLData(i + 1).getObject();
                if (this.updateNulls_[i]) {
                    insertStatement.setNull(++columnsSet2, this.row_.getSQLType(i + 1).getType());
                } else if (this.updateDefaults_[i]) {
                    ((AS400JDBCPreparedStatement)insertStatement).setDB2Default(++columnsSet2);
                } else if (this.updateUnassigned_[i]) {
                    ((AS400JDBCPreparedStatement)insertStatement).setDB2Unassigned(++columnsSet2);
                } else {
                    insertStatement.setObject(++columnsSet2, columnValue);
                }
                this.updateSet_[i] = false;
            }
            insertStatement.executeUpdate();
            SQLWarning warnings = insertStatement.getWarnings();
            if (warnings != null) {
                this.postCheckedWarning(warnings);
            }
            insertStatement.close();
            this.rowCache_.flush();
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private static final String prepareQuotes(String name) {
        return JDUtilities.prepareForDoubleQuotes(name);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            this.internalLock.lock();
            boolean bl = !this.positionValid_ && !this.positionInsert_ && (this.positionFromFirst_ > 0 || this.positionFromLast_ > 0);
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    private void testDataTruncation2(int columnIndex, SQLData data) throws SQLException {
        if (data != null) {
            this.connection_.testDataTruncation(null, this, columnIndex, false, data, null);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array columnValue) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + columnIndex);
    }

    @Override
    public void updateArray(String columnName, Array columnValue) throws SQLException {
        this.updateArray(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        if (length < 0) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, columnValue == null ? null : JDUtilities.streamToString(columnValue, length, "ISO8859_1"), null, -1);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream columnValue, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal columnValue) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        if (length < 0) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, columnValue == null ? null : JDUtilities.streamToBytes(columnValue, length), null, -1);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream columnValue, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean columnValue) throws SQLException {
        this.updateValue(columnIndex, (short)(columnValue ? 1 : 0), null, -1);
    }

    @Override
    public void updateBoolean(String columnName, boolean columnValue) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateBlob(int columnIndex, Blob columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateBlob(String columnName, Blob columnValue) throws SQLException {
        this.updateValue(this.findColumn(columnName), columnValue, null, -1);
    }

    @Override
    public void updateByte(int columnIndex, byte columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateByte(String columnName, byte columnValue) throws SQLException {
        this.updateByte(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateBytes(String columnName, byte[] columnValue) throws SQLException {
        this.updateBytes(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader columnValue, int length) throws SQLException {
        if (length < 0) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, columnValue == null ? null : JDUtilities.readerToString(columnValue, length), null, -1);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader columnValue, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateClob(String columnName, Clob columnValue) throws SQLException {
        this.updateValue(this.findColumn(columnName), columnValue, null, -1);
    }

    @Override
    public void updateDate(int columnIndex, Date columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateDate(String columnName, Date columnValue) throws SQLException {
        this.updateDate(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateDouble(int columnIndex, double columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateDouble(String columnName, double columnValue) throws SQLException {
        this.updateDouble(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateFloat(int columnIndex, float columnValue) throws SQLException {
        this.updateValue(columnIndex, Float.valueOf(columnValue), null, -1);
    }

    @Override
    public void updateFloat(String columnName, float columnValue) throws SQLException {
        this.updateFloat(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateInt(int columnIndex, int columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateInt(String columnName, int columnValue) throws SQLException {
        this.updateInt(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateLong(int columnIndex, long columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateLong(String columnName, long columnValue) throws SQLException {
        this.updateLong(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.updateValue(columnIndex, null, null, -1);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateDB2Default(int columnIndex) throws SQLException {
        this.updateValueExtendedIndicator(columnIndex, 1);
    }

    public void updateDBDefault(int columnIndex) throws SQLException {
        this.updateDB2Default(columnIndex);
    }

    public void updateDB2Default(String columnName) throws SQLException {
        this.updateDB2Default(this.findColumn(columnName));
    }

    public void updateDBDefault(String columnName) throws SQLException {
        this.updateDB2Default(this.findColumn(columnName));
    }

    public void updateDB2Unassigned(int columnIndex) throws SQLException {
        this.updateValueExtendedIndicator(columnIndex, 2);
    }

    public void updateDBUnassigned(int columnIndex) throws SQLException {
        this.updateDB2Unassigned(columnIndex);
    }

    public void updateDB2Unassigned(String columnName) throws SQLException {
        this.updateDB2Unassigned(this.findColumn(columnName));
    }

    public void updateDBUnassigned(String columnName) throws SQLException {
        this.updateDB2Unassigned(this.findColumn(columnName));
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateObject(String columnName, Object columnValue) throws SQLException {
        this.updateObject(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue, int scale) throws SQLException {
        if (scale < 0) {
            JDError.throwSQLException("HY094");
        }
        if (columnValue instanceof SQLXML) {
            this.updateSQLXML(columnIndex, (SQLXML)columnValue);
        } else {
            this.updateValue(columnIndex, columnValue, null, scale);
        }
    }

    @Override
    public void updateObject(String columnName, Object columnValue, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), columnValue, scale);
    }

    @Override
    public void updateRef(int columnIndex, Ref columnValue) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + columnIndex);
    }

    @Override
    public void updateRef(String columnName, Ref columnValue) throws SQLException {
        this.updateRef(this.findColumn(columnName), columnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        this.beforeUpdate();
        ConvTable convTable = null;
        if (this.positionInsert_ || !this.positionValid_) {
            JDError.throwSQLException("24000");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ");
        buffer.append(this.selectTable_);
        if (this.correlationName_ != null) {
            buffer.append(" AS ");
            buffer.append(this.correlationName_);
        }
        buffer.append(" SET ");
        int columnsSet = 0;
        for (int i = 0; i < this.columnCount_; ++i) {
            if (!this.updateSet_[i]) continue;
            if (columnsSet++ > 0) {
                buffer.append(",");
            }
            buffer.append("\"");
            if (this.statement_ != null) {
                if (this.extendedDescriptors_ != null) {
                    convTable = this.connection_.getConverter();
                    String columnName = this.extendedDescriptors_.getColumnDescriptors(i + 1, convTable, this.settings_).getBaseColumnName(convTable);
                    if (columnName != null) {
                        if (this.connection_.getVRM() < JDUtilities.vrm540) {
                            buffer.append(JDUtilities.stripOuterDoubleQuotes(columnName));
                        } else {
                            buffer.append(AS400JDBCResultSet.prepareQuotes(columnName));
                        }
                    } else {
                        buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                    }
                } else {
                    buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                }
            } else {
                buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
            }
            buffer.append("\"=?");
        }
        buffer.append(" WHERE CURRENT OF \"");
        buffer.append(this.cursorName_);
        buffer.append("\"");
        if (columnsSet > 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Updating a row: " + buffer);
            }
            try (PreparedStatement updateStatement = this.connection_.prepareStatement(buffer.toString());){
                int columnsSet2 = 0;
                for (int i = 0; i < this.columnCount_; ++i) {
                    if (!this.updateSet_[i]) continue;
                    Object columnValue = this.updateRow_.getSQLData(i + 1).getObject();
                    if (this.updateNulls_[i]) {
                        updateStatement.setNull(++columnsSet2, this.row_.getSQLType(i + 1).getType());
                        continue;
                    }
                    if (this.updateDefaults_[i]) {
                        ((AS400JDBCPreparedStatement)updateStatement).setDB2Default(++columnsSet2);
                        continue;
                    }
                    if (this.updateUnassigned_[i]) {
                        ((AS400JDBCPreparedStatement)updateStatement).setDB2Unassigned(++columnsSet2);
                        continue;
                    }
                    updateStatement.setObject(++columnsSet2, columnValue);
                }
                updateStatement.executeUpdate();
                SQLWarning warnings = updateStatement.getWarnings();
                if (warnings != null) {
                    this.postCheckedWarning(warnings);
                }
            }
            this.rowCache_.flush();
        }
    }

    @Override
    public void updateShort(int columnIndex, short columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateShort(String columnName, short columnValue) throws SQLException {
        this.updateShort(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateString(int columnIndex, String columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateString(String columnName, String columnValue) throws SQLException {
        this.updateString(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateTime(int columnIndex, Time columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateTime(String columnName, Time columnValue) throws SQLException {
        this.updateTime(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp columnValue) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), columnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue(int columnIndex, Object columnValue, Calendar calendar, int scale) throws SQLException {
        try {
            this.internalLock.lock();
            this.beforeUpdateValue(columnIndex);
            SQLData sqlData = this.updateRow_.getSQLType(columnIndex);
            int columnIndex0 = columnIndex - 1;
            int sqlType = sqlData.getSQLType();
            if (columnValue != null && (sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40)) {
                if (columnValue instanceof AS400JDBCBlobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(((AS400JDBCBlobLocator)columnValue).getHandle());
                    }
                    catch (ClassCastException sqlDataAsLocator) {}
                } else if (columnValue instanceof AS400JDBCClobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(((AS400JDBCClobLocator)columnValue).getHandle());
                    }
                    catch (ClassCastException sqlDataAsLocator) {}
                } else if (columnValue instanceof AS400JDBCNClobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(((AS400JDBCNClobLocator)columnValue).getHandle());
                    }
                    catch (ClassCastException sqlDataAsLocator) {}
                } else if (columnValue instanceof AS400JDBCSQLXMLLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(((AS400JDBCSQLXMLLocator)columnValue).getHandle());
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (columnValue != null) {
                sqlData.set(columnValue, calendar, scale);
            }
            this.updateNulls_[columnIndex0] = columnValue == null;
            this.updateDefaults_[columnIndex0] = false;
            this.updateUnassigned_[columnIndex0] = false;
            this.updateSet_[columnIndex0] = true;
            if (this.dataTruncation_) {
                this.testDataTruncation2(columnIndex, sqlData);
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldability() throws SQLException {
        try {
            int n;
            this.internalLock.lock();
            this.checkOpen();
            if (this.statement_ != null) {
                JDCursor cursor;
                int vrm = 0;
                if (this.connection_ != null) {
                    vrm = this.connection_.getVRM();
                }
                if ((cursor = this.statement_.getCursor()).getCursorAttributeHoldable() == 0 && (vrm <= JDUtilities.vrm610 || vrm >= JDUtilities.vrm710 && cursor.getCursorIsolationLevel() != 0)) {
                    int n2 = 2;
                    return n2;
                }
                if (cursor.getCursorAttributeHoldable() == 1 || vrm >= JDUtilities.vrm710 && cursor.getCursorIsolationLevel() == 0) {
                    int n3 = 1;
                    return n3;
                }
                int resultSetHoldability = this.statement_.getInternalResultSetHoldability();
                if (resultSetHoldability == 1 || resultSetHoldability == 2) {
                    int n4 = resultSetHoldability;
                    return n4;
                }
            }
            if (this.connection_ instanceof AS400JDBCConnection && this.connection_ != null) {
                n = this.connection_.getHoldability();
                return n;
            }
            n = 2;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            Reader value;
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            this.openReader_ = value = data == null ? null : data.getNCharacterStream();
            this.testDataTruncation(columnIndex, data, false);
            Reader reader = value;
            return reader;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            NClob value = data == null ? null : data.getNClob();
            this.testDataTruncation(columnIndex, data, false);
            NClob nClob = value;
            return nClob;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        return this.getNClob(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            String value = data == null ? null : data.getNString();
            this.testDataTruncation(columnIndex, data, false);
            String string = value;
            return string;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        return this.getNString(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            RowId value = data == null ? null : data.getRowId();
            this.testDataTruncation(columnIndex, data, false);
            RowId rowId = value;
            return rowId;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        return this.getRowId(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            this.internalLock.lock();
            SQLData data = this.getValue(columnIndex);
            SQLXML value = data == null ? null : data.getSQLXML();
            this.testDataTruncation(columnIndex, data, false);
            SQLXML sQLXML = value;
            return sQLXML;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        return this.getSQLXML(this.findColumn(columnName));
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateValue(columnIndex, nClob, null, -1);
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnName), nClob);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateValue(columnIndex, nString, null, -1);
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnName), nString);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.updateValue(columnIndex, x, null, -1);
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnName), x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        if (xmlObject == null) {
            this.updateValue(columnIndex, xmlObject, null, -1);
            return;
        }
        int sqlDataType = this.updateRow_ != null ? this.updateRow_.getSQLData(columnIndex).getType() : 2009;
        switch (sqlDataType) {
            case 2005: {
                this.updateCharacterStream(columnIndex, xmlObject.getCharacterStream());
                break;
            }
            case 2004: {
                this.updateBinaryStream(columnIndex, xmlObject.getBinaryStream());
                break;
            }
            default: {
                this.updateValue(columnIndex, xmlObject, null, -1);
            }
        }
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnName), xmlObject);
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCResultSet", "java.sql.ResultSet"};
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, x == null ? null : JDUtilities.streamToString(x, (int)length, "ISO8859_1"), null, -1);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, x == null ? null : JDUtilities.streamToBytes(x, (int)length), null, -1);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, inputStream == null ? null : JDUtilities.streamToBytes(inputStream, (int)length), null, -1);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, x == null ? null : JDUtilities.readerToString(x, (int)length), null, -1);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, reader == null ? null : JDUtilities.readerToString(reader, (int)length), null, -1);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, x == null ? null : JDUtilities.readerToString(x, (int)length), null, -1);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, reader == null ? null : JDUtilities.readerToString(reader, (int)length), null, -1);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateValue(columnIndex, x == null ? null : JDUtilities.streamToBytes(x), null, -1);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateValue(columnIndex, x == null ? null : JDUtilities.streamToBytes(x), null, -1);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateValue(columnIndex, inputStream == null ? null : JDUtilities.streamToBytes(inputStream), null, -1);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, x == null ? null : JDUtilities.readerToString(x), null, -1);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, reader == null ? null : JDUtilities.readerToString(reader), null, -1);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, x == null ? null : JDUtilities.readerToString(x), null, -1);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.beforeUpdateValue(columnIndex);
        this.checkForValidConversion(columnIndex);
        this.updateValue(columnIndex, reader == null ? null : JDUtilities.readerToString(reader), null, -1);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValueExtendedIndicator(int columnIndex, int columnValue) throws SQLException {
        try {
            this.internalLock.lock();
            this.beforeUpdateValue(columnIndex);
            int columnIndex0 = columnIndex - 1;
            this.updateNulls_[columnIndex0] = false;
            this.updateDefaults_[columnIndex0] = columnValue == 1;
            this.updateUnassigned_[columnIndex0] = columnValue == 2;
            this.updateSet_[columnIndex0] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        if (type == null) {
            JDError.throwSQLException("HY105");
        }
        if (this.byteArrayClass_ == null) {
            byte[] byteArray = new byte[1];
            this.byteArrayClass_ = byteArray.getClass();
        }
        if (type == String.class) {
            return this.getString(columnIndex);
        }
        if (type == Byte.class) {
            byte b = this.getByte(columnIndex);
            if (b == 0 && this.wasNull()) {
                return null;
            }
            return b;
        }
        if (type == Short.class) {
            short s = this.getShort(columnIndex);
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return s;
        }
        if (type == Integer.class) {
            int i = this.getInt(columnIndex);
            if (i == 0 && this.wasNull()) {
                return null;
            }
            return i;
        }
        if (type == Long.class) {
            long l = this.getLong(columnIndex);
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return l;
        }
        if (type == Float.class) {
            float f = this.getFloat(columnIndex);
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return Float.valueOf(f);
        }
        if (type == Double.class) {
            double d = this.getDouble(columnIndex);
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return d;
        }
        if (type == BigDecimal.class) {
            return this.getBigDecimal(columnIndex);
        }
        if (type == Boolean.class) {
            boolean b = this.getBoolean(columnIndex);
            if (!b && this.wasNull()) {
                return null;
            }
            return b;
        }
        if (type == Date.class) {
            return this.getDate(columnIndex);
        }
        if (type == Time.class) {
            return this.getTime(columnIndex);
        }
        if (type == Timestamp.class) {
            return this.getTimestamp(columnIndex);
        }
        if (type == this.byteArrayClass_) {
            return this.getBytes(columnIndex);
        }
        if (type == InputStream.class) {
            return this.getBinaryStream(columnIndex);
        }
        if (type == Reader.class) {
            return this.getCharacterStream(columnIndex);
        }
        if (type == Clob.class) {
            return this.getClob(columnIndex);
        }
        if (type == Array.class) {
            return this.getArray(columnIndex);
        }
        if (type == Blob.class) {
            return this.getBlob(columnIndex);
        }
        if (type == Ref.class) {
            return this.getRef(columnIndex);
        }
        if (type == URL.class) {
            return this.getURL(columnIndex);
        }
        if (type == NClob.class) {
            return this.getNClob(columnIndex);
        }
        if (type == RowId.class) {
            return this.getRowId(columnIndex);
        }
        if (type == SQLXML.class) {
            return this.getSQLXML(columnIndex);
        }
        if (type == Object.class) {
            return this.getObject(columnIndex);
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    protected void addSavedException(SQLException savedException) {
        this.savedException_ = savedException;
    }

    static int getDBSQLRequestDSCursorType(String cursorSensitivityProperty, int resultSetType, int resultSetConcurrency) {
        switch (resultSetType) {
            case 1003: {
                if (cursorSensitivityProperty.equalsIgnoreCase("insensitive") && resultSetConcurrency == 1007) {
                    return 5;
                }
                if (cursorSensitivityProperty.equalsIgnoreCase("sensitive")) {
                    return 4;
                }
                return 0;
            }
            case 1005: {
                if (cursorSensitivityProperty.equalsIgnoreCase("sensitive")) {
                    return 3;
                }
                if (cursorSensitivityProperty.equalsIgnoreCase("asensitive")) {
                    return 1;
                }
                return 3;
            }
        }
        return 2;
    }

    int mapSQLType(Object targetSqlType) throws SQLException {
        return 0;
    }

    public void updateObject(int columnIndex, Object x, Object targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnIndex, x, scaleOrLength);
    }

    public void updateObject(String columnLabel, Object x, Object targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnLabel, x, scaleOrLength);
    }

    public void updateObject(int columnIndex, Object x, Object targetSqlType) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    public void updateObject(String columnLabel, Object x, Object targetSqlType) throws SQLException {
        this.updateObject(columnLabel, x);
    }
}

