/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.PrintObjectPageInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class SpooledFileViewer
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int ABSOLUTE_FIDELITY = 0;
    public static final int CONTENT_FIDELITY = 1;
    public static final int LETTER = 0;
    public static final int LEGAL = 1;
    public static final int A3 = 2;
    public static final int A4 = 3;
    public static final int A5 = 4;
    public static final int B4 = 5;
    public static final int B5 = 6;
    public static final int EXECUTIVE = 7;
    public static final int LEDGER = 8;
    public static final int CONT80 = 9;
    public static final int CONT132 = 10;
    public static final int NONE = 11;
    private static final int BSIZE_ = 36;
    private static final int LISTBOXWIDTH_ = 300;
    private static final int LISTBOXHEIGHT_ = 175;
    private static final int PREF_WIDTH = 465;
    private static final int PREF_HEIGHT = 600;
    private static final int TOOLBARSIZE_ = 38;
    private static final int TOPOFFSET_ = 1;
    private static final String WSCSTOBJ = "/QSYS.LIB/QWPGIF.WSCST";
    private static final String a3Text_ = ResourceLoader.getPrintText("PAPER_SIZE_A3");
    private static final String a4Text_ = ResourceLoader.getPrintText("PAPER_SIZE_A4");
    private static final String a5Text_ = ResourceLoader.getPrintText("PAPER_SIZE_A5");
    private static final String absoluteText_ = ResourceLoader.getPrintText("FIDELITY_ABSOLUTE");
    private static final String actualSizeText_ = ResourceLoader.getText("MENU_ACTUAL_SIZE");
    private static final String b4Text_ = ResourceLoader.getPrintText("PAPER_SIZE_B4");
    private static final String b5Text_ = ResourceLoader.getPrintText("PAPER_SIZE_B5");
    private static final String cancelText_ = ResourceLoader.getText("DLG_CANCEL");
    private static final String cont80Text_ = ResourceLoader.getPrintText("PAPER_SIZE_CONT80");
    private static final String cont132Text_ = ResourceLoader.getPrintText("PAPER_SIZE_CONT132");
    private static final String contentText_ = ResourceLoader.getPrintText("FIDELITY_CONTENT");
    private static final String curPaperText_ = ResourceLoader.getPrintText("CURRENT_PAPER_SIZE");
    private static final String curVFidelityText_ = ResourceLoader.getPrintText("CURRENT_VIEWING_FIDELITY");
    private static final String executiveText_ = ResourceLoader.getPrintText("PAPER_SIZE_EXECUTIVE");
    private static final String firstPageText_ = ResourceLoader.getText("MENU_FIRST_PAGE");
    private static final String fitPageText_ = ResourceLoader.getText("MENU_FIT_PAGE");
    private static final String fitWidthText_ = ResourceLoader.getText("MENU_FIT_WIDTH");
    private static final String flashPageText_ = ResourceLoader.getText("MENU_FLASH_PAGE");
    private static final String goToText_ = ResourceLoader.getText("MENU_GO_TO_PAGE");
    private static final String goToPageText_ = ResourceLoader.getPrintText("GO_TO_PAGE");
    private static final String lastPageText_ = ResourceLoader.getText("MENU_LAST_PAGE");
    private static final String ledgerText_ = ResourceLoader.getPrintText("PAPER_SIZE_LEDGER");
    private static final String legalText_ = ResourceLoader.getPrintText("PAPER_SIZE_LEGAL");
    private static final String letterText_ = ResourceLoader.getPrintText("PAPER_SIZE_LETTER");
    private static final String nextPageText_ = ResourceLoader.getText("MENU_NEXT_PAGE");
    private static final String noneText_ = ResourceLoader.getPrintText("NONE");
    private static final String okText_ = ResourceLoader.getText("DLG_OK");
    private static final String paperSizeText_ = ResourceLoader.getPrintText("PAPER_SIZE");
    private static final String paperSizeWarnText_ = ResourceLoader.getPrintText("WARNING_PAPER_SIZE");
    private static final String prevPageText_ = ResourceLoader.getText("MENU_PREVIOUS_PAGE");
    private static final String vFidelityText_ = ResourceLoader.getPrintText("VIEWING_FIDELITY");
    private static final String vFidelityWarnText_ = ResourceLoader.getPrintText("WARNING_FIDELITY");
    private static final String warningText_ = ResourceLoader.getPrintText("WARNING");
    private static final String zoomText_ = ResourceLoader.getText("MENU_ZOOM");
    private static final Icon iconActualSize_ = ResourceLoader.getIcon("ResetViewIcon.gif");
    private static final Icon iconFirstPage_ = ResourceLoader.getIcon("FirstIcon.gif");
    private static final Icon iconFitPage_ = ResourceLoader.getIcon("FitPageIcon.gif");
    private static final Icon iconFitWidth_ = ResourceLoader.getIcon("FitWidthIcon.gif");
    private static final Icon iconFlashPage_ = ResourceLoader.getIcon("FlashIcon.gif");
    private static final Icon iconGoToPage_ = ResourceLoader.getIcon("GoToIcon.gif");
    private static final Icon iconLastPage_ = ResourceLoader.getIcon("LastIcon.gif");
    private static final Icon iconNextPage_ = ResourceLoader.getIcon("NextIcon.gif");
    private static final Icon iconPaperSize_ = ResourceLoader.getIcon("PaperIcon.gif");
    private static final Icon iconPrevPage_ = ResourceLoader.getIcon("PreviousIcon.gif");
    private static final Icon iconViewFidelity_ = ResourceLoader.getIcon("VFIcon.gif");
    private static final Icon iconZoom_ = ResourceLoader.getIcon("ZoomIcon.gif");
    private static final String[] paperSizes = new String[]{letterText_, legalText_, a3Text_, a4Text_, a5Text_, b4Text_, b5Text_, executiveText_, ledgerText_, cont80Text_, cont132Text_, noneText_};
    private static final String[] paperSizeValues = new String[]{"*LETTER", "*LEGAL", "*A3", "*A4", "*A5", "*B4", "*B5", "*EXECUTIVE", "*LEDGER", "*CONT80", "*CONT132", "*NONE"};
    private static final String[] viewingFidelities = new String[]{absoluteText_, contentText_};
    private static final String[] viewingValues = new String[]{"*ABSOLUTE", "*CONTENT"};
    private static int sPaperSize_ = 0;
    private static int sViewingFidelity_ = 1;
    private static boolean paperSizeChecked_ = false;
    private transient Image currentPageImage_ = null;
    private transient Image flashPageImage_ = null;
    private transient PrintObjectPageInputStream spooledFileIS_ = null;
    private boolean initialized_ = false;
    private boolean numberOfPagesEst_ = false;
    private int currentPageNumber_ = 0;
    private int flashPageNumber_ = 0;
    private int knownPages_ = 0;
    private int numberOfPages_ = 0;
    private int oldCurrentPage_ = 0;
    private int paperSize_ = 0;
    private int viewingFidelity_ = 0;
    private float zoomPercentage_ = 100.0f;
    private transient JButton actualButton_ = null;
    private transient JButton firstPageButton_ = null;
    private transient JButton fitPageButton_ = null;
    private transient JButton fitWidthButton_ = null;
    private transient JButton flashButton_ = null;
    private transient JButton gotoButton_ = null;
    private transient JButton lastPageButton_ = null;
    private transient JButton nextPageButton_ = null;
    private transient JButton paperSizeButton_ = null;
    private transient JButton prevPageButton_ = null;
    private transient JButton viewingFidelityButton_ = null;
    private transient JButton zoomButton_ = null;
    private transient JPanel statusBar_ = null;
    private transient JPanel toolBar_ = null;
    private transient JScrollPane scrollView_ = null;
    private SpooledFile spooledFile_ = null;
    private SpooledFilePageView_ pageView_ = null;
    private String estimateStar_ = "";
    private transient JTextField pageInfo_ = null;
    private transient JTextField zoomInfo_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public SpooledFileViewer() {
        this.spooledFile_ = null;
        this.createViewer();
    }

    public SpooledFileViewer(SpooledFile spooledFile) {
        if (spooledFile == null) {
            throw new NullPointerException("spooledFile");
        }
        this.spooledFile_ = spooledFile;
        this.createViewer();
        this.currentPageNumber_ = 1;
    }

    public SpooledFileViewer(SpooledFile spooledFile, int page) {
        if (spooledFile == null) {
            throw new NullPointerException("spooledFile");
        }
        if (page < 1) {
            throw new IllegalArgumentException("page");
        }
        this.spooledFile_ = spooledFile;
        this.createViewer();
        this.currentPageNumber_ = page;
    }

    public void actualSize() {
        if (this.initialized_) {
            this.pageView_.clearView();
            Dimension d = new Dimension(this.currentPageImage_.getWidth(this), this.currentPageImage_.getHeight(this));
            this.pageView_.setViewSize(d);
            this.calculateZoom();
            this.updateViewer();
        }
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addStatusBar() {
        this.add("South", this.statusBar_);
        this.validate();
    }

    public void addToolBar() {
        this.add("North", this.toolBar_);
        this.validate();
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    private void calculateZoom() {
        float imageWidth = this.getPageImageSize().width;
        if (imageWidth != 0.0f) {
            this.zoomPercentage_ = (float)this.pageView_.getWidth() / imageWidth * 100.0f;
        } else {
            this.errorEventSupport_.fireError(new ArithmeticException());
        }
    }

    void changeCurrentPage() {
        GoToBox_ theGoToBox = new GoToBox_((JFrame)VUtilities.getFrame(this));
        theGoToBox.setVisible(true);
    }

    void changePaperSize() {
        PaperSizeBox_ thePaperSizeBox = new PaperSizeBox_((JFrame)VUtilities.getFrame(this));
        thePaperSizeBox.setVisible(true);
    }

    void changeViewingFidelity() {
        ViewingFidelityBox_ theViewingFidelityBox = new ViewingFidelityBox_((JFrame)VUtilities.getFrame(this));
        theViewingFidelityBox.setVisible(true);
    }

    void changeZoom() {
        ZoomToBox_ theZoomToBox = new ZoomToBox_((JFrame)VUtilities.getFrame(this));
        theZoomToBox.setVisible(true);
    }

    public void close() {
        try {
            if (this.spooledFileIS_ != null) {
                this.spooledFileIS_.close();
                this.spooledFileIS_ = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JPanel createStatusBar() {
        JPanel statusBar = new JPanel();
        this.pageInfo_ = new JTextField(22);
        this.pageInfo_.setEditable(false);
        this.pageInfo_.transferFocus();
        this.zoomInfo_ = new JTextField(8);
        this.zoomInfo_.setEditable(false);
        this.zoomInfo_.transferFocus();
        statusBar.setLayout(new FlowLayout(0));
        statusBar.add(this.pageInfo_);
        statusBar.add(this.zoomInfo_);
        return statusBar;
    }

    private JPanel createToolBar() {
        JPanel toolBar = new JPanel();
        Insets insets = toolBar.getInsets();
        ViewerActionListener_ listener = new ViewerActionListener_();
        toolBar.setPreferredSize(new Dimension(38, 38));
        toolBar.setLayout(null);
        this.actualButton_ = new JButton(iconActualSize_);
        toolBar.add(this.actualButton_);
        this.actualButton_.setBounds(insets.left + 1, insets.top + 1, 36, 36);
        this.actualButton_.addActionListener(listener);
        this.actualButton_.setToolTipText(actualSizeText_);
        this.actualButton_.setActionCommand("actualSize");
        this.fitWidthButton_ = new JButton(iconFitWidth_);
        toolBar.add(this.fitWidthButton_);
        this.fitWidthButton_.setBounds(insets.left + 37, insets.top + 1, 36, 36);
        this.fitWidthButton_.addActionListener(listener);
        this.fitWidthButton_.setToolTipText(fitWidthText_);
        this.fitWidthButton_.setActionCommand("fitWidth");
        this.fitPageButton_ = new JButton(iconFitPage_);
        toolBar.add(this.fitPageButton_);
        this.fitPageButton_.setBounds(insets.left + 73, insets.top + 1, 36, 36);
        this.fitPageButton_.addActionListener(listener);
        this.fitPageButton_.setToolTipText(fitPageText_);
        this.fitPageButton_.setActionCommand("fitPage");
        this.zoomButton_ = new JButton(iconZoom_);
        toolBar.add(this.zoomButton_);
        this.zoomButton_.setBounds(insets.left + 109, insets.top + 1, 36, 36);
        this.zoomButton_.addActionListener(listener);
        this.zoomButton_.setToolTipText(zoomText_);
        this.zoomButton_.setActionCommand("zoom");
        this.gotoButton_ = new JButton(iconGoToPage_);
        toolBar.add(this.gotoButton_);
        this.gotoButton_.setBounds(insets.left + 152, insets.top + 1, 36, 36);
        this.gotoButton_.addActionListener(listener);
        this.gotoButton_.setToolTipText(goToText_);
        this.gotoButton_.setActionCommand("goToPage");
        this.firstPageButton_ = new JButton(iconFirstPage_);
        toolBar.add(this.firstPageButton_);
        this.firstPageButton_.setBounds(insets.left + 195, insets.top + 1, 36, 36);
        this.firstPageButton_.addActionListener(listener);
        this.firstPageButton_.setToolTipText(firstPageText_);
        this.firstPageButton_.setActionCommand("firstPage");
        this.prevPageButton_ = new JButton(iconPrevPage_);
        toolBar.add(this.prevPageButton_);
        this.prevPageButton_.setBounds(insets.left + 231, insets.top + 1, 36, 36);
        this.prevPageButton_.addActionListener(listener);
        this.prevPageButton_.setToolTipText(prevPageText_);
        this.prevPageButton_.setActionCommand("prevPage");
        this.nextPageButton_ = new JButton(iconNextPage_);
        toolBar.add(this.nextPageButton_);
        this.nextPageButton_.setBounds(insets.left + 267, insets.top + 1, 36, 36);
        this.nextPageButton_.addActionListener(listener);
        this.nextPageButton_.setToolTipText(nextPageText_);
        this.nextPageButton_.setActionCommand("nextPage");
        this.lastPageButton_ = new JButton(iconLastPage_);
        toolBar.add(this.lastPageButton_);
        this.lastPageButton_.setBounds(insets.left + 303, insets.top + 1, 36, 36);
        this.lastPageButton_.addActionListener(listener);
        this.lastPageButton_.setToolTipText(lastPageText_);
        this.lastPageButton_.setActionCommand("lastPage");
        this.flashButton_ = new JButton(iconFlashPage_);
        toolBar.add(this.flashButton_);
        this.flashButton_.setBounds(insets.left + 346, insets.top + 1, 36, 36);
        this.flashButton_.addActionListener(listener);
        this.flashButton_.setToolTipText(flashPageText_);
        this.flashButton_.setActionCommand("flashPage");
        this.paperSizeButton_ = new JButton(iconPaperSize_);
        toolBar.add(this.paperSizeButton_);
        this.paperSizeButton_.setBounds(insets.left + 389, insets.top + 1, 36, 36);
        this.paperSizeButton_.addActionListener(listener);
        this.paperSizeButton_.setToolTipText(paperSizeText_);
        this.paperSizeButton_.setActionCommand("changePaperSize");
        this.viewingFidelityButton_ = new JButton(iconViewFidelity_);
        toolBar.add(this.viewingFidelityButton_);
        this.viewingFidelityButton_.setBounds(insets.left + 425, insets.top + 1, 36, 36);
        this.viewingFidelityButton_.addActionListener(listener);
        this.viewingFidelityButton_.setToolTipText(vFidelityText_);
        this.viewingFidelityButton_.setActionCommand("changeViewingFidelity");
        return toolBar;
    }

    private void createViewer() {
        this.initializeTransient();
        if (!paperSizeChecked_) {
            try {
                Locale country = Locale.getDefault();
                String cntry = country.getISO3Country();
                if (cntry.equals("USA") || cntry.equals("CAN") || cntry.equals("BRA") || cntry.equals("MEX")) {
                    this.paperSize_ = 0;
                }
                this.paperSize_ = 3;
            }
            catch (MissingResourceException mre) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Default paper size selected");
                }
                this.paperSize_ = 3;
            }
            finally {
                paperSizeChecked_ = true;
            }
        } else {
            this.paperSize_ = sPaperSize_;
        }
        this.viewingFidelity_ = sViewingFidelity_;
        this.setLayout(new BorderLayout());
        this.toolBar_ = this.createToolBar();
        this.addToolBar();
        this.scrollView_ = new JScrollPane(22, 32);
        this.add("Center", this.scrollView_);
        this.statusBar_ = this.createStatusBar();
        this.addStatusBar();
        this.disableViewerButtons();
        this.repaint();
    }

    private void disableViewerButtons() {
        this.actualButton_.setEnabled(false);
        this.firstPageButton_.setEnabled(false);
        this.fitPageButton_.setEnabled(false);
        this.fitWidthButton_.setEnabled(false);
        this.flashButton_.setEnabled(false);
        this.gotoButton_.setEnabled(false);
        this.lastPageButton_.setEnabled(false);
        this.nextPageButton_.setEnabled(false);
        this.paperSizeButton_.setEnabled(false);
        this.prevPageButton_.setEnabled(false);
        this.viewingFidelityButton_.setEnabled(false);
        this.zoomButton_.setEnabled(false);
    }

    void displayPropertyChangeWarning(String property, int value) {
        boolean internetExplorer = false;
        Object[] options = new Object[]{okText_, cancelText_};
        Class<?> policyEngineClass = null;
        try {
            policyEngineClass = Class.forName("com.ms.security.PolicyEngine");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (policyEngineClass != null) {
            internetExplorer = true;
        }
        if (property.equals("viewingFidelity")) {
            if (!internetExplorer) {
                int selectedValue = JOptionPane.showOptionDialog(this, vFidelityWarnText_, warningText_, -1, 2, null, options, options[0]);
                if (selectedValue == 0) {
                    try {
                        this.setViewingFidelity(value);
                        this.load();
                    }
                    catch (Exception exception) {}
                }
            } else {
                WarningDialogBox_ wDialog = new WarningDialogBox_((JFrame)VUtilities.getFrame(this), vFidelityWarnText_, property, value);
                wDialog.setVisible(true);
            }
        } else if (property.equals("paperSize")) {
            if (!internetExplorer) {
                int selectedValue = JOptionPane.showOptionDialog(this, paperSizeWarnText_, warningText_, -1, 2, null, options, options[0]);
                if (selectedValue == 0) {
                    try {
                        this.setPaperSize(value);
                        this.load();
                    }
                    catch (Exception wDialog) {}
                }
            } else {
                WarningDialogBox_ wDialog = new WarningDialogBox_((JFrame)VUtilities.getFrame(this), paperSizeWarnText_, property, value);
                wDialog.setVisible(true);
            }
        } else if (Trace.isTraceOn()) {
            Trace.log(2, "Property for 'displayPropertyChangeWarning' not valid");
        }
    }

    private void enableViewerButtons() {
        this.actualButton_.setEnabled(true);
        this.firstPageButton_.setEnabled(true);
        this.fitPageButton_.setEnabled(true);
        this.fitWidthButton_.setEnabled(true);
        this.flashButton_.setEnabled(true);
        this.gotoButton_.setEnabled(true);
        this.lastPageButton_.setEnabled(true);
        this.nextPageButton_.setEnabled(true);
        this.paperSizeButton_.setEnabled(true);
        this.prevPageButton_.setEnabled(true);
        this.viewingFidelityButton_.setEnabled(true);
        this.zoomButton_.setEnabled(true);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.spooledFileIS_ != null) {
                this.spooledFileIS_.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public void fitHeight() {
        if (this.initialized_) {
            this.pageView_.clearView();
            JViewport viewPort = this.scrollView_.getViewport();
            Dimension viewPortSize = viewPort.getExtentSize();
            if (viewPortSize.width < 0) {
                viewPortSize.width = 0;
            }
            if (viewPortSize.height < 0) {
                viewPortSize.height = 0;
            }
            Dimension d = new Dimension();
            d.height = viewPortSize.height;
            d.width = this.currentPageImage_.getWidth(this) * viewPortSize.height / this.currentPageImage_.getHeight(this);
            this.pageView_.setViewSize(d);
            this.calculateZoom();
            this.updateViewer();
        }
    }

    public void fitPage() {
        if (this.initialized_) {
            Dimension d1 = this.scrollView_.getSize();
            Dimension d2 = this.scrollView_.getViewport().getExtentSize();
            if (d2.width < 0) {
                d2.width = 0;
            }
            if (d2.height < 0) {
                d2.height = 0;
            }
            int viewWidth = this.pageView_.getWidth();
            int viewHeight = this.pageView_.getHeight();
            if (viewWidth <= d2.width && viewHeight >= d2.height) {
                this.fitHeight();
            } else if (viewWidth >= d2.width && viewHeight <= d2.height) {
                this.fitWidth();
            } else if (viewWidth < d2.width) {
                if (Math.abs(d1.width - viewWidth) < Math.abs(d1.height - viewHeight)) {
                    this.fitWidth();
                } else {
                    this.fitHeight();
                }
            } else if (Math.abs(d1.width - viewWidth) < Math.abs(d1.height - viewHeight)) {
                this.fitHeight();
            } else {
                this.fitWidth();
            }
        }
    }

    public void fitWidth() {
        if (this.initialized_) {
            this.pageView_.clearView();
            JViewport viewPort = this.scrollView_.getViewport();
            Dimension viewPortSize = viewPort.getExtentSize();
            if (viewPortSize.width < 0) {
                viewPortSize.width = 0;
            }
            if (viewPortSize.height < 0) {
                viewPortSize.height = 0;
            }
            Dimension d = new Dimension();
            d.width = viewPortSize.width;
            d.height = this.currentPageImage_.getHeight(this) * viewPortSize.width / this.currentPageImage_.getWidth(this);
            this.pageView_.setViewSize(d);
            this.calculateZoom();
            this.updateViewer();
        }
    }

    public int getCurrentPage() {
        return this.currentPageNumber_;
    }

    public int getNumberOfPages() {
        return this.numberOfPages_;
    }

    private synchronized Image getPageImage(int page) throws IOException {
        Image image = null;
        if (this.spooledFileIS_ == null) {
            throw new IOException();
        }
        try {
            boolean pageSelected = this.spooledFileIS_.selectPage(page);
            if (!pageSelected) {
                throw new IOException();
            }
            int bytesAvailable = this.spooledFileIS_.available();
            if (bytesAvailable == 0) {
                throw new IOException();
            }
            byte[] imageData = new byte[bytesAvailable];
            this.spooledFileIS_.read(imageData, 0, bytesAvailable);
            Frame frame = new Frame();
            Toolkit kit = frame.getToolkit();
            MediaTracker imageLoader = new MediaTracker(frame);
            image = kit.createImage(imageData);
            if (image != null) {
                imageLoader.addImage(image, 0);
                imageLoader.waitForID(0);
                imageLoader = null;
            }
        }
        catch (Exception e) {
            throw new IOException();
        }
        return image;
    }

    private Dimension getPageImageSize() {
        if (this.currentPageImage_ != null) {
            return new Dimension(this.currentPageImage_.getWidth(this), this.currentPageImage_.getHeight(this));
        }
        return new Dimension(0, 0);
    }

    public int getPaperSize() {
        return this.paperSize_;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.pageView_ != null && this.pageView_.getWidth() < 500 && this.pageView_.getHeight() < 700) {
            return new Dimension(this.pageView_.getWidth() + 25, this.pageView_.getHeight() + 38 + this.statusBar_.getPreferredSize().height);
        }
        return new Dimension(465, 600);
    }

    public SpooledFile getSpooledFile() {
        return this.spooledFile_;
    }

    public int getViewingFidelity() {
        return this.viewingFidelity_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.addWorkingListener(new WorkingCursorAdapter(this));
        this.addFocusListener(new SerializationListener(this));
    }

    public boolean isNumberOfPagesEstimated() {
        return this.numberOfPagesEst_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException, PropertyVetoException {
        if (this.spooledFile_ == null) {
            this.errorEventSupport_.fireError(new IllegalStateException("spooledFile"));
        } else {
            this.workingEventSupport_.fireStartWorking();
            try {
                this.initialized_ = false;
                this.disableViewerButtons();
                PrintParameterList printParms = new PrintParameterList();
                printParms.setParameter(-8, WSCSTOBJ);
                printParms.setParameter(65, "*WSCST");
                printParms.setParameter(216, viewingValues[this.viewingFidelity_]);
                printParms.setParameter(212, paperSizeValues[this.paperSize_]);
                if (this.spooledFileIS_ != null) {
                    this.spooledFileIS_.close();
                }
                this.spooledFileIS_ = this.spooledFile_.getPageInputStream(printParms);
                if (this.spooledFileIS_ == null) {
                    throw new IOException();
                }
                int newValue = this.spooledFileIS_.getNumberOfPages();
                this.vetoableChangeSupport_.fireVetoableChange("numberOfPages", (Object)this.numberOfPages_, (Object)newValue);
                int oldValue = this.numberOfPages_;
                this.numberOfPages_ = newValue;
                this.propertyChangeSupport_.firePropertyChange("numberOfPages", (Object)oldValue, (Object)this.numberOfPages_);
                boolean newEstimated = this.spooledFileIS_.isPagesEstimated();
                this.vetoableChangeSupport_.fireVetoableChange("numberOfPagesEstimated", (Object)this.numberOfPagesEst_, (Object)newEstimated);
                boolean oldEstimated = this.numberOfPagesEst_;
                this.numberOfPagesEst_ = newEstimated;
                this.propertyChangeSupport_.firePropertyChange("numberOfPagesEstimated", (Object)oldEstimated, (Object)this.numberOfPagesEst_);
                if (this.numberOfPagesEst_) {
                    this.estimateStar_ = "*";
                }
                try {
                    this.currentPageImage_ = this.getPageImage(this.currentPageNumber_);
                    this.oldCurrentPage_ = this.currentPageNumber_;
                    this.knownPages_ = this.currentPageNumber_;
                }
                catch (IOException e) {
                    if (this.currentPageNumber_ != 1) {
                        this.setCurrentPage(1);
                        this.currentPageImage_ = this.getPageImage(this.currentPageNumber_);
                        this.oldCurrentPage_ = this.currentPageNumber_;
                        this.knownPages_ = this.currentPageNumber_;
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Error initializing spooled file viewer");
                    }
                    throw e;
                }
                this.pageView_ = new SpooledFilePageView_();
                this.scrollView_.setViewportView(this.pageView_);
                this.enableViewerButtons();
                this.initialized_ = true;
                this.calculateZoom();
                this.updateViewer();
                this.validate();
            }
            catch (Exception e) {
                this.initialized_ = false;
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error initializing spooled file viewer");
                }
                this.errorEventSupport_.fireError(e);
            }
            finally {
                this.workingEventSupport_.fireStopWorking();
            }
        }
    }

    public void loadFlashPage() throws PropertyVetoException {
        if (this.initialized_) {
            if (this.flashPageImage_ != null) {
                this.vetoableChangeSupport_.fireVetoableChange("currentPage", (Object)this.oldCurrentPage_, (Object)this.flashPageNumber_);
                this.pageView_.clearView();
                int tempPageNumber = this.flashPageNumber_;
                this.flashPageNumber_ = this.oldCurrentPage_;
                this.currentPageNumber_ = tempPageNumber;
                Image tempPageImage = this.flashPageImage_;
                this.flashPageImage_ = this.currentPageImage_;
                this.currentPageImage_ = tempPageImage;
                this.oldCurrentPage_ = this.currentPageNumber_;
                Dimension d1 = this.getPageImageSize();
                Dimension d2 = new Dimension();
                d2.width = (int)((float)d1.width * (this.zoomPercentage_ / 100.0f));
                d2.height = (int)((float)d1.height * (this.zoomPercentage_ / 100.0f));
                this.pageView_.setViewSize(d2);
                this.updateViewer();
                this.propertyChangeSupport_.firePropertyChange("currentPage", (Object)this.flashPageNumber_, (Object)this.currentPageNumber_);
            }
        } else {
            this.errorEventSupport_.fireError(new IllegalStateException());
        }
    }

    public void loadPage() throws PropertyVetoException {
        this.workingEventSupport_.fireStartWorking();
        if (this.initialized_) {
            if (this.currentPageNumber_ != this.oldCurrentPage_) {
                if (this.currentPageNumber_ == this.flashPageNumber_) {
                    this.loadFlashPage();
                } else {
                    try {
                        Image newPageImage = this.getPageImage(this.currentPageNumber_);
                        this.flashPageNumber_ = this.oldCurrentPage_;
                        this.flashPageImage_ = this.currentPageImage_;
                        this.oldCurrentPage_ = this.currentPageNumber_;
                        this.currentPageImage_ = newPageImage;
                        if (this.numberOfPagesEst_ && this.currentPageNumber_ > this.knownPages_) {
                            this.knownPages_ = this.currentPageNumber_;
                        }
                    }
                    catch (IOException e) {
                        if (this.numberOfPagesEst_ && this.currentPageNumber_ == this.knownPages_ + 1) {
                            this.vetoableChangeSupport_.fireVetoableChange("numberOfPages", (Object)this.numberOfPages_, (Object)this.knownPages_);
                            int oldValue = this.numberOfPages_;
                            this.numberOfPages_ = this.knownPages_;
                            this.propertyChangeSupport_.firePropertyChange("numberOfPages", (Object)oldValue, (Object)this.numberOfPages_);
                            this.vetoableChangeSupport_.fireVetoableChange("numberOfPagesEstimated", Boolean.TRUE, Boolean.FALSE);
                            this.numberOfPagesEst_ = false;
                            this.estimateStar_ = "";
                            this.propertyChangeSupport_.firePropertyChange("numberOfPagesEstimated", Boolean.TRUE, Boolean.FALSE);
                        }
                        this.vetoableChangeSupport_.fireVetoableChange("currentPage", (Object)this.currentPageNumber_, (Object)this.oldCurrentPage_);
                        int oldPage = this.currentPageNumber_;
                        this.currentPageNumber_ = this.oldCurrentPage_;
                        this.propertyChangeSupport_.firePropertyChange("currentPage", (Object)oldPage, (Object)this.currentPageNumber_);
                        this.errorEventSupport_.fireError(new IOException());
                    }
                }
            }
            Dimension d1 = this.getPageImageSize();
            Dimension d2 = new Dimension();
            d2.width = (int)((float)d1.width * (this.zoomPercentage_ / 100.0f));
            d2.height = (int)((float)d1.height * (this.zoomPercentage_ / 100.0f));
            this.pageView_.setViewSize(d2);
            this.updateViewer();
        } else {
            this.errorEventSupport_.fireError(new IllegalStateException());
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void pageBack() throws PropertyVetoException {
        this.setCurrentPage(this.currentPageNumber_ - 1);
        this.loadPage();
    }

    public void pageForward() throws PropertyVetoException {
        this.setCurrentPage(this.currentPageNumber_ + 1);
        this.loadPage();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
        this.initialized_ = false;
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeToolBar() {
        this.remove(this.toolBar_);
        this.validate();
    }

    public void removeStatusBar() {
        this.remove(this.statusBar_);
        this.validate();
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public synchronized void setCurrentPage(int newPage) throws PropertyVetoException {
        if (1 <= newPage && (newPage <= this.numberOfPages_ || this.numberOfPagesEst_ || !this.initialized_)) {
            this.vetoableChangeSupport_.fireVetoableChange("currentPage", (Object)this.currentPageNumber_, (Object)newPage);
            int oldPage = this.currentPageNumber_;
            this.currentPageNumber_ = newPage;
            this.propertyChangeSupport_.firePropertyChange("currentPage", (Object)oldPage, (Object)this.currentPageNumber_);
        }
    }

    public synchronized void setPaperSize(int paperSize) throws PropertyVetoException {
        if (0 <= paperSize && paperSize <= 11) {
            this.vetoableChangeSupport_.fireVetoableChange("paperSize", (Object)this.paperSize_, (Object)paperSize);
            int oldValue = this.paperSize_;
            sPaperSize_ = this.paperSize_ = paperSize;
            paperSizeChecked_ = true;
            this.propertyChangeSupport_.firePropertyChange("paperSize", (Object)oldValue, (Object)this.paperSize_);
        } else {
            this.errorEventSupport_.fireError(new IllegalArgumentException("paperSize"));
        }
    }

    public void setSpooledFile(SpooledFile spooledFile) throws PropertyVetoException {
        if (spooledFile == null) {
            throw new NullPointerException("spooledFile");
        }
        this.vetoableChangeSupport_.fireVetoableChange("spooledFile", this.spooledFile_, spooledFile);
        SpooledFile oldValue = this.spooledFile_;
        this.spooledFile_ = spooledFile;
        this.propertyChangeSupport_.firePropertyChange("spooledFile", oldValue, this.spooledFile_);
    }

    public synchronized void setViewingFidelity(int viewingFidelity) throws PropertyVetoException {
        if (0 <= viewingFidelity && viewingFidelity <= 1) {
            this.vetoableChangeSupport_.fireVetoableChange("viewingFidelity", (Object)this.viewingFidelity_, (Object)viewingFidelity);
            int oldValue = this.viewingFidelity_;
            sViewingFidelity_ = this.viewingFidelity_ = viewingFidelity;
            this.propertyChangeSupport_.firePropertyChange("viewingFidelity", (Object)oldValue, (Object)this.viewingFidelity_);
        } else {
            this.errorEventSupport_.fireError(new IllegalArgumentException("viewingFidelity"));
        }
    }

    private void updateViewer() {
        if (this.pageView_ != null && this.initialized_) {
            this.pageView_.repaint();
            this.zoomInfo_.setText((int)this.zoomPercentage_ + "%");
            String pageText = ResourceLoader.substitute(ResourceLoader.getPrintText("PAGE_OF"), new String[]{Integer.toString(this.currentPageNumber_), Integer.toString(this.numberOfPages_)});
            this.pageInfo_.setText(pageText + this.estimateStar_);
            if (this.currentPageNumber_ > 1) {
                this.firstPageButton_.setEnabled(true);
                this.prevPageButton_.setEnabled(true);
            } else {
                this.firstPageButton_.setEnabled(false);
                this.prevPageButton_.setEnabled(false);
            }
            if (!this.numberOfPagesEst_) {
                if (this.currentPageNumber_ < this.numberOfPages_) {
                    this.lastPageButton_.setEnabled(true);
                    this.nextPageButton_.setEnabled(true);
                } else {
                    this.lastPageButton_.setEnabled(false);
                    this.nextPageButton_.setEnabled(false);
                }
            } else {
                this.lastPageButton_.setEnabled(false);
                this.nextPageButton_.setEnabled(true);
            }
        }
    }

    private class ZoomToBox_
    extends JDialog
    implements ActionListener {
        private JButton okButton;
        private JButton cancelButton;
        private Checkbox[] radioButtons;
        private float zoomAmount;
        private TextField zoomPerc;

        public ZoomToBox_(JFrame parent) {
            super(parent, zoomText_, true);
            Container zoomDialog = this.getContentPane();
            this.setResizable(false);
            zoomDialog.setLayout(new BorderLayout());
            this.setSize(250, 175);
            CheckboxGroup zoomPGroup = new CheckboxGroup();
            boolean[] buttonOn = new boolean[5];
            for (int i = 0; i < 5; ++i) {
                buttonOn[i] = false;
            }
            switch ((int)SpooledFileViewer.this.zoomPercentage_) {
                case 50: {
                    buttonOn[0] = true;
                    break;
                }
                case 75: {
                    buttonOn[1] = true;
                    break;
                }
                case 125: {
                    buttonOn[2] = true;
                    break;
                }
                case 150: {
                    buttonOn[3] = true;
                    break;
                }
                default: {
                    buttonOn[4] = true;
                }
            }
            this.radioButtons = new Checkbox[5];
            this.radioButtons[0] = new Checkbox(" 50%", zoomPGroup, buttonOn[0]);
            this.radioButtons[1] = new Checkbox(" 75%", zoomPGroup, buttonOn[1]);
            this.radioButtons[2] = new Checkbox("125%", zoomPGroup, buttonOn[2]);
            this.radioButtons[3] = new Checkbox("150%", zoomPGroup, buttonOn[3]);
            this.radioButtons[4] = new Checkbox("", zoomPGroup, buttonOn[4]);
            JPanel rightBorder = new JPanel();
            zoomDialog.add("West", rightBorder);
            JPanel radioPanel = new JPanel();
            radioPanel.setLayout(new GridLayout(4, 1));
            radioPanel.add(this.radioButtons[0]);
            radioPanel.add(this.radioButtons[1]);
            radioPanel.add(this.radioButtons[2]);
            radioPanel.add(this.radioButtons[3]);
            zoomDialog.add("Center", radioPanel);
            JPanel zoomPercPanel = new JPanel();
            zoomPercPanel.setLayout(new FlowLayout(2));
            this.zoomPerc = buttonOn[4] ? new TextField(Integer.toString((int)SpooledFileViewer.this.zoomPercentage_), 4) : new TextField("100", 4);
            this.zoomPerc.setEditable(true);
            this.zoomPerc.setBackground(new Color(255, 255, 255));
            this.zoomPerc.addActionListener(this);
            JLabel percentage = new JLabel("%");
            zoomPercPanel.add(this.radioButtons[4]);
            zoomPercPanel.add(this.zoomPerc);
            zoomPercPanel.add(percentage);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(2));
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            JPanel zoomRightPanel = new JPanel();
            zoomRightPanel.setLayout(new BorderLayout());
            zoomRightPanel.add("Center", zoomPercPanel);
            zoomRightPanel.add("South", buttonPanel);
            zoomDialog.add("East", zoomRightPanel);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    ZoomToBox_.this.setVisible(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.setVisible(false);
            if (!command.equals("cancel")) {
                if (this.radioButtons[0].getState()) {
                    this.zoomAmount = 0.5f;
                } else if (this.radioButtons[1].getState()) {
                    this.zoomAmount = 0.75f;
                } else if (this.radioButtons[2].getState()) {
                    this.zoomAmount = 1.25f;
                } else if (this.radioButtons[3].getState()) {
                    this.zoomAmount = 1.5f;
                } else if (this.radioButtons[4].getState()) {
                    float userValue = Float.valueOf(this.zoomPerc.getText()).floatValue();
                    if ((double)userValue >= 1.0) {
                        this.zoomAmount = (float)((double)userValue / 100.0);
                    } else {
                        SpooledFileViewer.this.errorEventSupport_.fireError(new IllegalArgumentException("userValue"));
                        this.zoomAmount = 0.0f;
                    }
                }
                if (this.zoomAmount > 8.0f) {
                    this.zoomAmount = 8.0f;
                }
                if (this.zoomAmount > 0.0f) {
                    Dimension d1 = SpooledFileViewer.this.getPageImageSize();
                    Dimension d2 = new Dimension();
                    d2.width = (int)((float)d1.width * this.zoomAmount);
                    d2.height = (int)((float)d1.height * this.zoomAmount);
                    SpooledFileViewer.this.pageView_.setViewSize(d2);
                    SpooledFileViewer.this.zoomPercentage_ = this.zoomAmount * 100.0f;
                    SpooledFileViewer.this.updateViewer();
                }
            }
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                Rectangle bounds = this.getParent().getBounds();
                Rectangle bounds2 = this.getBounds();
                this.setLocation(bounds.x + (bounds.width - bounds2.width) / 2, bounds.y + (bounds.height - bounds2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class WarningDialogBox_
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        String property;
        int value;

        public WarningDialogBox_(JFrame parent, String warning, String prop, int val) {
            super(parent, warningText_, true);
            this.property = prop;
            this.value = val;
            this.getContentPane().setLayout(new BorderLayout());
            this.setSize(250, 150);
            JTextArea desc = new JTextArea(warning);
            desc.setEditable(false);
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(1));
            textPanel.add(desc);
            this.getContentPane().add("Center", textPanel);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            this.getContentPane().add("South", buttonPanel);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    WarningDialogBox_.this.setVisible(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.setVisible(false);
            if (!command.equals("cancel")) {
                if (this.property.equals("viewingFidelity")) {
                    try {
                        SpooledFileViewer.this.setViewingFidelity(this.value);
                        SpooledFileViewer.this.load();
                    }
                    catch (Exception exception) {}
                } else if (this.property.equals("paperSize")) {
                    try {
                        SpooledFileViewer.this.setPaperSize(this.value);
                        SpooledFileViewer.this.load();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                Rectangle bounds = this.getParent().getBounds();
                Rectangle bounds2 = this.getBounds();
                this.setLocation(bounds.x + (bounds.width - bounds2.width) / 2, bounds.y + (bounds.height - bounds2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class GoToBox_
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        TextField pageNumber;

        public GoToBox_(JFrame parent) {
            super(parent, goToPageText_, true);
            this.setResizable(false);
            this.getContentPane().setLayout(new BorderLayout());
            this.setSize(250, 100);
            JLabel desc = new JLabel(goToPageText_);
            this.pageNumber = new TextField("1", 6);
            this.pageNumber.setBackground(new Color(255, 255, 255));
            this.pageNumber.setEditable(true);
            this.pageNumber.setVisible(true);
            this.pageNumber.addActionListener(this);
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(1));
            textPanel.add(desc);
            textPanel.add(this.pageNumber);
            this.getContentPane().add("Center", textPanel);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            this.getContentPane().add("South", buttonPanel);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    GoToBox_.this.setVisible(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.setVisible(false);
            if (!command.equals("cancel")) {
                try {
                    SpooledFileViewer.this.setCurrentPage(Integer.valueOf(this.pageNumber.getText()));
                    SpooledFileViewer.this.loadPage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                Rectangle bounds = this.getParent().getBounds();
                Rectangle bounds2 = this.getBounds();
                this.setLocation(bounds.x + (bounds.width - bounds2.width) / 2, bounds.y + (bounds.height - bounds2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class ViewingFidelityBox_
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        final JList dataList;

        public ViewingFidelityBox_(JFrame parent) {
            super(parent, vFidelityText_, true);
            this.setResizable(false);
            this.getContentPane().setLayout(new BorderLayout());
            this.setSize(300, 175);
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(1));
            textPanel.add(new JLabel(curVFidelityText_ + " : " + viewingFidelities[SpooledFileViewer.this.viewingFidelity_]));
            this.getContentPane().add("North", textPanel);
            this.dataList = new JList<String>(viewingFidelities);
            this.dataList.setSelectedIndex(SpooledFileViewer.this.viewingFidelity_);
            JScrollPane scrollPane = new JScrollPane(this.dataList);
            this.getContentPane().add("Center", scrollPane);
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int index = ViewingFidelityBox_.this.dataList.locationToIndex(e.getPoint());
                        ViewingFidelityBox_.this.setVisible(false);
                        SpooledFileViewer.this.displayPropertyChangeWarning("viewingFidelity", index);
                    }
                }
            };
            this.dataList.addMouseListener(mouseListener);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            this.getContentPane().add("South", buttonPanel);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    ViewingFidelityBox_.this.setVisible(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.setVisible(false);
            if (command.equals("ok")) {
                int index = this.dataList.getSelectedIndex();
                SpooledFileViewer.this.displayPropertyChangeWarning("viewingFidelity", index);
                SpooledFileViewer.this.updateViewer();
            }
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                Rectangle bounds = this.getParent().getBounds();
                Rectangle bounds2 = this.getBounds();
                this.setLocation(bounds.x + (bounds.width - bounds2.width) / 2, bounds.y + (bounds.height - bounds2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class PaperSizeBox_
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        final JList dataList;

        public PaperSizeBox_(JFrame parent) {
            super(parent, paperSizeText_, true);
            this.setResizable(false);
            this.getContentPane().setLayout(new BorderLayout());
            this.setSize(300, 175);
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(1));
            textPanel.add(new JLabel(curPaperText_ + " : " + paperSizes[SpooledFileViewer.this.paperSize_]));
            this.getContentPane().add("North", textPanel);
            this.dataList = new JList<String>(paperSizes);
            JScrollPane scrollPane = new JScrollPane(this.dataList);
            this.getContentPane().add("Center", scrollPane);
            this.dataList.setSelectedIndex(SpooledFileViewer.this.paperSize_);
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int index = PaperSizeBox_.this.dataList.locationToIndex(e.getPoint());
                        PaperSizeBox_.this.setVisible(false);
                        SpooledFileViewer.this.displayPropertyChangeWarning("paperSize", index);
                    }
                }
            };
            this.dataList.addMouseListener(mouseListener);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            this.getContentPane().add("South", buttonPanel);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    PaperSizeBox_.this.setVisible(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.setVisible(false);
            if (command.equals("ok")) {
                int index = this.dataList.getSelectedIndex();
                SpooledFileViewer.this.displayPropertyChangeWarning("paperSize", index);
                SpooledFileViewer.this.updateViewer();
            }
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                Rectangle bounds = this.getParent().getBounds();
                Rectangle bounds2 = this.getBounds();
                this.setLocation(bounds.x + (bounds.width - bounds2.width) / 2, bounds.y + (bounds.height - bounds2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class SpooledFilePageView_
    extends JLabel {
        Dimension viewSize_;

        public SpooledFilePageView_() {
            this.viewSize_ = new Dimension(SpooledFileViewer.this.currentPageImage_.getWidth(this), SpooledFileViewer.this.currentPageImage_.getHeight(this));
        }

        public synchronized void clearView() {
            Rectangle r = this.getVisibleRect();
            this.getGraphics().clearRect(r.x, r.y, r.width, r.height);
        }

        @Override
        public int getHeight() {
            if (this.viewSize_ == null) {
                return 10;
            }
            return this.viewSize_.height;
        }

        @Override
        public int getWidth() {
            if (this.viewSize_ == null) {
                return 10;
            }
            return this.viewSize_.width;
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(SpooledFileViewer.this.currentPageImage_, 0, 0, this.viewSize_.width, this.viewSize_.height, this);
        }

        public void setViewSize(Dimension d) {
            this.viewSize_.width = d.width;
            this.viewSize_.height = d.height;
        }

        @Override
        public void update(Graphics g) {
            this.clearView();
            this.paint(g);
        }
    }

    private class ViewerActionListener_
    implements ActionListener {
        private ViewerActionListener_() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            try {
                if (command.equals("actualSize")) {
                    SpooledFileViewer.this.actualSize();
                } else if (command.equals("fitWidth")) {
                    SpooledFileViewer.this.fitWidth();
                } else if (command.equals("fitPage")) {
                    SpooledFileViewer.this.fitPage();
                } else if (command.equals("zoom")) {
                    SpooledFileViewer.this.changeZoom();
                } else if (command.equals("goToPage")) {
                    SpooledFileViewer.this.changeCurrentPage();
                } else if (command.equals("firstPage")) {
                    SpooledFileViewer.this.setCurrentPage(1);
                    SpooledFileViewer.this.loadPage();
                } else if (command.equals("prevPage")) {
                    SpooledFileViewer.this.pageBack();
                } else if (command.equals("nextPage")) {
                    SpooledFileViewer.this.pageForward();
                } else if (command.equals("lastPage")) {
                    SpooledFileViewer.this.setCurrentPage(SpooledFileViewer.this.numberOfPages_);
                    SpooledFileViewer.this.loadPage();
                } else if (command.equals("flashPage")) {
                    SpooledFileViewer.this.loadFlashPage();
                } else if (command.equals("changeViewingFidelity")) {
                    SpooledFileViewer.this.changeViewingFidelity();
                } else if (command.equals("changePaperSize")) {
                    SpooledFileViewer.this.changePaperSize();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

