/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.MutablePDU;
import org.snmp4j.PDU;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.event.AuthenticationFailureEvent;
import org.snmp4j.event.AuthenticationFailureListener;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.MutableStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.UnsupportedAddressClassException;

public class MessageDispatcherImpl
implements MessageDispatcher {
    private static final LogAdapter logger = LogFactory.getLogger(MessageDispatcherImpl.class);
    private Vector mpm = new Vector(3);
    private Map transportMappings = new Hashtable(5);
    private int nextTransactionID = new Random().nextInt(0x7FFFFFFD) + 1;
    private transient Vector commandResponderListeners;
    private transient Vector counterListeners;
    private transient Vector authenticationFailureListeners;
    private boolean checkOutgoingMsg = true;

    public synchronized void addMessageProcessingModel(MessageProcessingModel messageProcessingModel) {
        while (this.mpm.size() <= messageProcessingModel.getID()) {
            this.mpm.add(null);
        }
        if (this.mpm.get(messageProcessingModel.getID()) == null) {
            this.mpm.set(messageProcessingModel.getID(), messageProcessingModel);
        }
    }

    public synchronized void removeMessageProcessingModel(MessageProcessingModel messageProcessingModel) {
        this.mpm.set(messageProcessingModel.getID(), null);
    }

    public synchronized void addTransportMapping(TransportMapping transportMapping) {
        LinkedList<TransportMapping> linkedList = (LinkedList<TransportMapping>)this.transportMappings.get(transportMapping.getSupportedAddressClass());
        if (linkedList == null) {
            linkedList = new LinkedList<TransportMapping>();
            this.transportMappings.put(transportMapping.getSupportedAddressClass(), linkedList);
        }
        linkedList.add(transportMapping);
    }

    public TransportMapping removeTransportMapping(TransportMapping transportMapping) {
        List list = (List)this.transportMappings.remove(transportMapping.getSupportedAddressClass());
        if (list != null && list.remove(transportMapping)) {
            return transportMapping;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTransportMappings() {
        ArrayList arrayList = new ArrayList(this.transportMappings.size());
        Map map = this.transportMappings;
        synchronized (map) {
            Iterator iterator = this.transportMappings.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public synchronized int getNextRequestID() {
        int n;
        if ((n = this.nextTransactionID++) <= 0) {
            n = 1;
            this.nextTransactionID = 2;
        }
        return n;
    }

    protected PduHandle createPduHandle() {
        return new PduHandle(this.getNextRequestID());
    }

    protected void sendMessage(TransportMapping transportMapping, Address address, byte[] byArray) throws IOException {
        if (address instanceof GenericAddress) {
            address = ((GenericAddress)address).getAddress();
        }
        if (transportMapping == null) {
            String string = "No transport mapping for address class: " + address.getClass().getName() + "=" + address;
            logger.error(string);
            throw new IOException(string);
        }
        transportMapping.sendMessage(address, byArray);
    }

    public TransportMapping getTransport(Address address) {
        Class<?> clazz = address.getClass();
        List list = (List)this.transportMappings.get(clazz);
        if (list != null && list.size() > 0) {
            TransportMapping transportMapping = (TransportMapping)list.get(0);
            return transportMapping;
        }
        return null;
    }

    protected void dispatchMessage(TransportMapping transportMapping, MessageProcessingModel messageProcessingModel, Address address, BERInputStream bERInputStream) throws IOException {
        MutablePDU mutablePDU = new MutablePDU();
        Integer32 integer32 = new Integer32();
        Integer32 integer322 = new Integer32();
        OctetString octetString = new OctetString();
        Integer32 integer323 = new Integer32();
        PduHandle pduHandle = this.createPduHandle();
        Integer32 integer324 = new Integer32(transportMapping.getMaxInboundMessageSize());
        StatusInformation statusInformation = new StatusInformation();
        MutableStateReference mutableStateReference = new MutableStateReference();
        StateReference stateReference = new StateReference();
        stateReference.setTransportMapping(transportMapping);
        stateReference.setAddress(address);
        mutableStateReference.setStateReference(stateReference);
        int n = messageProcessingModel.prepareDataElements(this, address, bERInputStream, integer32, integer322, octetString, integer323, mutablePDU, pduHandle, integer324, statusInformation, mutableStateReference);
        if (mutableStateReference.getStateReference() != null) {
            mutableStateReference.getStateReference().setTransportMapping(transportMapping);
        }
        if (n == 0) {
            CommandResponderEvent commandResponderEvent = new CommandResponderEvent(this, transportMapping, address, integer32.getValue(), integer322.getValue(), octetString.getValue(), integer323.getValue(), pduHandle, mutablePDU.getPdu(), integer324.getValue(), mutableStateReference.getStateReference());
            this.fireProcessPdu(commandResponderEvent);
        } else {
            switch (n) {
                case -1414: 
                case -1412: 
                case -1402: {
                    AuthenticationFailureEvent authenticationFailureEvent = new AuthenticationFailureEvent(this, address, transportMapping, n, bERInputStream);
                    this.fireAuthenticationFailure(authenticationFailureEvent);
                    break;
                }
            }
            logger.warn(statusInformation.toString());
        }
    }

    public void processMessage(TransportMapping transportMapping, Address address, ByteBuffer byteBuffer) {
        this.processMessage(transportMapping, address, new BERInputStream(byteBuffer));
    }

    public void processMessage(TransportMapping transportMapping, Address address, BERInputStream bERInputStream) {
        block9: {
            this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpInPkts));
            if (!bERInputStream.markSupported()) {
                String string = "Message stream must support marks";
                logger.error(string);
                throw new IllegalArgumentException(string);
            }
            try {
                Serializable serializable;
                bERInputStream.mark(16);
                BER.MutableByte mutableByte = new BER.MutableByte();
                BER.decodeHeader(bERInputStream, mutableByte, false);
                if (mutableByte.getValue() != 48) {
                    logger.error("ASN.1 parse error (message is not a sequence)");
                    serializable = new CounterEvent(this, SnmpConstants.snmpInASNParseErrs);
                    this.fireIncrementCounter((CounterEvent)serializable);
                }
                serializable = new Integer32();
                ((Integer32)serializable).decodeBER(bERInputStream);
                MessageProcessingModel messageProcessingModel = this.getMessageProcessingModel(((Integer32)serializable).getValue());
                if (messageProcessingModel == null) {
                    logger.warn("SNMP version " + serializable + " is not supported");
                    CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.snmpInBadVersions);
                    this.fireIncrementCounter(counterEvent);
                } else {
                    bERInputStream.reset();
                    this.dispatchMessage(transportMapping, messageProcessingModel, address, bERInputStream);
                }
            }
            catch (Exception exception) {
                logger.error(exception);
                if (logger.isDebugEnabled()) {
                    exception.printStackTrace();
                }
                if (SNMP4JSettings.isFowardRuntimeExceptions()) {
                    throw new RuntimeException(exception);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.error(outOfMemoryError);
                if (!SNMP4JSettings.isFowardRuntimeExceptions()) break block9;
                throw outOfMemoryError;
            }
        }
    }

    public PduHandle sendPdu(Address address, int n, int n2, byte[] byArray, int n3, PDU pDU, boolean bl) throws MessageException {
        return this.sendPdu(null, address, n, n2, byArray, n3, pDU, bl);
    }

    public PduHandle sendPdu(TransportMapping transportMapping, Address address, int n, int n2, byte[] byArray, int n3, PDU pDU, boolean bl, PduHandleCallback pduHandleCallback) throws MessageException {
        try {
            MessageProcessingModel messageProcessingModel = this.getMessageProcessingModel(n);
            if (messageProcessingModel == null) {
                throw new MessageException("Unsupported message processing model: " + n);
            }
            if (!messageProcessingModel.isProtocolVersionSupported(n)) {
                throw new MessageException("SNMP version " + n + " is not supported " + "by message processing model " + n);
            }
            if (transportMapping == null) {
                transportMapping = this.getTransport(address);
            }
            if (transportMapping == null) {
                throw new UnsupportedAddressClassException("Unsupported address class (transport mapping): " + address.getClass().getName(), address.getClass());
            }
            if (pDU.isConfirmedPdu()) {
                MessageDispatcherImpl.checkListening4ConfirmedPDU(pDU, address, transportMapping);
            }
            this.checkOutgoingMsg(address, n, pDU);
            PduHandle pduHandle = pDU.getRequestID().getValue() == 0 && pDU.getType() != -94 ? this.createPduHandle() : new PduHandle(pDU.getRequestID().getValue());
            pDU.setRequestID(new Integer32(pduHandle.getTransactionID()));
            GenericAddress genericAddress = new GenericAddress();
            BEROutputStream bEROutputStream = new BEROutputStream();
            int n4 = messageProcessingModel.prepareOutgoingMessage(address, transportMapping.getMaxInboundMessageSize(), n, n2, byArray, n3, pDU, bl, pduHandle, genericAddress, bEROutputStream);
            if (n4 == 0) {
                if (pduHandleCallback != null) {
                    pduHandleCallback.pduHandleAssigned(pduHandle, pDU);
                }
            } else {
                throw new MessageException("Message processing model " + messageProcessingModel.getID() + " returned error: " + n4);
            }
            byte[] byArray2 = bEROutputStream.getBuffer().array();
            this.sendMessage(transportMapping, address, byArray2);
            return pduHandle;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new MessageException("Unsupported message processing model: " + n);
        }
        catch (MessageException messageException) {
            if (logger.isDebugEnabled()) {
                messageException.printStackTrace();
            }
            throw messageException;
        }
        catch (IOException iOException) {
            if (logger.isDebugEnabled()) {
                iOException.printStackTrace();
            }
            throw new MessageException(iOException.getMessage());
        }
    }

    private static void checkListening4ConfirmedPDU(PDU pDU, Address address, TransportMapping transportMapping) {
        if (transportMapping != null && !transportMapping.isListening()) {
            logger.warn("Sending confirmed PDU " + pDU + " to target " + address + " although transport mapping " + transportMapping + " is not listening for a response");
        }
    }

    protected void checkOutgoingMsg(Address address, int n, PDU pDU) throws MessageException {
        if (this.checkOutgoingMsg && n == 0 && pDU.getType() == -91) {
            logger.warn("Converting GETBULK PDU to GETNEXT for SNMPv1 target: " + address);
            pDU.setType(-95);
            pDU.setMaxRepetitions(0);
        }
    }

    public int returnResponsePdu(int n, int n2, byte[] byArray, int n3, PDU pDU, int n4, StateReference stateReference, StatusInformation statusInformation) throws MessageException {
        try {
            MessageProcessingModel messageProcessingModel = this.getMessageProcessingModel(n);
            if (messageProcessingModel == null) {
                throw new MessageException("Unsupported message processing model: " + n);
            }
            TransportMapping transportMapping = stateReference.getTransportMapping();
            if (transportMapping == null) {
                transportMapping = this.getTransport(stateReference.getAddress());
            }
            if (transportMapping == null) {
                throw new MessageException("Unsupported address class (transport mapping): " + stateReference.getAddress().getClass().getName());
            }
            BEROutputStream bEROutputStream = new BEROutputStream();
            int n5 = messageProcessingModel.prepareResponseMessage(n, transportMapping.getMaxInboundMessageSize(), n2, byArray, n3, pDU, n4, stateReference, statusInformation, bEROutputStream);
            if (n5 == 0) {
                this.sendMessage(transportMapping, stateReference.getAddress(), bEROutputStream.getBuffer().array());
            }
            return n5;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageException("Unsupported message processing model: " + n);
        }
        catch (IOException iOException) {
            throw new MessageException(iOException.getMessage());
        }
    }

    public void releaseStateReference(int n, PduHandle pduHandle) {
        MessageProcessingModel messageProcessingModel = this.getMessageProcessingModel(n);
        if (messageProcessingModel == null) {
            throw new IllegalArgumentException("Unsupported message processing model: " + n);
        }
        messageProcessingModel.releaseStateReference(pduHandle);
    }

    public synchronized void removeCommandResponder(CommandResponder commandResponder) {
        if (this.commandResponderListeners != null && this.commandResponderListeners.contains(commandResponder)) {
            Vector vector = (Vector)this.commandResponderListeners.clone();
            vector.removeElement(commandResponder);
            this.commandResponderListeners = vector;
        }
    }

    public synchronized void addCommandResponder(CommandResponder commandResponder) {
        Vector vector;
        Vector vector2 = vector = this.commandResponderListeners == null ? new Vector(2) : (Vector)this.commandResponderListeners.clone();
        if (!vector.contains(commandResponder)) {
            vector.addElement(commandResponder);
            this.commandResponderListeners = vector;
        }
    }

    protected void fireProcessPdu(CommandResponderEvent commandResponderEvent) {
        if (this.commandResponderListeners != null) {
            Vector vector = this.commandResponderListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CommandResponder)vector.elementAt(i)).processPdu(commandResponderEvent);
                if (!commandResponderEvent.isProcessed()) continue;
                return;
            }
        }
    }

    public MessageProcessingModel getMessageProcessingModel(int n) {
        try {
            return (MessageProcessingModel)this.mpm.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public synchronized void removeCounterListener(CounterListener counterListener) {
        if (this.counterListeners != null && this.counterListeners.contains(counterListener)) {
            Vector vector = (Vector)this.counterListeners.clone();
            vector.removeElement(counterListener);
            this.counterListeners = vector;
        }
    }

    public synchronized void addCounterListener(CounterListener counterListener) {
        Vector vector;
        Vector vector2 = vector = this.counterListeners == null ? new Vector(2) : (Vector)this.counterListeners.clone();
        if (!vector.contains(counterListener)) {
            vector.addElement(counterListener);
            this.counterListeners = vector;
        }
    }

    protected void fireIncrementCounter(CounterEvent counterEvent) {
        if (this.counterListeners != null) {
            Vector vector = this.counterListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CounterListener)vector.elementAt(i)).incrementCounter(counterEvent);
            }
        }
    }

    public void setCheckOutgoingMsg(boolean bl) {
        this.checkOutgoingMsg = bl;
    }

    public boolean isCheckOutgoingMsg() {
        return this.checkOutgoingMsg;
    }

    public synchronized void addAuthenticationFailureListener(AuthenticationFailureListener authenticationFailureListener) {
        Vector vector;
        Vector vector2 = vector = this.authenticationFailureListeners == null ? new Vector(2) : (Vector)this.authenticationFailureListeners.clone();
        if (!vector.contains(authenticationFailureListener)) {
            vector.addElement(authenticationFailureListener);
            this.authenticationFailureListeners = vector;
        }
    }

    public synchronized void removeAuthenticationFailureListener(AuthenticationFailureListener authenticationFailureListener) {
        if (this.authenticationFailureListeners != null && this.authenticationFailureListeners.contains(authenticationFailureListener)) {
            Vector vector = (Vector)this.authenticationFailureListeners.clone();
            vector.removeElement(authenticationFailureListener);
            this.authenticationFailureListeners = vector;
        }
    }

    protected void fireAuthenticationFailure(AuthenticationFailureEvent authenticationFailureEvent) {
        if (this.authenticationFailureListeners != null) {
            Vector vector = this.authenticationFailureListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((AuthenticationFailureListener)vector.elementAt(i)).authenticationFailure(authenticationFailureEvent);
            }
        }
    }

    public PduHandle sendPdu(TransportMapping transportMapping, Address address, int n, int n2, byte[] byArray, int n3, PDU pDU, boolean bl) throws MessageException {
        return this.sendPdu(transportMapping, address, n, n2, byArray, n3, pDU, bl, null);
    }
}

