/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

@InterfaceAudience.Private
class InvalidateBlocks {
    private final Map<DatanodeInfo, LightWeightHashSet<Block>> nodeToBlocks = new HashMap<DatanodeInfo, LightWeightHashSet<Block>>();
    private final Map<DatanodeInfo, LightWeightHashSet<Block>> nodeToECBlocks = new HashMap<DatanodeInfo, LightWeightHashSet<Block>>();
    private final LongAdder numBlocks = new LongAdder();
    private final LongAdder numECBlocks = new LongAdder();
    private final int blockInvalidateLimit;
    private final long pendingPeriodInMs;
    private final long startupTime = Time.monotonicNow();

    InvalidateBlocks(int blockInvalidateLimit, long pendingPeriodInMs) {
        this.blockInvalidateLimit = blockInvalidateLimit;
        this.pendingPeriodInMs = pendingPeriodInMs;
        this.printBlockDeletionTime(BlockManager.LOG);
    }

    private void printBlockDeletionTime(Logger log) {
        log.info("{} is set to {}", (Object)"dfs.namenode.startup.delay.block.deletion.sec", (Object)DFSUtil.durationToString(this.pendingPeriodInMs));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy MMM dd HH:mm:ss");
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(13, (int)(this.pendingPeriodInMs / 1000L));
        log.info("The block deletion will start around {}", (Object)sdf.format(calendar.getTime()));
    }

    long numBlocks() {
        return this.getECBlocks() + this.getBlocks();
    }

    long getBlocks() {
        return this.numBlocks.longValue();
    }

    long getECBlocks() {
        return this.numECBlocks.longValue();
    }

    private LightWeightHashSet<Block> getBlocksSet(DatanodeInfo dn) {
        if (this.nodeToBlocks.containsKey(dn)) {
            return this.nodeToBlocks.get(dn);
        }
        return null;
    }

    private LightWeightHashSet<Block> getECBlocksSet(DatanodeInfo dn) {
        if (this.nodeToECBlocks.containsKey(dn)) {
            return this.nodeToECBlocks.get(dn);
        }
        return null;
    }

    private LightWeightHashSet<Block> getBlocksSet(DatanodeInfo dn, Block block) {
        if (BlockIdManager.isStripedBlockID(block.getBlockId())) {
            return this.getECBlocksSet(dn);
        }
        return this.getBlocksSet(dn);
    }

    private void putBlocksSet(DatanodeInfo dn, Block block, LightWeightHashSet set) {
        if (BlockIdManager.isStripedBlockID(block.getBlockId())) {
            assert (this.getECBlocksSet(dn) == null);
            this.nodeToECBlocks.put(dn, set);
        } else {
            assert (this.getBlocksSet(dn) == null);
            this.nodeToBlocks.put(dn, set);
        }
    }

    private long getBlockSetsSize(DatanodeInfo dn) {
        LightWeightHashSet<Block> replicaBlocks = this.getBlocksSet(dn);
        LightWeightHashSet<Block> stripedBlocks = this.getECBlocksSet(dn);
        return (replicaBlocks == null ? 0 : replicaBlocks.size()) + (stripedBlocks == null ? 0 : stripedBlocks.size());
    }

    synchronized boolean contains(DatanodeInfo dn, Block block) {
        LightWeightHashSet<Block> s = this.getBlocksSet(dn, block);
        if (s == null) {
            return false;
        }
        Block blockInSet = s.getElement(block);
        return blockInSet != null && block.getGenerationStamp() == blockInSet.getGenerationStamp();
    }

    synchronized void add(Block block, DatanodeInfo datanode, boolean log) {
        LightWeightHashSet<Object> set = this.getBlocksSet(datanode, block);
        if (set == null) {
            set = new LightWeightHashSet();
            this.putBlocksSet(datanode, block, set);
        }
        if (set.add(block)) {
            if (BlockIdManager.isStripedBlockID(block.getBlockId())) {
                this.numECBlocks.increment();
            } else {
                this.numBlocks.increment();
            }
            if (log) {
                NameNode.blockStateChangeLog.debug("BLOCK* {}: add {} to {}", new Object[]{this.getClass().getSimpleName(), block, datanode});
            }
        }
    }

    synchronized void remove(DatanodeInfo dn) {
        LightWeightHashSet<Block> ecBlocksSet;
        LightWeightHashSet<Block> replicaBlockSets = this.nodeToBlocks.remove(dn);
        if (replicaBlockSets != null) {
            this.numBlocks.add(replicaBlockSets.size() * -1);
        }
        if ((ecBlocksSet = this.nodeToECBlocks.remove(dn)) != null) {
            this.numECBlocks.add(ecBlocksSet.size() * -1);
        }
    }

    synchronized void remove(DatanodeInfo dn, Block block) {
        LightWeightHashSet<Block> v = this.getBlocksSet(dn, block);
        if (v != null && v.remove(block)) {
            if (BlockIdManager.isStripedBlockID(block.getBlockId())) {
                this.numECBlocks.decrement();
            } else {
                this.numBlocks.decrement();
            }
            if (v.isEmpty() && this.getBlockSetsSize(dn) == 0L) {
                this.remove(dn);
            }
        }
    }

    private void dumpBlockSet(Map<DatanodeInfo, LightWeightHashSet<Block>> nodeToBlocksMap, PrintWriter out) {
        for (Map.Entry<DatanodeInfo, LightWeightHashSet<Block>> entry : nodeToBlocksMap.entrySet()) {
            LightWeightHashSet<Block> blocks = entry.getValue();
            if (blocks == null || blocks.size() <= 0) continue;
            out.println(entry.getKey());
            out.println(StringUtils.join((char)',', blocks));
        }
    }

    synchronized void dump(PrintWriter out) {
        int size = this.nodeToBlocks.values().size() + this.nodeToECBlocks.values().size();
        out.println("Metasave: Blocks " + this.numBlocks() + " waiting deletion from " + size + " datanodes.");
        if (size == 0) {
            return;
        }
        this.dumpBlockSet(this.nodeToBlocks, out);
        this.dumpBlockSet(this.nodeToECBlocks, out);
    }

    synchronized List<DatanodeInfo> getDatanodes() {
        HashSet<DatanodeInfo> set = new HashSet<DatanodeInfo>();
        set.addAll(this.nodeToBlocks.keySet());
        set.addAll(this.nodeToECBlocks.keySet());
        return new ArrayList<DatanodeInfo>(set);
    }

    @VisibleForTesting
    long getInvalidationDelay() {
        return this.pendingPeriodInMs - (Time.monotonicNow() - this.startupTime);
    }

    private int getBlocksToInvalidateByLimit(LightWeightHashSet<Block> blockSet, List<Block> toInvalidate, LongAdder statsAdder, int limit) {
        assert (blockSet != null);
        int remainingLimit = limit;
        List<Block> polledBlocks = blockSet.pollN(limit);
        toInvalidate.addAll(polledBlocks);
        statsAdder.add(polledBlocks.size() * -1);
        return remainingLimit -= polledBlocks.size();
    }

    synchronized List<Block> invalidateWork(DatanodeDescriptor dn) {
        long delay = this.getInvalidationDelay();
        if (delay > 0L) {
            BlockManager.LOG.debug("Block deletion is delayed during NameNode startup. The deletion will start after {} ms.", (Object)delay);
            return null;
        }
        int remainingLimit = this.blockInvalidateLimit;
        ArrayList<Block> toInvalidate = new ArrayList<Block>();
        if (this.nodeToBlocks.get((Object)dn) != null) {
            remainingLimit = this.getBlocksToInvalidateByLimit(this.nodeToBlocks.get((Object)dn), toInvalidate, this.numBlocks, remainingLimit);
        }
        if (remainingLimit > 0 && this.nodeToECBlocks.get((Object)dn) != null) {
            this.getBlocksToInvalidateByLimit(this.nodeToECBlocks.get((Object)dn), toInvalidate, this.numECBlocks, remainingLimit);
        }
        if (toInvalidate.size() > 0) {
            if (this.getBlockSetsSize(dn) == 0L) {
                this.remove(dn);
            }
            dn.addBlocksToBeInvalidated(toInvalidate);
        }
        return toInvalidate;
    }

    synchronized void clear() {
        this.nodeToBlocks.clear();
        this.nodeToECBlocks.clear();
        this.numBlocks.reset();
        this.numECBlocks.reset();
    }
}

