/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.delay;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.delay.DelayData;
import org.apache.hop.pipeline.transforms.delay.DelayMeta;

public class Delay
extends BaseTransform<DelayMeta, DelayData> {
    private static final Class<?> PKG = DelayMeta.class;

    public Delay(TransformMeta transformMeta, DelayMeta meta, DelayData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            String msgScale;
            this.first = false;
            switch (((DelayMeta)this.meta).getScaleTimeCode()) {
                case 0: {
                    msgScale = BaseMessages.getString(PKG, (String)"DelayDialog.MSScaleTime.Label", (String[])new String[0]);
                    ((DelayData)this.data).Multiple = 1;
                    break;
                }
                case 1: {
                    msgScale = BaseMessages.getString(PKG, (String)"DelayDialog.SScaleTime.Label", (String[])new String[0]);
                    ((DelayData)this.data).Multiple = 1000;
                    break;
                }
                case 2: {
                    msgScale = BaseMessages.getString(PKG, (String)"DelayDialog.MnScaleTime.Label", (String[])new String[0]);
                    ((DelayData)this.data).Multiple = 60000;
                    break;
                }
                case 3: {
                    msgScale = BaseMessages.getString(PKG, (String)"DelayDialog.HrScaleTime.Label", (String[])new String[0]);
                    ((DelayData)this.data).Multiple = 3600000;
                    break;
                }
                default: {
                    msgScale = "Unknown Scale";
                    ((DelayData)this.data).Multiple = 1;
                }
            }
            String timeOut = this.resolve(((DelayMeta)this.meta).getTimeout());
            ((DelayData)this.data).timeout = Const.toInt((String)timeOut, (int)0);
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"Delay.Log.TimeOut", (String[])new String[]{"" + ((DelayData)this.data).timeout, msgScale}));
            }
        }
        if (((DelayData)this.data).Multiple < 1000 && ((DelayData)this.data).timeout > 0) {
            try {
                Thread.sleep(((DelayData)this.data).timeout);
            }
            catch (Exception msgScale) {}
        } else {
            long timeStart = System.currentTimeMillis();
            boolean continueLoop = true;
            while (continueLoop && !this.isStopped()) {
                long now = System.currentTimeMillis();
                if (now >= timeStart + (long)(((DelayData)this.data).timeout * ((DelayData)this.data).Multiple)) {
                    continueLoop = false;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"Delay.WaitTimeIsElapsed.Label", (String[])new String[0]));
        }
        this.putRow(this.getInputRowMeta(), r);
        if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"Delay.Log.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
        }
        return true;
    }
}

