/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction.graph;

import com.google.auto.value.AutoValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.util.construction.SyntheticComponents;
import org.apache.beam.sdk.util.construction.graph.AutoValue_FusedPipeline;
import org.apache.beam.sdk.util.construction.graph.ExecutableStage;
import org.apache.beam.sdk.util.construction.graph.PipelineNode;
import org.apache.beam.sdk.util.construction.graph.PipelineValidator;
import org.apache.beam.sdk.util.construction.graph.QueryablePipeline;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class FusedPipeline {
    static @UnknownKeyFor @NonNull @Initialized FusedPipeline of(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ExecutableStage> environmentalStages, @UnknownKeyFor @NonNull @Initialized Set< @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> runnerStages, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements) {
        return new AutoValue_FusedPipeline(components, environmentalStages, runnerStages, requirements);
    }

    abstract // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components getComponents();

    public abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ExecutableStage> getFusedStages();

    public abstract @UnknownKeyFor @NonNull @Initialized Set< @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getRunnerExecutedTransforms();

    public abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getRequirements();

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline toPipeline() {
        Map<String, RunnerApi.PTransform> executableStageTransforms = this.getEnvironmentExecutedTransforms();
        Sets.SetView executableTransformIds = Sets.union(executableStageTransforms.keySet(), this.getRunnerExecutedTransforms().stream().map(PipelineNode.PTransformNode::getId).collect(Collectors.toSet()));
        RunnerApi.Components fusedComponents = this.getComponents().toBuilder().putAllTransforms(executableStageTransforms).build();
        List rootTransformIds = StreamSupport.stream(QueryablePipeline.forTransforms((Collection<String>)executableTransformIds, fusedComponents).getTopologicallyOrderedTransforms().spliterator(), false).map(PipelineNode.PTransformNode::getId).collect(Collectors.toList());
        RunnerApi.Pipeline res = RunnerApi.Pipeline.newBuilder().setComponents(fusedComponents).addAllRootTransformIds(rootTransformIds).addAllRequirements(this.getRequirements()).build();
        PipelineValidator.validate(res);
        return res;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform> getEnvironmentExecutedTransforms() {
        HashMap<String, RunnerApi.PTransform> topLevelTransforms = new HashMap<String, RunnerApi.PTransform>();
        for (ExecutableStage stage : this.getFusedStages()) {
            String baseName = String.format("%s/%s", stage.getInputPCollection().getPCollection().getUniqueName(), stage.getEnvironment().getUrn());
            Sets.SetView usedNames = Sets.union(topLevelTransforms.keySet(), this.getComponents().getTransformsMap().keySet());
            String uniqueId = SyntheticComponents.uniqueId(baseName, ((Set)usedNames)::contains);
            topLevelTransforms.put(uniqueId, stage.toPTransform(uniqueId));
        }
        return topLevelTransforms;
    }
}

