/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts;

import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.internal.AltsInternalContext;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.internal.HandshakerResult;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.internal.Identity;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7864")
public final class AltsContext {
    private final AltsInternalContext wrapped;

    AltsContext(AltsInternalContext wrapped) {
        this.wrapped = wrapped;
    }

    public static AltsContext createTestInstance(String peerServiceAccount, String localServiceAccount) {
        return new AltsContext(new AltsInternalContext(HandshakerResult.newBuilder().setPeerIdentity(Identity.newBuilder().setServiceAccount(peerServiceAccount).build()).setLocalIdentity(Identity.newBuilder().setServiceAccount(localServiceAccount).build()).build()));
    }

    public SecurityLevel getSecurityLevel() {
        switch (this.wrapped.getSecurityLevel()) {
            case SECURITY_NONE: {
                return SecurityLevel.SECURITY_NONE;
            }
            case INTEGRITY_ONLY: {
                return SecurityLevel.INTEGRITY_ONLY;
            }
            case INTEGRITY_AND_PRIVACY: {
                return SecurityLevel.INTEGRITY_AND_PRIVACY;
            }
        }
        return SecurityLevel.UNKNOWN;
    }

    public String getPeerServiceAccount() {
        return this.wrapped.getPeerServiceAccount();
    }

    public String getLocalServiceAccount() {
        return this.wrapped.getLocalServiceAccount();
    }

    public static enum SecurityLevel {
        UNKNOWN,
        SECURITY_NONE,
        INTEGRITY_ONLY,
        INTEGRITY_AND_PRIVACY;

    }
}

