/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConverterImpl;
import java.io.Serializable;

class NPCodePoint
implements Cloneable,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int SPOOLED_FILE_ID = 1;
    static final int WRITER_JOB_ID = 2;
    static final int OUTPUT_QUEUE_ID = 3;
    static final int PRINTER_FILE_ID = 4;
    static final int PRINTER_DEVICE_ID = 5;
    static final int SELECTION = 6;
    static final int ATTRIBUTE_LIST = 7;
    static final int ATTRIBUTE_VALUE = 8;
    static final int DATA = 9;
    static final int EXIT_PROGRAM_DATA = 10;
    static final int TARGET_SPOOLED_FILE_ID = 11;
    static final int SPOOLED_FILE_HANDLE = 12;
    static final int MESSAGE_HANDLE = 13;
    static final int LIBRARY_ID = 14;
    static final int RESOURCE_ID = 15;
    static final int RESOURCE_HANDLE = 16;
    static final int MAX_CODEPOINT_ID = 16;
    protected static final int LEN_HEADER = 6;
    private byte[] data_;
    private int ID_;
    private int length_;
    private int offset_ = 0;
    protected transient ConverterImpl converter_;

    protected Object clone() {
        NPCodePoint cp = new NPCodePoint(this);
        return cp;
    }

    NPCodePoint(NPCodePoint cp) {
        this.ID_ = cp.ID_;
        this.length_ = cp.length_;
        this.offset_ = cp.offset_;
        this.converter_ = cp.converter_;
        if (cp.data_ != null) {
            this.data_ = new byte[cp.data_.length];
            System.arraycopy(cp.data_, this.offset_, this.data_, this.offset_, this.data_.length - this.offset_);
        }
    }

    NPCodePoint() {
    }

    NPCodePoint(int ID) {
        this.setID(ID);
    }

    NPCodePoint(int ID, byte[] data) {
        this.setID(ID);
        this.data_ = data;
        this.length_ = this.data_.length;
    }

    byte[] getDataBuffer() {
        return this.data_;
    }

    byte[] getDataBuffer(int dataLength) {
        if (this.data_ == null || this.data_.length + this.offset_ < dataLength) {
            this.data_ = new byte[dataLength];
            this.offset_ = 0;
        }
        this.length_ = dataLength;
        return this.data_;
    }

    int getDataLength() {
        return this.getLength() - 6;
    }

    int getID() {
        return this.ID_;
    }

    int getOffset() {
        return this.offset_;
    }

    int getLength() {
        return this.length_ + 6;
    }

    void setDataBuffer(byte[] dataBuffer, int datalen, int offset) {
        this.data_ = dataBuffer;
        this.length_ = datalen;
        this.offset_ = offset;
    }

    void setConverter(ConverterImpl converter) {
        this.converter_ = converter;
    }

    void setID(int ID) {
        this.ID_ = ID;
    }

    void reset() {
        this.length_ = 0;
    }
}

