/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;

public class NativeErrorCode0100Exception
extends Exception {
    static final long serialVersionUID = 4L;
    private byte[] data = null;

    public NativeErrorCode0100Exception(byte[] data) {
        this.data = data;
    }

    public void throwMappedException(Converter converter) throws ObjectDoesNotExistException, AS400SecurityException, AS400Exception {
        String messageID = converter.byteArrayToString(this.data, 8, 7);
        if (messageID.equals("CPF9810")) {
            String libraryName = converter.byteArrayToString(this.data, 16, 10);
            Trace.log(2, "Library does not exist: '" + libraryName + "'");
            throw new ObjectDoesNotExistException("/QSYS.LIB/" + libraryName + ".LIB", 1);
        }
        if (messageID.equals("CPF9801")) {
            String objectName = converter.byteArrayToString(this.data, 16, 10);
            String libraryName = converter.byteArrayToString(this.data, 26, 10);
            throw new ObjectDoesNotExistException("/QSYS.LIB/" + libraryName + ".LIB/" + objectName + ".OBJ", 2);
        }
        if (messageID.equals("CPF2105")) {
            String objectName = converter.byteArrayToString(this.data, 16, 10);
            String libraryName = converter.byteArrayToString(this.data, 26, 10);
            String typeName = converter.byteArrayToString(this.data, 36, 6);
            throw new ObjectDoesNotExistException("/QSYS.LIB/" + libraryName + ".LIB/" + objectName + "." + typeName, 2);
        }
        if (messageID.equals("CPF9802")) {
            String objectName = converter.byteArrayToString(this.data, 16, 10);
            String libraryName = converter.byteArrayToString(this.data, 26, 10);
            throw new AS400SecurityException("/QSYS.LIB/" + libraryName + ".LIB/" + objectName + ".OBJ", 4);
        }
        if (messageID.equals("CPF2189")) {
            String objectName = converter.byteArrayToString(this.data, 16, 10);
            String libraryName = converter.byteArrayToString(this.data, 26, 10);
            String typeName = converter.byteArrayToString(this.data, 36, 6);
            throw new AS400SecurityException("/QSYS.LIB/" + libraryName + ".LIB/" + objectName + "." + typeName, 4);
        }
        if (messageID.equals("CPF9820") || messageID.equals("CPF2182")) {
            String libraryName = converter.byteArrayToString(this.data, 16, 10);
            throw new AS400SecurityException("/QSYS.LIB/" + libraryName + ".LIB", 3);
        }
        int substitutionDataLength = this.data.length - 16;
        byte[] substitutionData = new byte[substitutionDataLength];
        for (int i = 0; i < substitutionDataLength; ++i) {
            substitutionData[i] = this.data[16 + i];
        }
        throw new AS400Exception(new AS400Message(messageID, null, null, null, 30, 15, substitutionData, null, null, null, null));
    }
}

