/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ImmutableIntLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongIntMap;
import org.eclipse.collections.api.map.primitive.IntLongMap;
import org.eclipse.collections.api.map.primitive.MutableIntLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.IntLongPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntLongProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.LongIntMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.IntLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

final class ImmutableIntLongHashMap
implements ImmutableIntLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntLongMap delegate;

    ImmutableIntLongHashMap(IntLongMap delegate) {
        this.delegate = new IntLongHashMap(delegate);
    }

    public long get(int key) {
        return this.delegate.get(key);
    }

    public long getIfAbsent(int key, long ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(IntLongProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<IntLongPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableLongIntMap flipUniqueValues() {
        MutableLongIntMap result = LongIntMaps.mutable.empty();
        this.forEachKeyValue((IntLongProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableIntLongMap select(IntLongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntLongMap reject(IntLongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableLongIterator iterator = this.delegate.longIterator();
            while (iterator.hasNext()) {
                MutableLongBag batch = LongBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableIntLongMap toImmutable() {
        return this;
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)this.delegate.longIterator());
    }

    public void each(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongBag select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongBag reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public long max() {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    public long[] toArray() {
        return this.delegate.toArray();
    }

    public long[] toArray(long[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList() {
        return this.delegate.toList();
    }

    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableIntLongMap newWithKeyValue(int key, long value) {
        IntLongHashMap map = new IntLongHashMap(this.size() + 1);
        map.putAll((IntLongMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableIntLongMap newWithoutKey(int key) {
        IntLongHashMap map = new IntLongHashMap(this.size());
        map.putAll((IntLongMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableIntLongMap newWithoutAllKeys(IntIterable keys) {
        IntLongHashMap map = new IntLongHashMap(this.size());
        map.putAll((IntLongMap)this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntLongMapSerializationProxy((IntLongMap)this);
    }

    protected static class ImmutableIntLongMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntLongMap map;

        public ImmutableIntLongMapSerializationProxy() {
        }

        protected ImmutableIntLongMapSerializationProxy(IntLongMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((IntLongProcedure)new CheckedIntLongProcedure(){

                    @Override
                    public void safeValue(int key, long value) throws IOException {
                        out.writeInt(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntLongHashMap deserializedMap = new IntLongHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readInt(), in.readLong());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

